#ifndef AMDFLASH_h
#define AMDFLASH_h

#include "nios.h"

class AMDFlash
{
public:
	static void wait_at_least_1_us(void);												// This routine actually takes about 3 us on a 33.333MHz Nios32.
	static void unlock_bypass_mode(volatile unsigned char *flash_base);								// Unlock bypass mode, enabling fast writes.
	static void reset_bypass_mode(volatile unsigned char *flash_base);								// Turn bypass mode off, disabling fast writes and enabling normal function.
	static int await_write_complete(volatile unsigned char *addr, const unsigned char correct_value);				// Read the given address until two successive reads yield the same value. .
	static int nr_flash_write_bypass(volatile unsigned char *flash_base, volatile unsigned char *addr, unsigned char val);		// Write val to the given flash address, in bypass mode 
	static int nr_flash_erase_sector(unsigned long *flash_base, unsigned long *sector_address);					// Erase the flash sector at sector_address.
	static int nr_flash_write_buffer(unsigned long *flash_base, unsigned long *start_address, unsigned long *buffer, int size);	// Write a buffer of data to the flash, using bypass mode. 
//	static int amd29lv065d_flash_write_byte(unsigned char *flash_base, unsigned char *addr, unsigned char val); 			// Writes one byte to Flash
//	static int nr_flash_write(unsigned long *flash_base, unsigned long *addr, unsigned long val); 					// Writes one Value to Flash
    
//	static void Clear_Data_FLASH(void);												// Clear the Data Flash;

	static int WriteTraceToFlash(unsigned long *flash_address);
	static int LoadTraceSettings(unsigned long *flash_address);									//BF load settings of corresponding trace in memory
	static void LoadTracePoints(unsigned long *flash_address);									//BF load points of corresponding trace in memory
	static void ReadTraceFromFlash(unsigned long *flash_address);
    
//	static void copy_flash_to_planes(void);												// Copy the flash memory to the planes	
	static void copy_flash_to_plane(unsigned long *flash_address, unsigned long *plane);						// Copy one flash to plane
	
	static void Write_Config_Flash(void);												// Write Config to Flash
	static void Read_Config_Flash(void);												// Read Config from Flash
	
//	static void Write_TestData_Flash(void);												// Write TestData to Flash
//	static void Read_TestData_Flash(void);	                                                					// Read TestData from Flash

	static int WriteData_Byte_Flash(unsigned long *flash_address, unsigned char add, unsigned char data);   			// Writes a Datablock at given address
	static void ReadData_Prepare_Flash(unsigned long *flash_address);
	static unsigned char ReadData_Byte_Flash(unsigned int add);

	static void Write_Protected_Flash(void);											// Write Protected to Flash
	static void Read_Protected_Flash(void);	                                                					// Read Protected from Flash

	static void ReadProtReg(void);													//BF #002 read protected registervalues to get factory setting
	
	static void RecallTrace(void);
	static void SaveTrace(void);
	static void RecallOverlay(void);

};

#endif 
