//#include <stdio.h>
//#include "math.h"
#include "tc_vars.h"
#include "hardware_t.h"
//#include "flash_t.h"
//#include "display_t.h"
//#include "floatstr_t.h"
#include "signal_t.h"
//#include "interface_t.h"

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// 							Class Signal
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

/*
void Signal::Template(void)
{


}
*/

//##########################################################################################################################################################
// BF function for USTB roll mode
void Signal::USTB_ClearBuffer(void)
{
	int lVirtual_Zero=0;

//printf("\nclearing signal buffers...\r\n");

	if (USTB_Mode == USTB_ROLL)
	{
		// reset time pointer (memory index)
		if (USTB_Dir == USTB_FORWARD)		// direction = forward
		{ USTB_idx = MemStartOffs; MemWinStart = MemStartOffs+1; }
		else					// direction = reverse
		{ USTB_idx = MemoryEnd; MemWinStart = MemoryEnd - GRID_WIDTH;}

		// adjust signal pointers to 32k buffers
		S1Ptr = ROLL_OFFS1;
		S2Ptr = ROLL_OFFS2;
		S3Ptr = ROLL_OFFS3;
		S4Ptr = ROLL_OFFS4;
		SMPtr = ROLL_OFFSM;
	}
	else		// shift mode
	{
		if (USTB_Dir == USTB_FORWARD)		// direction = forward
		{
			USTB_idx = MemStartOffs;
			USTB_EOSignal = MemStartOffs;
			MemWinStart = MemStartOffs+1;

			S1Ptr = SIGNAL1;		// adjust signal pointers to 16k buffers with 80k shift space down
			S2Ptr = SIGNAL2;
			S3Ptr = SIGNAL3;
			S4Ptr = SIGNAL4;
			SMPtr = SIGNALM;
		}
		else					// direction = reverse
		{
			USTB_idx = MemoryEnd;
			USTB_EOSignal = MemoryEnd;
			MemWinStart = MemoryEnd - GRID_WIDTH;
			
			S1Ptr = SHIFT_OFFS1;		// adjust signal pointers to 16k buffers with 80k shift space up
			S2Ptr = SHIFT_OFFS2;
			S3Ptr = SHIFT_OFFS3;
			S4Ptr = SHIFT_OFFS4;
			SMPtr = SHIFT_OFFSM;
		}

	}

	Trig_Pos_Mem = USTB_idx;
	Trig_Pos_Display = (int) ((float)(Trig_Pos_Mem - MemWinStart) / ZoomFactor);
	//Trig_Pos_Display_dmode = (int) (((float)(Trig_Pos_Mem - MemWinStart) / ZoomFactorDel) - ((float) Cursor_Delayed_1 * (ZoomFactor / ZoomFactorDel)));


	//Channel 1
	lVirtual_Zero = ADC_VirtualZero_CH1;
	if (lVirtual_Zero > 255) lVirtual_Zero = 255;	//Limiter
	if (lVirtual_Zero < 0) lVirtual_Zero = 0;
	
	for(int i=MemStartOffs;i<MemoryEnd;i++) S1Ptr[i] = (char)lVirtual_Zero;
	
	//Channel 2
	lVirtual_Zero = ADC_VirtualZero_CH2;
	if (lVirtual_Zero > 255) lVirtual_Zero = 255;	//Limiter
	if (lVirtual_Zero < 0) lVirtual_Zero = 0;
	
	for(int i=MemStartOffs;i<MemoryEnd;i++) S2Ptr[i] = (char)lVirtual_Zero;

	//Channel 3
	lVirtual_Zero = ADC_VirtualZero_CH3;
	if (lVirtual_Zero > 255) lVirtual_Zero = 255;	//Limiter
	if (lVirtual_Zero < 0) lVirtual_Zero = 0;
	
	for(int i=MemStartOffs;i<MemoryEnd;i++) S3Ptr[i] = (char)lVirtual_Zero;


	//Channel 4
	lVirtual_Zero = ADC_VirtualZero_CH4;
	if (lVirtual_Zero > 255) lVirtual_Zero = 255;	//Limiter
	if (lVirtual_Zero < 0) lVirtual_Zero = 0;
	
	for(int i=MemStartOffs;i<MemoryEnd;i++) S4Ptr[i] = (char)lVirtual_Zero;


	//Channel math
	for(int i=MemStartOffs;i<MemoryEnd;i++) SMPtr[i] = ADC_ZERO;


}
//##########################################################################################################################################################
// BF reset all pointers and indices. Copy 16k buffers from end to start position
void Signal::USTB_ResetShiftBuffer(void)
{
	//printf("reset shift buffers\r\n");

	Hardware::Stop_Timer2();
	Hardware::Stop_Record();

	if (USTB_Dir == USTB_FORWARD)		// direction = forward
	{
		USTB_idx = MemStartOffs;
		USTB_EOSignal = MemStartOffs;
		//MemWinStart = MemStartOffs;

		S1Ptr = SIGNAL1;		// adjust signal pointers to 16k buffers with 80k shift space down
		S2Ptr = SIGNAL2;
		S3Ptr = SIGNAL3;
		S4Ptr = SIGNAL4;
		SMPtr = SIGNALM;

		for(int i=MemStartOffs;i<MemoryEnd;i++)
		{
			SIGNAL1[i] = SHIFT_OFFS1[i];
			SIGNAL2[i] = SHIFT_OFFS2[i];
			SIGNAL3[i] = SHIFT_OFFS3[i];
			SIGNAL4[i] = SHIFT_OFFS4[i];
			SIGNALM[i] = SHIFT_OFFSM[i];
		}

	}
	else					// direction = reverse
	{
		USTB_idx = MemoryEnd;
		USTB_EOSignal = MemoryEnd;
		//MemWinStart = MemoryEnd - GRID_WIDTH;
		
		S1Ptr = SHIFT_OFFS1;		// adjust signal pointers to 16k buffers with 80k shift space up
		S2Ptr = SHIFT_OFFS2;
		S3Ptr = SHIFT_OFFS3;
		S4Ptr = SHIFT_OFFS4;
		SMPtr = SHIFT_OFFSM;

		for(int i=MemStartOffs;i<MemoryEnd;i++)
		{
			SHIFT_OFFS1[i] = SIGNAL1[i];
			SHIFT_OFFS2[i] = SIGNAL2[i];
			SHIFT_OFFS3[i] = SIGNAL3[i];
			SHIFT_OFFS4[i] = SIGNAL4[i];
			SHIFT_OFFSM[i] = SIGNALM[i];
		}

	}

	Hardware::Reset_Timer2();

	Trig_Pos_Mem = USTB_idx;
	Trig_Pos_Display = (int) ((float)(Trig_Pos_Mem - MemWinStart) / ZoomFactor);
	//Trig_Pos_Display_dmode = (int) (((float)(Trig_Pos_Mem - MemWinStart) / ZoomFactorDel) - ((float) Cursor_Delayed_1 * (ZoomFactor / ZoomFactorDel)));

}
//##########################################################################################################################################################
// BF USTB mode: insert new sample to actual buffer (time) position.
void Signal::USTB_InsertSample(short invert, unsigned char ADC_VirtualZero, unsigned char *USTB_buff ,unsigned char *Signal)
{

	int lNew_Value=0;
	int lix;

/*
	if (USTB_Mode == USTB_SHIFT)		// shift mode active?
	{
		// shift all values to the left or right if buffer end/start is reached
		if (USTB_Dir == USTB_FORWARD)
		{
//printf("Shift forward...");
			for (lix = MemoryEnd; lix > MemStartOffs; lix--)
			{ Signal[lix] = Signal[lix-1]; }
//printf("ready\r\n");
		}
		else if(USTB_Dir == USTB_REVERSE)
		{
//printf("Shift reverse...\r\n");
			for (lix = MemStartOffs; lix < MemoryEnd; lix++)
			{ Signal[lix] = Signal[lix+1]; }
//printf("ready\r\n");
		}

	}
*/
	// calculate average value of ADC data array
	for (lix = 0; lix < 128; lix++)
	{ lNew_Value += USTB_buff[lix]; }

	// divide by number of samples
	lNew_Value = lNew_Value >> 7;		

	// signal inverted??
	if (invert)
	{ lNew_Value = (ADC_VirtualZero<<1) - lNew_Value; }
	
	// write new value to the current time position
	Signal[USTB_idx] = (unsigned char)lNew_Value;
}
//##########################################################################################################################################################
// BF USTB mode: invert signal buffer
// calculation must be done in two steps to avoid spikes caused by double inversion
void Signal::USTB_InvertSignal(unsigned char ADC_VirtualZero ,unsigned char *Signal)
{
	int idx_buff = USTB_idx;

	if (USTB_Dir == USTB_FORWARD)			// direction = forward
	{
		for (int i = idx_buff ;i < MemoryEnd;i++)
		{ Signal[i] = (ADC_VirtualZero<<1) - Signal[i];}

		for (int i = MemStartOffs;i < idx_buff;i++)
		{ Signal[i] = (ADC_VirtualZero<<1) - Signal[i];}

	}
	else						// direction = reverse
	{
		for (int i = idx_buff ;i > MemStartOffs;i--)
		{ Signal[i] = (ADC_VirtualZero<<1) - Signal[i];}

		for (int i = MemoryEnd ;i > idx_buff;i--)
		{ Signal[i] = (ADC_VirtualZero<<1) - Signal[i];}
	}

}
//##########################################################################################################################################################

void Signal::USTB_RecalcMath(void)
{

	//---------------------------------------------
	//         MATH function multiply
	//---------------------------------------------
	if (MenuStatus[MENU_MATH][2] == BTN_ON)      		// multiply 
	{	
		//set global math scaling and offset for drawing routine
		math_scale = math_mul_scale - 166;
		Math_Offset = Math_Mul_Offset;
		
		//calculate main math signal
		CalcMathMul(MemStartOffs, MemoryEnd, draw_factor, S1Ptr, S2Ptr, SMPtr);

	}	//multiply end

	//---------------------------------------------
	//         MATH function subtract
	//---------------------------------------------
	else if (MenuStatus[MENU_MATH][3] == BTN_ON)           	// subtract
	{	
		//set global math scaling and offset for drawing routine
		math_scale = math_sub_scale - 150;
		Math_Offset = Math_Sub_Offset;

		//calculate main math signal
		Signal::CalcMathSub(MemStartOffs, MemoryEnd, draw_factor, S1Ptr, S2Ptr, SMPtr);
	}	//subtract end

	//---------------------------------------------
	//         MATH function add
	//---------------------------------------------
	else if (MenuStatus[MENU_MATH][4] == BTN_ON)           	// add
	{
		//set global math scaling and offset for drawing routine
		math_scale = math_add_scale - 150;
		Math_Offset = Math_Add_Offset;
		
		//calculate main math signal
		Signal::CalcMathAdd(MemStartOffs, MemoryEnd, draw_factor, S1Ptr, S2Ptr, SMPtr);
	}	//add end



}
//##########################################################################################################################################################
/* BF */
// Build trigonometric tables for FFT
void Signal::FFT_BuildTrigoTables(void)
{
	//Speicher auf dem Stack reservieren
	int z,l,i,r,ct,buff; 	//,ar,v, la;
	int d[FFT_Level];	//Number of butterfly levels

	//Struktur vom Typ div_t erzeugen
	div_t s_div;

/*
	Signal::DRAWROUNDBUTTON(230, 180, 200, 80, 0, 0);
	Signal::TEXTOUTxvbig("Building trigonometric", 247, 192, 1, UI_Plane2);
	Signal::TEXTOUTxvbig("tables.", 247, 212, 1, UI_Plane2);
	Signal::TEXTOUTxvbig("Please wait a minute.", 247, 232, 1, UI_Plane2);
*/

/*
	// create sin() and cos() table as integer values
	for(i=0;i < FFT_Length;i++)  			
	{
		sin_tab[i] = (int)(FFT_INTFACT * sin(i*2*PI/FFT_Length));
		cos_tab[i] = (int)(FFT_INTFACT * cos(i*2*PI/FFT_Length));
	}
*/	
	// create window and trigonometric tables
	for(i=0,r=0 ;i < FFT_Length; i++)
	{
		sin_tab[i] = iSin1024[r];
		cos_tab[i] = iCos1024[r];

		win_tab[i] = FFT_Window[FFT_Windex][r];
	
		if (FFT_Length == FFT_512)
		r+=2;
		else
		r++;	
	}

	
	//Bit-Reversal- Tabelle bit_rev[0..] anlegen
	for(i=0 ;i < FFT_Length; i++)
	{
		z=i;
		//Dezimal-Index in Dualzahl umwandeln
		for(ct=0 ;ct < FFT_Level; ct++)
		{
			s_div = div(z,2);
			d[ct] = (int)s_div.rem;		// den Rest ins Feld
			z     = (int)s_div.quot;	// den Quotienten nach z
		}
		//Bit-Revers anordnen
		s_div = div(FFT_Level,2);
		for(ct=0 ;ct < (int)s_div.quot; ct++)
		{
			buff  = d[ct];
			d[ct] = d[FFT_Level-ct-1];
			d[FFT_Level-ct-1] = buff;
		}
		
		//Bit-Revers anordnen Zeitoptimiert mit Festwert
//		for(int buff,j=0;j<5;j++) 	        // 5 = FFT_LEVEL/radix  => x=div(FFT_LEVEL,2) => x.quot=5
//		{
//			buff 	     = d[j];
//			d[j] 	     = d[FFT_LEVEL-j-1];
//			d[FFT_LEVEL-j-1] = buff;
//		}

		//Umsortierten Index zurückwandeln in Dezimalzahl
		r = 0;
		for(ct=0 ;ct < FFT_Level; ct++)
		{
			r = r + (1<<ct) * d[ct];
		}
		//umsortierter Index
		bit_rev[i] = r;

	}//Ende Bit-Reversal-Tabelle
/*	
	//Delete popup
	Signal::DRAWROUNDBUTTON(230, 180, 200, 80, 0, 1);
	Signal::TEXTOUTxvbig("Building trigonometric", 247, 192, 0, UI_Plane2);
	Signal::TEXTOUTxvbig("tables.", 247, 212, 0, UI_Plane2);
	Signal::TEXTOUTxvbig("Please wait a minute.", 247, 232, 0, UI_Plane2);
*/
/*
	//check the values
	for(i=0;i < FFT_Length;i++)  			// {sin und cos-Tabelle prüfen}
	{
		//printf("SIN(x) = ");floatprintf((float)sin_tab[i]);
		//printf("COS(x) = ");floatprintf((float)cos_tab[i]);printf("\r\n");
		printf("SIN(x) =  %d\r\n",sin_tab[i]);
		printf("COS(x) =  %d\r\n",cos_tab[i]);

	}
	//check the values
//	for(Ii=0 ;Ii < FFT_LENGTH; Ii++)
//	printf("Bit reversal =  %d\r\n",bit_rev[Ii]);

*/

}
//##########################################################################################################################################################
/* BF */
// Calculate fast fourier transformation to get spectral analyzis of time signal. Trigonometric tables have to be build first.
// To get a periodic approximation, the time signal has to be processed with a window function. The simplest case is a 
// rectangle window, which has no side line suppression.
void Signal::FFT_CalcSpectrum(unsigned char *Signal, int *Spectrum)
{
	// buffer for real and imaginary part of spectrum - sharing the memory with the signal interpolation
	int *freq_re = (int *)SIGNAL1_Intpolate;
	int *freq_im = (int *)SIGNAL1_Intpolate_delayed; 


	//Speicher auf dem Stack reservieren
	int l=0,i=0,j=0,r=0,ar=0,v=0;
	int Fz1=0,Fz2=0,Fz3=0,Fz4=0,Fxr=0,Fxi=0,Fyr=0,Fyi=0;
	int ScaleShiftFactor;  
	

	double logval;
//printf("starting fft\r\n");
//printf("starting FFT");	
	// set variable scaling
	if (FFT_Mode == FFT_PWSP || FFT_Mode == FFT_PWDN)
	ScaleShiftFactor = FFT_Level - 3;
	else
	ScaleShiftFactor = FFT_Level - 2;

//printf(" ->  level %d  shift factor %d",FFT_Level, ScaleShiftFactor);	

	//-----------------------------------------------
	// get time signal and make a window overlay
	//-----------------------------------------------

	//sort timevalues bitreversal
	for(i=0;i<FFT_Length;i++)
	{
		if(FFT_Windex == -1)
		freq_re[i] = (int)(Signal[bit_rev[i]] - ADC_ZERO);					// no window overlay -> rectangle
		else
		freq_re[i] =  (win_tab[bit_rev[i]] * (int)(Signal[bit_rev[i]] - ADC_ZERO)) >> 13;	// window overlay

		freq_im[i] = 0;

		//printf("freq_re[%d] = ",i);floatprintf(freq_re[i]);
		//printf("     freq_im[%d] = ",i);floatprintf(freq_im[i]);printf("\r\n");
	}

	//-----------------------------------------------
	//             calculate FFT
	//-----------------------------------------------
//printf(" -> calculate butterflies");
	//calculate complex spectral values (butterflies)
	for(l=1;(l<=FFT_Level) && !UI_request;l++)	// level loop
	{
		for(i=0;i<=((1<<(FFT_Level-l))-1) && !UI_request;i++)
		{
			for(j=0;j<=((1<<(l-1))-1);j++)
			{
				r = j + i* (1 << l);
				ar= j * (FFT_Length >> l);
				v = 1 << (l-1);
				
				Fz1 = (cos_tab[ar] * freq_re[r+v]) >> 10;	//rescale from integer conversion
				Fz2 = (cos_tab[ar] * freq_im[r+v]) >> 10;	//rescale from integer conversion
				Fz3 = (sin_tab[ar] * freq_re[r+v]) >> 10;	//rescale from integer conversion
				Fz4 = (sin_tab[ar] * freq_im[r+v]) >> 10;	//rescale from integer conversion
				Fxr = freq_re[r] + Fz1 + Fz4;
				Fxi = freq_im[r] - Fz3 + Fz2;
				Fyr = freq_re[r] - Fz1 - Fz4;
				Fyi = freq_im[r] + Fz3 - Fz2;
				freq_re[r] = Fxr;
				freq_im[r] = Fxi;
				freq_re[r+v] = Fyr;
				freq_im[r+v] = Fyi;
			}
		}
	}


//printf("FFT mode = %d  length = %d\r\n",FFT_Mode,FFT_Length);
//printf(" - FFT mode = %d  length = %d",FFT_Mode,FFT_Length);
	switch(FFT_Mode)
	{
		case FFT_MAGN: 	// linear magnitude
		{
//printf(" -> FFT %d magnitude calculation...",FFT_Length);

			//get half of the spectrum because spectrum is mirrored at the middle and calculate output
			for (i=0,j=0;i < (FFT_Length/2)  && !UI_request;i++)
			{
				//downscale depending on FFT length
				freq_re[i] = freq_re[i] >> ScaleShiftFactor;
				freq_im[i] = freq_im[i] >> ScaleShiftFactor;

				//calc total value via power of two
				v = (freq_re[i]*freq_re[i]) + (freq_im[i]*freq_im[i]);	// v = Re² + IM²

				// and square root
				//r = iSqrt(v);
				r = Math_Sqrt(v);

				//printf("freq_re[%d] = %d    ",i,freq_re[i]);
				//printf("freq_im[%d] = %d    ",i,freq_im[i]);	
				//printf("v = Re² + IM² = %d    ",v);
				//printf("r = sqrt(v) = %d",r);
				// scale to display size
				//r = r << 2;
				//printf("scale r = %d\r\n",r);	
				
				//map to 512 or 1024 values
				if(FFT_Length == FFT_1024 )
					Spectrum[i] = r;
				else
				{ 
					Spectrum[j]   = r;
					Spectrum[j+1] = r;
					j+=2;
				}	
				
			}
//printf("done");
			break;
		}
		
		case FFT_PHAS: 	// linear phase
		{
			//get half of the spectrum because spectrum is mirrored at the middle and calculate output
			for (i=0,j=0;i < (FFT_Length/2)  && !UI_request;i++)
			{
				//downscale depending on FFT length
				freq_re[i] = freq_re[i] >> ScaleShiftFactor;
				freq_im[i] = freq_im[i] >> ScaleShiftFactor;


				r = 10;		//BF to be done!!!!!
				//phase = arctan(imag / real)


				//map to 512 or 1024 values
				if(FFT_Length == FFT_1024 )
					Spectrum[i] = r;
				else
				{ 
					Spectrum[j]   = r;
					Spectrum[j+1] = r;
					j+=2;
				}	

			}
			break;
		}

		case FFT_REAL: 	// linear real part
		{
			//get half of the spectrum because spectrum is mirrored at the middle and calculate output
			for (i=0,j=0;i < (FFT_Length/2) && !UI_request;i++)
			{
				//map to 512 or 1024 values
				if(FFT_Length == FFT_1024 )
					Spectrum[i] = freq_re[i] >> ScaleShiftFactor;	//downscale depending on FFT length
					if (Spectrum[i] < 0)				//absolute value
					Spectrum[i] = -Spectrum[i];
			else
				{ 
					Spectrum[j]   = freq_re[i] >> ScaleShiftFactor;
					if (Spectrum[j] < 0)				//absolute value
					Spectrum[j] = -Spectrum[j];

					Spectrum[j+1] = Spectrum[j];
					j+=2;
				}	

			}
			break;
		}

		case FFT_IMAG: 	// linear imaginary part
		{
			//get half of the spectrum because spectrum is mirrored at the middle and calculate output
			for (i=0,j=0;i < (FFT_Length/2) && !UI_request;i++)
			{
				//map to 512 or 1024 values
				if(FFT_Length == FFT_1024 )
					Spectrum[i] = freq_im[i] >> ScaleShiftFactor;	//downscale depending on FFT length
					if (Spectrum[i] < 0)				//absolute value
					Spectrum[i] = -Spectrum[i];

				else
				{ 
					Spectrum[j]   = freq_im[i] >> ScaleShiftFactor;
					if (Spectrum[j] < 0)				//absolute value
					Spectrum[j] = -Spectrum[j];

					Spectrum[j+1] = Spectrum[j];
					j+=2;
				}	

			}
			
			break;
		}

		case FFT_REIM: 	// linear real + imaginary
		{
			//get half of the spectrum because spectrum is mirrored at the middle and calculate output
			for (i=0,j=0;i < (FFT_Length/2) && !UI_request;i++)
			{
				//downscale depending on FFT length
				freq_re[i] = freq_re[i] >> ScaleShiftFactor;
				freq_im[i] = freq_im[i] >> ScaleShiftFactor;
				//downscale depending on FFT length

				if (freq_re[i] < 0)				//absolute value
				freq_re[i] = -freq_re[i];
				if (freq_im[i] < 0)				//absolute value
				freq_im[i] = -freq_im[i];

				//map to 512 or 1024 values
				if(FFT_Length == FFT_1024 )
					Spectrum[i] = freq_re[i] + freq_im[i];		//add real and imaginary part
				else
				{ 
					Spectrum[j]   = freq_re[i] + freq_im[i];
					Spectrum[j+1] = Spectrum[j];
					j+=2;
				}	

			}

			
			break;
		}

		case FFT_PWSP: 	// power spectrum in dBm
		{
			//get half of the spectrum because spectrum is mirrored at the middle and calculate output
			for (i=0,j=0;i < (FFT_Length/2)  && !UI_request;i++)
			{
				//downscale depending on FFT length
				freq_re[i] = freq_re[i] >> ScaleShiftFactor;
				freq_im[i] = freq_im[i] >> ScaleShiftFactor;

				//calc total value via power of two
				v = (freq_re[i]*freq_re[i]) + (freq_im[i]*freq_im[i]);	// v = Re² + IM²
	
				// and square root
				//r = iSqrt(v);
				r = Math_Sqrt(v);			//magnitude

				// calculate power spectrum
				// ps = 20 * log10(magn / ref)		ref = 0.316 V = 323/1024
				
				r = (r * 323) >> 10;			// magn/ref
				
				r = (int)iLog10[r];			//log10(magn/ref)
			
				r = r>>1;				//downscaling

				//map to 512 or 1024 values
				if(FFT_Length == FFT_1024 )
					Spectrum[i] = r;
				else
				{ 
					Spectrum[j]   = r;
					Spectrum[j+1] = r;
					j+=2;
				}	
				
			}
			break;
		}
		case FFT_PWDN: 	// power density spectrum in dBm
		{
			//get half of the spectrum because spectrum is mirrored at the middle and calculate output
			for (i=0,j=0;i < (FFT_Length/2)  && !UI_request;i++)
			{
				//downscale depending on FFT length
				freq_re[i] = freq_re[i] >> ScaleShiftFactor;
				freq_im[i] = freq_im[i] >> ScaleShiftFactor;

				//calc total value via power of two
				v = (freq_re[i]*freq_re[i]) + (freq_im[i]*freq_im[i]);	// v = Re² + IM²
	
				// and square root
				//r = iSqrt(v);
				r = Math_Sqrt(v);			//magnitude

				// calculate power spectrum
				// ps = 20 * log10(magn / ref)		ref = 0.316 V = 323/1024
				
				r = (r * 323) >> 10;			// magn/ref
				
				r = (int)iLog10[r];			//log10(magn/ref)

				// calculate power density spectrum
				// pd = ps - 10 * log10(ENBW * df)
				r -= FFT_NormENBW; 
				
			
				//r = r>>1;				//downscaling??

				//map to 512 or 1024 values
				if(FFT_Length == FFT_1024 )
					Spectrum[i] = r;
				else
				{ 
					Spectrum[j]   = r;
					Spectrum[j+1] = r;
					j+=2;
				}	
			}
			break;
		}

	}


    	//printf(" -> finished FFT\r\n");
}
//##########################################################################################################################################################
//multiply signals
void Signal::CalcMathMul(int start, int stop, int stepwidth ,unsigned char *SignalData1, unsigned char *SignalData2, unsigned char *MathData)
{

	int lix,liy;
	int lbuffer, lvalue1,lvalue2;

	int lgain = 0; 

	int lzero1 = (ADC_ZERO + int((float)Virtual_ZeroLevelCH1 / ScaleFactor[Selected_Voltage_CH1][GainIdx]));
	int lzero2 = (ADC_ZERO + int((float)Virtual_ZeroLevelCH2 / ScaleFactor[Selected_Voltage_CH2][GainIdx]));;

	if (GainIdx!=0) lgain = 1;

	int lfactor = ((math_voltage_factor[lgain][Selected_Voltage_CH1] * predivisor[MenuStatus[1][3] - 104]) * (math_voltage_factor[lgain][Selected_Voltage_CH2] * predivisor[MenuStatus[2][3] - 104]));

	lfactor = lfactor << 8;
	lfactor /= math_voltage_factor[lgain][math_scale];
	lfactor = lfactor << 8;
	//lfactor /= math_voltage_factor[lgain][math_scale];
	lfactor /= math_rescale[lgain][math_scale];

	for (lix=start, liy=start; lix < stop  && !UI_request; lix++)
	{
		if (lix != liy)		// interpolate points between step width
		{ MathData[lix] = MathData[lix-1]; continue; }

		liy += stepwidth;

		//convert to signed integer and shift to zero
		lvalue1 = (int)SignalData1[lix] - lzero1;
		lvalue2 = (int)SignalData2[lix] - lzero2;

		lbuffer = (-((lvalue1 * lvalue2 * lfactor) >> 16 ) + ADC_ZERO);

		if (lbuffer > 255) lbuffer = 255;		//limiter
		else if(lbuffer < 0) lbuffer = 0;

		MathData[lix] = (unsigned char)lbuffer;
	}


}
//##########################################################################################################################################################
//subtract signals
void Signal::CalcMathSub(int start, int stop, int stepwidth ,unsigned char *SignalData1, unsigned char *SignalData2, unsigned char *MathData)
{

	int lix,liy;
	int lbuffer, lvalue1,lvalue2;

	int lgain = 0; 

	int lzero1 = (ADC_ZERO + int((float)Virtual_ZeroLevelCH1 / ScaleFactor[Selected_Voltage_CH1][GainIdx]));
	int lzero2 = (ADC_ZERO + int((float)Virtual_ZeroLevelCH2 / ScaleFactor[Selected_Voltage_CH2][GainIdx]));;

	if (GainIdx!=0) lgain = 1;

	int lfactor1 = ((math_voltage_factor[lgain][Selected_Voltage_CH1] * predivisor[MenuStatus[1][3] - 104])<<12) / math_voltage_factor[lgain][math_scale];
	int lfactor2 = ((math_voltage_factor[lgain][Selected_Voltage_CH2] * predivisor[MenuStatus[2][3] - 104])<<12) / math_voltage_factor[lgain][math_scale];

	for (lix=start, liy=start; lix < stop  && !UI_request; lix++)
	{
		if (lix != liy)		// interpolate points between step width
		{ MathData[lix] = MathData[lix-1]; continue; }

		liy += stepwidth;

		//convert to signed integer and shift to zero
		lvalue1 = (int)SignalData1[lix] - lzero1;
		lvalue2 = (int)SignalData2[lix] - lzero2;

		//scale signals
		lvalue1 *= lfactor1;
		lvalue2 *= lfactor2;

		MathData[lix] = (unsigned char)(((lvalue1 - lvalue2)>>12) + ADC_ZERO);
	}

}
//##########################################################################################################################################################
//add signals
void Signal::CalcMathAdd(int start, int stop, int stepwidth ,unsigned char *SignalData1, unsigned char *SignalData2, unsigned char *MathData)
{
	int lix,liy;
	int lbuffer, lvalue1,lvalue2;

	int lgain = 0; 

	int lzero1 = (ADC_ZERO + int((float)Virtual_ZeroLevelCH1 / ScaleFactor[Selected_Voltage_CH1][GainIdx]));
	int lzero2 = (ADC_ZERO + int((float)Virtual_ZeroLevelCH2 / ScaleFactor[Selected_Voltage_CH2][GainIdx]));;

	if (GainIdx!=0) lgain = 1;

	//printf("\r\nCalcMathAdd\r\n");
	//printf("zero corr1 : %d   zero corr2 : %d\r\n",lzero1,lzero2);

	int lfactor1 = ((math_voltage_factor[lgain][Selected_Voltage_CH1] * predivisor[MenuStatus[1][3] - 104])<<12) / math_voltage_factor[lgain][math_scale];
	int lfactor2 = ((math_voltage_factor[lgain][Selected_Voltage_CH2] * predivisor[MenuStatus[2][3] - 104])<<12) / math_voltage_factor[lgain][math_scale];

	//printf("factor 1 : %d   factor 2 : %d\r\n",lfactor1,lfactor2);

	for (lix=start, liy=start; lix < stop  && !UI_request; lix++)
	{
		if (lix != liy)		// interpolate points between step width
		{ MathData[lix] = MathData[lix-1]; continue; }

		liy += stepwidth;

		//convert to signed integer and shift to zero
		lvalue1 = (int)SignalData1[lix] - lzero1;
		lvalue2 = (int)SignalData2[lix] - lzero2;

		//printf("S1 - zero = %d - %d = %d   S2 - zero = %d - %d = %d\r\n",SignalData1[lix], lzero1, lvalue1, SignalData2[lix], lzero2, lvalue2);

		//scale signals
		lvalue1 *= lfactor1;
		lvalue2 *= lfactor2;

		//printf("val1 * factor1 = %d   val2 * factor =  %d\r\n",lvalue1, lvalue2);

		MathData[lix] = (unsigned char)(((lvalue1 + lvalue2)>>12) + ADC_ZERO);

		//printf("val1 + val2 + 127 =  %d\r\n",MathData[lix]);
		//printf("----------------------------------------------------\r\n");

	}

}
//##########################################################################################################################################################
// BF Signal processing -> DSP unit
// only for normal TB. USTB is calculated directly in USTB ADC handler
void Signal::ProcessSignalData(void)
{
	if(!ACQ_NewData) return;

//printf("DSP Unit \n\r");

//---------------------------------------------------------------------------------------
//			Calculate drawing parameters
//---------------------------------------------------------------------------------------
	if (((MainTimebase + VirtualTimebase) < 4) && FFT_Mode == FFT_OFF) 		// BF 20ns + 10ns + 5ns + 2ns main mode - interpolated signal
	{
		draw_start = 0;
		draw_factor = 1;
	}
	else if (USTB_Mode != USTB_OFF)							// USTB active?
	{ 
		draw_start = MemWinStart;						// set drawing parameters 
		draw_factor = 1;
		return;									// and leave...
	}
	else 										// BF >= 50ns main mode - true signal and FFT
	{
		draw_start = (short) MemWinStart + PreTrigComp;				// must be calculated new after every acquisition
		draw_factor = (short)ZoomFactor;
	}


	if (MenuStatus[MENU_TIMEBASE][1] == BTN_ON)					// Delayed
	{
		if (ZoomFactorDel < 1) 							// 20ns + 10ns delayed mode  - interpolated signal
		{
			draw_dm_ixstart  = 0;						// set to zero because whole interpolation buffer must be drawn
			draw_dm_ixfactor = (short) ZoomFactorDel;	
		}
		else									// >= 50ns delayed mode - true signal
		{
			draw_dm_ixstart  = MemWinStart + PreTrigComp + (short)((float)Cursor_Delayed_1 * ZoomFactor);	//BF #003
			draw_dm_ixfactor = (short) ZoomFactorDel;	
		}
	}	

	unsigned char *lPtr_S1 = NULL;							//pointer to signal 1
	unsigned char *lPtr_S2 = NULL;							//pointer to signal 2
	unsigned char *lPtr_SM = NULL;							//pointer to math signal 

	int lCalcStart = MemWinStart + PreTrigComp;					// determine calculation range 
	int lCalcStop  = lCalcStart + (GRID_WIDTH * draw_factor) + draw_factor;		// determine calculation range 
	int lix;


	//---------------------------------------------------------------------------------------
	//				Invert Signal
	//---------------------------------------------------------------------------------------
	if (Run || SingleShot)
	{
		SingleShot = 0;

		int lSignalEnd;

		if (MainTimebase < 11) lSignalEnd = 16384;
		else lSignalEnd = 4096;

		if (Channel_1_Active && MenuStatus[MENU_CHANNEL1][2] - BTN_OFF)		// Channel 1 inversion on?
		{
			//for (int i=lCalcStart; i<lCalcStop;i++)
			for (int i=0; i<lSignalEnd;i++)
			{ SIGNAL1[i] = (ADC_VirtualZero_CH1<<1) - SIGNAL1[i]; }
		}
	
		if (Channel_2_Active && MenuStatus[MENU_CHANNEL2][2] - BTN_OFF)		// Channel 2 inversion on?
		{
			//for (int i=lCalcStart-draw_factor; i<lCalcStop;i++)
			for (int i=0; i<lSignalEnd;i++)
			{ SIGNAL2[i] = (ADC_VirtualZero_CH2<<1) - SIGNAL2[i]; }
		}
	
		if (Channel_3_Active && MenuStatus[MENU_CHANNEL3][2] - BTN_OFF)		// Channel 3 inversion on?
		{
			//for (int i=lCalcStart-draw_factor; i<lCalcStop;i++)
			for (int i=0; i<lSignalEnd;i++)
			{ SIGNAL3[i] = (ADC_VirtualZero_CH3<<1) - SIGNAL3[i]; }
		}
	
		if (Channel_4_Active && MenuStatus[MENU_CHANNEL4][2] - BTN_OFF)		// Channel 4 inversion on?
		{
			//for (int i=lCalcStart-draw_factor; i<lCalcStop;i++)
			for (int i=0; i<lSignalEnd;i++)
			{ SIGNAL4[i] = (ADC_VirtualZero_CH4<<1) - SIGNAL4[i]; }
		}
	
	}



	//---------------------------------------------------------------------------------------
	//				Average
	//---------------------------------------------------------------------------------------
	
	if (MenuStatus[MENU_ACQUIRE][1] > AVRG_OFF)		//Average not off?
	{
		char lmode = (char)(MenuStatus[MENU_ACQUIRE][1] - AVRG_OFF);

		if (lmode == 1)	//infinity mode
		{
			if (Channel_1_Active)
			for (int i=lCalcStart; i<lCalcStop;i++)
			{ Filter1_Buffer[i] = (unsigned char)(((int)Filter1_Buffer[i] + (int)SIGNAL1[i])>>1); 
			SIGNAL1[i] = Filter1_Buffer[i]; }

			if (Channel_2_Active)
			for (int i=lCalcStart; i<lCalcStop;i++)
			{ Filter2_Buffer[i] = (unsigned char)(((int)Filter2_Buffer[i] + (int)SIGNAL2[i])>>1); 
			SIGNAL2[i] = Filter2_Buffer[i]; }

			if (Channel_3_Active)
			for (int i=lCalcStart; i<lCalcStop;i++)
			{ Filter3_Buffer[i] = (unsigned char)(((int)Filter3_Buffer[i] + (int)SIGNAL3[i])>>1); 
			SIGNAL3[i] = Filter3_Buffer[i]; }

			if (Channel_4_Active)
			for (int i=lCalcStart; i<lCalcStop;i++)
			{ Filter4_Buffer[i] = (unsigned char)(((int)Filter4_Buffer[i] + (int)SIGNAL4[i])>>1); 
			SIGNAL4[i] = Filter4_Buffer[i]; }
		}
		else
		{
	//printf("average cnt = %d\n\r", ACQ_Average );
			if (ACQ_Average == lmode<<1)		// new cycle
			{
				if (Channel_1_Active) { for (int i=lCalcStart; i<lCalcStop;i++)	{ Filter1_Buffer[i] = SIGNAL1[i]; } }
				if (Channel_2_Active) { for (int i=lCalcStart; i<lCalcStop;i++)	{ Filter2_Buffer[i] = SIGNAL2[i]; } }
				if (Channel_3_Active) { for (int i=lCalcStart; i<lCalcStop;i++)	{ Filter3_Buffer[i] = SIGNAL3[i]; } }
				if (Channel_4_Active) { for (int i=lCalcStart; i<lCalcStop;i++)	{ Filter4_Buffer[i] = SIGNAL4[i]; } }
				
				ACQ_NewData = 0;
				ACQ_Average--;
				return;
			}
			else			// calculate average
			{ 
				for (int i=lCalcStart; i<lCalcStop;i++)
				{ Filter1_Buffer[i] =  (unsigned char)(((int)Filter1_Buffer[i] + (int)SIGNAL1[i])>>1); }
			}
			
	
			if (ACQ_Average == 0)	//cycle end
			{
				if (Channel_1_Active) { for (int i=lCalcStart; i<lCalcStop;i++) {  SIGNAL1[i] = Filter1_Buffer[i]; } }
				if (Channel_2_Active) { for (int i=lCalcStart; i<lCalcStop;i++) {  SIGNAL2[i] = Filter2_Buffer[i]; } }
				if (Channel_3_Active) { for (int i=lCalcStart; i<lCalcStop;i++) {  SIGNAL3[i] = Filter3_Buffer[i]; } }
				if (Channel_4_Active) { for (int i=lCalcStart; i<lCalcStop;i++) {  SIGNAL4[i] = Filter4_Buffer[i]; } }
	
				ACQ_Average = lmode<<1; // continous or steps
			}
			else
			{ ACQ_Average--; ACQ_NewData = 0; return;}	
		}

	}



	//---------------------------------------------------------------------------------------
	//				Noise Filter (low pass filter)
	//---------------------------------------------------------------------------------------
	
	if (MenuStatus[MENU_ACQUIRE][2] != FILT_OFF)			//Noise Filter not off?
	{
		//noise filter -> stage 1 nearly lossless, stage 2 with losing bandwidth
		if (MenuStatus[MENU_ACQUIRE][2] == (FILT_OFF+1) || MenuStatus[MENU_ACQUIRE][2] == (FILT_OFF+2))
		{
			char lStage = (char)(MenuStatus[MENU_ACQUIRE][2] - FILT_OFF);
//printf("Noise Filter \n\r");
			if (Channel_1_Active)
			{ LowPassFilter(lCalcStart, lCalcStop, lStage, SIGNAL1, Filter1_Buffer); }
			
			if (Channel_2_Active)
			{ LowPassFilter(lCalcStart, lCalcStop, lStage, SIGNAL2, Filter2_Buffer); }
			
			if (Channel_3_Active)
			{ LowPassFilter(lCalcStart, lCalcStop, lStage, SIGNAL3, Filter3_Buffer); }
			
			if (Channel_4_Active)
			{ LowPassFilter(lCalcStart, lCalcStop, lStage, SIGNAL4, Filter4_Buffer); }
		}
		//IIR low pass filter with 1 - 3 stages
		else if (MenuStatus[MENU_ACQUIRE][2] > (FILT_OFF+2))	
		{ 
			char lStage = (char)(MenuStatus[MENU_ACQUIRE][2] - (FILT_OFF+2));

			if (Channel_1_Active)
			{ IIR_Filter(lCalcStart, lCalcStop, lStage, SIGNAL1, Filter1_Buffer); }
			
			if (Channel_2_Active)
			{ IIR_Filter(lCalcStart, lCalcStop, lStage, SIGNAL2, Filter2_Buffer); }
			
			if (Channel_3_Active)
			{ IIR_Filter(lCalcStart, lCalcStop, lStage, SIGNAL3, Filter3_Buffer); }
			
			if (Channel_4_Active)
			{ IIR_Filter(lCalcStart, lCalcStop, lStage, SIGNAL4, Filter4_Buffer); }
		}

		//set signal pointers to filter buffer
		S1Ptr = Filter1_Buffer;
		S2Ptr = Filter2_Buffer;
		S3Ptr = Filter3_Buffer;
		S4Ptr = Filter4_Buffer;

//		printf("DSP filtering \n\r");

	}
	else		//no filtering
	{
		//set signal pointers to unfiltered signal
		S1Ptr = SIGNAL1;
		S2Ptr = SIGNAL2;
		S3Ptr = SIGNAL3;
		S4Ptr = SIGNAL4;
		//SMPtr = SIGNALM;
	}


        //--------------------------------------------------------------------------------------
	//        	 Interpolation (time stretch) for timebase 20ns, 10ns 5ns 2ns
	//--------------------------------------------------------------------------------------
	if(FFT_Mode == FFT_OFF)	
	{ 
		short lDel_IntPol_Offs = MemWinStart + PreTrigComp + (short)((float)Cursor_Delayed_1 * ZoomFactor);	//BF #003 Interpolation offset for delayed signal

		if (Channel_1_Active)
		{	
			if ((MainTimebase + VirtualTimebase) < 4)
			{ Interpolate(MainTimebase+VirtualTimebase, lCalcStart, S1Ptr, SIGNAL1_Intpolate); }
			
			if ((MenuStatus[MENU_TIMEBASE][1] == BTN_ON) && (ZoomFactorDel < 1)) //delayed mode
			{ Interpolate(MainTimebase - DelayedTimebase - 1, lDel_IntPol_Offs, S1Ptr, SIGNAL1_Intpolate_delayed); }
		}
		
		if (Channel_2_Active)
		{	
			if ((MainTimebase + VirtualTimebase) < 4)
			{ Interpolate(MainTimebase+VirtualTimebase, lCalcStart, S2Ptr, SIGNAL2_Intpolate); }
			
			if ((MenuStatus[MENU_TIMEBASE][1] == BTN_ON) && (ZoomFactorDel < 1))	//delayed mode
			{ Interpolate(MainTimebase - DelayedTimebase - 1, lDel_IntPol_Offs, S2Ptr, SIGNAL2_Intpolate_delayed); }
		}	
		//4-Channel Version
		if (NumberOfChannels == 4)
		{	
			if (Channel_3_Active)
			{	
				if ((MainTimebase + VirtualTimebase) < 4)
				{ Interpolate(MainTimebase+VirtualTimebase, lCalcStart, S3Ptr, SIGNAL3_Intpolate); }
				
				if ((MenuStatus[MENU_TIMEBASE][1] == BTN_ON) && (ZoomFactorDel < 1))	//delayed mode
				{ Interpolate(MainTimebase - DelayedTimebase - 1, lDel_IntPol_Offs, S3Ptr, SIGNAL3_Intpolate_delayed); }
			}	
			
			if (Channel_4_Active)
			{		   	
				if ((MainTimebase + VirtualTimebase) < 4)
				{ Interpolate(MainTimebase+VirtualTimebase, lCalcStart, S4Ptr, SIGNAL4_Intpolate); }
				
				if ((MenuStatus[MENU_TIMEBASE][1] == BTN_ON) && (ZoomFactorDel < 1))	//delayed mode
				{ Interpolate(MainTimebase - DelayedTimebase - 1, lDel_IntPol_Offs, S4Ptr, SIGNAL4_Intpolate_delayed); }
			}
		}	

	}
	//---------------------------------------------
	//         	FFT
	//---------------------------------------------
	else
	{
		//if(FFT_NewData || !Run)	// BF calculate spectrum
		if(FFT_NewData)		
		{ 
			//if(Channel_1_Active) FFT_CalcSpectrum(S1Ptr+draw_start,SPECTRUM);
			if(Channel_1_Active) FFT_CalcSpectrum(SIGNAL1,SPECTRUM);
			else if(Channel_2_Active) FFT_CalcSpectrum(S2Ptr+draw_start,SPECTRUM);
			else if(Channel_3_Active) FFT_CalcSpectrum(S3Ptr+draw_start,SPECTRUM);
			else if(Channel_4_Active) FFT_CalcSpectrum(S4Ptr+draw_start,SPECTRUM);
		}	
		
		return;
	}	



	//---------------------------------------------------------------------------------------
	//				MATH functions
	//---------------------------------------------------------------------------------------
	
	if (Channel_Math_Active) 
	{
		int lfactor;

		//width of calculating for math functions
//		lcalcstop = draw_start + ((GRID_WIDTH + 30) * draw_factor);	//BF ????? can be optimized!!
//		if (lcalcstop > 16280){lcalcstop = 16280;}
	
	
		//set pointers to signals
		if ((MainTimebase + VirtualTimebase) < 4) 	//BF 20ns + 10ns + 5ns + 2ns main mode - interpolated signal
		{
			lPtr_S1 = SIGNAL1_Intpolate;
			lPtr_S2 = SIGNAL2_Intpolate;
			lPtr_SM = SIGNALM_Intpolate;
		}
		else
		{
			lPtr_S1 = S1Ptr;
			lPtr_S2 = S2Ptr;
			lPtr_SM = SIGNALM;
		}
		SMPtr = SIGNALM;	// global math pointer to signal math	

		if (MenuStatus[MENU_TIMEBASE][1] == BTN_ON)	//Delayed
		{ lfactor = 1;	}				// 1 -> calculate all math values
		else 						//Main Mode
		{ lfactor = draw_factor; } 			// only calc the displayed values

		if (Channel_1_Active && Channel_2_Active)
		{

			//---------------------------------------------
			//         MATH function multiply
			//---------------------------------------------
			if (MenuStatus[MENU_MATH][2] == BTN_ON)      		// multiply 
			{	
				//set global math scaling and offset for drawing routine
				math_scale = math_mul_scale - 166;
				Math_Offset = Math_Mul_Offset;
				
				//calculate main math signal
				CalcMathMul(draw_start, lCalcStop, lfactor, lPtr_S1, lPtr_S2, lPtr_SM);
				
				//calculate delayed math signal
				if ((MenuStatus[MENU_TIMEBASE][1] == 241) && ((MainTimebase - DelayedTimebase -1) < 4))	//BF #003
				{ CalcMathMul(0, GRID_WIDTH+1, 1, SIGNAL1_Intpolate_delayed, SIGNAL2_Intpolate_delayed, SIGNALM_Intpolate_delayed); }
			}	//multiply end
	
			//---------------------------------------------
			//         MATH function subtract
			//---------------------------------------------
	
			else if (MenuStatus[MENU_MATH][3] == BTN_ON)            	// subtract
			{	
				//set global math scaling and offset for drawing routine
				math_scale = math_sub_scale - 150;
				Math_Offset = Math_Sub_Offset;
				
				//calculate main math signal
				CalcMathSub(draw_start, lCalcStop, lfactor, lPtr_S1, lPtr_S2, lPtr_SM);
	
				//calculate delayed math signal
				if ((MenuStatus[MENU_TIMEBASE][1] == 241) && ((MainTimebase - DelayedTimebase -1) < 4))	//BF #003
				{ CalcMathSub(0, GRID_WIDTH+1, 1, SIGNAL1_Intpolate_delayed, SIGNAL2_Intpolate_delayed, SIGNALM_Intpolate_delayed); }
			}	//subtract end
	
			//---------------------------------------------
			//         MATH function add
			//---------------------------------------------
			else if (MenuStatus[MENU_MATH][4] == BTN_ON)            	// add
			{
				//set global math scaling and offset for drawing routine
				math_scale = math_add_scale - 150;
				Math_Offset = Math_Add_Offset;
				
				//calculate main math signal
				CalcMathAdd(draw_start, lCalcStop, lfactor, lPtr_S1, lPtr_S2, lPtr_SM);
	
				//calculate delayed math signal
				if ((MenuStatus[MENU_TIMEBASE][1] == BTN_ON) && ((MainTimebase - DelayedTimebase -1) < 4))	//BF #003
				{ CalcMathAdd(0, GRID_WIDTH+1, 1, SIGNAL1_Intpolate_delayed, SIGNAL2_Intpolate_delayed, SIGNALM_Intpolate_delayed); }
			}	//add end
		}
		else if ((!Channel_1_Active && Channel_2_Active) || (!Channel_2_Active && Channel_1_Active))
		{
			for(int i=0;i<16280;i++) SIGNALM[i] = ADC_ZERO;		
			for(int i=0;i<1199;i++) SIGNALM_Intpolate[i] = ADC_ZERO;
		}
		

	}//Math End


} //Signal processing end 
//##########################################################################################################################################################
// BF Timebase 50ns is the fastest real timebase. For timebase 20nS, 10nS, 5nS and 2nS the additional samples must be interpolated 
// BF replaced complete interpolation with a simplified routine
// BF new linear interpolation
void Signal::Interpolate(int timebase, int start, unsigned char *SignalData, unsigned char *InterpolateResult)
{
    int ix,iy,incr;
	
	if (UI_request) return;	

	//printf("\r\ninterpolation start %d\r\n", start);	

	if(!test_sw2)
	{
		//printf("Linear interpolation on TB %d\r\n", timebase);

		if (timebase == 0)		// 2ns 
		{
			for(ix=0,iy=start;ix < (GRID_WIDTH + 25);ix+=25,iy++)
			LinearInterpolation(ix, (int)SignalData[iy], ix + 25, (int)SignalData[iy+1], InterpolateResult);
		}
		else if (timebase == 1)		// 5ns 
		{
			for(ix=0,iy=start;ix < (GRID_WIDTH + 10);ix+=10,iy++)
			LinearInterpolation(ix, (int)SignalData[iy], ix + 10, (int)SignalData[iy+1], InterpolateResult);
		}
		else if (timebase == 2)		// 10ns 
		{
			for(ix=0,iy=start;ix < (GRID_WIDTH + 5);ix+=5,iy++)
			LinearInterpolation(ix, (int)SignalData[iy], ix + 5, (int)SignalData[iy+1], InterpolateResult);
		}
		else if (timebase == 3)		// 20ns 
		{
			for(ix=0,iy=start,incr=2;ix < (GRID_WIDTH + 25);ix+=incr,iy++)
			{
				//toggle increment
				if(incr == 2){incr = 3;}
				else{incr = 2;}

				LinearInterpolation(ix, (int)SignalData[iy], ix + incr, (int)SignalData[iy+1], InterpolateResult);
			}

		}
		else
		{ printf("\r\nUnsupported timebase %d\r\n", timebase); }
	
	}
	else
	{
		int delta,rx;
		
		//printf("Simple interpolation on TB %d\r\n", timebase);

		if (timebase == 0)		// 2ns 
		{
			//for(ix=start,rx=0;rx < ((GRID_WIDTH * 2)-25);ix++,rx+=25)
			for(ix=start,rx=0;rx < (GRID_WIDTH + 25);ix++,rx+=25)
			{
				//copy original value
				InterpolateResult[rx] = SignalData[ix];
	
				//calc the difference between actual and next value
				delta = (SignalData[ix+1] - SignalData[ix]);
				
				//interpolate the next 24 values
				for (int j=1;j <= 24;j++)
				{ InterpolateResult[rx+j] = SignalData[ix] + (delta / ( 25 -j ) ); }
			}
		}
		else if (timebase == 1)		// 5ns 
		{
			//for(ix=start,rx=0;rx < ((GRID_WIDTH * 2)-10);ix++,rx+=10)
			for(ix=start,rx=0;rx < (GRID_WIDTH + 10);ix++,rx+=10)
			{
				//copy original value
				InterpolateResult[rx] = SignalData[ix];
	
				//calc the difference between actual and next value
				delta = (SignalData[ix+1] - SignalData[ix]);
				
				//interpolate the next 9 values
				for (int j=1;j <= 9;j++)
				{ InterpolateResult[rx+j] = SignalData[ix] + (delta / ( 10 -j ) ); }
			}
		}
		else if (timebase == 2)		// 10ns 
		{
			//for(ix=start,rx=0;rx < ((GRID_WIDTH * 2)-5);ix++,rx+=5)
			for(ix=start,rx=0;rx < (GRID_WIDTH + 5);ix++,rx+=5)
			{
				//copy original value
				InterpolateResult[rx] = SignalData[ix];
	
				//calc the difference between actual and next value
				delta = (SignalData[ix+1] - SignalData[ix]);
				
				//interpolate the next 4 values
				for (int j=1;j <= 4;j++)
				{ InterpolateResult[rx+j] = SignalData[ix] + (delta / ( 5 -j ) ); }
			}
	
		}
		else if (timebase == 3)		// 20ns 
		{
			//for(ix=start,rx=0,incr=1;rx < ((GRID_WIDTH * 2)-3);ix++,rx+=(incr+1))
			for(ix=start,rx=0,incr=1;rx < (GRID_WIDTH + 3);ix++,rx+=(incr+1))
			{
				//toggle increment
				if(incr == 1){incr = 2;}
				else{incr = 1;}
	
				//copy original value
				InterpolateResult[rx] = SignalData[ix];
	
				//calc the difference between actual and next value
				delta = (SignalData[ix+1] - SignalData[ix]);
			
				//interpolate the next 1 - 2  values
				for (int j=1;j <= incr;j++)
				{ InterpolateResult[rx+j] = SignalData[ix] + (delta / ( incr + 1 -j ) ); }
			}
		}
		else
		{ printf("\r\nUnsupported timebase %d\r\n", timebase); }

	}
}
//##########################################################################################################################################################
// BF linear interpolation with Bresenham algorithm
void Signal::LinearInterpolation(int x1, int y1, int x2, int y2, unsigned char *interpolation)
{
	
	//--------------------------------------------
	//special case horizontal line
	//--------------------------------------------
	if(y1 == y2)
	{
		if(x1 < x2)
		for(; x1 != x2; x1++)	{ interpolation[x1] = (char)y1; }
		else
		for(; x2 != x1; x2++)	{ interpolation[x2] = (char)y1; }
		return;
	}	

	//--------------------------------------------
	//special case vertical line
	//--------------------------------------------
	else if(x1 == x2)
	{
		if(y1 < y2)
		for(; y1 != y2; y1++)	{ interpolation[x1] = (char)y1; }
		else
		for(; y2 != y1; y2++)	{ interpolation[x1] = (char)y2; }
		return;
	}	

	//-------------------------------------------------------------
	// Bresenham algorithm for drawing diagonal lines
	//-------------------------------------------------------------
	int dy = y2 - y1;
        int dx = x2 - x1;
        int stepx, stepy;

	//check if delta is positive or negative
	if (dy < 0) { dy = -dy;  stepy = -1; } else { stepy = 1; }
        if (dx < 0) { dx = -dx;  stepx = -1; } else { stepx = 1; }

	//special case exact 45 degrees delta x / delta y = 1
	if (dx == dy)
	{
		//horizontal and vertical component increment constant with 1 
		if(x1 < x2) 
		{
			if(y1 < y2)
			{ 
				for(; x1 != x2; x1++, y1++)
				{ interpolation[x1] = (char)y1; }
				return;
			}
			else if(y1 > y2)
			{
				for(; x1 != x2; x1++, y1--)
				{ interpolation[x1] = (char)y1; }
				return;
			}
			
		}
		else if(x1 > x2)
		{
			if(y1 < y2) 
			{
				for(; x1 != x2; x1--, y1++)
				{ interpolation[x1] = (char)y1; }
				return;
			}
			else if(y1 > y2)
			{
				for(; x1 != x2; x1--, y1--)
				{ interpolation[x1] = (char)y1; }
				return;
			}
		}
	}

	
        dy <<= 1;                              		// dy is now 2*dy
        dx <<= 1;                              		// dx is now 2*dx
	
	//set starting point
	interpolation[x1] = (char)y1;
	
	//---------------------------------------------
	//between horizontal and 45 degrees
	//---------------------------------------------
	if (dx > dy)
	{
		int fraction = dy - (dx >> 1);   	// same as 2*dy - dx
		while (x1 != x2) {
			if (fraction >= 0) {
			y1 += stepy;
			fraction -= dx;              	// same as fraction -= 2*dx
			}
			x1 += stepx;
			fraction += dy;          	// same as fraction -= 2*dy
			interpolation[x1] = (char)y1;
		}
        	return;
	}

	//---------------------------------------------
	//between vertical and 45 degrees
	//---------------------------------------------
	if (dx < dy)
	{
		int fraction = dx - (dy >> 1);
		while (y1 != y2) {
			if (fraction >= 0) {
			x1 += stepx;
			fraction -= dy;
			}
			y1 += stepy;
			fraction += dx;
			interpolation[x1] = (char)y1;
		}
		return;
        }

}
//##########################################################################################################################################################
// BF -> generate test signals on all channels
void Signal::TestSignalGenerate(void)
{
	int ix, iy, tog, pw;
	int  lVirtual_Zero = 0;
	char lDCOffset     = 0;

	if (Channel_1_Active)	// draw rectangle signal
	{
		lVirtual_Zero = ADC_ZERO + (int)((float)Virtual_ZeroLevelCH1 / ScaleFactor[Selected_Voltage_CH1][GainIdx]);
		if (lVirtual_Zero > 255) lVirtual_Zero = 255;	//Limiter
		if (lVirtual_Zero < 0) lVirtual_Zero = 0;
	
		// Signal 1 (Yellow)
		tog = 0;
		iy = lVirtual_Zero + 100;		//Amplitude

		if ( MenuStatus[MENU_CHANNEL1][0] == 8) 	//AC
		lDCOffset = 0;//-20;
		else if ( MenuStatus[MENU_CHANNEL1][0] == 7)	//DC
		lDCOffset = 0;
		else						//GND
		{
			for (ix = 0; (ix < 16384) && !UI_request; ix++)
			SIGNAL1[ix] = lVirtual_Zero;
		}
		
		if ( MenuStatus[MENU_CHANNEL1][0] != 6)
		for (ix = 0, pw = 0; (ix < 16384) && !UI_request; ix++, pw++)
		{	
			//if (ix %200 == 0) 		//Pulswidth
			//if (ix %50 == 0) 		//Pulswidth
			if(pw==50)			//Pulswidth
			{
				pw = 0;
				if (tog == 0) tog = 1;
				else tog = 0;
			}
			
			if (tog == 0)
			{ iy = lVirtual_Zero - 73; }	//Amplitude
			else
			{ iy = lVirtual_Zero + 72;}	//Amplitude
	
			if (iy > 255) iy = 255;	//Limiter
			if (iy < 0) iy = 0;
		
			SIGNAL1[ix] = (char)iy + lDCOffset;
		}	
	
	}

	if (Channel_2_Active)
	{
		lVirtual_Zero = ADC_ZERO + int((float)Virtual_ZeroLevelCH2 / ScaleFactor[Selected_Voltage_CH2][GainIdx]);
		if (lVirtual_Zero > 255) lVirtual_Zero = 255;	//Limiter
		if (lVirtual_Zero < 0) lVirtual_Zero = 0;

		// Signal 2 (Green)
		tog = 0;	
		iy = lVirtual_Zero;
	
		if ( MenuStatus[MENU_CHANNEL2][0] == 8) 	//AC
		lDCOffset = 0;
		else if ( MenuStatus[MENU_CHANNEL2][0] == 7)	//DC
		lDCOffset = 20;
		else						//GND
		{
			for (ix = 0; (ix < 16384) && !UI_request; ix++)
			SIGNAL2[ix] = lVirtual_Zero;
		}

		if ( MenuStatus[MENU_CHANNEL2][0] != 6)
		// calculate sinus signal
		for (ix = 0, iy = 0; (ix < 16384) && !UI_request; ix++, iy+=4)
		{
			if(iy >= 1024)
			iy = 0;

			SIGNAL2[ix] = lVirtual_Zero + (iSin1024[iy] >> 4);
		}
		
/*
		// calculate triangle signal
		for (ix = 0; (ix < 16384) && !UI_request; ix++)
		{
			if (ix %80 == 0)
			{
				if (tog == 0) tog = 1;
				else tog = 0;
			}
			
			if (ix %2 == 0)
			{
				if (tog == 0) iy++;
				else iy--;
			}
			if (iy > 255) iy = 255;	//Limiter
			if (iy < 0) iy = 0;

			SIGNAL2[ix] = (char)iy + lDCOffset;
		}	
*/	
	}

	if (NumberOfChannels == 2)
	return;

	if (Channel_3_Active)
	{
		lVirtual_Zero = ADC_ZERO + int((float)Virtual_ZeroLevelCH3 / ScaleFactor[Selected_Voltage_CH3][GainIdx]);
		if (lVirtual_Zero > 255) lVirtual_Zero = 255;	//Limiter
		if (lVirtual_Zero < 0) lVirtual_Zero = 0;

		// Signal 3 (Purple)
		tog = 0;	
		iy = lVirtual_Zero + 25;
		
		if ( MenuStatus[MENU_CHANNEL3][0] == 8) 	//AC
		lDCOffset = -30;
		else if ( MenuStatus[MENU_CHANNEL3][0] == 7)	//DC
		lDCOffset = 0;
		else						//GND
		{
			for (ix = 0; (ix < 16384) && !UI_request; ix++)
			SIGNAL3[ix] = lVirtual_Zero;
		}

		
		if ( MenuStatus[MENU_CHANNEL3][0] != 6)
		for (ix = 0, pw = 0; (ix < 16384) && !UI_request; ix++,pw++)
		{	
			//if (ix %150 == 0) 		//Pulswidth
			if (pw == 150) 			//Pulswidth
			{
				pw = 0;
				if (tog == 0) tog = 1;
				else tog = 0;
			}
			
			if (tog == 0)
			{ iy = lVirtual_Zero - 25; }	//Amplitude
			else
			{ iy = lVirtual_Zero + 25;}	//Amplitude
	
			if (iy > 255) iy = 255;	//Limiter
			if (iy < 0) iy = 0;
		
			SIGNAL3[ix] = (char)iy + lDCOffset;
		}	
	}

	if (Channel_4_Active)
	{
		lVirtual_Zero = ADC_ZERO + int((float)Virtual_ZeroLevelCH4 / ScaleFactor[Selected_Voltage_CH4][GainIdx]);
		if (lVirtual_Zero > 255) lVirtual_Zero = 255;	//Limiter
		if (lVirtual_Zero < 0) lVirtual_Zero = 0;

		// Signal 4 (Red)
		tog = 0;	
		iy = lVirtual_Zero;
		
		
		if ( MenuStatus[MENU_CHANNEL4][0] == 8) 	//AC
		lDCOffset = 0;
		else if ( MenuStatus[MENU_CHANNEL4][0] == 7)	//DC
		lDCOffset = 25;
		else						//GND
		{
			for (ix = 0; (ix < 16384) && !UI_request; ix++)
			SIGNAL4[ix] = lVirtual_Zero;
		}
	
		if ( MenuStatus[MENU_CHANNEL4][0] != 6)
		for (ix = 0; (ix < 16384) && !UI_request; ix++)
		{
			if (ix %100 == 0)			//period
			{
				if (tog == 0) tog = 1;
				else tog = 0;
			}
			
			if (ix %2 == 0)	 			//Amplitude
			{
				if (tog == 0) iy++;
				else iy--;
			}
			if (iy > 255) iy = 255;	//Limiter
			if (iy < 0) iy = 0;

			SIGNAL4[ix] = (char)iy + lDCOffset;
		}	
	}
	if(FFT_Mode != FFT_OFF)
	FFT_NewData = 1;


}
//##########################################################################################################################################################
//BF for combi-trigger
void Signal::CalcMinMax(int start, int stop, int stepwidth ,unsigned char *SignalData1,  unsigned char *min, unsigned char *max){
  	int lix;
	int lbuffer, lvalue1,lvalue2;
	
	*min=255;
	*max=0;

	for (lix = start; lix < stop; lix+=stepwidth)
	{
		//convert to signed integer
		if (SignalData1[lix]>*max)
			*max=SignalData1[lix];
		if (SignalData1[lix]<*min)
			*min=SignalData1[lix];
	}
}
//##########################################################################################################################################################
//BF lookup tables for drawing routines
void Signal::Build_ScaleLookupTable(void)
{

	for (int i=0;i<256;i++)
	{
		ScaleLookupTable[i][0] = (short)((float)(i-ADC_ZERO) * ScaleFactor[0][GainIdx]);	//1er + 2er ranges
		ScaleLookupTable[i][1] = (short)((float)(i-ADC_ZERO) * ScaleFactor[2][GainIdx]);	//5er ranges
	}

}
//##########################################################################################################################################################
//BF FFT lookup table for drawing routines
void Signal::FFT_BuildScaleLookupTable(void)
{
	
	//get scaling index of active channel
	if(MenuStatus[MENU_FFT][0] == 137)	//FFT source channel 1
	{ 
		for (int i=0;i<256;i++)
		{ FFT_ScaleLookupTable[i] = (short)((float)i * ScaleFactor[0][GainIdx] * FFT_ScaleCorrection[Selected_Voltage_CH1][MenuStatus[MENU_FFT][2] - 66]); }
	}
	else if(MenuStatus[MENU_FFT][0] == 138)	//FFT source channel 2
	{ 
		for (int i=0;i<256;i++)
		{ FFT_ScaleLookupTable[i] = (short)((float)i * ScaleFactor[0][GainIdx] * FFT_ScaleCorrection[Selected_Voltage_CH2][MenuStatus[MENU_FFT][2] - 66]); }
	}
	else if(MenuStatus[MENU_FFT][0] == 139)	//FFT source channel 3
	{ 
		for (int i=0;i<256;i++)
		{ FFT_ScaleLookupTable[i] = (short)((float)i * ScaleFactor[0][GainIdx] * FFT_ScaleCorrection[Selected_Voltage_CH3][MenuStatus[MENU_FFT][2] - 66]); }
	}
	else if(MenuStatus[MENU_FFT][0] == 140)	//FFT source channel 4
	{ 
		for (int i=0;i<256;i++)
		{ FFT_ScaleLookupTable[i] = (short)((float)i * ScaleFactor[0][GainIdx] * FFT_ScaleCorrection[Selected_Voltage_CH4][MenuStatus[MENU_FFT][2] - 66]); }
	}



}
//##########################################################################################################################################################
//BF Noise Filter with proprietary algorithm
void Signal::LowPassFilter(int start, int stop, char strength, unsigned char *input, unsigned char *output)
{

	int lmin;					//values to the left side
	int lmax;					//values to the right side
	int lsum;					//totals
	

	// the samples between the undelayed samples are needed so we have to copy the complete signal window to output
	if (MenuStatus[MENU_TIMEBASE][1] == BTN_ON)
	{
		for(int i=start;i < stop ;i++)
		{ output[i] = input[i]; }
	}


	if (strength == 1)	// nearly lossless filtering -> corner frequency at 1GSa/s ca. 80 - 90Mhz
	{
		if (draw_factor < 4)
		{
			lmin = -1;
			lmax =  2;	

			for(int i=start;i < stop ;i+=draw_factor)		// go to next value
			{
				lsum = 0;
				for(int f=lmin;f<=lmax;f++)			// add the values from the left and the right
				lsum += input[i+f];
			
				output[i] = (unsigned char)(lsum>>2);		// calculate average
			}

		}
		else if (draw_factor == 4 || draw_factor == 5)
		{
			lmin = -3;
			lmax = 4;
	
			for(int i=start;i < stop ;i+=draw_factor)		// go to next value
			{
				lsum = 0;
				for(int f=lmin;f<=lmax;f++)			// add the values from the left and the right
				lsum += input[i+f];
				
				output[i] = (unsigned char)(lsum>>3);		// calculate average
			}
		}
		else if (draw_factor >= 10)	
 		{
			lmin = -7;
			lmax = 8;
	
			for(int i=start;i < stop ;i+=draw_factor)		// go to next value
			{
				lsum = 0;
				for(int f=lmin;f<=lmax;f++)			// add the values from the left and the right
				lsum += input[i+f];
				
				output[i] = (unsigned char)(lsum>>4);		// calculate average
			}	
		}
	}
	else if (strength == 2)		// strong filtering with loss of bandwidth -> corner frequency at 1GSa/s ca. 30Mhz
	{

		if (draw_factor < 4)
		{
			lmin = -3;
			lmax =  4;	

			for(int i=start;i < stop ;i+=draw_factor)		// go to next value
			{
				lsum = 0;
				for(int f=lmin;f<=lmax;f++)			// add the values from the left and the right
				lsum += input[i+f];
			
				output[i] = (unsigned char)(lsum>>3);		// calculate average
			}

		}
		else if (draw_factor == 4 || draw_factor == 5)
		{
			lmin = -7;
			lmax = 8;
	
			for(int i=start;i < stop ;i+=draw_factor)		// go to next value
			{
				lsum = 0;
				for(int f=lmin;f<=lmax;f++)			// add the values from the left and the right
				lsum += input[i+f];
				
				output[i] = (unsigned char)(lsum>>4);		// calculate average
			}
		}
		else if (draw_factor >= 10)	
 		{
			lmin = -15;
			lmax = 16;
	
			for(int i=start;i < stop ;i+=draw_factor)		// go to next value
			{
				lsum = 0;
				for(int f=lmin;f<=lmax;f++)			// add the values from the left and the right
				lsum += input[i+f];
				
				output[i] = (unsigned char)(lsum>>5);		// calculate average
			}	
		}


	}


}
//##########################################################################################################################################################
//BF Noise Filter (low pass)	
// IIR algorithm  filterOutput(next) = filterOutput + k * (signal - filterOutput) (k = 0.0....1.0)
//  => y[i+1] = y[i] + (x[i]-y[i])/(2^k)
//
void Signal::IIR_Filter(int start, int stop, char stage, unsigned char *input, unsigned char *output)
{
	
	int lsum;
	int lstart = start -10;

	if(stage == 1)								// corner frequency at 1GSa/s ca. 70Mhz with coefficient 0.5 
	{
		output[lstart] = input[lstart];

		for (int i=lstart;i<stop;i++)
		{ 
			lsum = ((int)input[i] - (int)output[i])>>1;		// using 2 (coefficient 0.25) corner frequency is ca.  30Mhz
			output[i+1] = (unsigned char)((int)output[i] + lsum);	
		}
	}


	if(stage == 2)								// corner frequency at 1GSa/s ca. 35 - 40Mhz with coefficients 0.5 
	{
		CopyBuffer[lstart] = input[lstart];

		for (int i=lstart;i<stop;i++)
		{ 
			lsum = ((int)input[i] - (int)CopyBuffer[i])>>1;	
			CopyBuffer[i+1] = (unsigned char)((int)CopyBuffer[i] + lsum);	
		}

		output[lstart] = CopyBuffer[lstart];

		for (int i=lstart;i<stop;i++)
		{ 
			lsum = ((int)CopyBuffer[i] - (int)output[i])>>1;	
			output[i+1] = (unsigned char)((int)output[i] + lsum);	
		}

	}


	if(stage == 3)								// corner frequency at 1GSa/s ca. 20Mhz with coefficients 0.5 and 0.25 in the last stage
	{
		for (int i=lstart;i<stop;i++)
		{ 
			output[lstart] = input[lstart];

			lsum = ((int)input[i] - (int)output[i])>>1;	
			output[i+1] = (unsigned char)((int)output[i] + lsum);	
		}

		CopyBuffer[lstart] = output[lstart];

		for (int i=lstart;i<stop;i++)
		{ 
			lsum = ((int)output[i] - (int)CopyBuffer[i])>>1;	
			CopyBuffer[i+1] = (unsigned char)((int)CopyBuffer[i] + lsum);	
		}

		output[lstart] = CopyBuffer[lstart];

		for (int i=lstart;i<stop;i++)
		{ 
			lsum = ((int)CopyBuffer[i] - (int)output[i])>>2;	
			output[i+1] = (unsigned char)((int)output[i] + lsum);	
		}

	}


}
//##########################################################################################################################################################
/*
//BF average
void Signal::Average(int start, int stop, unsigned char mode, unsigned char *input, unsigned char *avrg_buffer)
{




}
*/



