/* Header fr HHOrbits.cpp    */
/* ursprnglich: "N3EMO Orbit Simulator routines  v3.7"  */
/* Inhalt:  Satelliten-Positionen berechnen */

#ifndef HHOrbits_INCLUDED 
#define HHOrbits_INCLUDED 


typedef double mat3x3[3][3];




/* Initialize the Sun's Keplerian elements for a given epoch.
   Formulas are from "Explanatory Supplement to the Astronomical Ephemeris".
   Also init the sidereal reference. */

extern void InitOrbitRoutines(double EpochDay);



/* Solve Kepler's equation                                      */
/* Inputs:                                                      */
/*      MeanAnomaly     Time Since last perigee, in radians.    */
/*                      PI2 = one complete orbit.               */
/*      Eccentricity    Eccentricity of orbit's ellipse.        */
/* Output:                                                      */
/*      TrueAnomaly     Angle between perigee, geocenter, and   */
/*                      current position.                       */

extern double Kepler(double MeanAnomaly, double Eccentricity);


/* berechnet den Sub-Satelliten-Punkt
  Input:  SatX, SatY, SatZ = Satelliten-Vektor
          Time             = aktuelle Zeit

  Output: Latitude,Longitude,Height : alles double  */
extern void GetSubSatPoint(double SatX, double SatY, double SatZ,
	   			           double Time,
				           double *Latitude, double *Longitude, double *Height);




extern void GetPrecession (double SemiMajorAxis, double Eccentricity, double Inclination,
                           double *RAANPrecession, double *PerigeePrecession);


/* Compute the satellite postion and velocity in the RA based coordinate system */
extern void GetSatPosition (double EpochTime, double EpochRAAN, double EpochArgPerigee,
					        double SemiMajorAxis, double Inclination, double Eccentricity,
					        double RAANPrecession, double PerigeePrecession, double Time,
					        double TrueAnomaly,
					        double *X, double *Y, double *Z,
					        double *Radius, double *VX, double *VY, double *VZ);


/* ob 'verfinstert', vermutlich ob Satellit unsichtbar ist */
extern int Eclipsed(double SatX, double SatY, double SatZ,
			 double SatRadius, double CurrentTime);


/* Compute the site postion and velocity in the RA based coordinate system. 
   SiteMatrix is set to a matrix which is used by GetTopoCentric to convert
   geocentric coordinates to topocentric (observer-centered) coordinates. */
extern void GetSitPosition (double SiteLat, double SiteLong, double SiteElevation,
 					        double CurrentTime,
                            double *SiteX,  double *SiteY, double *SiteZ,
                            double *SiteVX, double *SiteVY, mat3x3 SiteMatrix);



extern void GetBearings(double SatX, double SatY, double SatZ,
				 double SiteX, double SiteY, double SiteZ,
                 mat3x3 SiteMatrix, double *Azimuth, double *Elevation);



extern void GetRange (double SiteX,  double SiteY, double SiteZ,
			          double SiteVX, double SiteVY,
                      double SatX,   double SatY,  double SatZ,
                      double SatVX,  double SatVY, double SatVZ,
                      double *Range, double *RangeRate);


/* Convert from geocentric RA based coordinates to topocentric
   (observer centered) coordinates */
extern void GetTopocentric (double SatX,  double SatY,  double SatZ,
						           double SiteX, double SiteY, double SiteZ,
						           mat3x3 SiteMatrix, double *X, double *Y, double *Z);









#endif

