

#include <stdlib.h>
#include <math.h>
#include "HHSat.h"
#include "HHSatCalc.h"
#include "HHSatDraw.h"
#include "HHOrbits.h"


/* Variablen fr Satellitenberechnung */

struct satellite sat; // Vorgabe: Kepler-Elemente und Satellitenname
double TLE_MaxAge;    // Vorgabe zum TLE-Einlesen


TCHAR  siteNam[24];
double siteLat;       // Vorgabe: Beobachter-Position
double siteLon;


/* Ergebnisse : Breite und Lnge des Satelliten */
double  satLAT;   
double  satLONG;
double  satHEIGHT;

/* Ergebnisse: Azimuth und Elevation des Satelliten */
double  satAZ;          
double  satEL;


/* andere Ergebnisse */
bool    isEclipsed;
double  Range;
double  RangeRate;
double  AgeOfTLE;
double  SatEpDay;

/**********************************************************************************/

#define dtr(x) ((x) * (PI / 180.0))                       /* Degree->Radian */
#define rtd(x) ((x) / (PI / 180.0))                       /* Radian->Degree */



bool Val_long(TCHAR* Pt, long* Pl)
{ long L;
  bool vorzeichen;
  int i;
  TCHAR c;

  vorzeichen = FALSE;
  L = 0;
  while (*Pt==' ') Pt++;
  c = *Pt++;
  if (c== '-')
   { vorzeichen = 1;
     c = *Pt++;
   }
  if (c=='+') c = *Pt++;

Schleife:
  if (!c) goto Schlend;
  if (c<'0') return FALSE;
  if (c>'9') return FALSE;
  i = c - '0';
  L = L * 10 + i;
  c = *Pt++;
  goto Schleife;
Schlend:
  if (vorzeichen) L = - L;
  *Pl = L;
  return TRUE;
}



bool Val_double(TCHAR* Pt, double* Pd)
{ double R, T;
  bool dp_seen, vorzeichen;
  int i;
  TCHAR c;

  dp_seen = vorzeichen = FALSE;
  R = 0;
  T = 1;
  while (*Pt==' ') Pt++;
  c = *Pt++;
  if (c== '-')
   { vorzeichen = 1;
     c = *Pt++;
   }
  if (c=='+') c = *Pt++;

Schleife:
  if (!c) goto Schlend;
  if (c=='.') { c=  *Pt++; dp_seen=1; }
  if (c<'0') return FALSE;
  if (c>'9') return FALSE;
  i = c - '0';
  R = R * 10.0 + i;
  if (dp_seen) T = T * 10.0;
  c = *Pt++;
  goto Schleife;
Schlend:
  R = R / T;
  if (vorzeichen) R = - R;
  *Pd = R;
  return TRUE;
}



TCHAR* wcopy (TCHAR* String, int where, int howmuch, TCHAR* toWhere)
{ TCHAR* Pt;
  TCHAR* Pz;
  Pt = &String[where];
  Pz = toWhere;
  while (howmuch--) *Pz++ = *Pt++;
  *Pz = 0;
  return Pz;
}



/*
Beispiel:
NOAA 18                 
1 28654U 05018A   07131.45212422  .00000285  00000-0  18244-3 0  9495
2 28654  98.8260  73.3543 0014718  16.1727 343.9897 14.11063425101675
|        1|0       2|0       3|0       4|0       5|0       6|0  
012345678901234567890123456789012345678901234567890123456789012345678
*/

bool Read_TLE_Entry (TCHAR* S_Name,
                     TCHAR* Line1, 
                     TCHAR* Line2)
                     
{ int i;
  TCHAR ts[32];
  long L;
  double D;

  memset(&sat, 0, sizeof sat);            /* Clear structure to allow equality tests */
  if (wcslen(Line1)<69) return FALSE;
  if (wcslen(Line2)<69) return FALSE;
  if (Line1[0]!='1') return FALSE;
  if (Line2[0]!='2') return FALSE;

  i = wcslen(S_Name);
  if (i>MAX_Sat_Name_Length) i = MAX_Sat_Name_Length;
  wcsncpy(sat.satname, S_Name, i);                   // Sat-Name kopieren

  wcopy(Line1,2,5,ts);   
  if (!Val_long(ts,&L)) return FALSE;
  sat.number = L;

  wcopy(Line1,9,2,ts);   
  if (!Val_long(ts,&L)) return FALSE;
  sat.intdes.launchyear = L;
 
  wcopy(Line1,11,3,ts);   
  if (!Val_long(ts,&L)) return FALSE;
  sat.intdes.launchno = L;

  i = 0;
  while (i<3) { sat.intdes.pieceno[i] = Line1[14+i]; ++i; }

  wcopy(Line1,18,2,ts);   
  if (!Val_long(ts,&L)) return FALSE;
  sat.epochyear = L;

  wcopy(Line1,20,12,ts);  
  if (!Val_double(ts,&D)) return FALSE;
  sat.epochday = D;

  i = 0; ts[0] = Line1[33]; if (ts[0]=='-') ++i;
  ts[i++] = '0'; wcopy(Line1,34,9,&ts[i]);
  if (!Val_double(ts,&D)) return FALSE;
  sat.meanmotiond1 = D;  // decay = 1. Ableitung der MeanMotion

  i = 0; ts[0] = Line1[44]; if (ts[0]=='-') ++i;
  ts[i++] = '0'; ts[i++] = '.';
  wcopy(Line1,45,5,&ts[i]);
  if (Val_double(ts,&D)) // kann auch leer sein!
	{ i = Line1[51]; L = 1;
      while (i>'0') { L = L * 10; --i; }
	  sat.meanmotiond2 = D / L;
    }

  i = 0; ts[0] = Line1[53]; if (ts[0]=='-') ++i;
  ts[i++] = '0'; ts[i++] = '.';
  wcopy(Line1,54,5,&ts[i]); if (!Val_double(ts,&D)) return FALSE;
  i = Line1[60]; L = 1;
  while (i>'0') { L = L * 10; --i; }
  if (Line1[59]=='-') D = D / L;
  else if (Line1[59]=='+') D = D * L;
       else return FALSE;
  sat.dragterm = D;
  sat.ephtype = Line1[62] - '0';
  wcopy(Line1,65,3,ts); if (!Val_long(ts,&L)) return FALSE;
  sat.elemnumber = L;
  
  wcopy(Line2,2,5,ts); if (!Val_long(ts,&L)) return FALSE;
  if (sat.number != L) return FALSE;
  
  wcopy(Line2,8,8,ts); if (!Val_double(ts,&D)) return FALSE;
  sat.inclination = D;

  wcopy(Line2,17,8,ts); if (!Val_double(ts,&D)) return FALSE;
  sat.rascendnode = D;

  ts[0] = '0'; ts[1] = '.';
  wcopy(Line2,26,7,&ts[2]); if (!Val_double(ts,&D)) return FALSE;
  sat.eccentricity = D;
     
  wcopy(Line2,34,8,ts); if (!Val_double(ts,&D)) return FALSE;
  sat.argperigee = D;

  wcopy(Line2,43,8,ts); if (!Val_double(ts,&D)) return FALSE;
  sat.meananomaly = D;

  wcopy(Line2,52,11,ts); if (!Val_double(ts,&D)) return FALSE;
  sat.meanmotion = D;

  wcopy(Line2,63,5,ts); if (!Val_long(ts,&L)) return FALSE;
  sat.revno = L;
    
  return TRUE;
}



/**********************************************************************************/

/*  UPDSAT  --  Update satellite position.  */

void updsat(double now)
{
    double smaxis, raanp, perigeep, reforbit, epday,
           avgmotion, currmotion, currorbit, meana, truea,
           ratx, raty, ratz, radius, satvx, satvy, satvz,
           ssplat, ssplong, sspheight, siteX, siteY, siteZ, siteVX, siteVY;
	mat3x3 siteMatrix;
    long iorbitnum, Yr;
    int yy;

    Yr = yy = sat.epochyear;
    Yr = Yr * 365;
    Yr = Yr + ((yy+3) >> 2);

    SatEpDay = epday = sat.epochday + Yr;
    AgeOfTLE = now - epday;
    smaxis = 331.25 * exp(2.0 * log((24 * 60.0) / sat.meanmotion) / 3.0);
    GetPrecession(smaxis, 
                  sat.eccentricity, 
                  dtr(sat.inclination),
                  &raanp, &perigeep);
    reforbit   = dtr(sat.meananomaly) / (2 * PI) + sat.revno;
    avgmotion  = sat.meanmotion + (now - epday) * (sat.meanmotiond1 / 2);
    currmotion = sat.meanmotion + (now - epday) * sat.meanmotiond1;
    smaxis     = 331.25 * exp(2.0 * log((24 * 60.0) / currmotion) / 3.0);
    currorbit  = reforbit + (now - epday) * avgmotion;
    iorbitnum  = (long) currorbit;

    meana      = (currorbit - iorbitnum) * (2 * PI);
    truea      = Kepler(meana, sat.eccentricity);

    GetSatPosition(epday, dtr(sat.rascendnode), dtr(sat.argperigee),
            smaxis, dtr(sat.inclination), sat.eccentricity, raanp, perigeep,
            now, truea, &ratx, &raty, &ratz, &radius, &satvx, &satvy, &satvz);

    GetSubSatPoint(ratx, raty, ratz, now, &ssplat, &ssplong, &sspheight);

    satHEIGHT = sspheight;
    satLAT    = rtd(ssplat);
    satLONG   = rtd(ssplong);

    GetSitPosition(dtr(siteLat), dtr(siteLon), 0.0, now, &siteX, &siteY, &siteZ, &siteVX, &siteVY, siteMatrix);
    GetBearings(ratx, raty, ratz, siteX, siteY, siteZ, siteMatrix, &satAZ, &satEL);

    satAZ   = rtd(satAZ);
    satEL   = rtd(satEL);

    isEclipsed = (Eclipsed(ratx, raty, ratz, radius, now)!=0);

    GetRange (siteX, siteY, siteZ,
              siteVX, siteVY,
              ratx, raty, ratz,
              satvx, satvy, satvz,
              &Range, &RangeRate);
}


