/* Typen und Konstanten fr die Satellitenberechnung */

#ifndef HHSATCALC_INCLUDED
#define HHSATCALC_INCLUDED


#include <windows.h>
#include <math.h>



#define PI 3.14159265358979323846
#define J2000				2451545.0		// Julian day of J2000 epoch
#define JulianCentury		36525.0			// Days in Julian century
#define AstronomicalUnit	149597870.0		// Astronomical unit in kilometres
#define SunSMAX	 (AstronomicalUnit * 1.000001018) // Semi-major axis of Earth's orbit
#define EarthRad			6378.14			// Earth's equatorial radius, km (IAU 1976)
#define LunatBase			2423436.0		/* Base date for E. W. Brown's numbered
											   series of lunations (1923 January 16) */
#define SynMonth			29.53058868		// Synodic month (mean time from new Moon to new Moon)




#define tan(x)	((sin(x)/cos(x)))

#define sgn(x) (((x) < 0) ? -1 : ((x) > 0 ? 1 : 0))       // Extract sign
#define abs(x) ((x) < 0 ? (-(x)) : (x))                   // Absolute val
#define fixangle(a) ((a) - 360.0 * (floor((a) / 360.0)))  // Fix angle   
#define fixangr(a)  ((a) - (PI*2) * (floor((a) / (PI*2))))  // Fix angle in radians
#define dtr(x) ((x) * (PI / 180.0))                       // Degree->Radian
#define rtd(x) ((x) / (PI / 180.0))                       // Radian->Degree



/* The  "Official"  element  sets  limit  the  satellite  name  to  12
   characters, but other, less formal sets, such as the TVRO satellite
   elements  posted  to  rec.video.satellite  use  longer  names.  The
   following  definition  lets  you  specify  the  longest  name   and
   compensate for this.  */

#define MAX_Sat_Name_Length 31

/*  Satellite data structure.  */

struct satellite {
    TCHAR satname[MAX_Sat_Name_Length + 1]; /* Satellite name         */
    long number;                      /* Satellite number             */
    struct {                          /* International designator     */
        int launchyear;               /* Last 2 digits of launch year */
        int launchno;                 /* Launch number of the year    */
        TCHAR pieceno[4];             /* Piece number of launch       */
    } intdes;
    int epochyear;                    /* Last two digits of epoch year        */
    double epochday;                  /* Julian day and fraction of epoch     */
    double meanmotiond1;              /* First time derivative of mean motion */
    double meanmotiond2;              /* Second time derivative of mean motion*/
    double dragterm;                  /* BSTAR drag term or radiation pressure coefficient. */
    int ephtype;                      /* Ephemeris type */
    int elemnumber;                   /* Element number */

    double inclination;               /* Inclination in degrees         */
    double rascendnode;               /* Right ascension of ascending node in degrees */
    double eccentricity;              /* Eccentricity                   */
    double argperigee;                /* Argument of perigee in degrees */
    double meananomaly;               /* Mean anomaly in degrees        */
    double meanmotion;                /* Mean motion in revs per day    */
    long revno;                       /* Revolution number at epoch     */
};


/* Variablen fr Satellitenberechnung */

extern struct satellite sat; // Vorgabe: Kepler-Elemente und Satellitenname
extern double TLE_MaxAge;    // Vorgabe zum TLE-Einlesen

extern TCHAR  siteNam[24];
extern double siteLat;       // Vorgabe: Beobachter-Position
extern double siteLon;


/* Ergebnisse : Breite und Lnge des Satelliten */
extern double  satLAT;   
extern double  satLONG;
extern double  satHEIGHT;

/* Ergebnisse: Azimuth und Elevation des Satelliten */
extern double  satAZ;          
extern double  satEL;


/* andere Ergebnisse */
extern bool    isEclipsed;
extern double  Range;
extern double  RangeRate;
extern double  AgeOfTLE;
extern double  SatEpDay;


extern TCHAR* wcopy        (TCHAR* String, int where, int howmuch, TCHAR* toWhere);
extern bool Val_long       (TCHAR* Pt, long* Pl);
extern bool Val_double     (TCHAR* Pt, double* Pd);
extern bool Read_TLE_Entry (TCHAR* S_Name, TCHAR* Line1, TCHAR* Line2); // Result in 'sat'
extern void updsat         (double now);

#endif
