/*
 * main.c
 *
 *  Created on: 31.08.2011
 *      Author: Frank
 */

#include <stdlib.h>
#include <avr/interrupt.h>

#include "define.h"

#ifdef DEBUG
#include "base.h"
#include "uart.h"
#endif

#include "timer.h"
#include "user.h"
#include "TLC5940.h"

#ifdef WITH_FB
#include "irmp.h"
#include "wceeprom.h"
#endif

int main( void )
{
#ifdef DEBUG
	uart_init();
#endif

#ifdef WITH_FB
	wcEeprom_init();
#endif

	cli();
	color_init();
	TLC5940_init( 12 );

#ifdef WITH_FB
	irmp_init();
	timer_init();
	user_init();
#endif
	sei();

	while( 1 )
	{
#ifdef WITH_FB
		autoleaveMenuMode();
		handle_ir_code();
#endif
		handle_leds();
	}
	return 0;
}
