/*
 * user.c
 *
 *  Created on: 29.08.2011
 *      Author: Frank
 *      Based on Wordclock - timer.c
 */

#include <inttypes.h>
#include <avr/io.h>
#ifdef WITH_FB
#include <avr/pgmspace.h>
#endif
#include <avr/interrupt.h>

#include "define.h"
#include "timer.h"
#include "user.h"
#ifdef WITH_FB
#include "irmp.h"
#include "wceeprom.h"
#endif

#define F_INTERRUPT           10000      // frequency of interrupts

#ifdef WITH_FB
#define  INTERRUPT_10000HZ    { irmp_ISR(); }
#else
#define  INTERRUPT_10000HZ    { }
#endif
#define  INTERRUPT_1000HZ     { }
#define  INTERRUPT_100HZ      { color_isr100Hz(); }
#ifdef WITH_FB
#define  INTERRUPT_10HZ       { user_isr10Hz(); }
#else
#define  INTERRUPT_10HZ       { }
#endif
#ifdef WITH_FB
#define  INTERRUPT_1HZ        { user_isr1HZ(); }
#else
#define  INTERRUPT_1HZ       { }
#endif
#define  INTERRUPT_1M         { }

void
timer_init (void)
{
  ICR1    = (F_CPU / F_INTERRUPT) - 1;                           // compare value: 1/10000 of CPU frequency
  TCCR1A  = (1 << WGM11);
  TCCR1B  = (1 << WGM13)|(1 << WGM12) | (1 << CS10);             // switch CTC PWM Mode on, set prescaler to 1
  TIMSK1  = 1 << ICIE1;                                          // ICIE1: Interrupt if timer reaches the Top (ICR1 register)
}

/*---------------------------------------------------------------------------------------------------------------------------------------------------
 * timer 1 compare handler, called every 1/10000 sec
 *---------------------------------------------------------------------------------------------------------------------------------------------------
*/
ISR(TIMER1_CAPT_vect)
{
  static uint8_t  thousands_counter;
  static uint8_t  hundreds_counter;
  static uint8_t  tenths_counter;
  static uint8_t  seconds_counter;
  static uint8_t  minutes_counter;

  INTERRUPT_10000HZ;

  thousands_counter++;

  if (thousands_counter != 10)
  {
    return;
  }

  thousands_counter = 0;

  INTERRUPT_1000HZ;

  hundreds_counter++;

  if (hundreds_counter != 10)
  {
    return;
  }

  hundreds_counter = 0;

  INTERRUPT_100HZ;

  tenths_counter++;

  if (tenths_counter != 10)                                                     // generate 10Hz ....
  {
    return;
  }

  tenths_counter = 0;

  INTERRUPT_10HZ;

  seconds_counter++;

  if (seconds_counter != 10)                                                    // generate 1Hz ....
  {
    return;
  }

  seconds_counter = 0;

  INTERRUPT_1HZ;

  minutes_counter++;

  if (minutes_counter != 60)                                                    // generate 1/60 Hz ....
  {
    return;
  }

  minutes_counter = 0;

  INTERRUPT_1M;
}
