/*
 * user.h
 *
 *  Created on: 29.08.2011
 *      Author: Frank
 */

#ifndef USER_H_
#define USER_H_

#include "hsv_rgb.h"

typedef enum e_MenuStates
{
	MS_normalMode = 0,
	MS_fadeMode,
	MS_MenuMode,
	MS_COUNT
} e_MenuStates;

typedef enum e_userCommands
{
  UI_ONOFF           = 0,   /**< switch on/off LEDs  */
  UI_BRIGHTNESS_UP   ,      /**< increase brightness */
  UI_BRIGHTNESS_DOWN ,      /**< decrease brighntess */

  UI_SATURATION_DOWN ,
  UI_SATURATION_UP   ,

  UI_UP              ,      /**< up/increase  (depends on current state)   */
  UI_DOWN            ,      /**< down/decrease  (depends on current state) */

  UI_1               ,
  UI_2               ,
  UI_3               ,
  UI_4               ,
  UI_5               ,
  UI_6               ,
  UI_7               ,
  UI_8               ,
  UI_9               ,
  UI_FADE            ,

  UI_MENU            ,
  UI_ENTER           ,

  UI_COMMAND_COUNT
}e_userCommands;

/* command defaults */
#define USER_ADDRESS_DEFAULT          0x0000

#define USER_CMD_DEF_ONOFF            0x000C
#define USER_CMD_DEF_BRIGHTNESS_UP    0x0010
#define USER_CMD_DEF_BRIGHTNESS_DOWN  0x0011
#define USER_CMD_DEF_BACKWARD         0x003C
#define USER_CMD_DEF_FORWARD          0x002E
#define USER_CMD_DEF_UP               0x0020
#define USER_CMD_DEF_DOWN             0x0021
#define USER_CMD_DEF_KEY1		      0x0001
#define USER_CMD_DEF_KEY2			  0x0002
#define USER_CMD_DEF_KEY3             0x0003
#define USER_CMD_DEF_KEY4             0x0004
#define USER_CMD_DEF_KEY5             0x0005
#define USER_CMD_DEF_KEY6             0x0006
#define USER_CMD_DEF_KEY7             0x0007
#define USER_CMD_DEF_KEY8             0x0008
#define USER_CMD_DEF_KEY9             0x0009
#define USER_CMD_DEF_KEY0             0x0000
#define USER_CMD_DEF_MENU             0x0052
#define USER_CMD_DEF_ENTER            0x0057

#define USER_COMMANDCODES_DEFAULTS { \
			USER_CMD_DEF_ONOFF,  \
			USER_CMD_DEF_BRIGHTNESS_UP,  \
			USER_CMD_DEF_BRIGHTNESS_DOWN,  \
			USER_CMD_DEF_BACKWARD, \
			USER_CMD_DEF_FORWARD, \
            USER_CMD_DEF_UP,  \
            USER_CMD_DEF_DOWN,  \
			USER_CMD_DEF_KEY1, \
			USER_CMD_DEF_KEY2, \
			USER_CMD_DEF_KEY3, \
			USER_CMD_DEF_KEY4, \
			USER_CMD_DEF_KEY5, \
			USER_CMD_DEF_KEY6, \
			USER_CMD_DEF_KEY7, \
			USER_CMD_DEF_KEY8, \
			USER_CMD_DEF_KEY9, \
			USER_CMD_DEF_KEY0, \
			USER_CMD_DEF_MENU,\
			USER_CMD_DEF_ENTER\
}

/** the maximum number of color-presets that can be stored */
#define UI_COLOR_PRESET_COUNT 10
/** the current fadeSteps in initialising */
#define FADING_STEP_INIT     3

#define USER_COLORPRESETS_DEFAULTS {\
   { 4095,    0, 4095 }, \
   { 4095, 4095, 4095 }, \
   { 3640, 4095, 4095 }, \
   { 3414, 4095, 4095 }, \
   { 2731, 4095, 4095 }, \
   { 2048, 4095, 4095 }, \
   { 1366, 4095, 4095 }, \
   {  683, 4095, 4095 }, \
   {    0, 4095, 4095 }, \
   {    0, 4095, 4095 }, /* only for fading mode */ \
}

#define USEREEPROMPARAMS_DEFAULT  {                          \
  /* .irAddress           = */ USER_ADDRESS_DEFAULT,         \
  /* .irCommandCodes      = */ USER_COMMANDCODES_DEFAULTS,   \
  /* .colorPresets        = */ USER_COLORPRESETS_DEFAULTS,   \
  /*  curColorProfile     = */ UI_COLOR_PRESET_COUNT - 1,    \
  /*  fadingSteps         = */ FADING_STEP_INIT,             \
  /* .mode                = */ MS_fadeMode                   \
}

/** contains the persistent data of the user module that should be stored in eeprom */
typedef struct UserEepromParams
{
  /** Address of the trained remote control */
  uint16_t irAddress;

  /**
   *  IR - controll commands for user interaction
   *  see e_userCommands for indexes
   */
  uint16_t irCommandCodes[UI_COMMAND_COUNT];

  /** color presets */
  struct rgb{
    uint16_t H;
    uint16_t S;
    uint16_t V;
  }colorPresets[UI_COLOR_PRESET_COUNT];

  /** the current selected profile */
  uint8_t curColorProfile;
  /** the current fadingSteps **/
  uint8_t fadingSteps;
  /** the current mode **/
  uint8_t mode;
}UserEepromParams;

#define USER_KEY_PRESS_DELAY_100ms   5

extern void handle_ir_code( void );
extern void handle_leds( void );
extern uint8_t handle_standardMode( uint8_t ir_code, uint8_t repetition );
extern uint8_t handle_fadeMode( uint8_t ir_code, uint8_t repetition );
extern uint8_t handle_menuMode( uint8_t ir_code, uint8_t repetition );
extern uint8_t handle_normalMode( uint8_t ir_code, uint8_t repetition );

extern void user_init( void );
extern void user_isr10Hz( void );
extern void user_isr1HZ( void );

extern void color_init( void );
extern void color_isr100Hz(void);

extern void increaseBrightness( void );
extern void decreaseBrightness( void );
extern void increaseFadingStep( void );
extern void decreaseFadingStep( void );
extern void increaseColorStep( uint8_t step );
extern void decreaseColorStep( uint8_t step );
extern void increaseSaturationStep( uint8_t step );
extern void decreaseSaturationStep( uint8_t step );
extern void setColorMode( uint8_t mode );
extern void setColorStep( void );
extern void saveColorStep( void );
extern void pwmOn( void );
extern void pwmOff( void );
extern void autoleaveMenuMode( void );

extern uint8_t getBrightnessValue( uint16_t V );
extern void setHSVValues( uint16_t H, uint16_t S, uint16_t V );

#endif /* USER_H_ */
