
#ifndef _DEBUG_H_INCLUDED_
#define _DEBUG_H_INCLUDED_

#include "project.h"
#include <avr/pgmspace.h>

#ifdef DEBUG

#if !defined(__AVR_ATmeg128__)&&!defined(_CHIP_ATMEGA128L_)&&\
    !defined(_CHIP_ATMEGA64_)&&!defined(_CHIP_ATMEGA64L_)&&\
    !defined(_CHIP_ATMEGA32_)&&!defined(_CHIP_ATMEGA32L_)&&\
    !defined(_CHIP_ATMEGA16_)&&!defined(_CHIP_ATMEGA16L_)&&\
    !defined(_CHIP_ATMEGA8535_)&&!defined(_CHIP_ATMEGA8535L_)&&\
    !defined(_CHIP_ATMEGA8_)&&!defined(_CHIP_ATMEGA8L_)&&\
    !defined(__AVR_ATmega128__)&&!defined(__AVR_ATmega32__)&&\
    !defined(__AVR_ATmega8583__)
#error "ATMEL Microcontroller not supported !!!"
#endif

#include <avr/io.h>

#ifndef PROJECT_NAME
#define PROJECT_NAME			"-xxxxx-"
#endif
#ifndef PROJECT_VERSION
#define PROJECT_VERSION			"Version x.xx"
#endif

#if defined(__AVR_ATmeg128__)||defined(_CHIP_ATMEGA128L_)
#ifndef MC_TYP_STRING
#define MC_TYP_STRING			"ATmega128(L)"
#endif
#endif

#if defined(_CHIP_ATMEGA64_)||defined(_CHIP_ATMEGA64L_)
#ifndef MC_TYP_STRING
#define MC_TYP_STRING			"ATmega64(L)"
#endif
#endif

#if defined(_CHIP_ATMEGA32_)||defined(_CHIP_ATMEGA32L_)||defined(__AVR_ATmega32__)
#ifndef MC_TYP_STRING
#define MC_TYP_STRING			"ATmega32(L)"
#endif
#endif

#if defined(_CHIP_ATMEGA16_)||defined(_CHIP_ATMEGA16L_)
#ifndef MC_TYP_STRING
#define MC_TYP_STRING			"ATmega16(L)"
#endif
#endif

#if defined(_CHIP_ATMEGA8535_)||defined(_CHIP_ATMEGA8535L_)||defined(__AVR_ATmega8583__)
#ifndef MC_TYP_STRING
#define MC_TYP_STRING			"ATmega8535(L)"
#endif
#endif

#if defined(_CHIP_ATMEGA8_)||defined(_CHIP_ATMEGA8L_)
#ifndef MC_TYP_STRING
#define MC_TYP_STRING			"ATmega8(L)"
#endif
#endif

#ifndef MC_TYP_STRING
#define MC_TYP_STRING			"ATmegaXXX"
#endif

#ifndef _MCU_CLOCK_FREQUENCY_
#define _MCU_CLOCK_FREQUENCY_ F_CPU
#endif

#if(_MCU_CLOCK_FREQUENCY_==16000000)
#define	MCU_CLOCK_STRING	"16.000MHz"
#endif

#if(_MCU_CLOCK_FREQUENCY_==14745600)
#define	MCU_CLOCK_STRING	"14.7456MHz"
#endif

#if(_MCU_CLOCK_FREQUENCY_==8000000)
#define	MCU_CLOCK_STRING	"8.0000MHz"
#endif

#if(_MCU_CLOCK_FREQUENCY_==7372800)
#define	MCU_CLOCK_STRING	"7.3728MHz"
#endif

#if(_MCU_CLOCK_FREQUENCY_==3686400)
#define	MCU_CLOCK_STRING	"3.6864MHz"
#endif

#if(_MCU_CLOCK_FREQUENCY_==1843200)
#define	MCU_CLOCK_STRING	"1.8432MHz"
#endif

#ifndef DEBUG_BAUD_RATE
#define	DEBUG_BAUD_RATE			38400UL
#endif

// #if doublespeed
#define	UBRRL_VALUE(x)		(((_MCU_CLOCK_FREQUENCY_/8UL)/(x))-1)
// #else
//#define	UBRRL_VALUE(x)		(_MCU_CLOCK_FREQUENCY_/16UL)/(x))-1)
// #endif
#define	UBRRH_VALUE(x)		((UBRRL_VALUE(x) & 0xf00)>>8)


#if !defined(DEBUG_UPLINK_UART0) &&\
    !defined(DEBUG_UPLINK_UART1) &&\
    !defined(DEBUG_UPLINK_UART_MAX3100) &&\
    !defined(DEBUG_UPLINK_I2C_HW)
#define DEBUG_UPLINK_UART0
#endif

#ifdef DEBUG_UPLINK_UART0
#if defined(__AVR_ATmega128__)||defined(_CHIP_ATMEGA128L_)||\
        defined(_CHIP_ATMEGA64_)||defined(_CHIP_ATMEGA64L_)

//#define DEBUG_SET_UART_BAUDRATE(x)			UBRR0L=UBRRL_VALUE(x)
//#define DEBUG_SET_UART_BAUDRATE(x)			UBRR0L=UBRRL_VALUE(x);UBRR0H=UBRRH_VALUE(x)
static inline void DEBUG_SET_UART_BAUDRATE(unsigned long int x)
{
    unsigned long k = UBRRL_VALUE(x);
    UBRR0L = k;
    UBRR0H = (k>>8);
}

// #if doublespeed
 #define DEBUG_SET_UART_DOUBLESPEED 			UCSR0A |= (1<<U2X) /*.1=1*/
//# else // not doublespeed
// #define DEBUG_SET_UART_DOUBLESPEED 			UCSR0A &= ~(1<<UC2X) /*.1=1*/
// #endif
    // init UART0
    // Communication Parameters: 8 Data, 1 Stop, No Parity
    // UART Receiver: On
    // UART Transmitter: On
    // UART IRQ-Receiver: Off
#define DEBUG_CONFIG_UART 				do{UCSR0B=((1<<RXEN)|(1<<TXEN));\
                                            UCSR0C=(1<<UCSZ1)|(1<<UCSZ0);}while(0)
#define DEBUG_UART_FLAG_REGISTER  			UCSR0A
#define DEBUG_UART_DATA_REGISTER  			UDR0
#define DEBUG_UART_PULLUP_ENABLE			PORTE|=0x01
#endif

#if defined(_CHIP_ATMEGA32_)||defined(_CHIP_ATMEGA32L_)||\
        defined(_CHIP_ATMEGA16_)||defined(_CHIP_ATMEGA16L_)||\
        defined(_CHIP_ATMEGA8535_)||defined(_CHIP_ATMEGA8535L_)||defined(__AVR_ATmega8583__)||\
        defined(_CHIP_ATMEGA8_)||defined(_CHIP_ATMEGA8L_)||defined(__AVR_ATmega32__)
#define DEBUG_SET_UART_BAUDRATE(x)			UBRRL=UBRRL_VALUE(x);UBRRH=UBRRH_VALUE(x)
#define DEBUG_SET_UART_DOUBLESPEED 			UCSRA |= (1<<U2X) /*.1=1; */
    // init UART0
    // Communication Parameters: 8 Data, 1 Stop, No Parity
    // UART Receiver: On
    // UART Transmitter: On
    // UART IRQ-Receiver: Off
#define DEBUG_CONFIG_UART 					UCSRB=0x18
#define DEBUG_UART_FLAG_REGISTER			UCSRA
#define DEBUG_UART_DATA_REGISTER  			UDR
#define DEBUG_UART_PULLUP_ENABLE			PORTD|=0x01
#endif
#endif

#ifdef DEBUG_UPLINK_UART1
#if defined(__AVR_ATmeg128__)||defined(_CHIP_ATMEGA128L_)||\
        defined(_CHIP_ATMEGA64_)||defined(_CHIP_ATMEGA64L_)
static inline void DEBUG_SET_UART_BAUDRATE(unsigned long int x)
{
    unsigned long k = UBRRL_VALUE(x);
    UBRR1L = k;
    UBRR1H = (k>>8);
}
//#define DEBUG_SET_UART_BAUDRATE(x)			UBRR1L=UBRRL_VALUE;UBRR1H=UBRRH_VALUE
#define DEBUG_SET_UART_DOUBLESPEED 			UCSR1A |= (1<<U2X)
    // init UART0
    // Communication Parameters: 8 Data, 1 Stop, No Parity
    // UART Receiver: On
    // UART Transmitter: On
    // UART IRQ-Receiver: Off
#define DEBUG_CONFIG_UART 					UCSR1B=((1<<RXEN)|(1<<TXEN));\
                                            UCSR1C=(1<<UCSZ1)|(1<<UCSZ0)
//#define DEBUG_CONFIG_UART 					UCSR1B=0x18
#define DEBUG_UART_FLAG_REGISTER			UCSR1A
#define DEBUG_UART_DATA_REGISTER  			UDR1
#define DEBUG_UART_PULLUP_ENABLE			PORTD|=0x04
#endif

#if defined(_CHIP_ATMEGA32_)||defined(_CHIP_ATMEGA32L_)||\
        defined(_CHIP_ATMEGA16_)||defined(_CHIP_ATMEGA16L_)||\
        defined(_CHIP_ATMEGA8535_)||defined(_CHIP_ATMEGA8535L_)||\
        defined(_CHIP_ATMEGA8_)||defined(_CHIP_ATMEGA8L_)||defined(__AVR_ATmega8583__)
#error "DEBUG_UPLINK_UART1 not available with this chip!"
#endif
#endif

#if defined(DEBUG_UPLINK_UART_MAX3100) && !defined(MAX3100_ENABLE)
#error "MAX3100_ENABLE not defined!"
#endif

#ifdef DEBUG_UPLINK_UART0
#define DEBUG_UPLINK_SELECTED
#endif
#ifdef DEBUG_UPLINK_UART1
#ifdef DEBUG_UPLINK_SELECTED
#error "DEBUG: Multiple Uplinks defined!"
#else
#define DEBUG_UPLINK_SELECTED
#endif
#endif
#ifdef DEBUG_UPLINK_UART_MAX3100
#ifdef DEBUG_UPLINK_SELECTED
#error "DEBUG: Multiple Uplinks defined!"
#else
#define DEBUG_UPLINK_SELECTED
#endif
#endif
#ifdef DEBUG_UPLINK_I2C_HW
#ifdef DEBUG_UPLINK_SELECTED
#error "DEBUG: Multiple Uplinks defined!"
#else
#define DEBUG_UPLINK_SELECTED
#endif
#endif

#ifndef DEBUG_MAX_UART_COMMAND
#define DEBUG_MAX_UART_COMMAND		30
#endif

#if defined(DEBUG_UPLINK_UART_MAX3100) ||\
    defined(DEBUG_UPLINK_UART1) ||\
    defined(DEBUG_UPLINK_I2C_HW)
#ifndef _ALTERNATE_GETCHAR_
#define _ALTERNATE_GETCHAR_
#endif
#ifndef _ALTERNATE_PUTCHAR_
#define _ALTERNATE_PUTCHAR_
#endif
#endif

#ifdef __CODEVISIONAVR__
#pragma used+
#endif
void debug_init(void);
unsigned char debug_uart_char_received(void);
unsigned char *debug_get_command(void);
unsigned char debug_set_command(PGM_P new_command);
void debug_display_frame(unsigned char *p_data, unsigned int size,
                         unsigned char break_count);
void debug_display_frame_ee(/*eeprom*/ unsigned char *p_data, unsigned int size,
                            unsigned char break_count);
unsigned char debug_string2ip(unsigned char *command, unsigned char *new_ip,
                              unsigned int *new_port);
unsigned char debug_string2mac(unsigned char *command,
                               unsigned char *new_mac);
unsigned char debug_atoi_hex_str(unsigned char *src, unsigned char *dest,
                                 unsigned char *length);
unsigned char *debug_search_parameter(unsigned char *command);
signed int debug_integer(unsigned char *command);
signed int debug_2nd_integer(unsigned char *command);
void debug_print_ip(PGM_P string_data, unsigned char *ip_data);
void debug_print_ip_ee(PGM_P string_data,
                       /*eeprom*/ unsigned char *ip_data);
void debug_print_mac(PGM_P string_data,
                     unsigned char *mac_data);
void debug_help(void);
void debug_info(PGM_P info_string);

#ifdef __CODEVISIONAVR__
#pragma used-


#ifdef COMMON_LIBRARY_ENABLE
#pragma library debug.lib
#endif
#endif
#endif
#endif // #ifndef _DEBUG_H_INCLUDED_
