
#include "project.h"

#include <stdio.h>
#include <string.h>
#include UTIL_H_FILEPATH
#include <avr/eeprom.h>
#include <avr/pgmspace.h>

#if 0
struct xRTOS_HEAP
{
   unsigned long ulDummy;
   unsigned char ucHeap[4096 - sizeof( long )];
}
xHeap __attribute__ ( ( section( ".data" ) ) ); // = { 0x018055AAUL, {} };


//static volatile char __atBus[0x10] __attribute__((section (".data")));
// Reserviere Speicher fr AT-Bus - Flle mit "ATBus Passive" Data.
volatile char __atBus[0x10] = {
   0xE0, 0xE0,
   0xE0, 0xE0,
   0xE0, 0xE0,
   0xE0, 0xE0,
   0xE0, 0xE0,
   0xE0, 0xE0,
   0xE0, 0xE0,
   0xE0, 0xE0
};                              // address 0x100, RD passive, WR passive,
                                // RESET passive

#endif


unsigned int memcpy2e(char *dest, void *src, unsigned int n)
{
    eeprom_write_block(src,dest,n);
    return n;
}

void memsete(void *dest, unsigned char c, unsigned int n)
{
   char e;

   while (n)
   {
      e = eeprom_read_byte(dest);
      if (e != c)
         eeprom_write_byte(dest, c);
      (unsigned char *) dest++;
      n--;
   }
}


unsigned int strstrfn(char *str1, PGM_P str2)
{
   unsigned int Lva = 0;
   unsigned char str_len;
   unsigned char c = pgm_read_byte(&str2[0]);

   str_len = strlen_P(str2);
   while (*str1 != 0x0)
   {
      if(c == *str1)    // lohnt sich ein strncmp_P ?
        if (strncmp_P(str1, str2, str_len) == 0)
         return Lva;
      str1++;
      Lva++;
   }
   return Lva;
}


unsigned char atoi_hex(unsigned char ascii_char)
{
   if (ascii_char >= '0' && ascii_char <= '9')
      return ascii_char - 0x30;
   else if (ascii_char >= 'A' && ascii_char <= 'F')
      return ascii_char - 0x37;
   else if (ascii_char >= 'a' && ascii_char <= 'f')
      return ascii_char - 0x57;
   return 0xff;
}


unsigned char itoa_hex(unsigned char binary)
{
   if (binary < 0x0A)
      return (binary + 0x30);
   else
      return (binary + 0x37);
}
