
/*****************************************************************************
 *
 *                          "arp_rarp.h"
 *                   -----------------------------
 *
 *  Version:    2.04
 *  File:     	..\..\arp_rarp.h
 *  Created:    03.04.2003
 *  Date:       24.08.2005
 *  Author:     Copyright (C) 2001-2005
 *              Udo Jakobza - FTZ Leipzig; D-04107 Leipzig; Wchterstr. 13
 *              info@easytoweb.net
 *  Func: 		header-file for arp.c
 *  license:
 *    This library is free software; you can redistribute it and/or modify it
 *    under the terms of the GNU Lesser General Public License as published by
 *    the Free Software Foundation; either version 2.1 of the License, or
 *    (at your option) any later version. This library is distributed in the hope
 *    that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *    warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *    See the GNU Lesser General Public License for more details.
 *	  see: http://www.gnu.org/copyleft/lesser.html
 *    You should have received a copy of the GNU Lesser General Public License
 *    along with this library; if not, write to the Free Software Foundation,
 *    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *    Die Bibliothek ist freie Software; Sie drfen sie unter den Bedingungen der
 *    GNU Lesser General Public License, wie von der Free Software Foundation
 *    verffentlicht, weiterverteilen und/oder modifizieren; entweder gem
 *    Version 2.1 der Lizenz oder (nach Ihrer Option) jeder spteren Version.
 *    Diese Bibliothek wird in der Hoffnung weiterverbreitet, da sie ntzlich
 *    sein wird, jedoch OHNE IRGENDEINE GARANTIE, auch ohne die implizierte
 *    Garantie der MARKTREIFE oder der VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK.
 *    Mehr Details finden Sie in der GNU Lesser General Public License.
 *	  see: http://www.gnu.org/copyleft/lesser.de.html
 *    Sie sollten eine Kopie der GNU Lesser General Public License zusammen mit
 *    dieser Bibliothek erhalten haben; falls nicht, schreiben Sie an die FSF,
 *    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 *  history:
 *		1.) 30.07.2003 Version 2.00a
 *			a.)	-
 *
 *****************************************************************************/
#ifndef _ARP_RARP_INCLUDED_
#define _ARP_RARP_INCLUDED_

#include "project.h"            // USER defines
#include IP_H_FILEPATH

#define ARP_FRAME	 			 0x0806
#define RARP_FRAME				 0x8035

#define ARP_HARDW_OFS			ETH_DATA_OFS + 0
#define ARP_PROT_OFS			ETH_DATA_OFS + 2
#define ARP_HLEN_PLEN_OFS		ETH_DATA_OFS + 4
#define ARP_OPCODE_OFS			ETH_DATA_OFS + 6
#define ARP_SENDER_HA_OFS		ETH_DATA_OFS + 8
#define ARP_SENDER_IP_OFS		ETH_DATA_OFS + 14
#define ARP_TARGET_HA_OFS		ETH_DATA_OFS + 18
#define ARP_TARGET_IP_OFS		ETH_DATA_OFS + 24
#define ARP_FRAME_SIZE			28

#define RARP_HARDW_OFS			ETH_DATA_OFS + 0
#define RARP_PROT_OFS			ETH_DATA_OFS + 2
#define RARP_HLEN_PLEN_OFS		ETH_DATA_OFS + 4
#define RARP_OPCODE_OFS			ETH_DATA_OFS + 6
#define RARP_SENDER_HA_OFS		ETH_DATA_OFS + 8
#define RARP_SENDER_IP_OFS		ETH_DATA_OFS + 14
#define RARP_TARGET_HA_OFS		ETH_DATA_OFS + 18
#define RARP_TARGET_IP_OFS		ETH_DATA_OFS + 24
#define RARP_FRAME_SIZE			28

#define HARDW_ETH10	  			1
#define IP_HLEN_PLEN			0x0604
#define ARP_OP_REQUEST			1
#define ARP_OP_ANSWER			2
#define RARP_OP_REQUEST			3
#define RARP_OP_ANSWER			4

#ifndef ARP_CACHE_SIZE
#define ARP_CACHE_SIZE			8
#endif

#if(ARP_CACHE_SIZE>255)
#error ERROR: "ARP_CACHE_SIZE" to big: ARP_CACHE_SIZE!!!
#endif

#ifndef RARP_DEFAULT_ANSWER_IP
#define RARP_DEFAULT_ANSWER_IP	{172, 16, 50, 169}
#endif

typedef enum
{
   ARP_REQUEST_IP,
   ARP_REQUEST_SELF,
   ARP_REQUEST_GATEWAY
}
ARP_REQUEST_MODE;


typedef struct
{
   unsigned char ip_adr[IP_ADR_SIZE];
   unsigned char mac_adr[6];
}
ARP_CACHE_STRUCTURE;

typedef enum
{
   ARP_REQUEST_TIMER_START,
   ARP_REQUEST_TIMER_CONTINUE
}
ARP_REQUEST_TIMER_MODE;

#ifdef __CODEVISIONAVR__
#pragma used+
#endif
#ifdef ARP_CACHE_ENABLE
unsigned char *arp_cache(unsigned char *ip_adr, unsigned char *mac_adr);
#endif
void arp_request_timer(ARP_REQUEST_TIMER_MODE mode);
void rarp_prepare_request(void);
void arp_rarp_process_frame(unsigned char broadcast_flag);
void arp_prepare_request(unsigned char *arp_ip, ARP_REQUEST_MODE mode);
void arp_prepare_answer(void);
void rarp_prepare_answer(unsigned char *rarp_ip);

#ifdef __CODEVISIONAVR__
#pragma used-

#ifdef ETW_LIBRARY_ENABLE
#pragma library arp_rarp.lib
#endif
#endif
#endif // #ifndef _ARP_RARP_INCLUDED_
