
/*****************************************************************************
 *
 *                             "ati.h" 
 *                   -----------------------------
 *                                                                            
 *  Version:    1.00
 *  File:     	ati.h    
 *  Created:    10.12.2004
 *  Date:       06.09.2005
 *  Author:     Copyright (C) 2001-2005
 *              Mirco Fuchs, Udo Jakobza - FTZ Leipzig; D-04107 Leipzig; Wchterstr. 13
 *              info@easytoweb.net
 *  Func: 		header-file for ati.c
 *  license:	
 *   This library is free software; you can redistribute it and/or modify it 
 *   under the terms of the GNU Lesser General Public License as published by 
 *   the Free Software Foundation; either version 2.1 of the License, or 
 *   (at your option) any later version. This library is distributed in the hope 
 *   that it will be useful, but WITHOUT ANY WARRANTY; without even the implied 
 *   warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
 *   See the GNU Lesser General Public License for more details.
 *	 see: http://www.gnu.org/copyleft/lesser.html	
 *   You should have received a copy of the GNU Lesser General Public License 
 *   along with this library; if not, write to the Free Software Foundation, 
 *   Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *	 
 *   Die Bibliothek ist freie Software; Sie drfen sie unter den Bedingungen der
 *   GNU Lesser General Public License, wie von der Free Software Foundation 
 *   verffentlicht, weiterverteilen und/oder modifizieren; entweder gem 
 *   Version 2.1 der Lizenz oder (nach Ihrer Option) jeder spteren Version. 
 *   Diese Bibliothek wird in der Hoffnung weiterverbreitet, da sie ntzlich 
 *   sein wird, jedoch OHNE IRGENDEINE GARANTIE, auch ohne die implizierte 
 *   Garantie der MARKTREIFE oder der VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK.
 *   Mehr Details finden Sie in der GNU Lesser General Public License.
 *	 see: http://www.gnu.org/copyleft/lesser.de.html	
 *   Sie sollten eine Kopie der GNU Lesser General Public License zusammen mit 
 *   dieser Bibliothek erhalten haben; falls nicht, schreiben Sie an die FSF,
 *   Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 * 
 *  history:	
 *	1.) 10.12.2004 Version 1.00
 *		a.)	- 
 * *****************************************************************************/
#ifndef _ATI_INCLUDED_
#define _ATI_INCLUDED_

#include <avr/pgmspace.h>

#define AT_DEVICE_INTERFACE_SEND_DATA(data)	uart1_putchar(data)
#define AT_DEVICE_INTERFACE_IRQ_ENABLE()	uart1_irq_receive_enable()
#define AT_DEVICE_INTERFACE_IRQ_DISABLE()	uart1_irq_receive_disable()

#define RECEIVE_FUNCTION(received_data) 	ppp_receive_data(received_data)
#include PPP_H_FILEPATH

#define ATI_TX_BUFFER_SIZE				64
#define ATI_RX_BUFFER_SIZE				127
#define ATI_STRING_LENGTH 				41

#define ATI_TIMEOUT_NEXT_CHAR			5
#define ATI_TIMEOUT_ANSWER				6000

#define ATI_CR							0x0d
#define	ATI_LF							0x0a

#define	ATI_MODE_COMMAND				0
#define	ATI_MODE_ONLINE_ENTERING		1
#define ATI_MODE_ONLINE					2
#define ATI_MODE_ONLINE_COMMAND_ENTER	3
#define ATI_MODE_ONLINE_COMMAND	 		4
#define ATI_MODE_COMMAND_ENTERING		5

#define ATI_ANSWER_HIDE					0
#define ATI_ANSWER_SHOW					1

#define ATI_WRITE_ONLY_AT_COMMANDS		0
#define ATI_WRITE_MEMORY_OVERFLOW		1
#define ATI_WRITE_COMMAND_WROTE			2
#define ATI_WRITE_ACCESS_DENIED			3
#define ATI_WRITE_DATA_SEND				4

#define ATI_CONNECT_DISCONNECT_OK		0
#define ATI_CONNECT_DISCONNECT_ERROR	1

#define ATI_ANSWER_DISABLED				0
#define ATI_ANSWER_ENABLED				1

typedef enum
{
   ATI_STATE_BUFFER_EMPTY,
   ATI_STATE_BUFFER_FILLED,
   ATI_STATE_CHECK_BUFFER,
   ATI_STATE_RSP_AWAITED,
   ATI_STATE_RECEIVE_DATA,
   ATI_STATE_UNREACHED
}
ATI_STATE;

typedef enum
{
   ATI_DEVICE_MODE_COMMAND,
   ATI_DEVICE_MODE_CARRIER,
   ATI_DEVICE_MODE_ONLINE,
   ATI_DEVICE_MODE_COMMAND_ONLINE,
   ATI_DEVICE_UNREACHED
}
ATI_DEVICE_MODE;

typedef enum
{
   ATI_DEVICE_RESPONSE_NO,
   ATI_DEVICE_RESPONSE_YES
}
ATI_DEVICE_RESPONSE;

typedef enum
{
   ATI_USER_INFO_BUFFER_FILLED,
   ATI_USER_INFO_BUFFER_EMPTY,
   ATI_USER_INFO_TIMEOUT
}
ATI_USER_INFO;

#ifdef __CODEVISIONAVR__
#pragma used+
#endif
void ati_state_machine(void);
void ati_init(void);
void ati_receive_data(unsigned char received_data);

unsigned char ati_write_data(unsigned char *ati_data);
#ifdef __CODEVISIONAVR__
unsigned char ati_write_data_flash(flash unsigned char *ati_data);
#else
unsigned char ati_write_data_flash(PGM_P ati_data);
#endif
unsigned char *ati_get_new_answer(void);
unsigned char ati_get_device_mode(unsigned char show_answer);
unsigned char ati_connect(unsigned char *destination);
unsigned char ati_disconnect(void);
void ati_answer_incomming_call(unsigned char behavior);
extern volatile ATI_STATE ati_state;
extern volatile ATI_STATE ati_state_old;
extern ATI_DEVICE_MODE ati_device_mode;
extern ATI_DEVICE_MODE ati_device_nextmode;

extern ATI_DEVICE_RESPONSE ati_device_response;
extern ATI_USER_INFO ati_user_info;


#ifdef __CODEVISIONAVR__
#pragma used-


#ifdef ETW_LIBRARY_ENABLE
#pragma library ati.lib
#endif
#endif
#endif
