
/*****************************************************************************
 *
 *                           "bootp.h" 
 *                   -----------------------------
 *                                                                            
 *  Version:    2.04
 *  File:     	..\..\bootp.h    
 *  Created:    02.04.2003
 *  Date:       10.08.2004
 *  Author:     Copyright (C) 2001-2004
 *              Udo Jakobza - FTZ Leipzig; D-04107 Leipzig; Wchterstr. 13
 *              info@easytoweb.net
 *  Func: 		Header file for bootp.c
 *  License:	
 *    This library is free software; you can redistribute it and/or modify it 
 *    under the terms of the GNU Lesser General Public License as published by 
 *    the Free Software Foundation; either version 2.1 of the License, or 
 *    (at your option) any later version. This library is distributed in the hope 
 *    that it will be useful, but WITHOUT ANY WARRANTY; without even the implied 
 *    warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
 *    See the GNU Lesser General Public License for more details.
 *	  see: http://www.gnu.org/copyleft/lesser.html	
 *    You should have received a copy of the GNU Lesser General Public License 
 *    along with this library; if not, write to the Free Software Foundation, 
 *    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *	
 *    Die Bibliothek ist freie Software; Sie drfen sie unter den Bedingungen der 
 *    GNU Lesser General Public License, wie von der Free Software Foundation 
 *    verffentlicht, weiterverteilen und/oder modifizieren; entweder gem 
 *    Version 2.1 der Lizenz oder (nach Ihrer Option) jeder spteren Version. 
 *    Diese Bibliothek wird in der Hoffnung weiterverbreitet, da sie ntzlich 
 *    sein wird, jedoch OHNE IRGENDEINE GARANTIE, auch ohne die implizierte 
 *    Garantie der MARKTREIFE oder der VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK. 
 *    Mehr Details finden Sie in der GNU Lesser General Public License.
 *	  see: http://www.gnu.org/copyleft/lesser.de.html	
 *    Sie sollten eine Kopie der GNU Lesser General Public License zusammen mit 
 *    dieser Bibliothek erhalten haben; falls nicht, schreiben Sie an die FSF,
 *    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 *  history:	
 *		1.) 30.07.2003 Version 2.00a
 *		2.) 26.02.2004 Version 2.03
 *			a.)	- external macro "BOOTP_TIMEOUT" 
 *
 *****************************************************************************/
#ifndef _BOOTP_INCLUDED_
#define _BOOTP_INCLUDED_

#include <avr/pgmspace.h>

#ifndef	BOOTP_TIMEOUT
#define	BOOTP_TIMEOUT				1000
#endif

#define BOOTP_FRAME_OP_REQUEST			1
#define BOOTP_FRAME_OP_ANSWER			2

#define BOOTP_OP_OFS			UDP_DATA_OFS + 0
#define BOOTP_HTYPE_OFS			UDP_DATA_OFS + 1
#define BOOTP_HLEN_OFS			UDP_DATA_OFS + 2
#define BOOTP_HOPS_OFS			UDP_DATA_OFS + 3
#define BOOTP_XID_OFS			UDP_DATA_OFS + 4
#define BOOTP_SECS_OFS			UDP_DATA_OFS + 8
#define BOOTP_UNUSED_OFS		UDP_DATA_OFS + 10
#define BOOTP_CIADDR_OFS		UDP_DATA_OFS + 12
#define BOOTP_YIADDR_OFS		UDP_DATA_OFS + 16
#define BOOTP_SIADDR_OFS		UDP_DATA_OFS + 20
#define BOOTP_GIADDR_OFS		UDP_DATA_OFS + 24
#define BOOTP_CHADDR_OFS		UDP_DATA_OFS + 28
#define BOOTP_SNAME_OFS			UDP_DATA_OFS + 44
#define BOOTP_FILE_OFS			UDP_DATA_OFS + 108
#define BOOTP_VEND_OFS			UDP_DATA_OFS + 236

#define BOOTP_MIN_HEADER_SIZE	44
#define BOOTP_SERVER_NAME_SIZE	64
#define BOOTP_BOOT_FILE_SIZE	128
#define BOOTP_VENDOR_SIZE		64
#define BOOTP_MAX_HEADER_SIZE	300




#define BOOTP_HEADER_SIZE		BOOTP_MAX_HEADER_SIZE

#define BOOTP_MAGIC_COOKIE			0x63825363
//#define BOOTP_MAGIC_COOKIE			PSTR("\x63\x82\x53\x63")
//#define BOOTP_MAGIC_COOKIE			PSTR("\x63\x53\x82\x63")
#define	BOOTP_VENDOR_SUBNET			1
#define	BOOTP_VENDOR_GATEWAY		3
#define	BOOTP_VENDOR_DNS			6
#define	BOOTP_VENDOR_DOMAIN_NAME	15
#define	BOOTP_VENDOR_NETBIOS_NODE	46
#define	BOOTP_VENDOR_END			0xff


#if(UDP_TX_DATA_SIZE<BOOTP_HEADER_SIZE)
#error ERROR: BOOTP-TX-BUFFER too small: "UDP_TX_DATA_SIZE"==UDP_TX_DATA_SIZE (use >=BOOTP_HEADER_SIZE)!!!
#endif

typedef enum
{
   TIMEOUT_STOP_CHECK,
   TIMEOUT_CHECK,
   TIMEOUT_START,
   TIMEOUT_RESTART,
   TIMEOUT_CLEAR
}
BOOTP_TIMEOUT_TYP;

#ifdef __CODEVISIONAVR__
#pragma used+
#endif
extern unsigned char bootp_ok;
void bootp_init(void);
void bootp_request(BOOTP_TIMEOUT_TYP mode);
unsigned char bootp_timeout(BOOTP_TIMEOUT_TYP mode);
void bootp_answer(void);
void bootp_process(void);

#ifdef WEB_DEBUG_BOOTP
void bootp_display(void);
#endif
#ifdef __CODEVISIONAVR__
#pragma used-

#ifdef ETW_LIBRARY_ENABLE
#pragma library bootp.lib
#endif
#endif
#endif // #ifndef _UDP_INCLUDED_
