
/*****************************************************************************
 *
 *                         "buffer.h" 
 *                   -----------------------------
 *                                                                            
 *  Version:    2.06
 *  File: 		..\..\buffer.h    
 *  Created:    15.04.2003
 *  Date:       02.07.2004
 *  Author:     Copyright (C) 2001-2004
 *              Udo Jakobza - FTZ Leipzig; D-04107 Leipzig; Wchterstr. 13
 *              info@easytoweb.net
 *  Function:   buffer handling of easyToWeb-Sotware
 *  License:	
 *    This library is free software; you can redistribute it and/or modify it 
 *    under the terms of the GNU Lesser General Public License as published by 
 *    the Free Software Foundation; either version 2.1 of the License, or 
 *    (at your option) any later version. This library is distributed in the hope 
 *    that it will be useful, but WITHOUT ANY WARRANTY; without even the implied 
 *    warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
 *    See the GNU Lesser General Public License for more details.
 *	  see: http://www.gnu.org/copyleft/lesser.html	
 *    You should have received a copy of the GNU Lesser General Public License 
 *    along with this library; if not, write to the Free Software Foundation, 
 *    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *	
 *    Die Bibliothek ist freie Software; Sie drfen sie unter den Bedingungen der 
 *    GNU Lesser General Public License, wie von der Free Software Foundation 
 *    verffentlicht, weiterverteilen und/oder modifizieren; entweder gem 
 *    Version 2.1 der Lizenz oder (nach Ihrer Option) jeder spteren Version. 
 *    Diese Bibliothek wird in der Hoffnung weiterverbreitet, da sie ntzlich 
 *    sein wird, jedoch OHNE IRGENDEINE GARANTIE, auch ohne die implizierte 
 *    Garantie der MARKTREIFE oder der VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK. 
 *    Mehr Details finden Sie in der GNU Lesser General Public License.
 *	  see: http://www.gnu.org/copyleft/lesser.de.html	
 *    Sie sollten eine Kopie der GNU Lesser General Public License zusammen mit 
 *    dieser Bibliothek erhalten haben; falls nicht, schreiben Sie an die FSF,
 *    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 *  history:	
 *		1.) 08.08.2003 Version 2.00
 *		2.) 15.08.2003 Version 2.01
 *			b.)	- buffer works now with pointer and size variables, see "BUFFER_FRAME"
 *			a.)	- delete some macros and variables from TCP-Stack
 *		3.) 12.11.2003 Version 2.02
 *			a.)	- delete buffer "tx_rx_buffer"
 *		4.) 16.06.2004 Version 2.04
 *			a.)	- delete UDP and BOOTP-Buffer
 *		5.) 02.07.2004 Version 2.04
 *			a.)	- 
 *
 *****************************************************************************/
#ifndef _BUFFER_INCLUDED_
#define _BUFFER_INCLUDED_

#include "project.h"

#include ETHERNET_H_FILEPATH
#include IP_H_FILEPATH
#ifdef IPSEC_ENABLE
#include IPSEC_H_FILEPATH
#endif
#include ICMP_H_FILEPATH
#include ARP_RARP_H_FILEPATH

#ifndef	BUFFER_COUNT
#define	BUFFER_COUNT	     	4
#endif

#define TX_BUFFER2_ARP_SIZE		(ETH_HEADER_SIZE + ARP_FRAME_SIZE)
#define TX_BUFFER2_ICMP_SIZE	(ETH_HEADER_SIZE+IP_HEADER_SIZE+IPSEC_ADD_SIZE+ICMP_HEADER_SIZE+ICMP_DATA_SIZE)

#define TX_BUFFER2_SIZE		TX_BUFFER2_ICMP_SIZE
#if(TX_BUFFER2_ARP_SIZE>TX_BUFFER2_SIZE)
#undef TX_BUFFER2_SIZE
#define TX_BUFFER2_SIZE		TX_BUFFER2_ARP_SIZE
#endif

#define	HOST_NETWORK_ENDIAN_32BIT(out, in)		swap32(out, in)
#define	NETWORK_HOST_ENDIAN_32BIT(out, in)		swap32(out, in)
#define	HOST_NETWORK_ENDIAN_16BIT(out, in)		swap16(out, in)
#define	NETWORK_HOST_ENDIAN_16BIT(out, in)		swap16(out, in)

#ifdef __CODEVISIONAVR__
#pragma used+
#endif
typedef struct
{
   unsigned char *data[BUFFER_COUNT];
   unsigned int datasize[BUFFER_COUNT];
   unsigned char gap;
   unsigned char rtop;
   unsigned char wtop;
}
BUFFER_FRAME;

extern unsigned char tx_frame2[TX_BUFFER2_SIZE];
extern unsigned int tx_frame2_size;

unsigned char buffer_process(void);
unsigned char buffer_data_available(void);
void buffer_clear(void);
unsigned char buffer_free(void);
unsigned char buffer_write_command(unsigned char *data,
                                   unsigned int datasize);
unsigned char buffer_process_wait(void);
void swap16(void *out_data, void *in_data);
void swap32(void *out_data, void *in_data);

#if 1
static __inline__ unsigned long htonl(unsigned long value) __attribute__((__always_inline__));
static __inline__ unsigned long htonl(unsigned long value)
{
   __asm__ ( "mov __tmp_reg__, %A0" "\n\t"
             "mov %A0, %D0"         "\n\t"
             "mov %D0, __tmp_reg__" "\n\t"
             "mov __tmp_reg__, %B0" "\n\t"
             "mov %B0, %C0"         "\n\t"
             "mov %C0, __tmp_reg__" "\n\t":"=r" ( value ):"0"( value ) );
   return value;
}

static __inline__ unsigned int htons(unsigned int value) __attribute__((__always_inline__));
static __inline__ unsigned int htons(unsigned int value) 
{
   __asm__ ( "mov __tmp_reg__, %A0" "\n\t"
             "mov %A0, %B0"         "\n\t"
             "mov %B0, __tmp_reg__" "\n\t":"=r" ( value ):"0"( value ) );
   return value;
}
#endif

#ifdef __CODEVISIONAVR__
#pragma used-

#ifdef ETW_LIBRARY_ENABLE
#pragma library buffer.lib
#endif
#endif
#endif
