
/*****************************************************************************
 *
 *                          "cs8900.h" 
 *                   -----------------------------
 *                                                                            
 *  Version:    2.06
 *  File:     	..\..\..\cs8900.h    
 *  Created:    12.02.2003
 *  Date:       12.11.2004
 *  Author:     Copyright (C) 2001-2004
 *              Udo Jakobza - FTZ Leipzig; D-04107 Leipzig; Wchterstr. 13
 *              info@easytoweb.net
 *  Func: 		header-file for cs8900.c
 *  license:	
 *    This library is free software; you can redistribute it and/or modify it 
 *    under the terms of the GNU Lesser General Public License as published by 
 *    the Free Software Foundation; either version 2.1 of the License, or 
 *    (at your option) any later version. This library is distributed in the hope 
 *    that it will be useful, but WITHOUT ANY WARRANTY; without even the implied 
 *    warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
 *    See the GNU Lesser General Public License for more details.
 *	  see: http://www.gnu.org/copyleft/lesser.html	
 *    You should have received a copy of the GNU Lesser General Public License 
 *    along with this library; if not, write to the Free Software Foundation, 
 *    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *	
 *    Die Bibliothek ist freie Software; Sie drfen sie unter den Bedingungen der 
 *    GNU Lesser General Public License, wie von der Free Software Foundation 
 *    verffentlicht, weiterverteilen und/oder modifizieren; entweder gem 
 *    Version 2.1 der Lizenz oder (nach Ihrer Option) jeder spteren Version. 
 *    Diese Bibliothek wird in der Hoffnung weiterverbreitet, da sie ntzlich 
 *    sein wird, jedoch OHNE IRGENDEINE GARANTIE, auch ohne die implizierte 
 *    Garantie der MARKTREIFE oder der VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK. 
 *    Mehr Details finden Sie in der GNU Lesser General Public License.
 *	  see: http://www.gnu.org/copyleft/lesser.de.html	
 *    Sie sollten eine Kopie der GNU Lesser General Public License zusammen mit 
 *    dieser Bibliothek erhalten haben; falls nicht, schreiben Sie an die FSF,
 *    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 *  history:	
 *		1.) 08.08.2003 Version 2.00
 *		2.) 26.08.2003 Version 2.01
 *			a.)	- CS8900-Interface supports now "CS8900_IO_PORT8", "CS8900_IO_PORT16"
 *				"CS8900_I2C_HW_8", "CS8900_I2C_HW_16", "CS8900_I2C_SW_8" and "CS8900_I2C_SW_16"
 *		3.) 02.09.2003 Version 2.01
 *			a.)	- Error message for wrong interface together with ATmega32
 *
 *****************************************************************************/
#ifndef _CS8900_INCLUDED_
#define _CS8900_INCLUDED_

#include "project.h"

#ifdef DEVICE_CS8900
#if !defined(CS8900_MEMORY)&&\
	(!defined(CS8900_IO_PORT8)&&!defined(CS8900_IO_PORT16)\
	&&!defined(CS8900_I2C_HW_8)&&!defined(CS8900_I2C_HW_16)\
	&&!defined(CS8900_I2C_SW_8)&&!defined(CS8900_I2C_SW_16))
#error ERROR: CS8900-INTERFACE (MUST define "CS8900_MEMORY" or another) !!!
#endif

#if defined(CS8900_MEMORY)&&\
	(defined(CS8900_IO_PORT8)||defined(CS8900_IO_PORT16)\
	||defined(CS8900_I2C_HW_8)||defined(CS8900_I2C_HW_16)\
	||defined(CS8900_I2C_SW_8)||defined(CS8900_I2C_SW_16))
#error ERROR: CS8900-INTERFACE (use "CS8900_MEMORY" only) !!!
#endif

#if defined(CS8900_IO_PORT8)&&\
	(defined(CS8900_MEMORY)||defined(CS8900_IO_PORT16)\
	||defined(CS8900_I2C_HW_8)||defined(CS8900_I2C_HW_16)\
	||defined(CS8900_I2C_SW_8)||defined(CS8900_I2C_SW_16))
#error ERROR: CS8900-INTERFACE (use "CS8900_IO_PORT8" only) !!!
#endif

#if defined(CS8900_IO_PORT16)&&\
	(defined(CS8900_MEMORY)||defined(CS8900_IO_PORT8)\
	||defined(CS8900_I2C_HW_8)||defined(CS8900_I2C_HW_16)\
	||defined(CS8900_I2C_SW_8)||defined(CS8900_I2C_SW_16))
#error ERROR: CS8900-INTERFACE (use "CS8900_IO_PORT16" only) !!!
#endif

#if defined(CS8900_I2C_HW_8)&&\
	(defined(CS8900_PORT8)||defined(CS8900_IO_PORT16)\
	||defined(CS8900_MEMORY)||defined(CS8900_I2C_HW_16)\
	||defined(CS8900_I2C_SW_8)||defined(CS8900_I2C_SW_16))
#error ERROR: CS8900-INTERFACE (use "CS8900_I2C_HW_8" only) !!!
#endif

#if defined(CS8900_I2C_HW_16)&&\
	(defined(CS8900_PORT8)||defined(CS8900_IO_PORT16)\
	||defined(CS8900_MEMORY)||defined(CS8900_I2C_HW_8)\
	||defined(CS8900_I2C_SW_8)||defined(CS8900_I2C_SW_16))
#error ERROR: CS8900-INTERFACE (use "CS8900_I2C_HW_16" only) !!!
#endif

#if defined(CS8900_I2C_SW_8)&&\
	(defined(CS8900_PORT8)||defined(CS8900_IO_PORT16)\
	||defined(CS8900_I2C_HW_8)||defined(CS8900_I2C_HW_16)\
	||defined(CS8900_MEMORY)||defined(CS8900_I2C_SW_16))
#error ERROR: CS8900-INTERFACE (use "CS8900_I2C_SW_8" only) !!!
#endif

#if defined(CS8900_I2C_SW_16)&&\
	(defined(CS8900_PORT8)||defined(CS8900_IO_PORT16)\
	||defined(CS8900_I2C_HW_8)||defined(CS8900_I2C_HW_16)\
	||defined(CS8900_MEMORY)||defined(CS8900_I2C_SW_8))
#error ERROR: CS8900-INTERFACE (use "CS8900_I2C_SW_16" only) !!!
#endif

#if defined(CS8900_MEMORY)&&(defined(_CHIP_ATMEGA32_)||defined(_CHIP_ATMEGA32L_))
#error ERROR: wrong CS8900-Interface for ATmega32(L)!!!
#endif

#endif

#ifndef CS8900_TRAFFIC_RECEIVE_H
#define CS8900_TRAFFIC_RECEIVE_H
#endif
#ifndef CS8900_TRAFFIC_RECEIVE_L
#define CS8900_TRAFFIC_RECEIVE_L
#endif
#ifndef CS8900_TRAFFIC_RECEIVE_OUTPUT
#define CS8900_TRAFFIC_RECEIVE_OUTPUT
#endif
#ifndef CS8900_TRAFFIC_TRANSMIT_H
#define CS8900_TRAFFIC_TRANSMIT_H
#endif
#ifndef CS8900_TRAFFIC_TRANSMIT_L
#define CS8900_TRAFFIC_TRANSMIT_L
#endif
#ifndef CS8900_TRAFFIC_TRANSMIT_OUTPUT
#define CS8900_TRAFFIC_TRANSMIT_OUTPUT
#endif

#ifndef CS8900_RESET_L
#define CS8900_RESET_L
#endif
#ifndef CS8900_RESET_H
#define CS8900_RESET_H
#endif
#ifndef CS8900_RESET_OUTPUT
#define CS8900_RESET_OUTPUT
#endif

#ifndef CS8900_SLEEP_L
#define CS8900_SLEEP_L
#endif
#ifndef CS8900_SLEEP_H
#define CS8900_SLEEP_H
#endif
#ifndef CS8900_SLEEP_OUTPUT
#define CS8900_SLEEP_OUTPUT
#endif

#ifndef CS8900_SBHE_L
#define CS8900_SBHE_L
#endif
#ifndef CS8900_SBHE_H
#define CS8900_SBHE_H
#endif
#ifndef CS8900_SBHE_OUTPUT
#define CS8900_SBHE_OUTPUT
#endif

#ifdef CS8900_MEMORY
#ifndef	CS8900_IO_ADDRESS
#define	CS8900_IO_ADDRESS  		  	0xf000
#endif
#define ETHER_IO_R(address)			*(volatile unsigned char*)(CS8900_IO_ADDRESS+address)
#define ETHER_IO_W(address, data)	*(volatile unsigned char*)(CS8900_IO_ADDRESS+address)=data
#endif


#if defined(CS8900_IO_PORT8)||defined(CS8900_IO_PORT16)||\
    defined(CS8900_I2C_HW_8)||defined(CS8900_I2C_HW_16)||defined(CS8900_I2C_SW_8)||defined(CS8900_I2C_SW_16)

#ifndef CS8900_IOR_L
#define CS8900_IOR_L
#endif
#ifndef CS8900_IOR_H
#define CS8900_IOR_H
#endif
#ifndef CS8900_IOR_OUTPUT
#define CS8900_IOR_OUTPUT
#endif

#ifndef CS8900_IOW_L
#define CS8900_IOW_L
#endif
#ifndef CS8900_IOW_H
#define CS8900_IOW_H
#endif
#ifndef CS8900_IOW_OUTPUT
#define CS8900_IOW_OUTPUT
#endif
#endif

#if defined(CS8900_IO_PORT8)||defined(CS8900_IO_PORT16)
#ifndef CS8900_ADR
#define	CS8900_ADR(x)
#endif
#ifndef CS8900_ADR_DDR
#define	CS8900_ADR_DDR
#endif

#ifndef CS8900_DATA_W
#define CS8900_DATA_W
#endif
#ifndef CS8900_DATA_R
#define CS8900_DATA_R
#endif
#ifndef CS8900_DATA_INPUT
#define CS8900_DATA_INPUT
#endif
#ifndef CS8900_DATA_OUTPUT
#define CS8900_DATA_OUTPUT
#endif
#endif

#ifdef CS8900_IO_PORT8
#define ETHER_IO_R(address)			_cs8900_r_port8(address)
#define ETHER_IO_W(address, data)	_cs8900_w_port8(address, data)
#endif

#ifdef CS8900_IO_PORT16
#define ETHER_IO_R_LE(address)		_cs8900_r_port16(address, LITTLE_ENDIAN)
#define ETHER_IO_R_BE(address)		_cs8900_r_port16(address, BIG_ENDIAN)
#define ETHER_IO_W(address, data)	_cs8900_w_port16(address, data)

#ifndef CS8900_DATA16_W
#define	CS8900_DATA16_W
#endif
#ifndef CS8900_DATA16_R
#define CS8900_DATA16_R
#endif
#ifndef CS8900_DATA16_INPUT
#define	CS8900_DATA16_INPUT
#endif
#ifndef CS8900_DATA16_OUTPUT
#define CS8900_DATA16_OUTPUT
#endif
#endif

#if defined(CS8900_I2C_HW_8)||defined(CS8900_I2C_HW_16)||defined(CS8900_I2C_SW_8)||defined(CS8900_I2C_SW_16)
#ifndef I2C_ADDRESS_EXPANDER
#define I2C_ADDRESS_EXPANDER		0x7a
#endif
#ifndef I2C_DATA8_EXPANDER
#define I2C_DATA8_EXPANDER			0x72
#endif
#ifndef I2C_DATA16_EXPANDER
#define I2C_DATA16_EXPANDER			0x70
#endif

#define	I2C_AND_WRITE_MODE			0xfe
#define	I2C_OR_READ_MODE			0x01

#if defined(CS8900_I2C_HW_8)||defined(CS8900_I2C_HW_16)
#define I2C_TWINT					(1<<7)
#define I2C_TWEA					(1<<6)
#define I2C_TWSTA					(1<<5)
#define I2C_TWSTO  					(1<<4)
#define I2C_TWEN 					(1<<2)

#define I2C_TWIE				   	0
#define I2C_TWPS0				   	0
#define I2C_TWPS1				   	1
#endif
#endif

#ifdef CS8900_I2C_HW_8
#define ETHER_IO_R(address)			_cs8900_r_i2c_hw8(address)
#define ETHER_IO_W(address, data)	_cs8900_w_i2c_hw8(address, data)
#endif

#ifdef CS8900_I2C_HW_16
#define ETHER_IO_R_LE(address)		_cs8900_r_i2c_hw16(address, LITTLE_ENDIAN)
#define ETHER_IO_R_BE(address)		_cs8900_r_i2c_hw16(address, BIG_ENDIAN)
#define ETHER_IO_W(address, data)	_cs8900_w_i2c_hw16(address, data)
#endif

#ifdef CS8900_I2C_SW_8
#define ETHER_IO_R(address)			_cs8900_r_i2c_sw8(address)
#define ETHER_IO_W(address, data)	_cs8900_w_i2c_sw8(address, data)
#endif

#ifdef CS8900_I2C_SW_16
#define ETHER_IO_R_LE(address)		_cs8900_r_i2c_sw16(address, LITTLE_ENDIAN)
#define ETHER_IO_R_BE(address)		_cs8900_r_i2c_sw16(address, BIG_ENDIAN)
#define ETHER_IO_W(address, data)	_cs8900_w_i2c_sw16(address, data)
#endif


#define CS8900_PP_CHIP_ID		0x0000



#define CS8900_PP_ISA_IOB		0x0020
#define CS8900_PP_ISA_INT     	0x0022
#define CS8900_PP_ISA_DMA     	0x0024
#define CS8900_PP_ISA_OFF      	0x0026
#define CS8900_PP_DMA_FRAME_C	0x0028
#define CS8900_PP_DMA_BYTE_C   	0x002A
#define CS8900_PP_ISA_MEM_B		0x002C
#define CS8900_PP_ISA_BOOT_B	0x0030
#define CS8900_PP_ISA_BOOT_M	0x0034

#define CS8900_PP_EE_CMD		0x0040
#define CS8900_PP_EE_DATA		0x0042

#define CS8900_PP_RX_CFG		0x0102
#define CS8900_PP_RX_CTL		0x0104
#define CS8900_PP_TX_CFG		0x0106
#define CS8900_PP_TX_CMD_RO		0x0108
#define CS8900_PP_BUF_CFG		0x010A
#define CS8900_PP_LINE_CTL		0x0112
#define CS8900_PP_SELF_CTL		0x0114
#define CS8900_PP_BUS_CTL		0x0116
#define CS8900_PP_TEST_CTL		0x0118

#define CS8900_PP_ISQ          	0x0120
#define CS8900_PP_RX_EVENT     	0x0124
#define CS8900_PP_TX_EVENT     	0x0128
#define CS8900_PP_BUF_EVENT    	0x012C
#define CS8900_PP_RX_MISS      	0x0130
#define CS8900_PP_TX_COL       	0x0132
#define CS8900_PP_LINE_ST      	0x0134
#define CS8900_PP_SELF_ST      	0x0136
#define CS8900_PP_BUS_ST       	0x0138
#define CS8900_PP_TDR          	0x013C

#define CS8900_PP_TX_CMD_WO	   	0x0144
#define CS8900_PP_TX_LENGTH    	0x0146

#define CS8900_PP_LAF          	0x0150
#define CS8900_PP_IA           	0x0158

#define CS8900_PP_RX_STATUS    	0x0400
#define CS8900_PP_RX_LENGTH    	0x0402
#define CS8900_PP_RX_FRAME    	0x0404
#define CS8900_PP_TX_FRAME     	0x0A00

#define DEFAULT_IO_BASE        	0x0300

#define SKIP_1               	0x0040
#define RX_STREAM_ENBL       	0x0080
#define RX_OK_ENBL           	0x0100
#define RX_DMA_ONLY          	0x0200
#define AUTO_RX_DMA          	0x0400
#define BUFFER_CRC           	0x0800
#define RX_CRC_ERROR_ENBL    	0x1000
#define RX_RUNT_ENBL         	0x2000
#define RX_EXTRA_DATA_ENBL   	0x4000

#define RX_IA_HASH_ACCEPT    	0x0040
#define RX_PROM_ACCEPT       	0x0080
#define RX_OK_ACCEPT         	0x0100
#define RX_MULTCAST_ACCEPT   	0x0200
#define RX_IA_ACCEPT         	0x0400
#define RX_BROADCAST_ACCEPT  	0x0800
#define RX_BAD_CRC_ACCEPT    	0x1000
#define RX_RUNT_ACCEPT       	0x2000
#define RX_EXTRA_DATA_ACCEPT 	0x4000

#define TX_LOST_CRS_ENBL     	0x0040
#define TX_SQE_ERROR_ENBL    	0x0080
#define TX_OK_ENBL           	0x0100
#define TX_LATE_COL_ENBL     	0x0200
#define TX_JBR_ENBL          	0x0400
#define TX_ANY_COL_ENBL      	0x0800
#define TX_16_COL_ENBL       	0x8000

#define TX_CMD_START_5_BYTES		0x0000
#define TX_CMD_START_381_BYTES		0x0040
#define TX_CMD_START_1021_BYTES		0x0080
#define TX_CMD_START_ALL_BYTES		0x00C0
#define TX_CMD_FORCE				0x0100
#define TX_CMD_ONE_COL				0x0200
#define TX_CMD_INHIBIT_CRC			0x1000
#define TX_CMD_PAD_DIS				0x2000

#define GENERATE_SW_INTERRUPT      0x0040
#define RX_DMA_ENBL                0x0080
#define READY_FOR_TX_ENBL          0x0100
#define TX_UNDERRUN_ENBL           0x0200
#define RX_MISS_ENBL               0x0400
#define RX_128_BYTE_ENBL           0x0800
#define TX_COL_COUNT_OVRFLOW_ENBL  0x1000
#define RX_MISS_COUNT_OVRFLOW_ENBL 0x2000
#define RX_DEST_MATCH_ENBL         0x8000

#define SERIAL_RX_ON         	0x0040
#define SERIAL_TX_ON         	0x0080
#define AUI_ONLY             	0x0100
#define AUTO_AUI_10BASET     	0x0200
#define MODIFIED_BACKOFF     	0x0800
#define POLARITY_DIS	     	0x1000
#define TWO_PART_DEFDIS      	0x2000
#define LOW_RX_SQUELCH       	0x4000

#define SELF_CTL_RESET			0x0040
#define SELF_CTL_SW_SUSPEND		0x0100
#define SELF_CTL_HW_SLEEP_E		0x0200
#define SELF_CTL_HW_STANDBY_E	0x0400
#define SELF_CTL_HC0E		 	0x1000
#define SELF_CTL_HC1E		 	0x2000
#define SELF_CTL_HCB0		  	0x4000
#define SELF_CTL_HCB1		  	0x8000

#define RESET_RX_DMA         	0x0040
#define MEMORY_ON            	0x0400
#define DMA_BURST_MODE       	0x0800
#define IO_CHANNEL_READY_ON  	0x1000
#define RX_DMA_SIZE_64K      	0x2000
#define ENABLE_IRQ           	0x8000

#define DISABLE_LT				0x0080
#define ENDEC_LOOPBACK       	0x0200
#define AUI_LOOPBACK         	0x0400
#define BACKOFF_OFF          	0x0800
#define FDX_8900             	0x4000

#define RX_IA_HASHED         	0x0040
#define RX_DRIBBLE           	0x0080
#define RX_OK                	0x0100
#define RX_HASHED            	0x0200
#define RX_IA                	0x0400
#define RX_BROADCAST         	0x0800
#define RX_CRC_ERROR         	0x1000
#define RX_RUNT              	0x2000
#define RX_EXTRA_DATA        	0x4000
#define HASH_INDEX_MASK      	0xFC00

#define TX_LOST_CRS          	0x0040
#define TX_SQE_ERROR         	0x0080
#define TX_OK                	0x0100
#define TX_LATE_COL          	0x0200
#define TX_JBR               	0x0400
#define TX_16_COL            	0x8000
#define TX_COL_COUNT_MASK    	0x7800

#define SW_INTERRUPT         	0x0040
#define RX_DMA               	0x0080
#define READY_FOR_TX         	0x0100
#define TX_UNDERRUN          	0x0200
#define RX_MISS              	0x0400
#define RX_128_BYTE          	0x0800
#define TX_COL_OVRFLW        	0x1000
#define RX_MISS_OVRFLW       	0x2000
#define RX_DEST_MATCH        	0x8000

#define LINK_OK              	0x0080
#define AUI_ON               	0x0100
#define TENBASET_ON          	0x0200
#define POLARITY_OK          	0x1000
#define CRS_OK               	0x4000

#define SELF_ST_33V_ACTIVE		0x0040
#define SELF_ST_INITD	 		0x0080
#define SELF_ST_SIBUSY	 		0x0100
#define SELF_ST_EEPROM_PRESENT	0x0200
#define SELF_ST_EEPROM_OK		0x0400
#define SELF_ST_EL_PRESENT		0x0800
#define SELF_ST_EE_SIZE			0x1000

#define TX_BID_ERROR         	0x0080
#define READY_FOR_TX_NOW     	0x0100

#define ISQ_RX_EVENT         	0x0004
#define ISQ_TX_EVENT        	0x0008
#define ISQ_BUFFER_EVENT     	0x000C
#define ISQ_RX_MISS_EVENT   	0x0010
#define ISQ_TX_COL_EVENT     	0x0012

#define ISQ_EVENT_MASK       	0x003F

#define IO_PORT_TX_RX        	0x0000

#define IO_PORT_TX_CMD        	0x0004
#define IO_PORT_TX_LEN         	0x0006
#define IO_PORT_ISQ            	0x0008
#define IO_PORT_ADD            	0x000A
#define IO_PORT_DATA           	0x000C

#define EEPROM_READ_CMD      	0x0200
#define EEPROM_WRITE_CMD     	0x0100
#define EEPROM_ERASE_CMD     	0x0300
#define EEPROM_WRITE_EN      	0x00F0
#define EEPROM_WRITE_DIS     	0x0000

#define EEPROM_ERASE_ALL     	0x00a0
#define EEPROM_WRITE_ALL     	0x0050

#define LO(x) ((unsigned char)((x)&0x00ff))
#define HI(x) ((unsigned char)(((x)>>8)&0x00ff))

#ifdef __CODEVISIONAVR__
#pragma used+
#endif
typedef enum
{
   LITTLE_ENDIAN,
   BIG_ENDIAN
}
ENDIAN_MODE;


typedef struct
{
   unsigned int addr;
   unsigned int data;
}
CS8900_INIT_DATA;

extern CS8900_INIT_DATA cs8900_init_data[5];

void cs8900_set_mac(unsigned char *new_mac);
unsigned char cs8900_init(void);
void cs8900_write_io_reg16(unsigned char address, unsigned int data);
unsigned int cs8900_read_io_reg16_le(unsigned char address);
unsigned int cs8900_read_io_reg16_be(unsigned char address);
unsigned int cs8900_read_io_reg16_HB1ST(unsigned char Address);
void cs8900_write_packetpage16(unsigned int address, unsigned int data);
unsigned int cs8900_read_packetpage16_le(unsigned int address);
unsigned int cs8900_read_packetpage16_be(unsigned int address);
void cs8900_write_frame(void *source, unsigned int size);
void cs8900_read_frame(void *dest, unsigned int size);
void cs8900_read_dummyframe(unsigned int size);
unsigned int cs8900_transmit_ready(unsigned int frame_size);
void cs8900_software_sleep(void);
void cs8900_software_wakeup(void);
void cs8900_software_reset(void);
void cs8900_hardware_reset(void);
void cs8900_rx_skip(void);
unsigned int cs8900_collision_counter(void);
unsigned int cs8900_miss_counter(void);

#ifdef __CODEVISIONAVR__
#pragma used-

#ifdef ETW_LIBRARY_ENABLE
#pragma library cs8900.lib
#endif
#endif
#endif
