
/*****************************************************************************
 *
 *                          "device.h"
 *                   -----------------------------
 *
 *  Version:    2.06
 *  File:     	..\..\..\device.h
 *  Created:    05.05.2003
 *  Date:       30.01.2005
 *  Author:     Copyright (C) 2001-2005
 *              Udo Jakobza - FTZ Leipzig; D-04107 Leipzig; Wchterstr. 13
 *              info@easytoweb.net
 *  Func: 		header-file for device.c
 *  License:
 *    This library is free software; you can redistribute it and/or modify it
 *    under the terms of the GNU Lesser General Public License as published by
 *    the Free Software Foundation; either version 2.1 of the License, or
 *    (at your option) any later version. This library is distributed in the hope
 *    that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *    warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *    See the GNU Lesser General Public License for more details.
 *	  see: http://www.gnu.org/copyleft/lesser.html
 *    You should have received a copy of the GNU Lesser General Public License
 *    along with this library; if not, write to the Free Software Foundation,
 *    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *    Die Bibliothek ist freie Software; Sie drfen sie unter den Bedingungen der
 *    GNU Lesser General Public License, wie von der Free Software Foundation
 *    verffentlicht, weiterverteilen und/oder modifizieren; entweder gem
 *    Version 2.1 der Lizenz oder (nach Ihrer Option) jeder spteren Version.
 *    Diese Bibliothek wird in der Hoffnung weiterverbreitet, da sie ntzlich
 *    sein wird, jedoch OHNE IRGENDEINE GARANTIE, auch ohne die implizierte
 *    Garantie der MARKTREIFE oder der VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK.
 *    Mehr Details finden Sie in der GNU Lesser General Public License.
 *	  see: http://www.gnu.org/copyleft/lesser.de.html
 *    Sie sollten eine Kopie der GNU Lesser General Public License zusammen mit
 *    dieser Bibliothek erhalten haben; falls nicht, schreiben Sie an die FSF,
 *    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 *  history:
 *		1.) 08.08.2003 Version 2.00
 *		2.) 08.08.2003 Version 2.01
 *			a.)	- new macro "EASYTOWEB_VERSION" replaced "SOFTWARE_VERSION";
 *		3.) 12.11.2003 Version 2.02
 *			a.)	- "DEVICE_PPP" supports now "DEVICE_READ_FRAME_16BIT_LE()";
 *		4.) 12.01.2004 Version 2.03
 *			a.)	- new IPSec device-functions
 *		5.) 24.06.2004 Version 2.04
 *			a.)	- new "DEVICE_WRITE_COMPLETE()" function - checks the
 *		6.) 30.01.2005 Version 2.06
 *			a.)	-
 *
 *****************************************************************************/
#ifndef _DEVICE_INCLUDED_
#define _DEVICE_INCLUDED_

#include "project.h"
#ifdef DEVICE_PPP
#include PPP_H_FILEPATH
#endif
#ifdef DEVICE_CS8900
#include CS8900_H_FILEPATH
#endif
#ifdef DEVICE_3c509b
#include NIC_3c509b_H_FILEPATH
#endif
#ifdef IPSEC_ENABLE
#include IPSEC_H_FILEPATH
#endif

#ifndef	MAC_DEFAULT_1
#define	MAC_DEFAULT_1			0x00
#define	MAC_DEFAULT_2			0x50
#define	MAC_DEFAULT_3			0xc2
#define	MAC_DEFAULT_4			0x21
#define	MAC_DEFAULT_5			0x10
#define	MAC_DEFAULT_6			0x00
#endif

#ifdef IPSEC_ENABLE
#define DEVICE_READ_IP_FRAME_16BIT()			ipsec_read_frame_16bit()
#define DEVICE_READ_IP_FRAME_16BIT_LE()			ipsec_read_frame_16bit_le()
#define DEVICE_READ_IP_FRAME_DUMMY(size)		ipsec_read_frame_dummy(size)
#define DEVICE_READ_IP_FRAME_DATA(dest, size)	ipsec_read_frame(dest, size)
#else
#ifdef DEVICE_CS8900
#define DEVICE_READ_IP_FRAME_16BIT()			cs8900_read_io_reg16_be(IO_PORT_TX_RX)
#define DEVICE_READ_IP_FRAME_16BIT_LE()			cs8900_read_io_reg16_le(IO_PORT_TX_RX)
#define DEVICE_READ_IP_FRAME_DUMMY(size)	 	cs8900_read_dummyframe(size)
#define DEVICE_READ_IP_FRAME_DATA(dest, size)	cs8900_read_frame(dest, size)
#endif
#ifdef DEVICE_3c509b
#define DEVICE_READ_IP_FRAME_16BIT()			DEVICE_READ_FRAME_16BIT()
#define DEVICE_READ_IP_FRAME_16BIT_LE()			DEVICE_READ_FRAME_16BIT_LE()
#define DEVICE_READ_IP_FRAME_DUMMY(size)        DEVICE_READ_FRAME_DUMMY(size)
#define DEVICE_READ_IP_FRAME_DATA(dest,size)    DEVICE_READ_FRAME_DATA(dest,size)
#endif
#ifdef DEVICE_PPP
#define DEVICE_READ_IP_FRAME_16BIT()			ppp_read_frame_16bit()
#define DEVICE_READ_IP_FRAME_16BIT_LE()			ppp_read_frame_16bit_le()
#define DEVICE_READ_IP_FRAME_DUMMY(size)	 	ppp_read_frame_dummy(size)
#define DEVICE_READ_IP_FRAME_DATA(dest, size)	ppp_read_frame(dest, size)
#endif
#endif

#ifdef DEVICE_CS8900
#define DEVICE_INIT()							cs8900_init()
#define DEVICE_READ_READY()						cs8900_read_packetpage16_le(CS8900_PP_RX_EVENT)
#define DEVICE_READ_FRAME_16BIT()	   			cs8900_read_io_reg16_be(IO_PORT_TX_RX)
#define DEVICE_READ_FRAME_16BIT_LE()			cs8900_read_io_reg16_le(IO_PORT_TX_RX)
#define DEVICE_READ_FRAME_DUMMY(size)			cs8900_read_dummyframe(size)
#define DEVICE_READ_FRAME_DATA(dest, size)		cs8900_read_frame(dest, size)
#define DEVICE_READ_FRAME_STATUS()				cs8900_read_io_reg16_HB1ST(IO_PORT_TX_RX)
#define DEVICE_RECEIVE_SKIP()					cs8900_rx_skip()
#define DEVICE_WRITE_FRAME_DATA(source, size)	cs8900_write_frame(source, size)
#define DEVICE_WRITE_READY(framesize)			cs8900_transmit_ready(framesize)
#define DEVICE_WRITE_COMPLETE()					cs8900_read_packetpage16_le(CS8900_PP_TX_EVENT)

#define	DEVICE_READ_READY_RECEIVE				RX_OK
#define	DEVICE_READ_READY_FRAME					RX_IA
#define	DEVICE_READ_READY_BROADCAST				RX_BROADCAST

#define	DEVICE_WRITE_COMPLETE_OK		  		TX_OK
#define	DEVICE_WRITE_COMPLETE_ERROR				(TX_LATE_COL | TX_JBR | TX_16_COL)
#endif

#ifdef DEVICE_PPP
#define DEVICE_INIT()							ppp_init_interface()
#define DEVICE_READ_READY()						ppp_ready()
#define DEVICE_READ_FRAME_16BIT()		        ppp_read_frame_16bit()
#define DEVICE_READ_FRAME_16BIT_LE()			ppp_read_frame_16bit_le()
#define DEVICE_READ_FRAME_STATUS()
#define DEVICE_READ_FRAME_DUMMY(size)			ppp_read_frame_dummy(size)
#define DEVICE_READ_FRAME_DATA(dest, size)	    ppp_read_frame(dest, size)
#define DEVICE_WRITE_FRAME_DATA(source, size)	ppp_write_data(source, size)
#define DEVICE_WRITE_READY(framesize)			ppp_write_ready(framesize)
#define DEVICE_WRITE_COMPLETE()					DEVICE_WRITE_COMPLETE_OK

#define	DEVICE_READ_READY_RECEIVE				0x0100
#define	DEVICE_READ_READY_FRAME					0x0400
#define	DEVICE_READ_READY_BROADCAST				0x0800

#define	DEVICE_WRITE_COMPLETE_OK		  		0x0100
#define	DEVICE_WRITE_COMPLETE_ERROR				0x8600
#endif

#ifdef DEVICE_3c509b
#define DEVICE_INIT()							(1)//nic_start()
#define DEVICE_READ_READY()						nic_get_RX_state()
extern unsigned int  DEVICE_READ_FRAME_16BIT(void);
extern unsigned int  DEVICE_READ_FRAME_16BIT_LE(void);
extern void          DEVICE_READ_FRAME_DATA(unsigned char *dest, unsigned int size);
extern void          DEVICE_READ_FRAME_DUMMY(unsigned int size);
#define DEVICE_READ_IPFRAME_DUMMY(size)			DEVICE_READ_FRAME_DUMMY(size)

//#define DEVICE_READ_FRAME_STATUS()				cs8900_read_io_reg16_HB1ST(IO_PORT_TX_RX)
//#define DEVICE_RECEIVE_SKIP()					cs8900_rx_skip()
#define DEVICE_WRITE_FRAME_DATA(source, size)	nic_write_frame(source, size)
#define DEVICE_WRITE_READY(framesize)			nic_transmit_ready(framesize)
#define DEVICE_WRITE_COMPLETE()					DEVICE_WRITE_COMPLETE_OK
////#define DEVICE_WRITE_COMPLETE()					cs8900_read_packetpage16_le(CS8900_PP_TX_EVENT)

#define	DEVICE_READ_READY_RECEIVE				(0 == 0)
//#define	DEVICE_READ_READY_FRAME					(0 == 0)
//#define	DEVICE_READ_READY_BROADCAST				RX_BROADCAST

#define	DEVICE_WRITE_COMPLETE_OK		  		(1==1)
#define	DEVICE_WRITE_COMPLETE_ERROR				(1==1)
#endif


#ifndef DEVICE_INIT
#define DEVICE_INIT
#endif

#ifndef DEVICE_READ_READY
#define DEVICE_READ_READY
#endif

#if !defined(DEVICE_READ_FRAME_16BIT) && !defined(DEVICE_3c509b)
#define DEVICE_READ_FRAME_16BIT
#endif

#if !defined(DEVICE_READ_FRAME_16BIT_LE) && !defined(DEVICE_3c509b)
#define DEVICE_READ_FRAME_16BIT_LE
#endif

#ifndef DEVICE_READ_FRAME_STATUS
#define DEVICE_READ_FRAME_STATUS
#endif

#if !defined(DEVICE_READ_FRAME_DUMMY) && !defined(DEVICE_3c509b)
#define DEVICE_READ_FRAME_DUMMY(a)
#endif

#if !defined(DEVICE_READ_FRAME_DATA) && !defined(DEVICE_3c509b)
#define DEVICE_READ_FRAME_DATA(a,b)
#endif

#ifndef DEVICE_RECEIVE_SKIP
#define DEVICE_RECEIVE_SKIP()
#endif

#ifndef DEVICE_WRITE_FRAME_DATA
#define DEVICE_WRITE_FRAME_DATA()
#endif

#ifndef DEVICE_WRITE_READY
#define DEVICE_WRITE_READY(framesize)
#endif

#ifdef __CODEVISIONAVR__
#pragma used+
#endif
#if defined(DEVICE_CS8900) || defined(DEVICE_3c509b)
extern unsigned char mac_address[6];
#endif
#ifdef __CODEVISIONAVR__
#pragma used-

#ifdef ETW_LIBRARY_ENABLE
#pragma library device.lib
#endif
#endif
#endif // #ifndef _DEVICE_INCLUDED_
