
/*****************************************************************************
 *
 *                          "ethernet.h"
 *                   -----------------------------
 *
 *  Version:    1.02
 *  File:     	...\projects\...\ethernet.h
 *  Created:    15.04.2003
 *  Date:       23.07.2003
 *  Author:     Copyright (C) 2001-2003
 *              Udo Jakobza - FTZ Leipzig; D-04107 Leipzig; Wchterstr. 13
 *              info@easytoweb.net
 *  Func: 		header-file for ethernet.c
 *  license:
 *    This library is free software; you can redistribute it and/or modify it
 *    under the terms of the GNU Lesser General Public License as published by
 *    the Free Software Foundation; either version 2.1 of the License, or
 *    (at your option) any later version. This library is distributed in the hope
 *    that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *    warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *    See the GNU Lesser General Public License for more details.
 *	  see: http://www.gnu.org/copyleft/lesser.html
 *    You should have received a copy of the GNU Lesser General Public License
 *    along with this library; if not, write to the Free Software Foundation,
 *    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *    Bibliothek ist freie Software; Sie drfen sie unter den Bedingungen der
 *    GNU Lesser General Public License, wie von der Free Software Foundation
 *    verffentlicht, weiterverteilen und/oder modifizieren; entweder gem
 *    Version 2.1 der Lizenz oder (nach Ihrer Option) jeder spteren Version.
 *    Diese Bibliothek wird in der Hoffnung weiterverbreitet, da sie ntzlich
 *    sein wird, jedoch OHNE IRGENDEINE GARANTIE, auch ohne die implizierte
 *    Garantie der MARKTREIFE oder der VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK.
 *    Mehr Details finden Sie in der GNU Lesser General Public License.
 *	  see: http://www.gnu.org/copyleft/lesser.de.html
 *    Sie sollten eine Kopie der GNU Lesser General Public License zusammen mit
 *    dieser Bibliothek erhalten haben; falls nicht, schreiben Sie an die FSF,
 *    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 *  history:
 *		1.) 30.07.2003 Version 2.00a
 *			a.)	-
 *
 *****************************************************************************/
#ifndef _ETHERNET_INCLUDED_
#define _ETHERNET_INCLUDED_

#define ETH_DA_OFS           0
#define ETH_SA_OFS           6
#define ETH_TYPE_OFS         12
#define ETH_DATA_OFS         14
#define ETH_HEADER_SIZE      14

#define MAC_ADR_SIZE		 6

#ifdef __CODEVISIONAVR__
#define SWAPB(DATA)			((unsigned int)((DATA) << 8) | ((DATA) >> 8))
#else
static __inline__ unsigned int SWAPB(unsigned int value) __attribute__((__always_inline__));
static __inline__ unsigned int SWAPB(unsigned int value)
{
   __asm__ ( "mov __tmp_reg__, %A0" "\n\t"
             "mov %A0, %B0"         "\n\t"
             "mov %B0, __tmp_reg__" "\n\t":"=r" ( value ):"0"( value ) );
   return value;
}
#endif
#ifdef __CODEVISIONAVR__
#pragma used+
#endif
extern unsigned char mac_of_last_frame[MAC_ADR_SIZE];

void ethernet_process(void);
#if defined(DEVICE_3c509b)
void ethernet_process_frame(unsigned char broadcast_flag, unsigned int len);
#else
void ethernet_process_frame(unsigned char broadcast_flag);
#endif
#ifdef __CODEVISIONAVR__
#pragma used-

#ifdef ETW_LIBRARY_ENABLE
#pragma library ethernet.lib
#endif
#endif
#endif
