
/*****************************************************************************
 *
 *                        "ftp_server.h" 
 *                   -----------------------------
 *                                                                            
 *  Version:    2.03
 *  File:     	...\...\ftp_server.h    
 *  Created:    11.08.2001
 *  Date:       06.07.2004
 *  Author:     Copyright (C) 2001-2004
 *              Udo Jakobza - FTZ Leipzig; D-04107 Leipzig; Wchterstr. 13
 *              info@easytoweb.net
 *  Func: 	Header file for ftp_server.c
 *  license:	
 *    This library is free software; you can redistribute it and/or modify it 
 *    under the terms of the GNU Lesser General Public License as published by 
 *    the Free Software Foundation; either version 2.1 of the License, or 
 *    (at your option) any later version. This library is distributed in the hope 
 *    that it will be useful, but WITHOUT ANY WARRANTY; without even the implied 
 *    warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
 *    See the GNU Lesser General Public License for more details.
 *	  see: http://www.gnu.org/copyleft/lesser.html	
 *    You should have received a copy of the GNU Lesser General Public License 
 *    along with this library; if not, write to the Free Software Foundation, 
 *    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *	
 *    Die Bibliothek ist freie Software; Sie drfen sie unter den Bedingungen der 
 *    GNU Lesser General Public License, wie von der Free Software Foundation 
 *    verffentlicht, weiterverteilen und/oder modifizieren; entweder gem 
 *    Version 2.1 der Lizenz oder (nach Ihrer Option) jeder spteren Version. 
 *    Diese Bibliothek wird in der Hoffnung weiterverbreitet, da sie ntzlich 
 *    sein wird, jedoch OHNE IRGENDEINE GARANTIE, auch ohne die implizierte 
 *    Garantie der MARKTREIFE oder der VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK. 
 *    Mehr Details finden Sie in der GNU Lesser General Public License.
 *	  see: http://www.gnu.org/copyleft/lesser.de.html	
 *    Sie sollten eine Kopie der GNU Lesser General Public License zusammen mit 
 *    dieser Bibliothek erhalten haben; falls nicht, schreiben Sie an die FSF,
 *    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 *  history:	
 *		1.) 11.08.2003 Version 2.01
 *			a.)	- 
 *
 *****************************************************************************/
#ifndef _FTP_SERVER_INCLUDED_
#define _FTP_SERVER_INCLUDED_

#include "project.h"
#include <avr/pgmspace.h>

#if 0
#ifndef FTP_CRLF
#define	FTP_CRLF			PSTR("\r\n")
#endif

#define	FTP_REPLY_125		PSTR("125 Data connection already open\r\n")
#define	FTP_REPLY_150		PSTR("150 File status ok\r\n")
#define	FTP_REPLY_200		PSTR("200 Command okay\r\n")
#define	FTP_REPLY_202		PSTR("202 Command not implemented, superfluous at this site\r\n")
#define	FTP_REPLY_214		PSTR("214 easyToWeb-\"PROJECT_NAME\" \"PROJECT_VERSION\r\n")
#define	FTP_REPLY_215		PSTR("215 easyToWeb-Software FTZ Leipzig\r\n")
#define	FTP_REPLY_220		PSTR("220 Service ready for new user\r\n")
#define	FTP_REPLY_221		PSTR("221 Service closing control connection\r\n")
#define	FTP_REPLY_226		PSTR("226 Closing data connection\r\n")
#define	FTP_REPLY_227		PSTR("227 Entering Passiv Mode %u,%u,%u,%u,%u,%u\r\n")
#define	FTP_REPLY_230		PSTR("230 User looged in, proceed\r\n")
#define	FTP_REPLY_250		PSTR("250 Requested file action okay\r\n")
#define	FTP_REPLY_257		PSTR("257 \x22%s\x22 created\r\n")
#define	FTP_REPLY_331		PSTR("331 User name ok, need password\r\n")
#define	FTP_REPLY_332		PSTR("332 Need account for login\r\n")
#define	FTP_REPLY_421		PSTR("421 Service not available, closing control connections\r\n")
#define	FTP_REPLY_425		PSTR("425 Can not open data connection\r\n")
#define	FTP_REPLY_426		PSTR("426 Connection closed, transfer aborted\r\n")
#define	FTP_REPLY_450		PSTR("450 Requested file action not taken\r\n")
#define	FTP_REPLY_451		PSTR("451 Requested action aborted\r\n")
#define	FTP_REPLY_500		PSTR("500 Syntax error, command unrecognized\r\n")
#define	FTP_REPLY_501		PSTR("501 Syntax error in parameters or argumants\r\n")
#define	FTP_REPLY_502		PSTR("502 Command not implemented\r\n")
#define	FTP_REPLY_503		PSTR("503 Bad sequence of commands\r\n")
#define	FTP_REPLY_504		PSTR("504 Command not implemented for that parameter\r\n")
#define	FTP_REPLY_530		PSTR("530 Not logged in\r\n")
#define	FTP_REPLY_532		PSTR("532 Need account for storing files\r\n")
#define	FTP_REPLY_550		PSTR("550 Requested action not taken, File unavailable\r\n")
#define	FTP_REPLY_552		PSTR("552 Requested file action aborted, Exceeded storage allocation\r\n")

#define	FTP_COMMAND_XMKD	PSTR("XMKD")
#define	FTP_COMMAND_XRMD	PSTR("XRMD")
#define	FTP_COMMAND_XPWD	PSTR("XPWD")
#define	FTP_COMMAND_XCUP	PSTR("XCUP")
#define	FTP_COMMAND_XCWD	PSTR("XCWD")

#define	FTP_COMMAND_USER	PSTR("USER")
#define	FTP_COMMAND_PASS	PSTR("PASS")
#define	FTP_COMMAND_ACCT	PSTR("ACCT")
#define	FTP_COMMAND_CWD		PSTR("CWD")
#define	FTP_COMMAND_CDUP	PSTR("CDUP")
#define	FTP_COMMAND_SMNT	PSTR("SMNT")
#define	FTP_COMMAND_QUIT	PSTR("QUIT")
#define	FTP_COMMAND_REIN	PSTR("REIN")
#define	FTP_COMMAND_PORT	PSTR("PORT")
#define	FTP_COMMAND_PASV	PSTR("PASV")
#define	FTP_COMMAND_TYPE	PSTR("TYPE")
#define	FTP_COMMAND_STRU	PSTR("STRU")
#define	FTP_COMMAND_MODE	PSTR("MODE")
#define	FTP_COMMAND_RETR	PSTR("RETR")
#define	FTP_COMMAND_STOR	PSTR("STOR")
#define	FTP_COMMAND_STOU	PSTR("STOU")
#define	FTP_COMMAND_APPE	PSTR("APPE")
#define	FTP_COMMAND_ALLO	PSTR("ALLO")
#define	FTP_COMMAND_REST	PSTR("REST")
#define	FTP_COMMAND_RNFR	PSTR("RNFR")
#define	FTP_COMMAND_RNTO	PSTR("RNTO")
#define	FTP_COMMAND_ABOR	PSTR("ABOR")
#define	FTP_COMMAND_DELE	PSTR("DELE")
#define	FTP_COMMAND_RMD		PSTR("RMD")
#define	FTP_COMMAND_MKD		PSTR("MKD")
#define	FTP_COMMAND_PWD		PSTR("PWD")
#define	FTP_COMMAND_LIST	PSTR("LIST")
#define	FTP_COMMAND_NLST	PSTR("NLST")
#define	FTP_COMMAND_SITE	PSTR("SITE")
#define	FTP_COMMAND_SYST	PSTR("SYST")
#define	FTP_COMMAND_STAT	PSTR("STAT")
#define	FTP_COMMAND_HELP	PSTR("HELP")
#define	FTP_COMMAND_NOOP	PSTR("NOOP")
#endif

#define	FTP_MAX_COMMAND_SIZE	5
#define FTP_MAX_PARAMETER_SIZE	20



#ifndef	FTP_USER_ID
#define	FTP_USER_ID			PSTR("etw")
#endif

#ifndef	FTP_PASSWORD
#define	FTP_PASSWORD		PSTR("etw")
#endif

#ifndef	FTP_ACCOUNT
#define	FTP_ACCOUNT			PSTR("test")
#endif


#define	FTP_FLAG_TYPE_MASK		0x00fe
#define	FTP_FLAG_PASSIV			0x0001
#define	FTP_FLAG_TYPE_A			0x0002
#define	FTP_FLAG_TYPE_E			0x0004
#define	FTP_FLAG_TYPE_I			0x0008
#define	FTP_FLAG_TYPE_L			0x0010
#define	FTP_FLAG_TYPE_N			0x0020
#define	FTP_FLAG_TYPE_T			0x0040
#define	FTP_FLAG_TYPE_C			0x0080
#define	FTP_FLAG_MODE_S			0x0100
#define	FTP_FLAG_MODE_B			0x0200
#define	FTP_FLAG_MODE_C			0x0400
#define	FTP_FLAG_STRU_F			0x0800
#define	FTP_FLAG_STRU_R			0x1000
#define	FTP_FLAG_STRU_P			0x2000

typedef enum
{
   FTP_STATE_CLOSED,
   FTP_STATE_USER_ID,
   FTP_STATE_PASSWORD,
   FTP_STATE_COMMAND,
   FTP_STATE_ACCOUNT,
   FTP_STATE_LIST,
   FTP_STATE_RETR,
   FTP_STATE_STOR
}
FTP_STATE_MACHINE;

typedef enum
{
   FTP_SERVER_GET_NOTHING,
   FTP_SERVER_GET_NORMAL,
   FTP_SERVER_GET_BREAK
}
FTP_SERVER_GET_MODE;

#ifdef __CODEVISIONAVR__
#pragma used+
#endif
extern unsigned char ftp_server_tcp_command;
void ftp_server(void);

#ifdef WEB_DEBUG_FTP
void ftp_debug_do_cmd(unsigned char *command);
#endif
#ifdef __CODEVISIONAVR__
#pragma used-

#ifdef ETW_LIBRARY_ENABLE
#pragma library ftp_server.lib
#endif
#endif
#endif // #ifndef _FTP_SERVER_INCLUDED_
