
/*****************************************************************************
 *
 *                           "hardware.h" 
 *                   -----------------------------
 *                                                                            
 *  Version:    2.09
 *  File:    	..\include\hardware.h
 *  Created:    09.06.2005
 *  Date:       09.06.2005
 *  Author:     Copyright (C) 2001-2005
 *              Udo Jakobza - FTZ Leipzig; 04107 Leipzig; Wchterstr. 13
 *	  			jakobza@e-technik.htwk-leipzig.de
 *  Func: 	Header file for hardware.c
 *
 *  License:	
 *    This library is free software; you can redistribute it and/or modify it 
 *    under the terms of the GNU Lesser General Public License as published by 
 *    the Free Software Foundation; either version 2.1 of the License, or 
 *    (at your option) any later version. This library is distributed in the hope 
 *    that it will be useful, but WITHOUT ANY WARRANTY; without even the implied 
 *    warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
 *    See the GNU Lesser General Public License for more details.
 *    see: http://www.gnu.org/copyleft/lesser.html	
 *    You should have received a copy of the GNU Lesser General Public License 
 *    along with this library; if not, write to the Free Software Foundation, 
 *    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *	
 *    Die Bibliothek ist freie Software; Sie drfen sie unter den Bedingungen der 
 *    GNU Lesser General Public License, wie von der Free Software Foundation 
 *    verffentlicht, weiterverteilen und/oder modifizieren; entweder gem 
 *    Version 2.1 der Lizenz oder (nach Ihrer Option) jeder spteren Version. 
 *    Diese Bibliothek wird in der Hoffnung weiterverbreitet, da sie ntzlich 
 *    sein wird, jedoch OHNE IRGENDEINE GARANTIE, auch ohne die implizierte 
 *    Garantie der MARKTREIFE oder der VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK. 
 *    Mehr Details finden Sie in der GNU Lesser General Public License.
 *    see: http://www.gnu.org/copyleft/lesser.de.html	
 *    Sie sollten eine Kopie der GNU Lesser General Public License zusammen mit 
 *    dieser Bibliothek erhalten haben; falls nicht, schreiben Sie an die FSF,
 *    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 *  History:	
 *		1.) 08.08.2003 Version 2.00
 *		2.) 12.08.2003 Version 2.01
 *			a.)	- the macros "LED1_ACTIV", "LED2_ACTIV", "LED3_ACTIV" and "LED1_ACTIV"
 *				are now public, see inside of "easytoweb.h" to enable/disable LED's
 *				of easyToWeb-AVR Modul
 *		3.) 20.08.2003 Version 2.01
 *			a.)	- new macros for the SPI-Interface
 *          b.) - new public macros:
 *				 "SPI_MISO_OUTPUT", "SPI_MISO_INPUT", "SPI_MISO_LOW" and "SPI_MISO_HIGH"
 *				 "SPI_MOSI_OUTPUT", "SPI_MOSI_INPUT", "SPI_MOSI_LOW" and "SPI_MOSI_HIGH"
 *				 "SPI_SCK_OUTPUT", "SPI_SCK_INPUT", "SPI_SCK_LOW" and "SPI_SCK_HIGH"
 *				see inside of "easytoweb.h" to control the SPI-Port of your hardware
 *		4.) 09.06.2005 Version 2.09
 *			a.)	- rename the file etw_mc.h to hardware.h
 *
 *****************************************************************************/
#ifndef _HARDWARE_INCLUDED_
#define _HARDWARE_INCLUDED_

#include "project.h"
#include <avr/pgmspace.h>

#ifdef ENABLE_EEPROM_ADDRESS
#include <avr/eeprom.h>
#ifndef EEMEM
#define EEMEM  __attribute__ ((section (".eeprom")))
#endif

#include IP_H_FILEPATH
#endif

#define IP_FFFFFFFF				0xFFFFFFFFUL

#define	TIMER1_PRE			2

#if defined (_MCU_CLOCK_FREQUENCY_)
#define TIMER1_ACOMP (_MCU_CLOCK_FREQUENCY_ / 800)
#else
#define TIMER1_ACOMP (F_CPU / 800)
#endif

#ifndef	LED1_ON
#define	LED1_ON
#endif
#ifndef	LED1_OFF
#define	LED1_OFF
#endif
#ifndef	LED1_PIN
#define	LED1_PIN		1
#endif
#ifndef	LED1_PASSIV
#define	LED1_PASSIV
#endif
#ifndef LED1_ACTIV
#define	LED1_ACTIV
#endif

#ifndef	LED2_ON
#define	LED2_ON
#endif
#ifndef	LED2_OFF
#define	LED2_OFF
#endif
#ifndef	LED2_PIN
#define	LED2_PIN		1
#endif
#ifndef	LED2_PASSIV
#define	LED2_PASSIV
#endif
#ifndef LED2_ACTIV
#define	LED2_ACTIV
#endif

#ifndef	LED3_ON
#define	LED3_ON
#endif
#ifndef	LED3_OFF
#define	LED3_OFF
#endif
#ifndef	LED3_PIN
#define	LED3_PIN		1
#endif
#ifndef	LED3_PASSIV
#define	LED3_PASSIV
#endif
#ifndef LED3_ACTIV
#define	LED3_ACTIV
#endif

#ifndef	LED4_ON
#define	LED4_ON
#endif
#ifndef	LED4_OFF
#define	LED4_OFF
#endif
#ifndef	LED4_PIN
#define	LED4_PIN		1
#endif
#ifndef	LED4_PASSIV
#define	LED4_PASSIV
#endif
#ifndef LED4_ACTIV
#define	LED4_ACTIV
#endif

#define	ADCSR_ADEN	    	0x80
#define	ADCSR_ADSC	    	0x40
#define	ADCSR_ADFR	    	0x20
#define	ADCSR_ADIF	    	0x10
#define	ADCSR_ADIE	    	0x08
#define	ADCSR_128	    	0x07
#define	ADCSR_64	    	0x06
#define	ADCSR_32	    	0x05
#define	ADCSR_16	    	0x04
#define	ADCSR_8		    	0x03
#define	ADCSR_4		    	0x02
#define	ADCSR_2		    	0x01

#define	AD_CHANNEL_0		0x00
#define	AD_CHANNEL_1		0x01
#define	AD_CHANNEL_2		0x02
#define	AD_CHANNEL_3		0x03
#define	AD_CHANNEL_4		0x04
#define	AD_CHANNEL_5		0x05
#define	AD_CHANNEL_6		0x06
#define	AD_CHANNEL_7		0x07
#define	AD_REF_EXT			0x00
#define	AD_REF_AVCC			0x40
#define	AD_REF_256			0xC0

#define	SRL_0	   		0x00
#define	SRL_1			0x10
#define	SRL_2			0x20
#define	SRL_3			0x30
#define	SRL_4			0x40
#define	SRL_5			0x50
#define	SRL_6			0x60
#define	SRL_7			0x70

#define	SRW00_XMCRA		0x04
#define	SRW01_XMCRA		0x08
#define	SRW10_MCUCR		0x40
#define	SRW11_XMCRA		0x02

#define	SPCR_SPIE		0x80
#define	SPCR_SPE		0x40
#define	SPCR_DORD		0x20
#define	SPCR_MSTR		0x10
#define	SPCR_CPOL		0x08
#define	SPCR_CPHA		0x04
#define	SPCR_128		0x03
#define	SPCR_64			0x02
#define	SPCR_16			0x01
#define	SPCR_4			0x00

#if defined(_CHIP_ATMEGA128_)||defined(_CHIP_ATMEGA128L_)||defined(__AVR_ATmega128__)||\
      defined(_CHIP_ATMEGA32_)||defined(_CHIP_ATMEGA32L_)||defined(__AVR_ATmega32__)||\
      defined(_CHIP_ATMEGA161_)||defined(_CHIP_ATMEGA161L_)||defined(__AVR_ATmega16__)
#define	SPCR_32			0x0102
#define	SPCR_8			0x0101
#define	SPCR_2			0x0100
#endif

#define SPI_MODE		(SPCR_SPE | SPCR_MSTR | SPCR_4 | SPCR_CPOL | SPCR_CPHA)

#ifndef	SPI_MISO_OUTPUT
#define	SPI_MISO_OUTPUT
#endif
#ifndef	SPI_MISO_INPUT
#define	SPI_MISO_INPUT
#endif
#ifndef	SPI_MISO_LOW
#define	SPI_MISO_LOW
#endif
#ifndef	SPI_MISO_HIGH
#define	SPI_MISO_HIGH
#endif

#ifndef	SPI_MOSI_OUTPUT
#define	SPI_MOSI_OUTPUT
#endif
#ifndef	SPI_MOSI_INPUT
#define	SPI_MOSI_INPUT
#endif
#ifndef	SPI_MOSI_LOW
#define	SPI_MOSI_LOW
#endif
#ifndef	SPI_MOSI_HIGH
#define	SPI_MOSI_HIGH
#endif

#ifndef	SPI_SCK_OUTPUT
#define	SPI_SCK_OUTPUT
#endif
#ifndef	SPI_SCK_INPUT
#define	SPI_SCK_INPUT
#endif
#ifndef	SPI_SCK_LOW
#define	SPI_SCK_LOW
#endif
#ifndef	SPI_SCK_HIGH
#define	SPI_SCK_HIGH
#endif

#ifndef	MAX_1WIRE_DEVICES
#define	MAX_1WIRE_DEVICES	1
#endif

#ifdef __CODEVISIONAVR__
#pragma used+
#endif

extern volatile unsigned int counter_10ms_16bit;
extern volatile unsigned long second_counter;
extern volatile unsigned int day_counter;
extern unsigned char hardware_reset_status;

#ifdef ENABLE_EEPROM_ADDRESS
#ifdef __CODEVISIONAVR__
extern eeprom unsigned char eeprom_ip[IP_ADR_SIZE];
extern eeprom unsigned char eeprom_submask[IP_ADR_SIZE];
extern eeprom unsigned char eeprom_gateway[IP_ADR_SIZE];
#else
#include <avr/eeprom.h>
extern EEMEM unsigned char eeprom_ip[IP_ADR_SIZE];
extern EEMEM unsigned char eeprom_submask[IP_ADR_SIZE];
extern EEMEM unsigned char eeprom_gateway[IP_ADR_SIZE];
#endif
#endif

#ifndef __CODEVISIONAVR__
extern void delay_ms(unsigned int ms);
#endif

#ifdef DEVICE_CS8900
unsigned char hardware_read_CS8900_mac(unsigned char *romcode_buffer,
                                unsigned char *data_buffer,
                                unsigned char device);
#elif defined(DEVICE_3c509b)
unsigned char hardware_read_mac(unsigned char *romcode_buffer,
                                unsigned char *data_buffer,
                                unsigned char device);
#endif                             
void hardware_timer1_init(void);
unsigned int hardware_timer1_counter(void);
void hardware_set_second_counter(unsigned long new_value);
void hardware_init(void);
void hardware_ad_init(unsigned char init_value);
unsigned int hardware_ad_read(unsigned char channel);

#if defined(DEVICE_CS8900) || defined(DEVICE_3c509b)
void hardware_init_mac_address(void);
#endif
#ifdef IP_ENABLE
void hardware_init_ip_addresses(void);
#endif
void hardware_spi_init(unsigned int mode);

#if defined(AT_DEVICE_MODEM) || defined(AT_DEVICE_BLUETOOTH)
void uart1_irq_receive_enable(void);
void uart1_irq_receive_disable(void);
void uart1_putchar(unsigned char c);
#endif

#ifdef __CODEVISIONAVR__
#ifdef ETW_LIBRARY_ENABLE
#pragma library hardware.lib
#endif
#endif
#ifdef __CODEVISIONAVR__
#pragma used-
#endif
#endif
