
/*****************************************************************************
 *
 *                        "http_server.h" 
 *                   -----------------------------
 *                                                                            
 *  Version:    2.09
 *  File:     	..\..\http_server.h    
 *  Created:    04.11.2001
 *  Date:       27.04.2005
 *  Author:     Copyright (C) 2001-2005
 *              Udo Jakobza - FTZ Leipzig; D-04107 Leipzig; Wchterstr. 13
 *              info@easytoweb.net
 *  Func: 	Header file for http_server.c
 *  license:	
 *    This library is free software; you can redistribute it and/or modify it 
 *    under the terms of the GNU Lesser General Public License as published by 
 *    the Free Software Foundation; either version 2.1 of the License, or 
 *    (at your option) any later version. This library is distributed in the hope 
 *    that it will be useful, but WITHOUT ANY WARRANTY; without even the implied 
 *    warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
 *    See the GNU Lesser General Public License for more details.
 *	  see: http://www.gnu.org/copyleft/lesser.html	
 *    You should have received a copy of the GNU Lesser General Public License 
 *    along with this library; if not, write to the Free Software Foundation, 
 *    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *	
 *    Die Bibliothek ist freie Software; Sie drfen sie unter den Bedingungen der 
 *    GNU Lesser General Public License, wie von der Free Software Foundation 
 *    verffentlicht, weiterverteilen und/oder modifizieren; entweder gem 
 *    Version 2.1 der Lizenz oder (nach Ihrer Option) jeder spteren Version. 
 *    Diese Bibliothek wird in der Hoffnung weiterverbreitet, da sie ntzlich 
 *    sein wird, jedoch OHNE IRGENDEINE GARANTIE, auch ohne die implizierte 
 *    Garantie der MARKTREIFE oder der VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK. 
 *    Mehr Details finden Sie in der GNU Lesser General Public License.
 *	  see: http://www.gnu.org/copyleft/lesser.de.html	
 *    Sie sollten eine Kopie der GNU Lesser General Public License zusammen mit 
 *    dieser Bibliothek erhalten haben; falls nicht, schreiben Sie an die FSF,
 *    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 *  history:	
 *		1.) 04.11.2003 Version 2.02
 *		2.) 02.12.2003 Version 2.03
 *			a.)	- HTTP-Server supports now a default start file, see "HTTP_DEFAULT_FILE"
 *		3.) 17.01.2005 Version 2.06
 *			a.)	- HTTP-Server with Default, File and CGI support
 *
 *****************************************************************************/
#ifndef _HTTP_SERVER_INCLUDED_
#define _HTTP_SERVER_INCLUDED_

#include <avr/pgmspace.h>

#define	HTTP_CRLF				PSTR("\r\n")

#define	HTTP_STATUS_100			PSTR("100 Continue")

#define	HTTP_STATUS_200			PSTR("200 OK")
#define	HTTP_STATUS_201			PSTR("201 Created")
#define	HTTP_STATUS_202			PSTR("202 Accepted")

#define	HTTP_STATUS_404			PSTR("404 Not Found")


#ifndef HTTP_DEFAULT_FILE
#define HTTP_DEFAULT_FILE		PSTR("start.html")
#endif

typedef enum
{
   HTTP_SERVER_FILE_START,
//   HTTP_SERVER_FILE_DATA,
//   HTTP_SERVER_FILE_CLOSE
}
HTTP_SERVER_FILE_STATUS;

typedef enum
{
   HTTP_SERVER_DEFAULT_START,
   HTTP_SERVER_DEFAULT_DATA
}
HTTP_SERVER_DEFAULT_STATUS;

typedef enum
{
   HTTP_SERVER_START,
   HTTP_SERVER_FILE_DATA,
   HTTP_SERVER_FILE_CLOSE,
   HTTP_SERVER_DATA,
   HTTP_SERVER_CLOSE_CONNECTION,
   HTTP_SERVER_CLOSE,
   HTTP_SERVER_HTTP_GET,
   HTTP_SERVER_HTTP_PUT
}
HTTP_SERVER_STATUS;

#ifdef __CODEVISIONAVR__
#pragma used+
#endif
extern unsigned char http_server_tcp;
void http_server(void);

#ifdef __CODEVISIONAVR__
#pragma used-

#ifdef ETW_LIBRARY_ENABLE
#pragma library http_server.lib
#endif
#endif

#endif
