
/*****************************************************************************
 *
 *                          "icmp.h" 
 *                   -----------------------------
 *                                                                            
 *  Version:    2.04
 *  File:     	..\..\..\icmp.h    
 *  Created:    03.04.2003
 *  Date:       07.07.2004
 *  Author:     Copyright (C) 2001-2004
 *              Udo Jakobza - FTZ Leipzig; D-04107 Leipzig; Wchterstr. 13
 *              info@easytoweb.net
 *  Func: 		header-file for icmp.c
 *  License:	
 *    This library is free software; you can redistribute it and/or modify it 
 *    under the terms of the GNU Lesser General Public License as published by 
 *    the Free Software Foundation; either version 2.1 of the License, or 
 *    (at your option) any later version. This library is distributed in the hope 
 *    that it will be useful, but WITHOUT ANY WARRANTY; without even the implied 
 *    warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
 *    See the GNU Lesser General Public License for more details.
 *	  see: http://www.gnu.org/copyleft/lesser.html	
 *    You should have received a copy of the GNU Lesser General Public License 
 *    along with this library; if not, write to the Free Software Foundation, 
 *    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *	
 *    Die Bibliothek ist freie Software; Sie drfen sie unter den Bedingungen der 
 *    GNU Lesser General Public License, wie von der Free Software Foundation 
 *    verffentlicht, weiterverteilen und/oder modifizieren; entweder gem 
 *    Version 2.1 der Lizenz oder (nach Ihrer Option) jeder spteren Version. 
 *    Diese Bibliothek wird in der Hoffnung weiterverbreitet, da sie ntzlich 
 *    sein wird, jedoch OHNE IRGENDEINE GARANTIE, auch ohne die implizierte 
 *    Garantie der MARKTREIFE oder der VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK. 
 *    Mehr Details finden Sie in der GNU Lesser General Public License.
 *	  see: http://www.gnu.org/copyleft/lesser.de.html	
 *    Sie sollten eine Kopie der GNU Lesser General Public License zusammen mit 
 *    dieser Bibliothek erhalten haben; falls nicht, schreiben Sie an die FSF,
 *    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 *  history:	
 *		1.) 30.07.2003 Version 2.00a
 *		2.) 10.11.2003 Version 2.02
 *			a.)	- add Timestamp-Request/Reply-Message
 *		3.) 27.01.2004 Version 2.03
 *			a.)	- add ICMP-Header structure, see "ICMP_HEADER_STRUCTURE"
 *		4.) 01.07.2004 Version 2.04
 *			a.)	- ICMP_DATA_SIZE now 56 Bytes
 *
 *****************************************************************************/
#ifndef _ICMP_INCLUDED_
#define _ICMP_INCLUDED_

#include "project.h"

#define ICMP_TYPE_CODE_OFS	IP_DATA_OFS + 0
#define ICMP_CHKSUM_OFS		IP_DATA_OFS + 2
#define ICMP_IDENT_OFS		IP_DATA_OFS + 4
#define ICMP_SEQ_OFS		IP_DATA_OFS + 6
#define ICMP_HEADER_SIZE	8

#ifndef ICMP_DATA_SIZE
#define ICMP_DATA_SIZE		56
#endif

#define ICMP_ECHO_DATA_OFS 				IP_DATA_OFS + 8

#define ICMP_TIMESTAMP_ORIGINATE_OFS	IP_DATA_OFS + 8
#define ICMP_TIMESTAMP_RECEIVE_OFS		IP_DATA_OFS + 12
#define ICMP_TIMESTAMP_TRANSMIT_OFS		IP_DATA_OFS + 16
#define ICMP_TIMESTAMP_SIZE				20

#define ICMP_ECHO_REPLY	 			0
#define ICMP_DEST_UNREACHABLE		3
#define ICMP_ECHO_REQUEST			8
#define ICMP_TIMESTAMP_REQUEST		13
#define ICMP_TIMESTAMP_REPLY		14

#define CLOCKS_PER_SEC	1000
//#warn "CLOCKS_PER_SEC"

typedef struct
{
   unsigned char type;
   unsigned char code;
   unsigned int checksum;
   unsigned int ident;          // only available with Ping
   unsigned int seq;
}
ICMP_HEADER_STRUCTURE;


#ifdef __CODEVISIONAVR__
#pragma used+
#endif
void icmp_prepare_echo_reply(unsigned char *ip_remote,
                             unsigned char *mac_remote,
                             unsigned int icmp_ident, unsigned int icmp_seq);
void icmp_prepare_echo_request(unsigned char *ip_remote,
                               unsigned char *mac_remote,
                               unsigned char pattern);
void icmp_prepare_timestamp_request(unsigned char *ip_remote,
                                    unsigned char *mac_remote,
                                    unsigned long time);
void icmp_process_frame(void);

#ifdef __CODEVISIONAVR__
#pragma used-

#ifdef ETW_LIBRARY_ENABLE
#pragma library icmp.lib
#endif
#endif
#endif
