
/*****************************************************************************
 *
 *                            "ip.h"
 *                   -----------------------------
 *
 *  Version:    2.06
 *  File:     	..\..\..\ip.h
 *  Created:    08.04.2003
 *  Date:       05.10.2004
 *  Author:     Copyright (C) 2001-2004
 *              Udo Jakobza - FTZ Leipzig; D-04107 Leipzig; Wchterstr. 13
 *              info@easytoweb.net
 *  Func: 		header-file for ip.c
 *  License:
 *    This library is free software; you can redistribute it and/or modify it
 *    under the terms of the GNU Lesser General Public License as published by
 *    the Free Software Foundation; either version 2.1 of the License, or
 *    (at your option) any later version. This library is distributed in the hope
 *    that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *    warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *    See the GNU Lesser General Public License for more details.
 *	  see: http://www.gnu.org/copyleft/lesser.html
 *    You should have received a copy of the GNU Lesser General Public License
 *    along with this library; if not, write to the Free Software Foundation,
 *    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *    Die Bibliothek ist freie Software; Sie drfen sie unter den Bedingungen der
 *    GNU Lesser General Public License, wie von der Free Software Foundation
 *    verffentlicht, weiterverteilen und/oder modifizieren; entweder gem
 *    Version 2.1 der Lizenz oder (nach Ihrer Option) jeder spteren Version.
 *    Diese Bibliothek wird in der Hoffnung weiterverbreitet, da sie ntzlich
 *    sein wird, jedoch OHNE IRGENDEINE GARANTIE, auch ohne die implizierte
 *    Garantie der MARKTREIFE oder der VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK.
 *    Mehr Details finden Sie in der GNU Lesser General Public License.
 *	  see: http://www.gnu.org/copyleft/lesser.de.html
 *    Sie sollten eine Kopie der GNU Lesser General Public License zusammen mit
 *    dieser Bibliothek erhalten haben; falls nicht, schreiben Sie an die FSF,
 *    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 *  History:
 *		1.) 30.07.2003 Version 2.00a
 *		2.) 02.02.2004 Version 2.03
 *			a.)	- new format for all IP-MACRO defaults
 *		3.) 05.02.2004 Version 2.03
 *			a.)	- define "IPSEC_OFFSET", see ipsec.h
 *
 *****************************************************************************/
#ifndef _IP_INCLUDED_
#define _IP_INCLUDED_

#include "project.h"

typedef union {
    unsigned long l_ip;
    unsigned char b_ip[4];
} IP_ADDR_TYPE;


#ifndef IP_REMOTE_DEFAULT
#define IP_REMOTE_DEFAULT		(172, 16, 50, 13)
#endif

#ifndef IP_DEFAULT
#define IP_DEFAULT				(172, 16, 50, 5)
#endif

#ifndef IP_SUBMASK_DEFAULT
#define IP_SUBMASK_DEFAULT		(255, 255, 255, 0)
#endif

#ifndef IP_GATEWAY_DEFAULT
#define IP_GATEWAY_DEFAULT		(172, 16, 50, 12)
#endif

#ifndef	IPSEC_ENABLE
#define	IPSEC_OFFSET	 		0
#define IPSEC_ADD_SIZE			0
#endif

#define IP_HEADER_START_OFS		ETH_DATA_OFS + IPSEC_OFFSET + 0
#define IP_VER_IHL_TOS_OFS		ETH_DATA_OFS + IPSEC_OFFSET + 0
#define IP_TOTAL_LENGTH_OFS		ETH_DATA_OFS + IPSEC_OFFSET + 2
#define IP_IDENT_OFS			ETH_DATA_OFS + IPSEC_OFFSET + 4
#define IP_FLAGS_FRAG_OFS		ETH_DATA_OFS + IPSEC_OFFSET + 6
#define IP_TTL_OFS				ETH_DATA_OFS + IPSEC_OFFSET + 8
#define IP_PROTOCOL_OFS			ETH_DATA_OFS + IPSEC_OFFSET + 9
#define IP_TTL_PROT_OFS			ETH_DATA_OFS + IPSEC_OFFSET + 8
#define IP_HEAD_CHKSUM_OFS		ETH_DATA_OFS + IPSEC_OFFSET + 10
#define IP_SOURCE_OFS			ETH_DATA_OFS + IPSEC_OFFSET + 12
#define IP_DESTINATION_OFS		ETH_DATA_OFS + IPSEC_OFFSET + 16
#define IP_DATA_OFS				ETH_DATA_OFS + IPSEC_OFFSET + 20
#define IP_HEADER_SIZE			20

#define IP_VER_IHL				0x4500
#define IP_TOS_MIN_DELAY		0x0010
#define IP_TOS_MAX_TROUGHPUT	0x0008
#define IP_TOS_MAX_RELIABILITY	0x0004
#define IP_TOS_MIN_COST			0x0002
#define IP_TOS_NORMAL			0x0000

#define IP_FLAG_DONTFRAG		0x4000
#define IP_FLAG_MOREFRAG		0x2000
#define IP_FRAGOFS_MASK			0x1FFF

#define IP_IP_PROT				4
#define IP_ICMP_PROT			1
#define IP_TCP_PROT     	    6
#define IP_UDP_PROT				17
#define IP_IPSEC_ESP_PROT		50
#define IP_IPSEC_AH_PROT		51

#define IP_FRAME				0x0800
#define IP_ADR_SIZE				sizeof(IP_ADDR_TYPE)

#define IP_DEFAULT_TTL			64

typedef struct
{
   unsigned char ver_ihl;
   unsigned char tos;
   unsigned int length;
   unsigned int ident;
   unsigned int flags_frag_offset;
   unsigned char ttl;
   unsigned char protocol;
   unsigned int checksum;
   unsigned char source[IP_ADR_SIZE];
   unsigned char destination[IP_ADR_SIZE];
}
IP_HEADER_STRUCTURE;


#ifdef __CODEVISIONAVR__
#pragma used+
#endif
extern IP_HEADER_STRUCTURE ip_header;
extern unsigned char ip_of_last_frame[IP_ADR_SIZE];

extern unsigned char ip_address[IP_ADR_SIZE];
extern unsigned char ip_subnet_mask[IP_ADR_SIZE];
extern unsigned char ip_gateway[IP_ADR_SIZE];

void ip_process_frame(unsigned char broadcast_flag);
unsigned int ip_checksum(void *data, unsigned int count,
                         unsigned char *tcp_ip_remote);
unsigned char ip_header_write(unsigned char *eth_data,
                              unsigned int *ip_length,
                              unsigned char *ip_offset,
                              unsigned char ip_protocol,
                              unsigned char *ip_source,
                              unsigned char *ip_destination);

#ifdef __CODEVISIONAVR__
#pragma used-

#ifdef ETW_LIBRARY_ENABLE
#pragma library ip.lib
#endif
#endif
#endif // #ifndef _IP_INCLUDED_
