
/*****************************************************************************
 *
 *                            "measure.h" 
 *                   -----------------------------
 *                                                                            
 *  Version:    2.00a
 *  File:     	...\projects\easyToWeb\...\measure.h    
 *  Created:    06.12.2002
 *  Date:       07.05.2003
 *  Author:     Copyright (C) 2001-2003 
 *              Udo Jakobza - FTZ Leipzig; D-04107 Leipzig; Wchterstr. 13
 *              info@easytoweb.net
 *  Func: 		Header file for measure.c
 *  license:	
 *    This library is free software; you can redistribute it and/or modify it 
 *    under the terms of the GNU Lesser General Public License as published by 
 *    the Free Software Foundation; either version 2.1 of the License, or 
 *    (at your option) any later version. This library is distributed in the hope 
 *    that it will be useful, but WITHOUT ANY WARRANTY; without even the implied 
 *    warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
 *    See the GNU Lesser General Public License for more details.
 *	  see: http://www.gnu.org/copyleft/lesser.html	
 *    You should have received a copy of the GNU Lesser General Public License 
 *    along with this library; if not, write to the Free Software Foundation, 
 *    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *	
 *    Bibliothek ist freie Software; Sie drfen sie unter den Bedingungen der 
 *    GNU Lesser General Public License, wie von der Free Software Foundation 
 *    verffentlicht, weiterverteilen und/oder modifizieren; entweder gem 
 *    Version 2.1 der Lizenz oder (nach Ihrer Option) jeder spteren Version. 
 *    Diese Bibliothek wird in der Hoffnung weiterverbreitet, da sie ntzlich 
 *    sein wird, jedoch OHNE IRGENDEINE GARANTIE, auch ohne die implizierte 
 *    Garantie der MARKTREIFE oder der VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK. 
 *    Mehr Details finden Sie in der GNU Lesser General Public License.
 *	  see: http://www.gnu.org/copyleft/lesser.de.html	
 *    Sie sollten eine Kopie der GNU Lesser General Public License zusammen mit 
 *    dieser Bibliothek erhalten haben; falls nicht, schreiben Sie an die FSF,
 *    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 *  history:	
 *		1.) 30.07.2003 Version 2.00a
 *			a.)	- 
 *
 *****************************************************************************/
#ifdef	WEB_DEBUG_MEASURE

#ifndef _MEASURE_INCLUDED_
#define _MEASURE_INCLUDED_

#include <avr/io.h>

#ifndef _MCU_CLOCK_FREQUENCY_
#define _MCU_CLOCK_FREQUENCY_ F_CPU
#endif

#define MEASURE_TIME (16000000UL/_MCU_CLOCK_FREQUENCY_)
/*
#if (_MCU_CLOCK_FREQUENCY_ == 16000000) || (F_CPU == 16000000)
#define	MEASURE_TIME	16
#endif

#if (_MCU_CLOCK_FREQUENCY_==8000000) || (F_CPU == 8000000)
#define	MEASURE_TIME	32
#endif

#if (_MCU_CLOCK_FREQUENCY_==7372800) || (F_CPU == 7372800)
#define	MEASURE_TIME	35
#endif
*/

#define MEA_BUFFER_FRAME1_S		0
#define MEA_BUFFER_FRAME1_E		1
#define MEA_BUFFER_FRAME2_S		2
#define MEA_BUFFER_FRAME2_E		3
#define MEA_UDP_CHECKSUM_S		4
#define MEA_UDP_CHECKSUM_E		5
#define MEA_ICMP_CHECKSUM_S1	6
#define MEA_ICMP_CHECKSUM_E1	7
#define MEA_ICMP_CHECKSUM_S2	8
#define MEA_ICMP_CHECKSUM_E2	9
#define MEA_TCP_CHECKSUM_S1		10
#define MEA_TCP_CHECKSUM_E1		11
#define MEA_TCP_CHECKSUM_S2		12
#define MEA_TCP_CHECKSUM_E2		13
#define MEA_TCP_DATA_S			14
#define MEA_TCP_DATA_E			15
#define MEA_TCP_FRAME_S			16
#define MEA_TCP_FRAME_E			17
#define MEA_ICMP_ECHO_S			18
#define MEA_ICMP_ECHO_E			19
#define MEA_ARP_ANSWER_S		20
#define MEA_ARP_ANSWER_E		21
#define MEA_ARP_REQUEST_S		22
#define MEA_ARP_REQUEST_E		23
#define MEA_TCP_S				24
#define MEA_TCP_E1				25
#define MEA_TCP_E2				26
#define MEA_TCP_E3				27
#define MEA_ETHERNET_S			28
#define MEA_ETHERNET_E			29
#define MEA_NET_S				30
#define MEA_NET_E				31
#define MEA_MAIN_S				32
#define MEA_MAIN_E				33

#define MEA_MAX_TIMES			34
#define MEA_MAX_TIME_FRAMES		4

#define MEASURE_SETTIME(x)     measure_pointer->time[x]=TCNT1; measure_pointer->over[x]=measure_timer1;

#ifdef __CODEVISIONAVR__
#pragma used+
#endif

typedef struct
{
   unsigned int time[MEA_MAX_TIMES];
   unsigned char over[MEA_MAX_TIMES];
}
MEASURE_FRAME;

typedef MEASURE_FRAME *p_MEASURE_FRAME;

extern unsigned char measure_timer1;
extern unsigned char measure_flag;
extern MEASURE_FRAME measure_buffer[MEA_MAX_TIME_FRAMES];
extern p_MEASURE_FRAME measure_pointer;

void measure_init(void);
void measure_time(void);
void measure_switch_time_frame(void);
void measure_diplay(void);

#ifdef __CODEVISIONAVR__
#pragma used-

#ifdef ETW_LIBRARY_ENABLE
#pragma library measure.lib
#endif
#endif
#endif
#endif
