
/*****************************************************************************
 *
 *                          "ppp.h" 
 *                   -----------------------------
 *                                                                            
 *  Version:    2.10
 *  File:     	..\..\ppp.h    
 *  Created:    12.05.2003
 *  Date:       25.08.2005
 *  Author:     Copyright (C) 2001-2005
 *              Wofgang Lutsch, Udo Jakobza
 *              FTZ Leipzig; D-04107 Leipzig; Wchterstr. 13
 *              info@easytoweb.net
 *  Func: 		header-file for ppp.c
 *  license:	
 *    This library is free software; you can redistribute it and/or modify it 
 *    under the terms of the GNU Lesser General Public License as published by 
 *    the Free Software Foundation; either version 2.1 of the License, or 
 *    (at your option) any later version. This library is distributed in the hope 
 *    that it will be useful, but WITHOUT ANY WARRANTY; without even the implied 
 *    warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
 *    See the GNU Lesser General Public License for more details.
 *	  see: http://www.gnu.org/copyleft/lesser.html	
 *    You should have received a copy of the GNU Lesser General Public License 
 *    along with this library; if not, write to the Free Software Foundation, 
 *    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *	
 *    Die Bibliothek ist freie Software; Sie drfen sie unter den Bedingungen der 
 *    GNU Lesser General Public License, wie von der Free Software Foundation 
 *    verffentlicht, weiterverteilen und/oder modifizieren; entweder gem 
 *    Version 2.1 der Lizenz oder (nach Ihrer Option) jeder spteren Version. 
 *    Diese Bibliothek wird in der Hoffnung weiterverbreitet, da sie ntzlich 
 *    sein wird, jedoch OHNE IRGENDEINE GARANTIE, auch ohne die implizierte 
 *    Garantie der MARKTREIFE oder der VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK. 
 *    Mehr Details finden Sie in der GNU Lesser General Public License.
 *	  see: http://www.gnu.org/copyleft/lesser.de.html	
 *    Sie sollten eine Kopie der GNU Lesser General Public License zusammen mit 
 *    dieser Bibliothek erhalten haben; falls nicht, schreiben Sie an die FSF,
 *    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 *  history:	
 *		1.) 30.07.2003 Version 2.00a
 *			a.)	- 
 *
 *****************************************************************************/
#ifndef _PPP_INCLUDED_
#define _PPP_INCLUDED_

#define PPP_SERVER 			1
#define PPP_CLIENT 			2

#ifndef PPP_SERVER_CLIENT_MODE
#define PPP_SERVER_CLIENT_MODE	PPP_SERVER
#endif

#ifndef PPP_MRU
#define PPP_MRU					512
#endif
#ifndef PPP_MTU
#define PPP_MTU					512
#endif
#define PPP_HDLC_HEADER			4
#define PPP_HDLC_TRAILER		2

#define PPP_RX_BUFFER_START		((unsigned char*)ppp_rx_buffer)
#define PPP_RX_BUFFER_END		((unsigned char*)ppp_rx_buffer+PPP_HDLC_HEADER+PPP_MRU+PPP_HDLC_TRAILER)
#define PPP_TX_BUFFER_START		((unsigned char*)ppp_tx_buffer)

#define PPP_MAX_DATA_PACKETS	3
typedef struct
{
   unsigned char *addr;
   unsigned int size;
}
PPP_BUFFER_TABLE;

#define PPP_ADDRESS_OFS						0
#define PPP_CONTROL_OFS						1
#define PPP_PROTOCOL_OFS					0
#define PPP_CODE_OFS						2
#define PPP_ID_OFS							3
#define PPP_LENGTH_OFS						4
#define PPP_OPTIONS_OFS						6
#define PPP_FLAG_SEQUENZE					0x7e
#define PPP_CONTROL_ESCAPE					0x7d
#define PPP_ADDRESS					   		0xff
#define PPP_CONTROL							0x03
#define PPP_CE_BIT							0x20

#define PPP_CONFIGURE_REQUEST				1
#define PPP_CONFIGURE_ACK					2
#define PPP_CONFIGURE_NAK					3
#define PPP_CONFIGURE_REJECT				4
#define PPP_TERMINATE_REQUEST				5
#define PPP_TERMINATE_ACK					6
#define PPP_CODE_REJECT						7
#define PPP_PROTOCOL_REJECT					8
#define PPP_ECHO_REQUEST					9
#define PPP_ECHO_REPLY						10
#define PPP_DISCARD_REQUEST					11

#define LCP_MAX_RECEIVE_UNIT				1
#define LCP_ACCM							2
#define LCP_AUTHENTICATION_TYPE				3
#define LCP_QUALITY_PROTOCOL				4
#define LCP_MAGIC_NUMBER					5
#define LCP_LINK_QUALITY_MONITORING			6
#define LCP_PROTOCOL_FIELD_COMP				7
#define LCP_ADR_CTL_FIELD_COMP				8

#define LCP_MAX_RECEIVE_UNIT_LEN			4
#define LCP_ACCM_LEN						6
#define LCP_AUTHENTICATION_TYPE_LEN	   		4
#define LCP_QUALITY_PROTOCOL_LEN			4
#define LCP_MAGIC_NUMBER_LEN				6
#define LCP_LINK_QUALITY_MONITORING_LEN		6
#define LCP_PROTOCOL_FIELD_COMP_LEN			2
#define LCP_ADR_CTL_FIELD_COMP_LEN			2

#define LCP_OPTIONS_DATA_OFS				2

#define IPCP_IP_ADR      			   		3
#define IPCP_GATEWAY_81    			   		0x81
#define IPCP_GATEWAY_82    			   		0x82
#define IPCP_GATEWAY_83   			   		0x83
#define IPCP_GATEWAY_84    			   		0x84

#define IPCP_IP_ADR_LEN		      	   		6

#define IPCP_OPTIONS_DATA_OFS				2

#define PPP_STATUS_UP						0x01
#define PPP_STATUS_RX_DATA			   		0x02

#define PPP_RX_FLAG_FAIL					0x0001
#define PPP_RX_FLAG_MRU						0x0002
#define PPP_RX_FLAG_ACCM					0x0004
#define PPP_RX_FLAG_AUTH	            	0x0008
#define PPP_RX_FLAG_PFC						0x0010
#define PPP_RX_FLAG_ACFC					0x0020
#define PPP_RX_FLAG_GATEWAY81				0x0040
#define PPP_RX_FLAG_GATEWAY82				0x0080
#define PPP_RX_FLAG_GATEWAY83				0x0100
#define PPP_RX_FLAG_GATEWAY84				0x0200

typedef enum
{
   PPP_STATE_INITIAL,
   PPP_STATE_STARTING,
   PPP_STATE_CLOSED,
   PPP_STATE_STOPPED,
   PPP_STATE_CLOSING,
   PPP_STATE_STOPPING,
   PPP_STATE_REQUEST_SENT,
   PPP_STATE_ACK_RECEIVED,
   PPP_STATE_ACK_SENT,
   PPP_STATE_OPENED,
   PPP_STATE_UNREACHED
}
PPP_STATE_LCP_IPCP;

typedef enum
{
   PPP_EVENT_UP,
   PPP_EVENT_DOWN,
   PPP_EVENT_OPEN,
   PPP_EVENT_CLOSE,
   PPP_EVENT_TO,
   PPP_EVENT_TO_EX,
   PPP_EVENT_RCR,
   PPP_EVENT_RCR_BAD,
   PPP_EVENT_RCA,
   PPP_EVENT_RCN,
   PPP_EVENT_RTR,
   PPP_EVENT_RTA,
   PPP_EVENT_RUC,
   PPP_EVENT_RXJ,
   PPP_EVENT_RXJ_CAT,
   PPP_EVENT_RXR,
   PPP_EVENT_NONE,
   PPP_EVENT_UNREACHED
}
PPP_EVENT_TYPE;

typedef enum
{
   PPP_PROTOCOL_LCP,
   PPP_PROTOCOL_PAP,
   PPP_PROTOCOL_IPCP,
   PPP_PROTOCOL_IP,
   PPP_PROTOCOL_UNKNOWN
}
PPP_PROTOCOL_TYPE;


typedef enum
{
   PPP_PHASE_DEAD,
   PPP_PHASE_ESTABLISH,
   PPP_PHASE_AUTHENTICATE,
   PPP_PHASE_NETWORK,
   PPP_PHASE_TERMINATE,
   PPP_PHASE_UNREACHED
}
PPP_PHASE;


#define PPP_INIT_FCS16	0xffff
#define PPP_GOOD_FCS16	0xf0b8


#ifdef __CODEVISIONAVR__
#pragma used+
#endif

extern PPP_EVENT_TYPE ppp_event;
extern unsigned char ppp_behaviour;
#ifdef WEB_DEBUG_PPP
extern PGM_P ppp_event_name[18] PROGMEM;
#endif

void ppp_main(void);
extern void ppp_init(void);

unsigned char ppp_init_interface(void);
unsigned char ppp_interface_available(void);
unsigned char ppp_data_available(void);
void ppp_data_clear(void);
void ppp_receive_data(unsigned char data);

unsigned int ppp_ready(void);
unsigned char ppp_write_ready(unsigned int count);
unsigned char ppp_write_data(unsigned char *data, unsigned int count);
unsigned int ppp_read_frame_16bit(void);
unsigned int ppp_read_frame_16bit_le(void);
void ppp_read_frame_dummy(unsigned int size);
void ppp_read_frame(void *dest, unsigned int size);

#ifdef __CODEVISIONAVR__
#pragma used-

#ifdef ETW_LIBRARY_ENABLE
#pragma library ppp.lib
#endif
#endif
#endif
