
/*****************************************************************************
 *
 *                            "tcp.h" 
 *                   -----------------------------
 *                                                                            
 *  Version:    2.06
 *  File:     	..\..\tcp.h    
 *  Created:    08.04.2003
 *  Date:       22.03.2005
 *  Author:     Copyright (C) 2001-2005
 *              Udo Jakobza - FTZ Leipzig; D-04107 Leipzig; Wchterstr. 13
 *              info@easytoweb.net
 *  Func: 		header-file for tcp.c
 *  License:	
 *    This library is free software; you can redistribute it and/or modify it 
 *    under the terms of the GNU Lesser General Public License as published by 
 *    the Free Software Foundation; either version 2.1 of the License, or 
 *    (at your option) any later version. This library is distributed in the hope 
 *    that it will be useful, but WITHOUT ANY WARRANTY; without even the implied 
 *    warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
 *    See the GNU Lesser General Public License for more details.
 *	  see: http://www.gnu.org/copyleft/lesser.html	
 *    You should have received a copy of the GNU Lesser General Public License 
 *    along with this library; if not, write to the Free Software Foundation, 
 *    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *	
 *    Die Bibliothek ist freie Software; Sie drfen sie unter den Bedingungen der 
 *    GNU Lesser General Public License, wie von der Free Software Foundation 
 *    verffentlicht, weiterverteilen und/oder modifizieren; entweder gem 
 *    Version 2.1 der Lizenz oder (nach Ihrer Option) jeder spteren Version. 
 *    Diese Bibliothek wird in der Hoffnung weiterverbreitet, da sie ntzlich 
 *    sein wird, jedoch OHNE IRGENDEINE GARANTIE, auch ohne die implizierte 
 *    Garantie der MARKTREIFE oder der VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK. 
 *    Mehr Details finden Sie in der GNU Lesser General Public License.
 *	  see: http://www.gnu.org/copyleft/lesser.de.html	
 *    Sie sollten eine Kopie der GNU Lesser General Public License zusammen mit 
 *    dieser Bibliothek erhalten haben; falls nicht, schreiben Sie an die FSF,
 *    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 *  history:	
 *		1.) 08.08.2003 Version 2.00
 *		2.) 13.08.2003 Version 2.01
 *			a.)	- start of implementation of FTP-Server
 *		3.) 12.11.2003 Version 2.02
 *			a.)	- set macro "TCP_MAX_CONNECTIONS" to 1
 *		4.) 08.01.2004 Version 2.03
 *			a.)	- macros "TCP_RETRY_TIMEOUT", "TCP_FIN_TIMEOUT" and "TCP_MAX_RETRYS" are
 *                now free macros, see project.h;
 *			b.)	- set "TCP_RETRY_TIMEOUT" to shorter time from 2sec to 1sec;
 *			c.)	- set "TCP_FIN_TIMEOUT" to shorter time 0,5sec to 0,25sec;
 *		5.) 27.01.2004 Version 2.03
 *			a.)	- add TCP-Header structure, see "TCP_HEADER_STRUCTURE"
 *
 *****************************************************************************/
#ifndef _TCP_INCLUDED_
#define _TCP_INCLUDED_

#include "project.h"

#include <avr/pgmspace.h>

#include ETHERNET_H_FILEPATH
#include IP_H_FILEPATH
#ifdef IPSEC_ENABLE
#include IPSEC_H_FILEPATH
#endif

#define SOCK_PASSIV_OPEN				0x00
#define SOCK_ACTIV_OPEN					0x01
#define SOCK_READY_CONNECT				0x02
#define SOCK_CONNECTED					0x04
#define SOCK_DISCONNECTING				0x08
#define SOCK_DISCONNECTED				0x10
#define SOCK_DATA_AVAILABLE				0x20

#define SOCK_ERR_OK						0x00
#define SOCK_ERR_ARP_TIMEOUT			0x01
#define SOCK_ERR_TCP_TIMEOUT			0x02
#define SOCK_ERR_CONN_RESET				0x04
#define SOCK_ERR_REMOTE					0x08
#define SOCK_ERR_TCP_SEQ				0x10
#define SOCK_ERR_TCP_ACK				0x20
#define SOCK_ERR_TCP					0x40

#ifndef TCP_RETRY_TIMEOUT
#define TCP_RETRY_TIMEOUT		10
#endif
#if(TCP_RETRY_TIMEOUT<1)
#error ERROR: "TCP_RETRY_TIMEOUT" too small: TCP_RETRY_TIMEOUT!!!
#endif

#ifndef TCP_FIN_TIMEOUT
#define TCP_FIN_TIMEOUT			15
#endif
#if(TCP_FIN_TIMEOUT<1)
#error ERROR: "TCP_FIN_TIMEOUT" too small: TCP_FIN_TIMEOUT!!!
#endif

#if(TCP_FIN_TIMEOUT<TCP_RETRY_TIMEOUT)
#error ERROR: "TCP_FIN_TIMEOUT" must bigger as "TCP_RETRY_TIMEOUT"!!!
#endif

#ifndef TCP_MAX_RETRYS
#define TCP_MAX_RETRYS			4
#endif

#ifndef TCP_ADD_PSH_FLAG
#define TCP_ADD_PSH_FLAG
#endif

#define TCP_SRCPORT_OFS			IP_DATA_OFS + 0
#define TCP_DESTPORT_OFS		IP_DATA_OFS + 2
#define TCP_SEQNR_OFS			IP_DATA_OFS + 4
#define TCP_ACKNR_OFS			IP_DATA_OFS + 8
#define TCP_DATA_CODE_OFS		IP_DATA_OFS + 12
#define TCP_WINDOW_OFS			IP_DATA_OFS + 14
#define TCP_CHKSUM_OFS			IP_DATA_OFS + 16
#define TCP_URGENT_OFS			IP_DATA_OFS + 18
#define TCP_DATA_OFS			IP_DATA_OFS + 20
#define TCP_HEADER_SIZE			20
#define TCP_ALL_HEADER_SIZE		(ETH_HEADER_SIZE+IP_HEADER_SIZE+IPSEC_ADD_SIZE+TCP_HEADER_SIZE)

#define DATA_OFS_MASK			0xF000
#define TCP_CODE_FIN			0x0001
#define TCP_CODE_SYN			0x0002
#define TCP_CODE_RST			0x0004
#define TCP_CODE_PSH			0x0008
#define TCP_CODE_ACK			0x0010
#define TCP_CODE_URG			0x0020
#ifdef TCP_ALIVE_ACTIV_ENABLE
#define TCP_CODE_ACK_ALIVE		0x0810
#endif

#define TCP_OPT_MSS				0x0204
#define TCP_OPT_MSS_SIZE		4

#define TCP_PORT_ECHO			7
#define TCP_PORT_DISCARD		9
#define TCP_PORT_DAYTIME		13
#define TCP_PORT_QOTD			17
#define TCP_PORT_CHARGEN		19
#ifndef TCP_PORT_FTP_DATA
#define TCP_PORT_FTP_DATA		20
#endif
#ifndef TCP_PORT_FTP_COMMAND
#define TCP_PORT_FTP_COMMAND	21
#endif
#define TCP_PORT_SSH			22
#define TCP_PORT_TELNET			23
#define TCP_PORT_HTTP			80

#define TCP_FLAG_OPEN 					0x01
#define TCP_FLAG_PASSIV					0x02
#define TCP_FLAG_ACTIVE		 			0x04
#define TCP_FLAG_IP_ADDR_RESOLVED		0x08
#define TCP_FLAG_CLOSE_REQUESTED		0x10
#define TCP_FLAG_ABORT					0x20
#define TCP_FLAG_TIMER_RUNNING			0x40
#define TCP_FLAG_TIMER_CTRL_RETRANSMIT	0x80

#define TCP_FLAG_RESET_MASK		 		(TCP_FLAG_PASSIV | TCP_FLAG_ACTIVE)

#ifndef TCP_TX_BUFFER_SIZE
#define TCP_TX_BUFFER_SIZE			128
#endif

#ifndef TCP_TX_SEGMENT_SIZE
#define TCP_TX_SEGMENT_SIZE			128
#endif

#if(TCP_TX_BUFFER_SIZE<TCP_TX_SEGMENT_SIZE)
#error ERROR: "TCP_TX_BUFFER_SIZE" to small: needs TCP_TX_SEGMENT_SIZE!!!
#endif

#if((TCP_TX_BUFFER_SIZE%TCP_TX_SEGMENT_SIZE)!=0)
#define TCP_TX_BUFFER_COUNT			((TCP_TX_BUFFER_SIZE/TCP_TX_SEGMENT_SIZE)+1)
#else
#define TCP_TX_BUFFER_COUNT			(TCP_TX_BUFFER_SIZE/TCP_TX_SEGMENT_SIZE)
#endif

#define TCP_TX_BUFFER_AGE_OVER		32

#if(TCP_TX_BUFFER_COUNT>(TCP_TX_BUFFER_AGE_OVER-1))
#error ERROR: "TCP_TX_BUFFER_COUNT" to big: TCP_TX_BUFFER_COUNT!!!
#endif

#if(TCP_TX_BUFFER_COUNT<1)
#error ERROR: "TCP_TX_BUFFER_COUNT" to small: TCP_TX_BUFFER_COUNT!!!
#endif

#define TCP_TX_BUFFER_UNDEF			0xFF


#ifndef TCP_TX_DELAY_COUNT
#define TCP_TX_DELAY_COUNT			3
#endif

#if(TCP_TX_DELAY_COUNT>255)
#error ERROR: "TCP_TX_DELAY_COUNT" to big: use max. 255 !!!
#endif

#ifndef TCP_RX_BUFFER_SIZE
#define TCP_RX_BUFFER_SIZE			256
#endif
#ifndef TCP_RX_SEGMENT_SIZE
#define TCP_RX_SEGMENT_SIZE			128
#endif

#if(TCP_RX_BUFFER_SIZE<(TCP_RX_SEGMENT_SIZE*2))
#error ERROR: "TCP_RX_BUFFER_SIZE" to small: needs "TCP_RX_SEGMENT_SIZE"*2 !!!
#endif

#ifndef TCP_MAX_WINDOW_SIZE
#define TCP_MAX_WINDOW_SIZE 		TCP_RX_SEGMENT_SIZE
#endif

#if(TCP_MAX_WINDOW_SIZE>TCP_RX_BUFFER_SIZE)
#error ERROR: "TCP_MAX_WINDOW_SIZE" to big: use max. TCP_RX_BUFFER_SIZE !!!
#endif

#ifndef TCP_MAX_CONNECTIONS
#define TCP_MAX_CONNECTIONS			1
#endif

#if(TCP_MAX_CONNECTIONS>254)
#error ERROR: "TCP_MAX_CONNECTIONS" too big: TCP_MAX_CONNECTIONS!!!
#endif

#define TCP_WRONG_CONNECTIONS		0xFF

#define TCP_ALIVE_FLAG_ENABLE		0x01
#define TCP_ALIVE_FLAG_OPEN			0x02

#define TCP_ALIVE_MIN_TIME			5
#ifndef TCP_ALIVE_ACK_RETRYS
#define TCP_ALIVE_ACK_RETRYS		4
#else
#if(TCP_ALIVE_ACK_RETRYS<1)
#error ERROR: "TCP_ALIVE_ACK_RETRYS" too small: TCP_ALIVE_ACK_RETRYS!!!
#endif
#endif
#define TCP_ALIVE_TIMEOUT_FACTOR	(TCP_ALIVE_ACK_RETRYS+1)
#define TCP_ALIVE_MAX_TIME			(0xFFFF/TCP_ALIVE_TIMEOUT_FACTOR)
#ifndef TCP_ALIVE_DEFAULT_TIME
#define TCP_ALIVE_DEFAULT_TIME		40
#endif

#define TCP_TX_FLAG_FREE			0x01
#define TCP_TX_FLAG_HALF_FULL		0x02
#define TCP_TX_FLAG_FULL			0x04
#define TCP_TX_FLAG_SENT			0x08
#define TCP_TX_FLAG_RETRANSMIT		0x10

typedef struct
{
   unsigned int src;
   unsigned int dest;
   unsigned long seq;
   unsigned long ack;
   unsigned int offset_flags;
   unsigned int window;
   unsigned int checksum;
   unsigned int urgent;
}
TCP_HEADER_STRUCTURE;

typedef enum
{
   CLOSED,
   LISTEN,
   SYN_SENT,
   SYN_RCVD,
   ESTABLISHED,
   FIN_WAIT_1,
   FIN_WAIT_2,
   CLOSE_WAIT,
   CLOSING,
   LAST_ACK,
   TIME_WAIT,
   TCP_UNREACHED
}
TCP_STATE_MACHINE;

typedef enum
{
   TCP_NONE,
   TCP_ARP_REQUEST,
   TCP_SYN_FRAME,
   TCP_SYN_ACK_FRAME,
   TCP_FIN_FRAME
}
TCP_LAST_FRAME_SENT;


typedef struct
{
   unsigned char flags;
   unsigned char age;
   unsigned long unack;
   unsigned long next;
   unsigned char timer;
   unsigned char retry_counter;
   unsigned int data_count;     // count of TCP-data bytes to send
   unsigned char *data_position;
   unsigned char data_frame[TCP_ALL_HEADER_SIZE + TCP_TX_SEGMENT_SIZE + 4];
}
TCP_TX_BUFFER_STRUCTURE;


typedef struct
{
   unsigned int gap;
   unsigned int rtop;
   unsigned int wtop;
   unsigned char data_frame[TCP_RX_BUFFER_SIZE + 1];
}
TCP_RX_BUFFER_STRUCTURE;

typedef struct
{
   unsigned char tcp_socket_status;
   unsigned char tcp_socket_error;
   unsigned int tcp_port_local;
   unsigned int tcp_port_remote;
   unsigned char tcp_ip_remote[IP_ADR_SIZE];
   unsigned char tcp_mac_remote[6];
   unsigned char tcp_flags;
   TCP_STATE_MACHINE tcp_state_machine;
   // -------------------------------------------------------------------------------- 
   // 
   TCP_LAST_FRAME_SENT tcp_last_frame_sent;     // Ctrl-retransmission type
   unsigned long tcp_sequence_next;
   unsigned long tcp_sequence_ack;
   unsigned long tcp_sequence_unack;
   unsigned int tcp_window_remote;
   unsigned int tcp_window_local;
   unsigned char tcp_timer;
   unsigned char tcp_retry_counter;
   unsigned char tcp_tx_ctrl_frame[TCP_ALL_HEADER_SIZE + TCP_OPT_MSS_SIZE +
                                   4];
   // TX and RX
   // -------------------------------------------------------------------------------- 
   // 
   TCP_TX_BUFFER_STRUCTURE tcp_tx[TCP_TX_BUFFER_COUNT];
   TCP_RX_BUFFER_STRUCTURE tcp_rx;
   // Alive
   // -------------------------------------------------------------------------------- 
   // 
#ifdef TCP_ALIVE_ACTIV_ENABLE
   unsigned char tcp_alive_flag;
   unsigned int tcp_alive_time;
   unsigned char tcp_alive_50ms_bit;
   unsigned int tcp_alive_delay;
   unsigned int tcp_alive_timeout_delay;
#endif
   // Debug
   // -------------------------------------------------------------------------------- 
   // 
#ifdef WEB_DEBUG_TCP
   TCP_STATE_MACHINE last_tcp_state_machine;
   unsigned char last_tcp_socket_error;
   unsigned long tcp_iss_number;
   unsigned long tcp_irs_number;
   unsigned long tcp_rx_ok_data;
   unsigned long tcp_rx_wrong_data;
   unsigned long tcp_rx_lost_data;
   unsigned long tcp_tx_ok_data;
   unsigned long tcp_tx_repeat_data;
#endif
}
TCP_STRUCTURE;


typedef enum
{
   TCP_DATA_FRAME_1ST_SEND,
   TCP_DATA_FRAME_RETRANSMIT
}
TCP_DATA_FRAME_MODE;

typedef enum
{
   TCP_RX_BUFFER_GET_SIZE,
   TCP_RX_BUFFER_READ_DATA,
   TCP_RX_BUFFER_SET_DATA
}
TCP_RX_BUFFER_READ_MODE;

typedef enum
{
   TCP_TX_BUFFER_GET_SIZE,
   TCP_TX_BUFFER_WRITE_RAM_DATA,
   TCP_TX_BUFFER_WRITE_FLASH_DATA,
   TCP_TX_BUFFER_SET_DATA
}
TCP_TX_BUFFER_WRITE_MODE;


typedef enum
{
   TCP_GENERATE_ISN_1ST,
   TCP_GENERATE_ISN_RETRANSMIT
}
TCP_GENERATE_ISN_MODE;

#ifdef __CODEVISIONAVR__
#pragma used+
#endif

#if defined(WEB_DEBUG_TCP)||defined(WEB_DEBUG_TCP_OFFLINE)
#ifdef __CODEVISIONAVR__
extern char flash *tcp_state_name[];
extern char flash *tcp_retransmit_name[5];
#else
extern PGM_P tcp_state_name[] PROGMEM;
extern PGM_P tcp_retransmit_name[5] PROGMEM;
#endif
#endif

#ifdef WEB_DEBUG_TCP_OFFLINE
extern TCP_STRUCTURE tcp_struct[TCP_MAX_CONNECTIONS];
extern unsigned int tcp_isn_high_number;
#endif

void tcp_main(void);
void tcp_process_frame(void);
void tcp_arp_resolved(unsigned char *new_mac);
void tcp_clock_handler(void);

void tcp_init(void);
void tcp_init_connection(unsigned char tcp_connection);
TCP_STRUCTURE *tcp_get_struct(unsigned char tcp_connection);
void tcp_passive_reopen(unsigned char tcp_connection);
unsigned char tcp_passive_open(unsigned int tcp_local_port);
unsigned char tcp_active_open(unsigned char *dest_ip_address,
                              unsigned int dest_port,
                              unsigned int source_port);
void tcp_close(unsigned char tcp_connection);
void tcp_abort(unsigned char tcp_connection);
void tcp_rx_buffer_clear(unsigned char tcp_connection);
unsigned char *tcp_rx_buffer_read(unsigned char tcp_connection,
                                  unsigned char *data_dest,
                                  unsigned int *tcp_data_count,
                                  TCP_RX_BUFFER_READ_MODE read_mode);
unsigned char tcp_get_error(unsigned char tcp_connection);

#ifdef TCP_ALIVE_ACTIV_ENABLE
void tcp_alive_set_time(unsigned char tcp_connection,
                        unsigned int alive_time);
void tcp_alive_enable(unsigned char tcp_connection);
void tcp_alive_disable(unsigned char tcp_connection);
#endif
unsigned int tcp_tx_buffer_write(unsigned char tcp_connection,
                                 unsigned char *ram_data,
                                 unsigned int datalen,
                                 TCP_TX_BUFFER_WRITE_MODE write_mode);
#ifdef __CODEVISIONAVR__
unsigned int tcp_tx_buffer_write_f(unsigned char tcp_connection,
                                   flash unsigned char *flash_data,
                                   unsigned int datalen,
                                   TCP_TX_BUFFER_WRITE_MODE write_mode);
#else
unsigned int tcp_tx_buffer_write_f(unsigned char tcp_connection,
                                   PGM_P flash_data,
                                   unsigned int datalen,
                                   TCP_TX_BUFFER_WRITE_MODE write_mode);
#endif


#ifdef __CODEVISIONAVR__
#pragma used-

#ifdef ETW_LIBRARY_ENABLE
#pragma library tcp.lib
#endif
#endif
#endif
