
/*****************************************************************************
 *
 *                             "udp.h" 
 *                   -----------------------------
 *                                                                            
 *  Version:    2.06
 *  File:     	..\..\udp.h    
 *  Created:    31.08.2001
 *  Date:       25.01.2005
 *  Author:     Copyright (C) 2001-2005
 *              Udo Jakobza - FTZ Leipzig; D-04107 Leipzig; Wchterstr. 13
 *              info@easytoweb.net
 *  Func: 		Header file for udp.c
 *  License:	
 *    This library is free software; you can redistribute it and/or modify it 
 *    under the terms of the GNU Lesser General Public License as published by 
 *    the Free Software Foundation; either version 2.1 of the License, or 
 *    (at your option) any later version. This library is distributed in the hope 
 *    that it will be useful, but WITHOUT ANY WARRANTY; without even the implied 
 *    warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
 *    See the GNU Lesser General Public License for more details.
 *	  see: http://www.gnu.org/copyleft/lesser.html	
 *    You should have received a copy of the GNU Lesser General Public License 
 *    along with this library; if not, write to the Free Software Foundation, 
 *    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *	
 *    Die Bibliothek ist freie Software; Sie drfen sie unter den Bedingungen der 
 *    GNU Lesser General Public License, wie von der Free Software Foundation 
 *    verffentlicht, weiterverteilen und/oder modifizieren; entweder gem 
 *    Version 2.1 der Lizenz oder (nach Ihrer Option) jeder spteren Version. 
 *    Diese Bibliothek wird in der Hoffnung weiterverbreitet, da sie ntzlich 
 *    sein wird, jedoch OHNE IRGENDEINE GARANTIE, auch ohne die implizierte 
 *    Garantie der MARKTREIFE oder der VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK. 
 *    Mehr Details finden Sie in der GNU Lesser General Public License.
 *	  see: http://www.gnu.org/copyleft/lesser.de.html	
 *    Sie sollten eine Kopie der GNU Lesser General Public License zusammen mit 
 *    dieser Bibliothek erhalten haben; falls nicht, schreiben Sie an die FSF,
 *    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 *  history:	
 *		1.) 30.07.2003 Version 2.00a
 *		2.) 27.01.2004 Version 2.03
 *			a.)	- add UDP-Header structure, see "UDP_HEADER_STRUCTURE"
 *		3.) 14.06.2004 Version 2.04
 *			a.)	- supports now multiple connections, see "UDP_STRUCTURE"
 *
 *****************************************************************************/
#ifndef _UDP_INCLUDED_
#define _UDP_INCLUDED_

#include "project.h"            // USER defines
#include IP_H_FILEPATH
#include ETHERNET_H_FILEPATH
#ifdef IPSEC_ENABLE
#include IPSEC_H_FILEPATH
#endif

#define UDP_PORT_BOOTP_SERVER		67
#define UDP_PORT_BOOTP_CLIENT		68

#define UDP_SRCPORT_OFS				IP_DATA_OFS + 0
#define UDP_DESTPORT_OFS			IP_DATA_OFS + 2
#define UDP_LEN_OFS					IP_DATA_OFS + 4
#define UDP_CHKSUM_OFS				IP_DATA_OFS + 6
#define UDP_DATA_OFS				IP_DATA_OFS + 8
#define UDP_HEADER_SIZE				8
#define UDP_ALL_HEADER_SIZE			(ETH_HEADER_SIZE+IP_HEADER_SIZE+IPSEC_ADD_SIZE+UDP_HEADER_SIZE)

#ifndef UDP_TX_DATA_SIZE
#define	UDP_TX_DATA_SIZE	  		50
#endif

#ifndef UDP_RX_DATA_SIZE
#define	UDP_RX_DATA_SIZE			50
#endif

#ifndef UDP_MAX_CONNECTIONS
#define UDP_MAX_CONNECTIONS			1
#endif

#if(UDP_MAX_CONNECTIONS==0)
#error ERROR: UDP no "UDP_MAX_CONNECTIONS" !!!
#endif

#define UDP_WRONG_CONNECTIONS		0xFF

#define UDP_FLAG_OPEN 				0x01
#define UDP_FLAG_PASSIV				0x02
#define UDP_FLAG_ACTIVE		 		0x04
#define UDP_FLAG_BIND				0x08
#define UDP_DATA_AVAILABLE			0x10
#define UDP_TX_BUF_FREE				0x20
#define UDP_TX_BUF_HALF_FULL		0x40
#define UDP_TX_BUF_FULL				0x80


typedef struct
{
   unsigned int port_src;
   unsigned int port_dest;      // destination port number
   unsigned int length;
   unsigned int checksum;
}
UDP_HEADER_STRUCTURE;

typedef struct
{
   unsigned char udp_flags;
   unsigned int udp_port_local;
   unsigned int udp_port_remote;
   unsigned char udp_ip_remote[IP_ADR_SIZE];
   unsigned char udp_mac_remote[6];
   unsigned int udp_tx_data_count;
   unsigned int udp_tx_all_count;
   unsigned char udp_tx_frame[UDP_ALL_HEADER_SIZE + UDP_TX_DATA_SIZE];
   unsigned char *udp_tx_data_position;
   unsigned int udp_rx_data_count;
   unsigned char udp_rx_frame[UDP_RX_DATA_SIZE];
}
UDP_STRUCTURE;

#ifdef __CODEVISIONAVR__
#pragma used+
#endif

void udp_init(void);
UDP_STRUCTURE *udp_get_struct(unsigned char udp_connection);
unsigned char udp_open(unsigned int udp_local_port,
                       unsigned char *dest_mac_address,
                       unsigned char *dest_ip_address, unsigned int dest_port,
                       unsigned char udp_flag);
void udp_close(unsigned char udp_connection);
unsigned int udp_tx_buffer_prepare(unsigned char udp_connection,
                                   unsigned char *data, unsigned int datalen);
void udp_rx_buffer_release(unsigned char udp_connection);
void udp_main(void);
unsigned char udp_bind(unsigned char udp_connection,
                       unsigned char *dest_mac_address,
                       unsigned char *dest_ip_address);
void udp_unbind(unsigned char udp_connection);
void udp_process_frame(void);

#ifdef WEB_DEBUG_UDP
void udp_info(unsigned int port_number);
#endif

#ifdef __CODEVISIONAVR__
#pragma used-

#ifdef ETW_LIBRARY_ENABLE
#pragma library udp.lib
#endif
#endif
#endif
