
/*****************************************************************************
 *
 *                          "web_debug.h" 
 *                   -----------------------------
 *                                                                            
 *  Version:    2.04
 *  File:     	..\..\..\web_debug.h    
 *  Created:    09.08.2002
 *  Date:       21.01.2005
 *  Author:     Copyright (C) 2001-2005
 *              Udo Jakobza - FTZ Leipzig; D-04107 Leipzig; Wchterstr. 13
 *              info@easytoweb.net
 *  Func:  		Header file for web_debug.c
 *  License:	
 *    This library is free software; you can redistribute it and/or modify it 
 *    under the terms of the GNU Lesser General Public License as published by 
 *    the Free Software Foundation; either version 2.1 of the License, or 
 *    (at your option) any later version. This library is distributed in the hope 
 *    that it will be useful, but WITHOUT ANY WARRANTY; without even the implied 
 *    warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
 *    See the GNU Lesser General Public License for more details.
 *	  see: http://www.gnu.org/copyleft/lesser.html	
 *    You should have received a copy of the GNU Lesser General Public License 
 *    along with this library; if not, write to the Free Software Foundation, 
 *    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *	
 *    Die Bibliothek ist freie Software; Sie drfen sie unter den Bedingungen der 
 *    GNU Lesser General Public License, wie von der Free Software Foundation 
 *    verffentlicht, weiterverteilen und/oder modifizieren; entweder gem 
 *    Version 2.1 der Lizenz oder (nach Ihrer Option) jeder spteren Version. 
 *    Diese Bibliothek wird in der Hoffnung weiterverbreitet, da sie ntzlich 
 *    sein wird, jedoch OHNE IRGENDEINE GARANTIE, auch ohne die implizierte 
 *    Garantie der MARKTREIFE oder der VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK. 
 *    Mehr Details finden Sie in der GNU Lesser General Public License.
 *	  see: http://www.gnu.org/copyleft/lesser.de.html	
 *    Sie sollten eine Kopie der GNU Lesser General Public License zusammen mit 
 *    dieser Bibliothek erhalten haben; falls nicht, schreiben Sie an die FSF,
 *    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 *  history:	
 *		1.) 08.08.2003 Version 2.00
 *		2.) 11.08.2003 Version 2.01
 *			a.)	- function "web_debug_info(..)" supports now the macros "PROJECT_NAME",
 *				  "PROJECT_VERSION" and "AVR_TYP_STRING";
 *		3.) 02.09.2003 Version 2.01
 *			a.)	- macros "PROJECT_NAME", "PROJECT_VERSION" and "AVR_TYP_STRING" 
 *                now with default value;
 *		4.) 12.01.2004 Version 2.03
 *			a.)	- new macro "WEB_DEBUG_IPSEC_BIT"
 *		5.) 02.02.2004 Version 2.03
 *			a.)	- start of project of MACRO functions to handle Debug messages
 *                "WEB_DEBUG_IPSEC_SA_MSG" and "WEB_DEBUG_IPSEC_MSG"
 *		6.) 13.08.2004 Version 2.04
 *			a.)	- rename macro "AVR_TYP_STRING" to "MC_TYP_STRING";
 *		7.) 21.01.2005 Version 2.06
 *			a.)	- 
 *
 *****************************************************************************/
#ifndef _WEB_DEBUG_INCLUDED_
#define _WEB_DEBUG_INCLUDED_

#include "project.h"

#ifdef WEB_DEBUG
#include <avr/eeprom.h>
#include <avr/pgmspace.h>

#ifndef DEBUG
#error  define "DEBUG", see project.h !!!
#endif

#ifndef EASYTOWEB_VERSION
#define EASYTOWEB_VERSION		"Version 2.1x"
#endif

#define WEB_DEBUG_CS8900_BIT		0x0001
#define WEB_DEBUG_ATI_BIT			0x0002
#define WEB_DEBUG_PPP_BIT			0x0004
#define WEB_DEBUG_BUFFER_BIT		0x0008
#define WEB_DEBUG_ETHERNET_BIT		0x0010
#define WEB_DEBUG_ARP_RARP_BIT		0x0020
#define WEB_DEBUG_IP_BIT			0x0040
#define WEB_DEBUG_ICMP_BIT			0x0080
#define WEB_DEBUG_TCP_BIT			0x0100
#define WEB_DEBUG_UDP_BIT			0x0200
#define WEB_DEBUG_BOOTP_BIT			0x0400
#define WEB_DEBUG_HTTP_BIT			0x0800
#define WEB_DEBUG_FTP_BIT			0x1000
#define WEB_DEBUG_FILE_BIT			0x2000
#define WEB_DEBUG_IPSEC_BIT			0x4000


#ifdef WEB_DEBUG_IPSEC
#define WEB_DEBUG_IPSEC_SA_MSG(__message__) { \
				if(web_debug_flag & WEB_DEBUG_IPSEC_BIT) { \
					printf __message__ ;  } }
#define WEB_DEBUG_IPSEC_SA_MSG_SPD(__message__, __spd_entry__) { \
				if(web_debug_flag & WEB_DEBUG_IPSEC_BIT) { \
					printf __message__ ; \
					ipsec_sa_debug_spd_print_s(__spd_entry__);  } }
#define WEB_DEBUG_IPSEC_SA_MSG_SAD(__message__, __sad_entry__) { \
				if(web_debug_flag & WEB_DEBUG_IPSEC_BIT) { \
					printf __message__ ; \
					ipsec_sa_debug_sad_print_s(__sad_entry__);  } }
#define WEB_DEBUG_IPSEC_SA_TEST(__message__) { \
					printf __message__ ;  }
#define WEB_DEBUG_IPSEC_MSG(__message__) { \
				if(web_debug_flag & WEB_DEBUG_IPSEC_BIT) { \
					printf __message__ ; } }
#else
#define WEB_DEBUG_IPSEC_SA_MSG(__message__)
#define WEB_DEBUG_IPSEC_SA_MSG_SPD(__message__, __spd_entry__)
#define WEB_DEBUG_IPSEC_SA_MSG_SAD(__message__, __sad_entry__)
#define WEB_DEBUG_IPSEC_SA_TEST(__message__)
#define WEB_DEBUG_IPSEC_MSG(__message__)
#endif

#ifdef __CODEVISIONAVR__
#pragma used+
#endif

#ifdef __CODEVISIONAVR__
 extern eeprom unsigned int web_debug_flag;
 void web_debug_info(flash unsigned char *info_string);
#else
 #ifndef EEMEM
  #define EEMEM  __attribute__ ((section (".eeprom")))
 #endif
 extern unsigned int web_debug_flag EEMEM;
 void web_debug_info(PGM_P info_string);
#endif

void web_debug_init(void);
unsigned char *web_debug_command(void);
void web_debug_display_addresses(void);

#ifdef __CODEVISIONAVR__
#pragma used-


#ifdef ETW_LIBRARY_ENABLE
#pragma library web_debug.lib
#endif
#endif
#endif

#endif
