
/*****************************************************************************
 *
 *                         "ppp_main.c"
 *                   -----------------------------
 *                                                                            
 *  Version:    2.03
 *  File:    	..\..\..\ppp_main.c    
 *  Created:    16.05.2003
 *  Date:       07.02.2004
 *  Author:     Copyright (C) 2001-2003 
 *              Udo Jakobza - FTZ Leipzig; D-04107 Leipzig; Wchterstr. 13
 *				info@easytoweb.net
 *  Function:	main-task for easyToWeb-PPP-Interface
 *  license:	
 *    This library is free software; you can redistribute it and/or modify it 
 *    under the terms of the GNU Lesser General Public License as published by 
 *    the Free Software Foundation; either version 2.1 of the License, or 
 *    (at your option) any later version. This library is distributed in the hope 
 *    that it will be useful, but WITHOUT ANY WARRANTY; without even the implied 
 *    warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
 *    See the GNU Lesser General Public License for more details.
 *	  see: http://www.gnu.org/copyleft/lesser.html	
 *    You should have received a copy of the GNU Lesser General Public License 
 *    along with this library; if not, write to the Free Software Foundation, 
 *    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *	
 *    Die Bibliothek ist freie Software; Sie drfen sie unter den Bedingungen der 
 *    GNU Lesser General Public License, wie von der Free Software Foundation 
 *    verffentlicht, weiterverteilen und/oder modifizieren; entweder gem 
 *    Version 2.1 der Lizenz oder (nach Ihrer Option) jeder spteren Version. 
 *    Diese Bibliothek wird in der Hoffnung weiterverbreitet, da sie ntzlich 
 *    sein wird, jedoch OHNE IRGENDEINE GARANTIE, auch ohne die implizierte 
 *    Garantie der MARKTREIFE oder der VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK. 
 *    Mehr Details finden Sie in der GNU Lesser General Public License.
 *	  see: http://www.gnu.org/copyleft/lesser.de.html	
 *    Sie sollten eine Kopie der GNU Lesser General Public License zusammen mit 
 *    dieser Bibliothek erhalten haben; falls nicht, schreiben Sie an die FSF,
 *    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 *  supported CodeVisionAVR C-Compiler: 
 * 		Version 1.23.8c and Version 1.23.8d (from 03.07.2003)
 *  Ressources: 
 * 		Version 1.23.8c: EEPROM-16 Byte; FLASH-16082 Word SRAM-2068 Byte
 * 		Version 1.23.8d: EEPROM-16 Byte; FLASH-16069 Word SRAM-2068 Byte
 *  history:	
 *		1.) 05.08.2003 Version 2.00a
 *			a.)	- first version for WWW
 *		2.) 12.11.2003 Version 2.02
 *
 *****************************************************************************/
#include "project.h"            // USER defines

#include <stdio.h>
#ifdef __CODEVISIONAVR__
#include <mega128.h>
#else
#include <avr/io.h>
#include <avr/wdt.h>
#include <avr/sleep.h>
#include <avr/pgmspace.h>
#endif
#include PPP_H_FILEPATH         // see file "project.h" inside of your
                                // project path
#include HARDWARE_H_FILEPATH    // see file "project.h" inside of your
                                // project path
#include PPP_DEBUG_H_FILEPATH   // see file "project.h" inside of your
                                // project path
#include SERVER_H_FILEPATH      // see file "project.h" inside of your
                                // project path
#include CS8900_SLEEP_H_FILEPATH        // see file "project.h" inside of
                                        // your project path
#ifdef WEB_DEBUG_MEASURE        // enable time-measure debug functions, see
                                // measure.c
#include MEASURE_H_FILEPATH     // see file "project.h" inside of your
                                // project path
#endif
#ifdef WEB_DEBUG
#include WEB_DEBUG_H_FILEPATH   // see file "project.h" inside of your
                                // project path
#endif

//#pragma regalloc-
//#pragma regalloc+

//*********************************************************************************
// Description  : main routine to start the USER-Program
// Input                : none
// Output       : none
// Indication   : none
//*********************************************************************************
int main(void)
{
   unsigned char counter_10ms_delay0 = 20;
   unsigned char counter_10ms_old;

   hardware_init();
#if !defined(BOARD_WB_NONIC_M128) && !defined(BOARD_WB_3c509b_M128) 
   cs8900_sleep_activ();
#endif   
#ifdef HTTP_ENABLE
   server_init();
#endif
#ifdef WEB_DEBUG
   web_debug_info(0x00);
#ifdef HTTP_ENABLE
   if (server_ok)
      printf_P(PSTR("HTTP-Server OK\n"));
   else
      printf_P(PSTR("HTTP-Server ERROR\n"));
#endif
#endif
   counter_10ms_old = (unsigned char) counter_10ms_16bit;
   while (1)
   {
#ifdef __CODEVISIONAVR__
#asm("wdr");                    // Reset Watchdog
#else
      wdt_reset();
#endif      
#ifdef HTTP_ENABLE
      server_main();
#endif
      //idle();                   // every time with IDLE-Mode
#ifdef WEB_DEBUG
      web_debug_command();
#endif
      if (counter_10ms_old != (unsigned char) counter_10ms_16bit)
      {
         counter_10ms_old = (unsigned char) counter_10ms_16bit;
         if (counter_10ms_delay0 > 0)
            counter_10ms_delay0--;
         else
         {
            counter_10ms_delay0 = 40;
/*            
            if (LED1_PIN)
               LED1_ON;         // PortD.4 LED1
            else
               LED1_OFF;        // PortD.4 LED1
*/
         }
      }
   }
}
