
/*****************************************************************************
 *
 *                          "project.h" 
 *                   -----------------------------
 *                                                                            
 *  Version:    2.03
 *  File:     	../../project.h    
 *  Created:    16.07.2003
 *  Date:       27.08.2004
 *  Author:     Copyright (C) 2001-2004
 *              Udo Jakobza - FTZ Leipzig; D-04107 Leipzig; Wchterstr. 13
 *              info@easytoweb.net
 *  Func: 		header-file to define USER-values
 *  license:	
 *    This library is free software; you can redistribute it and/or modify it 
 *    under the terms of the GNU Lesser General Public License as published by 
 *    the Free Software Foundation; either version 2.1 of the License, or 
 *    (at your option) any later version. This library is distributed in the hope 
 *    that it will be useful, but WITHOUT ANY WARRANTY; without even the implied 
 *    warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
 *    See the GNU Lesser General Public License for more details.
 *    see: http://www.gnu.org/copyleft/lesser.html	
 *    You should have received a copy of the GNU Lesser General Public License 
 *    along with this library; if not, write to the Free Software Foundation, 
 *    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *	
 *    Die Bibliothek ist freie Software; Sie drfen sie unter den Bedingungen der 
 *    GNU Lesser General Public License, wie von der Free Software Foundation 
 *    verffentlicht, weiterverteilen und/oder modifizieren; entweder gem 
 *    Version 2.1 der Lizenz oder (nach Ihrer Option) jeder spteren Version. 
 *    Diese Bibliothek wird in der Hoffnung weiterverbreitet, da sie ntzlich 
 *    sein wird, jedoch OHNE IRGENDEINE GARANTIE, auch ohne die implizierte 
 *    Garantie der MARKTREIFE oder der VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK. 
 *    Mehr Details finden Sie in der GNU Lesser General Public License.
 *	  see: http://www.gnu.org/copyleft/lesser.de.html	
 *    Sie sollten eine Kopie der GNU Lesser General Public License zusammen mit 
 *    dieser Bibliothek erhalten haben; falls nicht, schreiben Sie an die FSF,
 *    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 *  history:	
 *		1.) 30.07.2003 Version 2.00a
 *			a.)	- 
 *
 *****************************************************************************/
#ifndef _PROJECT_INCLUDED_
#define _PROJECT_INCLUDED_

// --------------------------------------------------------------------------------
// USER Global Module definitions
// -------------------------------------------------------------------------------- 
#define BOARD_ETW_ATMEGA32      // enable easyToWeb-ATmega32 Board

// --------------------------------------------------------------------------------
// USER Global path to all header-files
// -------------------------------------------------------------------------------- 
#define	UTIL_H_FILEPATH			"../../ext_common/include/util.h"
#define DEBUG_H_FILEPATH		"../../ext_common/include/debug.h"
// --------------------------------------------------------------------------------
#define	HARDWARE_H_FILEPATH		"../../include/hardware.h"
#define DEVICE_H_FILEPATH		"../../include/device.h"
#define CS8900_H_FILEPATH		"../../include/cs8900.h"
#define CS8900_SLEEP_H_FILEPATH	"../../include/cs8900_sleep.h"
#define PPP_H_FILEPATH			"../../include/ppp.h"
#define ETHERNET_H_FILEPATH		"../../include/ethernet.h"
#define BUFFER_H_FILEPATH		"../../include/buffer.h"
#define MEASURE_H_FILEPATH		"../../include/measure.h"
#define IP_H_FILEPATH			"../../include/ip.h"
#define ARP_RARP_H_FILEPATH		"../../include/arp_rarp.h"
#define ICMP_H_FILEPATH			"../../include/icmp.h"
#define UDP_H_FILEPATH			"../../include/udp.h"
#define UDP_CLIENT_H_FILEPATH	"../../include/udp_client.h"
#define SERVER_H_FILEPATH		"../../include/server.h"
// --------------------------------------------------------------------------------
#define WEB_DEBUG_H_FILEPATH	"../../include/web_debug.h"
#define CS8900_DEBUG_H_FILEPATH	"../../include/cs8900_debug.h"

// --------------------------------------------------------------------------------
// USER Global general definitions
// -------------------------------------------------------------------------------- 
#define ENABLE_EEPROM_ADDRESS   // enable the eeprom-space to save all
                                // easyToWeb IP-addresses

// --------------------------------------------------------------------------------
// USER Global Device (CS8900, PPP and so on) definitions
// -------------------------------------------------------------------------------- 
#define DEVICE_CS8900           // switch on the CS8900 device

// --------------------------------------------------------------------------------
// USER Global Interface between CS8900 and MC definitions
// -------------------------------------------------------------------------------- 
#define CS8900_IO_PORT8         // data to/from CS8900 over Port-IO
//#define CS8900_IO_PORT16              // data to/from CS8900 over Port-IO
//#define CS8900_I2C_HW_8               // data to/from CS8900 over I2C-HW-Bus (about 400kHz)
//#define CS8900_I2C_HW_16              // data to/from CS8900 over I2C-HW-Bus (about 400kHz)
//#define CS8900_I2C_SW_8               // data to/from CS8900 over I2C-SW-Bus (about 100kHz)
//#define CS8900_I2C_SW_16              // data to/from CS8900 over I2C-SW-Bus (about 100kHz)

// --------------------------------------------------------------------------------
// USER Global Ethernet-Protocol definitions
// -------------------------------------------------------------------------------- 
#define ETHERNET_ENABLE         // enable the ETHERNET-Protocol
#define ARP_ENABLE              // enable the ARP-Protocol
#define IP_ENABLE               // enable the IP-Protocol
#define ICMP_ENABLE             // enable the ICMP-Protocol
#define UDP_ENABLE              // enable the UDP-Protocol

// --------------------------------------------------------------------------------
// USER Global Debug definitions
// -------------------------------------------------------------------------------- 
//#define DEBUG                                 // enable all global debug functions, see debug.c
//#define WEB_DEBUG                             // enable web debug functions, see web_debug.c
//#define WEB_DEBUG_CS8900              // enable low level CS8900 debug functions, see cs8900.c
//#define WEB_DEBUG_BUFFER              // enable BUFFER debug functions, see buffer.c
//#define WEB_DEBUG_ETHERNET    // enable ETHERNET debug functions, see ethernet.c
//#define WEB_DEBUG_ARP                 // enable ARP debug functions, see arp.c
//#define WEB_DEBUG_IP                  // enable IP debug functions, see ip.c
//#define WEB_DEBUG_ICMP                // enable ICMP debug functions, see icmp.c
//#define WEB_DEBUG_UDP                 // enable UDP debug functions, see udp.c

// --------------------------------------------------------------------------------
// USER Global Debug definitions
// -------------------------------------------------------------------------------- 
#define PROJECT_NAME			"eTW-ATmega32 + ATmega8535 + UDP-Client"
#define PROJECT_VERSION			"Version 1.03"
#define	DEBUG_BAUD_RATE			115200  // actual baudrate of
                                                // Debug-Interface

// --------------------------------------------------------------------------------
// USER IP-addresses for own subnet
// -------------------------------------------------------------------------------- 
#define IP_DEFAULT		       	{192, 168, 50, 216}     // our
                                                                // internet
                                                                // protocol
                                                                // (IP)
                                                                // address
#define IP_SUBMASK_DEFAULT		{255, 255, 255, 0}      // subnet
                                                                // mask
#define IP_GATEWAY_DEFAULT		{192, 168, 50, 160}     // standard
                                                                // gateway
#define IP_SERVER				{192, 168, 50, 3}

// --------------------------------------------------------------------------------
// USER IP-addresses for internet
// -------------------------------------------------------------------------------- 
//#define IP_DEFAULT                    {141, 57, 27, 167}              // our internet protocol (IP) address
//#define IP_SUBMASK_DEFAULT            {255, 255, 252, 0}              // subnet mask
//#define IP_GATEWAY_DEFAULT            {141, 57, 24, 3}                // standard gateway
//#define IP_SERVER                                     {141, 57, 27, 176}

// --------------------------------------------------------------------------------
// USER UDP-definitions
// -------------------------------------------------------------------------------- 
#define	UDP_TX_DATA_SIZE			16      // user transmit data 
                                                        // size
#define	UDP_RX_DATA_SIZE			16      // user receive data
                                                        // size
#define UDP_MAX_CONNECTIONS			1       // 
#define UDP_CLIENT_PORT_LOCAL		33333
#define UDP_CLIENT_PORT_SERVER		33331

// --------------------------------------------------------------------------------
// USER easyToWeb-LED function
// -------------------------------------------------------------------------------- 
//#define       LED1_ON                 PORTD.0=0
//#define       LED1_OFF                PORTD.0=1
//#define       LED1_PIN                PIND.0
//#define       LED1_PASSIV             DDRD.0=0
//#define       LED1_ACTIV              DDRD.0=1

//#define       LED2_ON                 PORTD.1=0
//#define       LED2_OFF                PORTD.1=1
//#define       LED2_PIN                PIND.1
//#define       LED2_PASSIV             DDRD.1=0
//#define       LED2_ACTIV              DDRD.1=1

// --------------------------------------------------------------------------------
// USER CS8900-Mikrocontroller-Interface
// -------------------------------------------------------------------------------- 
#define CS8900_IOR_L			PORTB&=~(1<<3)/*.3=0*/       // /IOR_ETH
#define CS8900_IOR_H			PORTB|=(1<<3) /*.3=1*/       // /IOR_ETH
#define CS8900_IOR_OUTPUT		DDRB|=(1<<3)  /*.3=1*/        // /IOR_ETH

#define CS8900_IOW_L			PORTB&=~(1<<2)/*.2=0*/       // /IOW_ETH
#define CS8900_IOW_H			PORTB|=(1<<2) /*.2=1*/       // /IOW_ETH
#define CS8900_IOW_OUTPUT		DDRB|=(1<<2)  /*.2=1*/        // /IOW_ETH

#define CS8900_RESET_L			PORTB&=~(1<<1)/*.1=0*/       // RES_CS89
#define CS8900_RESET_H			PORTB|=(1<<1) /*.1=1*/       // RES_CS89
#define CS8900_RESET_OUTPUT		DDRB|=(1<<1)  /*.1=1*/        // RES_CS89

#define CS8900_SLEEP_L
#define CS8900_SLEEP_H
#define CS8900_SLEEP_OUTPUT

#if defined(CS8900_IO_PORT8)||defined(CS8900_I2C_HW_8)||defined(CS8900_I2C_SW_8)
#define CS8900_SBHE_L
#define CS8900_SBHE_H
#define CS8900_SBHE_OUTPUT
#endif // #if
       // defined(CS8900_IO_PORT8)||defined(CS8900_I2C_HW_8)||defined(CS8900_I2C_SW_8)

#if defined(CS8900_IO_PORT16)||defined(CS8900_I2C_HW_16)||defined(CS8900_I2C_SW_16)
#define CS8900_SBHE_L			PORTB&=~(1<<0)/*.0=0*/       // /SBHE
#define CS8900_SBHE_H			PORTB|=(1<<0) /*.0=1*/       // /SBHE
#define CS8900_SBHE_OUTPUT		DDRB|=(1<<0)  /*.0=1*/        // /SBHE
#endif // #if
       // defined(CS8900_IO_PORT16)||defined(CS8900_I2C_HW_16)||defined(CS8900_I2C_SW_16)

#if defined(CS8900_IO_PORT8)||defined(CS8900_IO_PORT16)
#define	CS8900_ADR(x)			PORTD&=0x0f;PORTD|=((x&0x0f)<<4)        // PORTx.4..PORTx.7 
                                                                                // A0..A3
#define	CS8900_ADR_DDR			DDRD|=((1<<4)|(1<<5)|(1<<6)|(1<<7))/*DDRD.4=1;DDRD.5=1;DDRD.6=1;DDRD.7=1*/     // DDRx.4..DDRx.7 
                                                                                // A0..A3

#define CS8900_DATA_W			PORTA   // AD0..AD7
#define CS8900_DATA_R			PINA    // AD0..AD7
#define CS8900_DATA_INPUT		DDRA=0x00       // AD0..AD7
#define CS8900_DATA_OUTPUT		DDRA=0xff       // AD0..AD7
#endif // #if defined(CS8900_IO_PORT8)||defined(CS8900_IO_PORT16)

#ifdef CS8900_IO_PORT16         // data to/from CS8900 over Port-IO
#define	CS8900_DATA16_W		  		PORTC   // AD8..AD15
#define CS8900_DATA16_R				PINC    // AD8..AD15
#define	CS8900_DATA16_INPUT			DDRC=0x00       // AD8..AD15
#define CS8900_DATA16_OUTPUT		DDRC=0xff       // AD8..AD15
#endif // #define CS8900_IO_PORT16

#if defined(CS8900_I2C_HW_8)||defined(CS8900_I2C_HW_16)||defined(CS8900_I2C_SW_8)||defined(CS8900_I2C_SW_16)
#define I2C_ADDRESS_EXPANDER		0x7a    // address of
                                                // address-i2c-expander (A0
                                                // .. A3)
#define I2C_DATA8_EXPANDER			0x72    // address of
                                                        // data8-i2c-expander 
                                                        // (AD0 .. AD7)
#define I2C_DATA16_EXPANDER			0x70    // address of
                                                        // data16-i2c-expander 
                                                        // (AD8 .. AD15)
#endif // #if
       // defined(CS8900_I2C_HW_8)||defined(CS8900_I2C_HW_16)||defined(CS8900_I2C_SW_8)||defined(CS8900_I2C_SW_16)

// --------------------------------------------------------------------------------
// icmp.c
// -------------------------------------------------------------------------------- 
#define ICMP_DATA_SIZE		8

#endif // #define _PROJECT_INCLUDED_
