
/*****************************************************************************
 *
 *                         "udp_main.c"
 *                   -----------------------------
 *                                                                            
 *  Version:    2.10
 *  File:    	..\..\udp_main.c    
 *  Created:    15.07.2002
 *  Date:       09.09.2005
 *  Author:     Copyright (C) 2001-2005
 *              Udo Jakobza - FTZ Leipzig; D-04107 Leipzig; Wchterstr. 13
 *				info@easytoweb.net
 *  Function:	main-task for UDP sample
 *  license:	
 *    This library is free software; you can redistribute it and/or modify it 
 *    under the terms of the GNU Lesser General Public License as published by 
 *    the Free Software Foundation; either version 2.1 of the License, or 
 *    (at your option) any later version. This library is distributed in the hope 
 *    that it will be useful, but WITHOUT ANY WARRANTY; without even the implied 
 *    warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
 *    See the GNU Lesser General Public License for more details.
 *	  see: http://www.gnu.org/copyleft/lesser.html	
 *    You should have received a copy of the GNU Lesser General Public License 
 *    along with this library; if not, write to the Free Software Foundation, 
 *    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *	
 *    Die Bibliothek ist freie Software; Sie drfen sie unter den Bedingungen der 
 *    GNU Lesser General Public License, wie von der Free Software Foundation 
 *    verffentlicht, weiterverteilen und/oder modifizieren; entweder gem 
 *    Version 2.1 der Lizenz oder (nach Ihrer Option) jeder spteren Version. 
 *    Diese Bibliothek wird in der Hoffnung weiterverbreitet, da sie ntzlich 
 *    sein wird, jedoch OHNE IRGENDEINE GARANTIE, auch ohne die implizierte 
 *    Garantie der MARKTREIFE oder der VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK. 
 *    Mehr Details finden Sie in der GNU Lesser General Public License.
 *	  see: http://www.gnu.org/copyleft/lesser.de.html	
 *    Sie sollten eine Kopie der GNU Lesser General Public License zusammen mit 
 *    dieser Bibliothek erhalten haben; falls nicht, schreiben Sie an die FSF,
 *    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 *  history:	
 *		1.) 10.08.2004 Version 2.04
 *			a.)	- 
 *
 *
 ****************************************************************************/
#include "project.h"            // USER defines

#include <avr/sleep.h>
#include <avr/wdt.h>
#include <stdio.h>
#include <string.h>

#include HARDWARE_H_FILEPATH    // see file "project.h" inside of your
                                // project path
#include UDP_H_FILEPATH         // see file "project.h" inside of your
                                // project path
#include UDP_CLIENT_H_FILEPATH  // see file "project.h" inside of your
                                // project path
#include SERVER_H_FILEPATH      // see file "project.h" inside of your
                                // project path
#include DEBUG_H_FILEPATH       // see file "project.h" inside of your
                                // project path

//#pragma regalloc-
//#pragma regalloc+

//*********************************************************************************
// Description  : main routine to start the USER-Program
// Input                : none
// Output       : none
// Indication   : none
//*********************************************************************************
int main(void)
{
   unsigned char counter_10ms_delay0 = 50;
   unsigned char counter_10ms_old;

   hardware_init();             // init microcontroller and interfaces
#ifdef DEBUG
   debug_init();
#endif
   udp_client_init();
#ifdef DEBUG
#ifdef UDP_ENABLE
   if (udp_client_ok)
      printf_P(PSTR("UDP Client OK\n"));
   else
      printf_P(PSTR("UDP Client Error\n"));
#endif // #ifdef UDP_ENABLE
#endif // #ifdef DEBUG
   counter_10ms_old = (unsigned char) counter_10ms_16bit;
//   LED1_OFF;
//   LED2_OFF;
   while (1)
   {
//#asm("wdr");                    // Reset Watchdog
      wdt_reset();
      //idle();                   // every time with IDLE-Mode
      udp_client_main();
#ifdef DEBUG
      debug_get_command();
#endif
      if (counter_10ms_old != (unsigned char) counter_10ms_16bit)
      {
         counter_10ms_old = (unsigned char) counter_10ms_16bit;
         if (counter_10ms_delay0 > 0)
            counter_10ms_delay0--;
         else
         {
            counter_10ms_delay0 = 100;
/*
            if (LED1_PIN)
               LED1_ON;
            else
               LED1_OFF;
*/
         }
      }
   }
}
