
/*****************************************************************************
 *
 *                          "project.h"
 *                   -----------------------------
 *
 *  Version:    2.03
 *  File:     	../samples/../project.h
 *  Created:    16.07.2003
 *  Date:       03.12.2004
 *  Author:     Copyright (C) 2001-2004
 *              Udo Jakobza - FTZ Leipzig; D-04107 Leipzig; Wchterstr. 13
 *				info@easytoweb.net
 *  Func: 		header-file to define USER-values
 *  License:
 *    This library is free software; you can redistribute it and/or modify it
 *    under the terms of the GNU Lesser General Public License as published by
 *    the Free Software Foundation; either version 2.1 of the License, or
 *    (at your option) any later version. This library is distributed in the hope
 *    that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *    warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *    See the GNU Lesser General Public License for more details.
 *	  see: http://www.gnu.org/copyleft/lesser.html
 *    You should have received a copy of the GNU Lesser General Public License
 *    along with this library; if not, write to the Free Software Foundation,
 *    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *    Die Bibliothek ist freie Software; Sie drfen sie unter den Bedingungen der
 *    GNU Lesser General Public License, wie von der Free Software Foundation
 *    verffentlicht, weiterverteilen und/oder modifizieren; entweder gem
 *    Version 2.1 der Lizenz oder (nach Ihrer Option) jeder spteren Version.
 *    Diese Bibliothek wird in der Hoffnung weiterverbreitet, da sie ntzlich
 *    sein wird, jedoch OHNE IRGENDEINE GARANTIE, auch ohne die implizierte
 *    Garantie der MARKTREIFE oder der VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK.
 *    Mehr Details finden Sie in der GNU Lesser General Public License.
 *	  see: http://www.gnu.org/copyleft/lesser.de.html
 *    Sie sollten eine Kopie der GNU Lesser General Public License zusammen mit
 *    dieser Bibliothek erhalten haben; falls nicht, schreiben Sie an die FSF,
 *    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 *  history:
 *		1.) 08.08.2003 Version 2.00
 *		2.) 12.08.2003 Version 2.01
 *			a.)	- new macros "PROJECT_NAME", "PROJECT_VERSION" and "EASYTOWEB_VERSION"
 *		3.) 27.02.2003 Version 2.03
 *
 *****************************************************************************/
#ifndef _PROJECT_INCLUDED_
#define _PROJECT_INCLUDED_


#define DEBUG_UPLINK_UART0
#define	DEBUG_BAUD_RATE			38400  // actual baudrate of Debug-Interface

// --------------------------------------------------------------------------------
// USER Global Module definitions
// --------------------------------------------------------------------------------
//#define BOARD_ETW_AVR           // enable easyToWeb-AVR Board
#define BOARD_WB_3c509B_AVR       // enable my 3c509b-AVR Board

// --------------------------------------------------------------------------------
// USER Global path to all header-files
// --------------------------------------------------------------------------------
#define	UTIL_H_FILEPATH			"../../ext_common/include/util.h"
#define DEBUG_H_FILEPATH		"../../ext_common/include/debug.h"
// --------------------------------------------------------------------------------
#define	HARDWARE_H_FILEPATH		"../../include/hardware.h"
#define DEVICE_H_FILEPATH		"../../include/device.h"
#define CS8900_H_FILEPATH		"../../include/cs8900.h"
#define NIC_3c509b_H_FILEPATH   "../../include/3c509b.h"
#define ETHERNET_H_FILEPATH		"../../include/ethernet.h"
#define BUFFER_H_FILEPATH		"../../include/buffer.h"
#define MEASURE_H_FILEPATH		"../../include/measure.h"
#define IP_H_FILEPATH			"../../include/ip.h"
#define ARP_RARP_H_FILEPATH		"../../include/arp_rarp.h"
#define ICMP_H_FILEPATH			"../../include/icmp.h"
#define TCP_H_FILEPATH			"../../include/tcp.h"
#define UDP_H_FILEPATH			"../../include/udp.h"
#define BOOTP_H_FILEPATH		"../../include/bootp.h"
#define WEBSIDE_H_FILEPATH		"../../include/webside.h"
#define SERVER_H_FILEPATH		"../../include/server.h"
#define FTP_SERVER_H_FILEPATH	"../../include/ftp_server.h"
#define HTTP_SERVER_H_FILEPATH	"../../include/http_server.h"
#define UDP_SERVER_H_FILEPATH	"../../include/udp_server.h"
// --------------------------------------------------------------------------------
#define WEB_DEBUG_H_FILEPATH	"../../include/web_debug.h"
#define PPP_DEBUG_H_FILEPATH	"../../include/ppp_debug.h"
#define TCP_DEBUG_H_FILEPATH	"../../include/tcp_debug.h"
#define CS8900_DEBUG_H_FILEPATH	"../../include/cs8900_debug.h"

// --------------------------------------------------------------------------------
// USER Global general definitions
// --------------------------------------------------------------------------------
#define ENABLE_EEPROM_ADDRESS   // enable the eeprom-space to save all
                                // easyToWeb IP-addresses

// --------------------------------------------------------------------------------
// USER Global Device (CS8900, PPP and so on) definitions
// --------------------------------------------------------------------------------
#define DEVICE_3c509b           // switch on the 3c509b device
//#define DEVICE_CS8900         // switch on the CS8900 device
//#define DEVICE_PPP            // switch on the PPP device

// --------------------------------------------------s------------------------------
// USER Global Interface between CS8900 and MC definitions
// --------------------------------------------------------------------------------
//#define CS8900_MEMORY           // data to/from CS8900 over Memory-Bus
//#define CS8900_IO_PORT8         // data to/from CS8900 over Port-IO
//#define CS8900_IO_PORT16        // data to/from CS8900 over Port-IO
//#define CS8900_I2C_HW_8         // data to/from CS8900 over I2C-HW-Bus (about 400kHz)
//#define CS8900_I2C_HW_16        // data to/from CS8900 over I2C-HW-Bus (about 400kHz)
//#define CS8900_I2C_SW_8         // data to/from CS8900 over I2C-SW-Bus (about 100kHz)
//#define CS8900_I2C_SW_16        // data to/from CS8900 over I2C-SW-Bus (about 100kHz)

//#define CS8900_TX_PADDING_DISABLE     // disable Padding of TX-Frame if <60Byte, see "CS8900_PP_TX_CMD_WO"
//#define CS8900_IO_ADDRESS     0xf000  // define the address to read/write IO of Ethernet

// --------------------------------------------------------------------------------
// USER Global Ethernet-Protocol definitions
// --------------------------------------------------------------------------------
#define ETHERNET_ENABLE         // enable the ETHERNET-Protocol
#define ARP_ENABLE              // enable the ARP-Protocol
#define IP_ENABLE               // enable the IP-Protocol
#define ICMP_ENABLE             // enable the ICMP-Protocol
//#define UDP_ENABLE            // enable the UDP-Protocol
//#define BOOTP_ENABLE          // enable the BOOTP-Protocol
#define TCP_ENABLE              // enable the TCP-Protocol
#define HTTP_ENABLE             // enable the HTTP-Protocol

// --------------------------------------------------------------------------------
// USER Global Debug definitions
// --------------------------------------------------------------------------------
#define DEBUG                   // enable all global debug functions, see
                                // debug.c
#define WEB_DEBUG               // enable web debug functions, see
                                // web_debug.c
//#define WEB_DEBUG_MEASURE     // enable time-measure debug functions, see measure.c
//#define WEB_DEBUG_CS8900      // enable low level CS8900 debug functions,
                                // see cs8900.c
//#define WEB_DEBUG_PPP         // enable low level PPP debug functions, see ppp.c
//#define WEB_DEBUG_MODEM       // enable low level MODEM debug functions, see modem.c
#define WEB_DEBUG_BUFFER        // enable BUFFER debug functions, see
                                // buffer.c
#define WEB_DEBUG_ETHERNET      // enable ETHERNET debug functions, see
                                // ethernet.c
#define WEB_DEBUG_ARP           // enable ARP debug functions, see arp.c
#define WEB_DEBUG_IP            // enable IP debug functions, see ip.c
#define WEB_DEBUG_ICMP          // enable ICMP debug functions, see icmp.c
//#define WEB_DEBUG_UDP         // enable UDP debug functions, see udp.c
//#define WEB_DEBUG_BOOTP       // enable BOOTP debug functions, see bootp.c
#define WEB_DEBUG_TCP           // enable TCP debug functions, see tcp.c
#define WEB_DEBUG_TCP_OFFLINE   // enable TCP debug functions, see
                                // tcp_debug.c
#define WEB_DEBUG_HTTP          // enable HTTP debug functions, see
                                // http_server.c
//#define WEB_DEBUG_FTP         // enable FTP debug functions, see ftp.c

// --------------------------------------------------------------------------------
// USER Global Debug definitions
// --------------------------------------------------------------------------------
#define PROJECT_NAME			"eTW-AVR-3c509b-HTTP-Server"
#define PROJECT_VERSION			"Version 1.21"

// --------------------------------------------------------------------------------
// USER IP-addresses for own subnet
// --------------------------------------------------------------------------------
#define IP_DEFAULT				{172,  16,  50, 216}     // our internet protocol (IP) address
#define IP_SUBMASK_DEFAULT		{255, 255, 255,   0}     // subnet mask
#define IP_GATEWAY_DEFAULT		{172,  16,  50,  11}     // standard gateway

// --------------------------------------------------------------------------------
// USER IP-addresses for internet
// --------------------------------------------------------------------------------
//#define IP_DEFAULT                    {141, 57, 27, 167}              // our internet protocol (IP) address
//#define IP_SUBMASK_DEFAULT            {255, 255, 252, 0}              // subnet mask
//#define IP_GATEWAY_DEFAULT            {141, 57, 24, 3}                // standard gateway

// --------------------------------------------------------------------------------
// USER TCP-definitions
// --------------------------------------------------------------------------------
#if 1
#define TCP_TX_BUFFER_SIZE		480     // max. TCP-TX-Buffer data size
#define TCP_TX_SEGMENT_SIZE		250     // max. outgoing TCP data size

#define TCP_RX_BUFFER_SIZE		500     // max. TCP-RX-Buffer data size
#define TCP_RX_SEGMENT_SIZE		250     // max. incoming TCP data size

#define TCP_MAX_CONNECTIONS		1       // max. TCP connections

#else
#define TCP_TX_BUFFER_SIZE		3000    // max. TCP-TX-Buffer data size
#define TCP_TX_SEGMENT_SIZE		512     // max. outgoing TCP data size

#define TCP_RX_BUFFER_SIZE		2048    // max. TCP-RX-Buffer data size
#define TCP_RX_SEGMENT_SIZE		512     // max. incoming TCP data size

#define TCP_MAX_CONNECTIONS		4       // max. TCP connections
#endif
// --------------------------------------------------------------------------------
// USER UDP-definitions
// --------------------------------------------------------------------------------
#define	UDP_TX_DATA_SIZE		300     // the lowest size to handle BootP-Data
#define	UDP_RX_DATA_SIZE		12      // user receive data size
#define UDP_MAX_CONNECTIONS		1       // for BootP-Protokoll

// --------------------------------------------------------------------------------
// USER BootP-definitions
// --------------------------------------------------------------------------------
#define	BOOTP_TIMEOUT			1000    // 10 sec. timeout until wait of anwser from
                                        // BootP-Server (max. 655,35 sec.)

// --------------------------------------------------------------------------------
// USER easyToWeb-LED function enable/disable
// --------------------------------------------------------------------------------
/*
#define	LED1_ON	   		 		PORTD.4=0
#define	LED1_OFF				PORTD.4=1
#define	LED1_PIN		 		PIND.4
#define	LED1_PASSIV		 		DDRD.4=0
#define	LED1_ACTIV		 		DDRD.4=1
*/
// --------------------------------------------------------------------------------
// USER CS8900-Mikrocontroller-Interface Traffic-Lines
// --------------------------------------------------------------------------------

#define CS8900_TRAFFIC_RECEIVE_OUTPUT	DDRD|=(1<<6)   //.6=1
#define CS8900_TRAFFIC_RECEIVE_H		PORTD|=(1<<6)  //.6=1
#define CS8900_TRAFFIC_RECEIVE_L		PORTD&=~(1<<6) //.6=0

#define CS8900_TRAFFIC_TRANSMIT_OUTPUT	DDRD|=(1<<5)   //.5=1
#define CS8900_TRAFFIC_TRANSMIT_H       PORTD|=(1<<5)  //.5=1
#define CS8900_TRAFFIC_TRANSMIT_L		PORTD&=~(1<<5) //.5=0

// --------------------------------------------------------------------------------
// see file arp.c
// --------------------------------------------------------------------------------
#define ARP_CACHE_SIZE		5       // sets the size of ARP-Cache
#define ARP_CACHE_ENABLE            // Enable ARP-Cache

// --------------------------------------------------------------------------------
// see file icmp.c
// --------------------------------------------------------------------------------
#define ICMP_DATA_SIZE		1472    // Linux uses this size

// --------------------------------------------------------------------------------
// see file webside.c
// --------------------------------------------------------------------------------
#define WEBSIDE_DEFAULT_ENABLE  // with default webside

#endif // #define _PROJECT_INCLUDED_
