
/*****************************************************************************
 *
 *                         "icmp_ipsec.c"
 *                   -----------------------------
 *
 *  Version:    2.03
 *  File:    	..\..\icmp_ipsec.c
 *  Created:    14.12.2003
 *  Date:       10.08.2004
 *  Author:     Copyright (C) 2001-2004
 *              Udo Jakobza - FTZ Leipzig; D-04107 Leipzig; Wchterstr. 13
 *				info@easytoweb.net
 *  Function:	main-task for easyToWeb-HTTP-Server
 *  License:
 *    This library is free software; you can redistribute it and/or modify it
 *    under the terms of the GNU Lesser General Public License as published by
 *    the Free Software Foundation; either version 2.1 of the License, or
 *    (at your option) any later version. This library is distributed in the hope
 *    that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *    warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *    See the GNU Lesser General Public License for more details.
 *	  see: http://www.gnu.org/copyleft/lesser.html
 *    You should have received a copy of the GNU Lesser General Public License
 *    along with this library; if not, write to the Free Software Foundation,
 *    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *    Die Bibliothek ist freie Software; Sie drfen sie unter den Bedingungen der
 *    GNU Lesser General Public License, wie von der Free Software Foundation
 *    verffentlicht, weiterverteilen und/oder modifizieren; entweder gem
 *    Version 2.1 der Lizenz oder (nach Ihrer Option) jeder spteren Version.
 *    Diese Bibliothek wird in der Hoffnung weiterverbreitet, da sie ntzlich
 *    sein wird, jedoch OHNE IRGENDEINE GARANTIE, auch ohne die implizierte
 *    Garantie der MARKTREIFE oder der VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK.
 *    Mehr Details finden Sie in der GNU Lesser General Public License.
 *	  see: http://www.gnu.org/copyleft/lesser.de.html
 *    Sie sollten eine Kopie der GNU Lesser General Public License zusammen mit
 *    dieser Bibliothek erhalten haben; falls nicht, schreiben Sie an die FSF,
 *    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 *  history:
 *		1.) 11.02.2004 Version 2.03
 *			a.)	-
 *
 *****************************************************************************/
#include "project.h"            // USER defines

//#include <mega128.h>
#include <avr/sleep.h>
#include <avr/wdt.h>
#include <stdio.h>

#include HARDWARE_H_FILEPATH    // see file "project.h" inside of your project path
#include DEVICE_H_FILEPATH      // see file "project.h" inside of your project path
#include BUFFER_H_FILEPATH      // see file "project.h" inside of your project path
#include ETHERNET_H_FILEPATH    // see file "project.h" inside of your project path
#ifdef WEB_DEBUG
#include WEB_DEBUG_H_FILEPATH   // see file "project.h" inside of your project path
#endif

//#pragma regalloc-
//#pragma regalloc+

// *********************************************************************************
// Description  : main routine to start the USER-Program
// Input                : none
// Output       : none
// Indication   : none
// *********************************************************************************
int main(void)
{
   unsigned char counter_10ms_delay0 = 20;
   unsigned char counter_10ms_old;

   hardware_init();             // init microcontroller and interfaces
   hardware_init_mac_address();
#ifdef IP_ENABLE
   hardware_init_ip_addresses();
#endif
   buffer_clear();
   if (DEVICE_INIT() == 0)
      while(1) ;
#ifdef ARP_ENABLE
   arp_request_timer(ARP_REQUEST_TIMER_START);  // start mode
#endif
#ifdef WEB_DEBUG
   web_debug_info(0x00);
#endif
   counter_10ms_old = (unsigned char) counter_10ms_16bit;
   while (1)
   {
//#asm("wdr");                    // Reset Watchdog
       wdt_reset();
#ifdef ETHERNET_ENABLE
      ethernet_process();       // handle network and easyToWeb-stack events
#endif
      buffer_process();         // handles the buffer management
#ifdef WEB_DEBUG
      web_debug_command();
#endif
      if (counter_10ms_old != (unsigned char) counter_10ms_16bit)
      {
         counter_10ms_old = (unsigned char) counter_10ms_16bit;
         if (counter_10ms_delay0 > 0)
            counter_10ms_delay0--;
         else
         {
            counter_10ms_delay0 = 20;
/*
            LED4_ACTIV;         // DDRD.7 LED4
            if (LED4_PIN)
               LED4_ON;         // PortD.4 LED1
            else
               LED4_OFF;        // PortD.4 LED1
*/
         }
      }
   }
}
