
/*****************************************************************************
 *
 *                         "udp_main.c"
 *                   -----------------------------
 *                                                                            
 *  Version:    2.06
 *  File:    	..\..\udp_main.c    
 *  Created:    15.07.2002
 *  Date:       25.01.2005
 *  Author:     Copyright (C) 2001-2005
 *              Udo Jakobza - FTZ Leipzig; D-04107 Leipzig; Wchterstr. 13
 *				info@easytoweb.net
 *  Function:	main-task for UDP server sample
 *  license:	
 *    This library is free software; you can redistribute it and/or modify it 
 *    under the terms of the GNU Lesser General Public License as published by 
 *    the Free Software Foundation; either version 2.1 of the License, or 
 *    (at your option) any later version. This library is distributed in the hope 
 *    that it will be useful, but WITHOUT ANY WARRANTY; without even the implied 
 *    warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
 *    See the GNU Lesser General Public License for more details.
 *	  see: http://www.gnu.org/copyleft/lesser.html	
 *    You should have received a copy of the GNU Lesser General Public License 
 *    along with this library; if not, write to the Free Software Foundation, 
 *    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *	
 *    Die Bibliothek ist freie Software; Sie drfen sie unter den Bedingungen der 
 *    GNU Lesser General Public License, wie von der Free Software Foundation 
 *    verffentlicht, weiterverteilen und/oder modifizieren; entweder gem 
 *    Version 2.1 der Lizenz oder (nach Ihrer Option) jeder spteren Version. 
 *    Diese Bibliothek wird in der Hoffnung weiterverbreitet, da sie ntzlich 
 *    sein wird, jedoch OHNE IRGENDEINE GARANTIE, auch ohne die implizierte 
 *    Garantie der MARKTREIFE oder der VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK. 
 *    Mehr Details finden Sie in der GNU Lesser General Public License.
 *	  see: http://www.gnu.org/copyleft/lesser.de.html	
 *    Sie sollten eine Kopie der GNU Lesser General Public License zusammen mit 
 *    dieser Bibliothek erhalten haben; falls nicht, schreiben Sie an die FSF,
 *    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 *  history:	
 *		1.) 10.08.2004 Version 2.04
 *			a.)	- 
 *
 *****************************************************************************/
#include "project.h"            // USER defines

#include <avr/sleep.h>
#include <stdio.h>
#include <avr/io.h>
#include <avr/wdt.h>
#include <avr/pgmspace.h>
#include HARDWARE_H_FILEPATH    // see file "project.h" inside of your
                                // project path
#ifdef WEB_DEBUG
#include WEB_DEBUG_H_FILEPATH   // see file "project.h" inside of your
                                // project path
#endif
#include SERVER_H_FILEPATH      // see file "project.h" inside of your
                                // project path
//#include UDP_H_FILEPATH                               // see file "project.h" inside of your project path
#include UDP_H_SERVER_FILEPATH  // see file "project.h" inside of your
                                // project path


//#pragma regalloc-
//#pragma regalloc+

// *********************************************************************************
// Description  : main routine to start the USER-Program
// Input                : none
// Output       : none
// Indication   : none
// *********************************************************************************
int main(void)
{
   unsigned char counter_10ms_delay0 = 20;
   unsigned char counter_10ms_old;

   hardware_init();             // init microcontroller and interfaces
#ifdef UDP_ENABLE
   udp_server_init(33000);
#endif
#ifdef WEB_DEBUG
   web_debug_info(0x00);
#ifdef UDP_ENABLE
   if (server_ok)
      printf_P(PSTR("UDP-Server OK\r"));
   else
      printf_P(PSTR("UDP-Server Error"));
#endif
#endif
   counter_10ms_old = (unsigned char) counter_10ms_16bit;
/*
   LED1_OFF;                    // PortD.4 LED1
   LED2_OFF;                    // PortD.5 LED2
   LED3_OFF;                    // PortD.6 LED3
   LED4_OFF;                    // PortD.7 LED4
*/   
   while (1)
   {
//#asm("wdr");                    // Reset Watchdog
      wdt_reset();
    //  idle();                   // every time with IDLE-Mode
#ifdef UDP_ENABLE
      udp_server_main();
#endif
#ifdef WEB_DEBUG
      web_debug_command();
#endif
      if (counter_10ms_old != (unsigned char) counter_10ms_16bit)
      {
         counter_10ms_old = (unsigned char) counter_10ms_16bit;
         if (counter_10ms_delay0 > 0)
            counter_10ms_delay0--;
         else
         {
            counter_10ms_delay0 = 40;
/*
            if (LED1_PIN)
               LED1_ON;         // PortD.4 LED1
            else
               LED1_OFF;        // PortD.4 LED1
*/               
         }
      }
   }
}
