
/*****************************************************************************
 *
 *                              "arp_rarp.c"
 *                   -----------------------------
 *
 *  Version:    2.10
 *  File:     	..\..\arp_rarp.c
 *  Created:    03.04.2003
 *  Date:       24.08.2005
 *  Author:     Copyright (C) 2001-2005
 *              Udo Jakobza - FTZ Leipzig; D-04107 Leipzig; Wchterstr. 13
 *				info@easytoweb.net
 *  Func:		implements the ARP-Functions and provides a simple API to the user
 *  License:
 *    This library is free software; you can redistribute it and/or modify it
 *    under the terms of the GNU Lesser General Public License as published by
 *    the Free Software Foundation; either version 2.1 of the License, or
 *    (at your option) any later version. This library is distributed in the hope
 *    that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *    warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *    See the GNU Lesser General Public License for more details.
 *	  see: http://www.gnu.org/copyleft/lesser.html
 *    You should have received a copy of the GNU Lesser General Public License
 *    along with this library; if not, write to the Free Software Foundation,
 *    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *    Die Bibliothek ist freie Software; Sie drfen sie unter den Bedingungen der
 *    GNU Lesser General Public License, wie von der Free Software Foundation
 *    verffentlicht, weiterverteilen und/oder modifizieren; entweder gem
 *    Version 2.1 der Lizenz oder (nach Ihrer Option) jeder spteren Version.
 *    Diese Bibliothek wird in der Hoffnung weiterverbreitet, da sie ntzlich
 *    sein wird, jedoch OHNE IRGENDEINE GARANTIE, auch ohne die implizierte
 *    Garantie der MARKTREIFE oder der VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK.
 *    Mehr Details finden Sie in der GNU Lesser General Public License.
 *	  see: http://www.gnu.org/copyleft/lesser.de.html
 *    Sie sollten eine Kopie der GNU Lesser General Public License zusammen mit
 *    dieser Bibliothek erhalten haben; falls nicht, schreiben Sie an die FSF,
 *    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 *  history:
 *		1.) 30.07.2003 Version 2.00a
 *		2.) 25.02.2004 Version 2.03
 *			a.)	-
 *
 *****************************************************************************/
#include "project.h"

#if defined(ARP_ENABLE) || defined(RARP_ENABLE)

#include <stdio.h>
#include <string.h>
#include DEVICE_H_FILEPATH
#include ETHERNET_H_FILEPATH
#include BUFFER_H_FILEPATH
#include IP_H_FILEPATH
#ifdef TCP_ENABLE
#include TCP_H_FILEPATH
#endif
#include ARP_RARP_H_FILEPATH
#ifdef WEB_DEBUG_MEASURE
#include MEASURE_H_FILEPATH
#endif
#ifdef WEB_DEBUG
#include WEB_DEBUG_H_FILEPATH
#include DEBUG_H_FILEPATH
#endif

#ifdef __CODEVISIONAVR__
#pragma regalloc-
#endif
#if defined(ARP_ENABLE) && defined(ARP_CACHE_ENABLE)
ARP_CACHE_STRUCTURE arp_cache_buffer[ARP_CACHE_SIZE];
#endif

#ifdef __CODEVISIONAVR__
#pragma regalloc+
#endif

#if defined(WEB_DEBUG_ARP)||defined(WEB_DEBUG_RARP)
static const char ARP_IP[] PROGMEM = "ARP IP ";
static const char ARP_MAC[] PROGMEM = "ARP MAC";
#endif
#ifdef WEB_DEBUG_ARP
static const char ARP_IP_SRC[] PROGMEM = "ARP IP-Source     ";
static const char ARP_IP_DST[] PROGMEM = "ARP IP-Destination";
static const char ARP_SRC_MAC[] PROGMEM = "ARP Source-MAC";
static const char ARP_DST_MAC[] PROGMEM = "ARP Dest-MAC  ";
#endif
#ifdef WEB_DEBUG_RARP
static const char RARP_IP[] PROGMEM = "RARP IP";
static const char RARP_MAC[] PROGMEM = "RARP MAC";
static const char RARP_SRC_MAC[] PROGMEM = "RARP Source-MAC";
static const char RARP_DST_MAC[] PROGMEM = "RARP Dest-MAC  ";
static const char RARP_DST_IP[]  PROGMEM = "RARP Dest-IP   ";
#endif


void arp_rarp_process_frame(unsigned char broadcast_flag)
{
#if defined(WEB_DEBUG_ARP)||defined(WEB_DEBUG_RARP)
   static unsigned int arp_rarp_count = 0;
#endif
   unsigned char ip_destination[IP_ADR_SIZE] = RARP_DEFAULT_ANSWER_IP;
   unsigned int arp_rarp_option;

#ifdef WEB_DEBUG_MEASURE
#endif
#if defined(WEB_DEBUG_ARP)||defined(WEB_DEBUG_RARP)
   if (!broadcast_flag)
   {
      arp_rarp_count++;
      if (web_debug_flag & WEB_DEBUG_ARP_RARP_BIT)
         printf_P(PSTR("ARP_RARP Read-FRAME:%u\n"), arp_rarp_count);
   }
#else
   broadcast_flag = 0;
#endif
   if ((DEVICE_READ_FRAME_16BIT() == HARDW_ETH10) &&
       (DEVICE_READ_FRAME_16BIT() == IP_FRAME) &&
       (DEVICE_READ_FRAME_16BIT() == IP_HLEN_PLEN))
   {
      arp_rarp_option = DEVICE_READ_FRAME_16BIT();
#ifdef ARP_ENABLE
      if (arp_rarp_option == ARP_OP_ANSWER)
      {
         DEVICE_READ_FRAME_DATA(mac_of_last_frame, sizeof(mac_of_last_frame));
         DEVICE_READ_FRAME_DATA(ip_of_last_frame, IP_ADR_SIZE);
#ifdef WEB_DEBUG_ARP
         if (web_debug_flag & WEB_DEBUG_ARP_RARP_BIT)
         {
            printf_P(PSTR("ARP Answer\n"));
            debug_print_ip(ARP_IP, ip_of_last_frame);
            debug_print_mac(ARP_MAC, mac_of_last_frame);
         }
#endif
#ifdef ARP_CACHE_ENABLE
         arp_cache(ip_of_last_frame, mac_of_last_frame);
#endif
#ifdef TCP_ENABLE
         tcp_arp_resolved(mac_of_last_frame);
#endif
      }
      if (arp_rarp_option == ARP_OP_REQUEST)
      {
         DEVICE_READ_FRAME_DATA(mac_of_last_frame, sizeof(mac_of_last_frame));
         DEVICE_READ_FRAME_DATA(ip_of_last_frame, IP_ADR_SIZE);
         DEVICE_READ_FRAME_DUMMY(6);
         DEVICE_READ_FRAME_DATA(ip_destination, IP_ADR_SIZE);
//-         if (!memcmp(&ip_destination[0], &ip_address[0], IP_ADR_SIZE))
         if (*(long *)&ip_destination[0] == *(long *)&ip_address[0])
         {
#ifdef WEB_DEBUG_ARP
            if (web_debug_flag & WEB_DEBUG_ARP_RARP_BIT)
            {
               if (broadcast_flag)
                  printf_P(PSTR("ARP Read-FRAME: Broadcast:\n"));
               else
                  printf_P(PSTR("ARP Request\n"));
               debug_print_ip(ARP_IP_SRC, ip_of_last_frame);
               debug_print_ip(ARP_IP_DST, ip_destination);
            }
#endif
            arp_prepare_answer();
         }
      }
#endif
#ifdef RARP_ENABLE
      if (arp_rarp_option == RARP_OP_ANSWER)
      {
         DEVICE_READ_FRAME_DATA(mac_of_last_frame, sizeof(mac_of_last_frame));
         DEVICE_READ_FRAME_DATA(ip_of_last_frame, IP_ADR_SIZE);
#ifdef WEB_DEBUG_RARP
         if (web_debug_flag & WEB_DEBUG_ARP_RARP_BIT)
         {
            printf_P(PSTR("RARP Answer\n"));
            debug_print_ip(RARP_IP, ip_of_last_frame);
            debug_print_mac(RARP_MAC, mac_of_last_frame);
         }
#endif
      }
      if (arp_rarp_option == RARP_OP_REQUEST)
      {
         DEVICE_READ_FRAME_DATA(mac_of_last_frame, 6);
         DEVICE_READ_FRAME_DUMMY(4 + 6 + 4);
#ifdef WEB_DEBUG_RARP
         if (web_debug_flag & WEB_DEBUG_ARP_RARP_BIT)
            printf_P(PSTR("RARP Request\n"));
#endif
         rarp_prepare_answer(ip_destination);
      }
#endif
   }
   else
   {
#if defined(WEB_DEBUG_ARP)||defined(WEB_DEBUG_RARP)
      if (web_debug_flag & WEB_DEBUG_ARP_RARP_BIT)
         printf_P(PSTR("ARP_RARP wrong FRAME:%u\n"), arp_rarp_count);
#endif
   }
}


#ifdef ARP_ENABLE
#ifdef ARP_CACHE_ENABLE
unsigned char *arp_cache(unsigned char *ip_adr, unsigned char *mac_adr)
{
   static unsigned char write_position = 0;
   unsigned char Lva;

   if ((ip_adr == 0) && (mac_adr == 0))
   {
#ifdef WEB_DEBUG_ARP
      if (web_debug_flag & WEB_DEBUG_ARP_RARP_BIT)
         printf_P(PSTR("ARP Cache Error\n"));
#endif
      return 0x0;
   }
   if ((ip_adr != 0) && (mac_adr != 0))
   {
      for (Lva = 0; Lva < ARP_CACHE_SIZE; Lva++)
      {
         if ((ip_adr != 0x0)
             && (*(long *)ip_adr == *(long *)arp_cache_buffer[Lva].ip_adr))
//-             && (!memcmp(ip_adr, arp_cache_buffer[Lva].ip_adr, IP_ADR_SIZE)))
            break;
      }
      if (Lva >= ARP_CACHE_SIZE)
      {
         Lva = write_position;
         write_position++;
         if (write_position >= ARP_CACHE_SIZE)
            write_position = 0;
      }
      *(long *)arp_cache_buffer[Lva].ip_adr = *(long *)ip_adr;
//-      memcpy(arp_cache_buffer[Lva].ip_adr, ip_adr, IP_ADR_SIZE);
      memcpy(arp_cache_buffer[Lva].mac_adr, mac_adr, 6);
#ifdef WEB_DEBUG_ARP
      if (web_debug_flag & WEB_DEBUG_ARP_RARP_BIT)
      {
         printf_P(PSTR("ARP Write-Cache: %u\n"), Lva);
         debug_print_ip(ARP_IP, ip_adr);
         debug_print_mac(ARP_MAC, mac_adr);
      }
#endif
      return 0x0;
   }
   for (Lva = 0; Lva < ARP_CACHE_SIZE; Lva++)
   {
      if ((ip_adr != 0x0)
          && (*(long *)ip_adr == *(long *)arp_cache_buffer[Lva].ip_adr))
//-          && (!memcmp(ip_adr, arp_cache_buffer[Lva].ip_adr, IP_ADR_SIZE)))
      {
#ifdef WEB_DEBUG_ARP
         if (web_debug_flag & WEB_DEBUG_ARP_RARP_BIT)
         {
            printf_P(PSTR("ARP Read-MAC-Cache: %u\n"), Lva);
            debug_print_ip(ARP_IP, arp_cache_buffer[Lva].ip_adr);
            debug_print_mac(ARP_MAC, arp_cache_buffer[Lva].mac_adr);
         }
#endif
         return arp_cache_buffer[Lva].mac_adr;
      }
      if ((mac_adr != 0x0)
          && (!memcmp(mac_adr, arp_cache_buffer[Lva].mac_adr, 6)))
      {
#ifdef WEB_DEBUG_ARP
         if (web_debug_flag & WEB_DEBUG_ARP_RARP_BIT)
         {
            printf_P(PSTR("ARP Read-IP-Cache: %u\n"), Lva);
            debug_print_ip(ARP_IP, arp_cache_buffer[Lva].ip_adr);
            debug_print_mac(ARP_MAC, arp_cache_buffer[Lva].mac_adr);
         }
#endif
         return arp_cache_buffer[Lva].ip_adr;
      }
   }
   return 0x0;
}
#endif



void arp_prepare_request(unsigned char *arp_ip, ARP_REQUEST_MODE mode)
{
#ifdef WEB_DEBUG_MEASURE
   MEASURE_SETTIME(MEA_ARP_REQUEST_S)
#endif
   memset(&tx_frame2[ETH_DA_OFS], 0xFF, MAC_ADR_SIZE);
   memcpy(&tx_frame2[ETH_SA_OFS], &mac_address[0], MAC_ADR_SIZE);
   *(unsigned int *) &tx_frame2[ETH_TYPE_OFS] = SWAPB(ARP_FRAME);
   *(unsigned int *) &tx_frame2[ARP_HARDW_OFS] = SWAPB(HARDW_ETH10);
   *(unsigned int *) &tx_frame2[ARP_PROT_OFS] = SWAPB(IP_FRAME);
   *(unsigned int *) &tx_frame2[ARP_HLEN_PLEN_OFS] = SWAPB(IP_HLEN_PLEN);
   *(unsigned int *) &tx_frame2[ARP_OPCODE_OFS] = SWAPB(ARP_OP_REQUEST);
   memcpy(&tx_frame2[ARP_SENDER_HA_OFS], &mac_address[0], MAC_ADR_SIZE);
   memcpy(&tx_frame2[ARP_SENDER_IP_OFS], &ip_address[0], IP_ADR_SIZE);
   memset(&tx_frame2[ARP_TARGET_HA_OFS], 0x00, MAC_ADR_SIZE);
   if (mode == ARP_REQUEST_IP)
   {
      if (((arp_ip[0] ^ ip_address[0]) & ip_subnet_mask[0]) ||
          ((arp_ip[1] ^ ip_address[1]) & ip_subnet_mask[1]) ||
          ((arp_ip[2] ^ ip_address[2]) & ip_subnet_mask[2]) ||
          ((arp_ip[3] ^ ip_address[3]) & ip_subnet_mask[3]))
//         memcpy(&tx_frame2[ARP_TARGET_IP_OFS], &ip_gateway[0],
//                IP_ADR_SIZE);
         *(long *)&tx_frame2[ARP_TARGET_IP_OFS] = *(long *)&ip_gateway[0];
      else
         *(long *)&tx_frame2[ARP_TARGET_IP_OFS] = *(long *)arp_ip;
//-         memcpy(&tx_frame2[ARP_TARGET_IP_OFS], arp_ip, 4);
   }
   else if (mode == ARP_REQUEST_SELF)
   {
      memcpy(&tx_frame2[ARP_TARGET_HA_OFS], &mac_address[0], MAC_ADR_SIZE);
      *(long *)&tx_frame2[ARP_TARGET_IP_OFS] = *(long *)&ip_address[0];
//-      memcpy(&tx_frame2[ARP_TARGET_IP_OFS], &ip_address[0], IP_ADR_SIZE);
   }
   else if (mode == ARP_REQUEST_GATEWAY)
   {
//-      memcpy(&tx_frame2[ARP_TARGET_IP_OFS], &ip_gateway[0],
//-             IP_ADR_SIZE);
      *(long *)&tx_frame2[ARP_TARGET_IP_OFS] = *(long *)&ip_gateway[0];
   }
   tx_frame2_size = ETH_HEADER_SIZE + ARP_FRAME_SIZE;
   buffer_write_command(tx_frame2, tx_frame2_size);
#ifdef WEB_DEBUG_MEASURE
   MEASURE_SETTIME(MEA_ARP_REQUEST_E)
#endif
#ifdef WEB_DEBUG_ARP
   if (web_debug_flag & WEB_DEBUG_ARP_RARP_BIT)
   {
      printf_P(PSTR("ARP Write-REQUEST: %ubyte\n"), tx_frame2_size);
      debug_print_ip(ARP_IP, &tx_frame2[ARP_TARGET_IP_OFS]);
   }
#endif
}


void arp_prepare_answer(void)
{
#ifdef WEB_DEBUG_MEASURE
   MEASURE_SETTIME(MEA_ARP_ANSWER_S)
#endif
   memcpy(&tx_frame2[ETH_DA_OFS], &mac_of_last_frame[0], MAC_ADR_SIZE);
   memcpy(&tx_frame2[ETH_SA_OFS], &mac_address[0], MAC_ADR_SIZE);
   *(unsigned int *) &tx_frame2[ETH_TYPE_OFS] = SWAPB(ARP_FRAME);
   *(unsigned int *) &tx_frame2[ARP_HARDW_OFS] = SWAPB(HARDW_ETH10);
   *(unsigned int *) &tx_frame2[ARP_PROT_OFS] = SWAPB(IP_FRAME);
   *(unsigned int *) &tx_frame2[ARP_HLEN_PLEN_OFS] = SWAPB(IP_HLEN_PLEN);
   *(unsigned int *) &tx_frame2[ARP_OPCODE_OFS] = SWAPB(ARP_OP_ANSWER);
   memcpy(&tx_frame2[ARP_SENDER_HA_OFS], &mac_address[0], MAC_ADR_SIZE);
//-   memcpy(&tx_frame2[ARP_SENDER_IP_OFS], &ip_address[0], IP_ADR_SIZE);
   *(long *)&tx_frame2[ARP_SENDER_IP_OFS] = *(long *)&ip_address[0];
   memcpy(&tx_frame2[ARP_TARGET_HA_OFS], &mac_of_last_frame[0], MAC_ADR_SIZE);
//-   memcpy(&tx_frame2[ARP_TARGET_IP_OFS], &ip_of_last_frame[0], IP_ADR_SIZE);
   *(long *)&tx_frame2[ARP_TARGET_IP_OFS] = *(long *)&ip_of_last_frame[0];

   tx_frame2_size = ETH_HEADER_SIZE + ARP_FRAME_SIZE;
   buffer_write_command(tx_frame2, tx_frame2_size);
#ifdef WEB_DEBUG_MEASURE
   MEASURE_SETTIME(MEA_ARP_ANSWER_E)
#endif
#ifdef WEB_DEBUG_ARP
   if (web_debug_flag & WEB_DEBUG_ARP_RARP_BIT)
   {
      printf_P(PSTR("ARP Write-ANSWER: %ubyte\n"), tx_frame2_size);
      debug_print_mac(ARP_SRC_MAC, &tx_frame2[ARP_SENDER_HA_OFS]);
      debug_print_mac(ARP_DST_MAC, &tx_frame2[ARP_TARGET_HA_OFS]);
   }
#endif
}


void arp_request_timer(ARP_REQUEST_TIMER_MODE mode)
{
   static unsigned long arp_timer1 = 0;

   if ((arp_timer1 == 0) || (mode == ARP_REQUEST_TIMER_START))
   {
      arp_timer1 = 0;
      // ARP-Request to the easyToWeb-Server self - promote the MAC and IP to
      //
      // switch
      arp_prepare_request(ip_address, ARP_REQUEST_SELF);
      // send the frame to Ethernet-Controller
      if (mode == ARP_REQUEST_TIMER_START)
         buffer_process_wait();
      else
         buffer_process();
      // ARP-Request to the Gateway - promote the MAC and IP to the gateway
      arp_prepare_request(ip_address, ARP_REQUEST_GATEWAY);
      // send the frame to Ethernet-Controller
      if (mode == ARP_REQUEST_TIMER_START)
         buffer_process_wait();
      else
         buffer_process();
      arp_timer1 = 0xfffff * 10;
   }
   arp_timer1--;
}
#endif

#ifdef RARP_ENABLE
void rarp_prepare_request(void)
{
   memset(&tx_frame2[ETH_DA_OFS], 0xFF, MAC_ADR_SIZE);
   memcpy(&tx_frame2[ETH_SA_OFS], &mac_address[0], MAC_ADR_SIZE);
   *(unsigned int *) &tx_frame2[ETH_TYPE_OFS] = SWAPB(RARP_FRAME);
   *(unsigned int *) &tx_frame2[RARP_HARDW_OFS] = SWAPB(HARDW_ETH10);
   *(unsigned int *) &tx_frame2[RARP_PROT_OFS] = SWAPB(IP_FRAME);
   *(unsigned int *) &tx_frame2[RARP_HLEN_PLEN_OFS] = SWAPB(IP_HLEN_PLEN);
   *(unsigned int *) &tx_frame2[RARP_OPCODE_OFS] = SWAPB(RARP_OP_REQUEST);
   memcpy(&tx_frame2[RARP_SENDER_HA_OFS], &mac_address[0], MAC_ADR_SIZE);
   memset(&tx_frame2[RARP_SENDER_IP_OFS], 0x0, IP_ADR_SIZE);
   memcpy(&tx_frame2[RARP_TARGET_HA_OFS], &mac_address[0], MAC_ADR_SIZE);
   memset(&tx_frame2[RARP_TARGET_IP_OFS], 0x0, IP_ADR_SIZE);
   tx_frame2_size = ETH_HEADER_SIZE + RARP_FRAME_SIZE;
   buffer_write_command(tx_frame2, tx_frame2_size);
#ifdef WEB_DEBUG_RARP
   if (web_debug_flag & WEB_DEBUG_ARP_RARP_BIT)
   {
      printf_P(PSTR("RARP Write-REQUEST: %ubyte\n"), tx_frame2_size);
      debug_print_mac(RARP_MAC, &tx_frame2[RARP_TARGET_HA_OFS]);
   }
#endif
}

void rarp_prepare_answer(unsigned char *rarp_ip)
{
   memcpy(&tx_frame2[ETH_DA_OFS], &mac_of_last_frame[0], MAC_ADR_SIZE);
   memcpy(&tx_frame2[ETH_SA_OFS], &mac_address[0], MAC_ADR_SIZE);
   *(unsigned int *) &tx_frame2[ETH_TYPE_OFS] = SWAPB(RARP_FRAME);
   *(unsigned int *) &tx_frame2[RARP_HARDW_OFS] = SWAPB(HARDW_ETH10);
   *(unsigned int *) &tx_frame2[RARP_PROT_OFS] = SWAPB(IP_FRAME);
   *(unsigned int *) &tx_frame2[RARP_HLEN_PLEN_OFS] = SWAPB(IP_HLEN_PLEN);
   *(unsigned int *) &tx_frame2[RARP_OPCODE_OFS] = SWAPB(RARP_OP_ANSWER);
   memcpy(&tx_frame2[RARP_SENDER_HA_OFS], &mac_address[0], MAC_ADR_SIZE);
//-   memcpy(&tx_frame2[RARP_SENDER_IP_OFS], &ip_address[0], IP_ADR_SIZE);
   *(long *)&tx_frame2[RARP_SENDER_IP_OFS] = *(long *)&ip_address[0];
   memcpy(&tx_frame2[RARP_TARGET_HA_OFS], &mac_of_last_frame[0], MAC_ADR_SIZE);
//-   memcpy(&tx_frame2[RARP_TARGET_IP_OFS], rarp_ip, IP_ADR_SIZE);
   *(long *)&tx_frame2[RARP_TARGET_IP_OFS] = *(long *)rarp_ip;

   tx_frame2_size = ETH_HEADER_SIZE + RARP_FRAME_SIZE;
   buffer_write_command(tx_frame2, tx_frame2_size);
#ifdef WEB_DEBUG_RARP
   if (web_debug_flag & WEB_DEBUG_ARP_RARP_BIT)
   {
      printf_P(PSTR("RARP Write-ANSWER: %ubyte\n"), tx_frame2_size);
      debug_print_mac(RARP_SRC_MAC, &tx_frame2[RARP_SENDER_HA_OFS]);
      debug_print_mac(RARP_DST_MAC, &tx_frame2[RARP_TARGET_HA_OFS]);
      debug_print_ip(RARP_DST_IP, &tx_frame2[RARP_TARGET_IP_OFS]);
   }
#endif
}
#endif

#endif

