
/*****************************************************************************
 *
 *                              "ati.c"
 *                   -----------------------------
 *
 *  Version:    1.00
 *  File:     	ati.c
 *  Created:    10.12.2004
 *  Date:       06.09.2005
 *  Author:     Copyright (C) 2001-2005
 *              Mirco Fuchs, Udo Jakobza
 *              FTZ Leipzig; D-04107 Leipzig; Wchterstr. 13
 *				info@easytoweb.net
 *  Func:		interface to AT-Device
 *  license:
 *   This library is free software; you can redistribute it and/or modify it
 *   under the terms of the GNU Lesser General Public License as published by
 *   the Free Software Foundation; either version 2.1 of the License, or
 *   (at your option) any later version. This library is distributed in the hope
 *   that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *   warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *   See the GNU Lesser General Public License for more details.
 *	 see: http://www.gnu.org/copyleft/lesser.html
 *   You should have received a copy of the GNU Lesser General Public License
 *   along with this library; if not, write to the Free Software Foundation,
 *   Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *   Die Bibliothek ist freie Software; Sie drfen sie unter den Bedingungen der
 *   GNU Lesser General Public License, wie von der Free Software Foundation
 *   verffentlicht, weiterverteilen und/oder modifizieren; entweder gem
 *   Version 2.1 der Lizenz oder (nach Ihrer Option) jeder spteren Version.
 *   Diese Bibliothek wird in der Hoffnung weiterverbreitet, da sie ntzlich
 *   sein wird, jedoch OHNE IRGENDEINE GARANTIE, auch ohne die implizierte
 *   Garantie der MARKTREIFE oder der VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK.
 *   Mehr Details finden Sie in der GNU Lesser General Public License.
 *	 see: http://www.gnu.org/copyleft/lesser.de.html
 *   Sie sollten eine Kopie der GNU Lesser General Public License zusammen mit
 *   dieser Bibliothek erhalten haben; falls nicht, schreiben Sie an die FSF,
 *   Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 *  history:
 *	1.) 10.12.2004 Version 1.00
 *		a.)	-
 * *****************************************************************************/
#include "project.h"

#include <avr/io.h>
#include <stdio.h>
#include <string.h>
//#include <avr/delay.h>
#include <ctype.h>
#include HARDWARE_H_FILEPATH
#include ATI_H_FILEPATH
#ifdef WEB_DEBUG_ATI
#include ATI_DEBUG_H_FILEPATH
#endif
#ifdef WEB_DEBUG
#include WEB_DEBUG_H_FILEPATH
#endif

#ifdef __CODEVISIONAVR__
#pragma regalloc-
#endif
unsigned char ati_tx_buffer[ATI_TX_BUFFER_SIZE];
unsigned char ati_rx_buffer[ATI_RX_BUFFER_SIZE];
unsigned char ati_user_buffer[ATI_RX_BUFFER_SIZE];

unsigned char *p_ati_tx_buffer_s;
unsigned char *p_ati_tx_buffer_w;
unsigned char volatile *p_ati_rx_buffer;

unsigned char *p_ati_response_start;
unsigned char *p_ati_response_stop;

unsigned char ati_disconnect_flag = 0;

#ifdef ATI_ANSWER_ENABLE_DEFAULT
unsigned char ati_answer_flag = ATI_ANSWER_ENABLED;
#else
unsigned char ati_answer_flag = ATI_ANSWER_DISABLED;
#endif

unsigned char ati_old_time;
unsigned char ati_timeout_next_char;
unsigned int ati_timeout_answer;

volatile ATI_STATE ati_state;
volatile ATI_STATE ati_state_old;

ATI_DEVICE_MODE ati_device_mode;
ATI_DEVICE_MODE ati_device_nextmode;

ATI_DEVICE_RESPONSE ati_device_response;
ATI_USER_INFO ati_user_info;

#ifdef __CODEVISIONAVR__
#pragma regalloc+
#endif

static const char modem_at[] PROGMEM = "AT";
static const char modem_ata[] PROGMEM = "ATA";
static const char modem_atd[] PROGMEM = "ATD";
static const char modem_ath[] PROGMEM = "ATH";
//static const char modem_atUd0[] PROGMEM = "AT&D0";
//static const char modem_atUk0[] PROGMEM = "AT&K0";
//static const char modem_atm2[] PROGMEM = "ATM2";
//static const char modem_atX3[] PROGMEM = "ATX3";
static const char modem_atz[] PROGMEM = "ATZ";

static const char modem_OK[] PROGMEM = "OK";
static const char modem_PPP[] PROGMEM = "+++";
static const char modem_NO_CARRIER[] PROGMEM = "NO CARRIER";
static const char modem_RING[] PROGMEM = "RING";
static const char modem_CONNECT[] PROGMEM = "CONNECT";
#ifdef WEB_DEBUG_ATI
static const char ati_mem_ovl[] PROGMEM = "ATI Memory overflow, try again\n";
#endif


void ati_send_command(void);
unsigned char ati_check_tx_buffer(void);
unsigned char ati_rsp_awaited(void);
void ati_check_rx_buffer(void);

void ati_state_machine(void)
{
   unsigned char ret;           // to store the return-value of the functions

   switch (ati_state)
   {
   case ATI_STATE_BUFFER_EMPTY:
      break;
   case ATI_STATE_BUFFER_FILLED:
      ati_send_command();
      if (ati_state != ATI_STATE_RECEIVE_DATA)
         ati_state = ATI_STATE_RSP_AWAITED;
      else
         ati_state_old = ATI_STATE_RSP_AWAITED;
      break;
   case ATI_STATE_CHECK_BUFFER:
      ret = ati_check_tx_buffer();
      if (ati_state != ATI_STATE_RECEIVE_DATA)
      {
         if (ret == ATI_STATE_BUFFER_FILLED)
            ati_state = ATI_STATE_BUFFER_FILLED;
         else
            ati_state = ATI_STATE_BUFFER_EMPTY;
      }
      else
      {
         if (ret == ATI_STATE_BUFFER_FILLED)
            ati_state_old = ATI_STATE_BUFFER_FILLED;
         else
            ati_state_old = ATI_STATE_BUFFER_EMPTY;
      }
      break;
   case ATI_STATE_RSP_AWAITED:
      ret = ati_rsp_awaited();
      if (ati_state != ATI_STATE_RECEIVE_DATA)
      {
         if (ret == ATI_STATE_CHECK_BUFFER)
            ati_state = ATI_STATE_CHECK_BUFFER;
         else
            ati_state = ATI_STATE_RSP_AWAITED;
      }
      else
      {
         if (ret == ATI_STATE_CHECK_BUFFER)
            ati_state_old = ATI_STATE_CHECK_BUFFER;
         else
            ati_state_old = ATI_STATE_RSP_AWAITED;
      }
      break;
   case ATI_STATE_RECEIVE_DATA:
      ati_check_rx_buffer();
      if (ati_timeout_next_char == 0)
         ati_state = ati_state_old;
      break;
   default:
      break;
   }                            // end
   // switch
#ifdef WEB_DEBUG_ATI
   if (web_debug_flag & WEB_DEBUG_ATI_BIT)
   {
      ati_debug_print_state_change();
      ati_debug_print_mode_change();
   }
#endif
}

void ati_init(void)
{
#ifdef WEB_DEBUG_ATI
   if (web_debug_flag & WEB_DEBUG_ATI_BIT)
      printf_P(PSTR("ATI Starting initialisation ...\n"));
#endif
   p_ati_tx_buffer_w = ati_tx_buffer;
   p_ati_tx_buffer_s = ati_tx_buffer;
   p_ati_rx_buffer = ati_rx_buffer;
   ati_state = ATI_STATE_BUFFER_EMPTY;
   ati_device_response = ATI_DEVICE_RESPONSE_NO;
   ati_device_mode = ATI_DEVICE_MODE_COMMAND;
   ati_device_nextmode = ATI_DEVICE_MODE_COMMAND;

#ifdef AT_DEVICE_MODEM
   DDRB  |= (1<<4);// .4 = 1;
   PORTB |= (1<<4);// .4 = 1;
   ati_write_data_flash(modem_atz);
   ati_write_data_flash(PSTR("AT&D0"));
   ati_write_data_flash(PSTR("AT&K0"));
   ati_write_data_flash(PSTR("ATM2"));
   ati_write_data_flash(PSTR("ATX3"));
#endif

#ifdef AT_DEVICE_BLUETOOTH
   AT_DEVICE_INTERFACE_IRQ_DISABLE();
   DDRF  |= 0x08;
   PORTF &= ~0x08;
   for(char i=0; i < 10; i++)
    delay_ms(10);
   PORTF |= 0x08;
   for(int j=0; j < 500; j++)
    delay_ms(10);
   AT_DEVICE_INTERFACE_IRQ_ENABLE();
   ati_write_data_flash(modem_atz);
   ati_write_data_flash(PSTR("ATS0=0"));
#endif
#ifdef WEB_DEBUG_ATI
   if (web_debug_flag & WEB_DEBUG_ATI_BIT)
      printf_P(PSTR("ATI initialised\n"));
#endif
}


unsigned char ati_rsp_awaited(void)
{
   unsigned char *p_ati_answer;
   unsigned char response_found = 0;
   unsigned char lf_passed = 0;
   unsigned char response_end = 0;
   unsigned char response_length;

#ifdef WEB_DEBUG_ATI
   unsigned char *p_temp;
#endif

   p_ati_answer = p_ati_response_stop;
   switch (ati_device_response)
   {
   case ATI_DEVICE_RESPONSE_YES:
      *p_ati_answer = '\0';
      while (response_found == 0)
      {
         switch (*p_ati_answer--)
         {
         case ATI_LF:
            lf_passed = 1;
            break;
         case ATI_CR:
            if ((response_end == 0) && (lf_passed == 1))
            {
               response_end = 1;
               lf_passed = 0;
            }
            if ((response_end == 1) && (lf_passed == 1))
            {
               p_ati_answer += 3;
               lf_passed = 0;
               response_end = 0;
               response_found = 1;
            }
            break;
         default:
            lf_passed = 0;
         }
      }
      response_length = (p_ati_response_stop + 1) - p_ati_response_start;
      strncpy(ati_user_buffer, p_ati_response_start, response_length);
      ati_user_info = ATI_USER_INFO_BUFFER_FILLED;
#ifdef WEB_DEBUG_ATI
      if (web_debug_flag & WEB_DEBUG_ATI_BIT)
      {
         p_temp = p_ati_response_start;
         printf_P(PSTR("ATI AT-Device answer: \""));
         while (*p_temp != 0)
         {
            if (isprint(*p_temp))
               printf_P(PSTR("%c"), *p_temp);
            p_temp++;
         }
         printf_P(PSTR("\"\n"));
      }
#endif
      switch (ati_device_mode)
      {
      case ATI_DEVICE_MODE_COMMAND:
         break;
      case ATI_DEVICE_MODE_CARRIER:
         if (ati_device_nextmode == ATI_DEVICE_MODE_ONLINE)
         {
            if (strncmp_P(p_ati_answer, modem_CONNECT, 7) == 0)
            {
               ati_device_mode = ATI_DEVICE_MODE_ONLINE;
               ati_device_nextmode = ATI_DEVICE_MODE_ONLINE;
#ifdef WEB_DEBUG_ATI
               if (web_debug_flag & WEB_DEBUG_ATI_BIT)
                  printf_P(PSTR("ATI Connected. Online mode\n"));
#endif
            }
            else
            {

               ati_device_mode = ATI_DEVICE_MODE_COMMAND;
               ati_device_nextmode = ATI_DEVICE_MODE_COMMAND;
#ifdef WEB_DEBUG_ATI
               if (web_debug_flag & WEB_DEBUG_ATI_BIT)
                  printf_P(PSTR("ATI Conection failed. Command mode\n"));
#endif
               ati_write_data_flash(modem_ath);
            }
         }
         else if (ati_device_nextmode == ATI_DEVICE_MODE_COMMAND_ONLINE)
         {
            if (strncmp_P(p_ati_answer, modem_OK, sizeof(modem_OK)-1) == 0)
            {

#ifdef WEB_DEBUG_ATI
               if (web_debug_flag & WEB_DEBUG_ATI_BIT)
                  printf_P(PSTR("ATI Online command mode\n"));
#endif
               ati_device_mode = ATI_DEVICE_MODE_COMMAND_ONLINE;
               ati_device_nextmode = ATI_DEVICE_MODE_COMMAND_ONLINE;
               if (ati_disconnect_flag)
               {
                  ati_disconnect_flag = 0;
                  ati_write_data_flash(modem_ath);
               }
            }
            else
            {
#ifdef WEB_DEBUG_ATI
               if (web_debug_flag & WEB_DEBUG_ATI_BIT)
                  printf_P(PSTR("ATI Connection failed. Command mode\n"));
#endif
               ati_write_data_flash(modem_ath);
               ati_device_mode = ATI_DEVICE_MODE_COMMAND;
               ati_device_nextmode = ATI_DEVICE_MODE_COMMAND;
            }
         }
         else if (ati_device_nextmode == ATI_DEVICE_MODE_COMMAND)
         {

            if ((strncmp_P(p_ati_answer, modem_OK, sizeof(modem_OK)-1) == 0) ||
                (strncmp_P(p_ati_answer, modem_NO_CARRIER, sizeof(modem_NO_CARRIER)-1) == 0))
            {
#ifdef WEB_DEBUG_ATI
               if (web_debug_flag & WEB_DEBUG_ATI_BIT)
                  printf_P(PSTR("ATI Command mode\n"));
#endif
               ati_device_mode = ATI_DEVICE_MODE_COMMAND;
               ati_device_nextmode = ATI_DEVICE_MODE_COMMAND;
            }
         }
         break;
      default:
         break;
      }
      ati_device_response = ATI_DEVICE_RESPONSE_NO;
      return ATI_STATE_CHECK_BUFFER;
      break;
   case ATI_DEVICE_RESPONSE_NO:
      if (ati_old_time != (unsigned char) counter_10ms_16bit)
      {
         ati_old_time = (unsigned char) counter_10ms_16bit;
         ati_timeout_answer--;
      }
      if (ati_timeout_answer == 0)
      {
#ifdef WEB_DEBUG_ATI
         if (web_debug_flag & WEB_DEBUG_ATI_BIT)
            printf_P(PSTR("ATI TIMEOUT\n"));
#endif
         ati_user_info = ATI_USER_INFO_TIMEOUT;
         // a stabil functionality of the AT-device is not longer guaranted
         // use ati_get_answer to detect ATI_USER_INFO_TIMEOUT, then reset
         // the device
         // using ati_init();
         ati_device_mode = ATI_DEVICE_MODE_COMMAND;
         ati_device_nextmode = ATI_DEVICE_MODE_COMMAND;
         return ATI_STATE_CHECK_BUFFER;
      }
      return ATI_STATE_RSP_AWAITED;
      break;
   }
   return ATI_STATE_UNREACHED;
}  // unsigned char ati_rsp_awaited(void)

void ati_send_command(void)
{
   unsigned char ati_strlength;

   ati_strlength = *p_ati_tx_buffer_s++;

#ifdef WEB_DEBUG_ATI
   if (web_debug_flag & WEB_DEBUG_ATI_BIT)
      printf_P(PSTR("ATI Waiting for AT-Device answer\n"));
#endif

   while (ati_strlength-- > 0)
   {
      if (p_ati_tx_buffer_s > &ati_tx_buffer[ATI_TX_BUFFER_SIZE - 1])
      {
         p_ati_tx_buffer_s = ati_tx_buffer;
      }
      AT_DEVICE_INTERFACE_SEND_DATA(*p_ati_tx_buffer_s++);
   }
   AT_DEVICE_INTERFACE_SEND_DATA(ATI_CR);
   if (p_ati_tx_buffer_s > &ati_tx_buffer[ATI_TX_BUFFER_SIZE - 1])
   {
      p_ati_tx_buffer_s = ati_tx_buffer;
   }
   ati_timeout_answer = ATI_TIMEOUT_ANSWER;
   ati_user_info = ATI_USER_INFO_BUFFER_EMPTY;
}                               // end

                                                                                                                               // void
                                                                                                                               //
                                                                                                                               // ati_send_command(void)



unsigned char ati_check_tx_buffer(void)
{
   if (p_ati_tx_buffer_w != p_ati_tx_buffer_s)
      return ATI_STATE_BUFFER_FILLED;
   else
      return ATI_STATE_BUFFER_EMPTY;
}

void ati_check_rx_buffer(void)
{
   unsigned char *p_ati_rx_buffer_local = ati_rx_buffer;
   char response_begin = 0;
   char cr_passed = 0;

   if (ati_old_time != (unsigned char) counter_10ms_16bit)
   {
      ati_old_time = (unsigned char) counter_10ms_16bit;
      ati_timeout_next_char--;
   }
   if (ati_timeout_next_char == 0)
   {
      while (p_ati_rx_buffer_local < p_ati_rx_buffer)
      {
         switch (*p_ati_rx_buffer_local++)
         {
         case ATI_CR:
            cr_passed = 1;
            break;
         case ATI_LF:
            if (cr_passed && (response_begin == 0))
            {
               cr_passed = 0;
               response_begin = 1;
               p_ati_response_start = (p_ati_rx_buffer_local - 2);
               p_ati_rx_buffer_local = (unsigned char *)(p_ati_rx_buffer - 2);
            }
            else if (cr_passed && (response_begin == 1))
            {
               cr_passed = 0;
               response_begin = 0;
               p_ati_response_stop = (unsigned char *)p_ati_rx_buffer;
               if (ati_state_old == ATI_STATE_RSP_AWAITED)
                  ati_device_response = ATI_DEVICE_RESPONSE_YES;
               else
               {

                  if (strncmp_P((p_ati_response_start + 2), modem_RING, sizeof(modem_RING)-1) == 0)
                  {
#ifdef WEB_DEBUG_ATI
                     if (web_debug_flag & WEB_DEBUG_ATI_BIT)
                        printf_P(PSTR("ATI Incomming Call\n"));
#endif
                     if (ati_answer_flag == ATI_ANSWER_ENABLED)
                        ati_write_data_flash(modem_ata);
                  }
               }
            }
            break;
         default:
            cr_passed = 0;
         }
      }                         // end
      // while
      p_ati_rx_buffer = ati_rx_buffer;
   }                            // end
   // if(ati_timeout_next_char ==  0)
}  // end

                                                                                                                               // void
                                                                                                                               //
                                                                                                                               // ati_check_rx_buffer(void)
/*
  void ati_receive_data(unsigned char reveived_data)
*/
/*
 * Wird von Empfangs-Interrupt aufgerufen
 */
void ati_receive_data(unsigned char received_data)
{
#ifdef WEB_DEBUG_ATI_RECEIVE
   putchar(received_data);
#endif
   if (ati_device_mode != ATI_DEVICE_MODE_ONLINE)
   {
      if (ati_state != ATI_STATE_RECEIVE_DATA)
         ati_state_old = ati_state;
      ati_state = ATI_STATE_RECEIVE_DATA;
      ati_timeout_next_char = ATI_TIMEOUT_NEXT_CHAR;
      *p_ati_rx_buffer++ = received_data;
   }
   else if (ati_device_mode == ATI_DEVICE_MODE_ONLINE)
   {
      RECEIVE_FUNCTION(received_data);
   }
}  // end

/*
 unsigned char ati_write_data_flash(flash unsigned char *ati_data)
*/
unsigned char ati_write_data_flash(PGM_P ati_data)
{
   unsigned char ati_string[ATI_STRING_LENGTH];

//   if (strlen_P(ati_data) < ATI_STRING_LENGTH)
      strncpy_P(ati_string, ati_data, ATI_STRING_LENGTH);
   return ati_write_data(ati_string);
}


unsigned char ati_write_data(unsigned char *ati_data)
{
   unsigned char ati_strlength;
   unsigned char first_char = 1;
   unsigned char offset_a;
   unsigned char offset_b;
   unsigned char *p_temp;

   p_temp = ati_data;
   while (*p_temp != 0)
   {
      *p_temp = toupper(*p_temp);
      p_temp++;
   }
   switch (ati_device_mode)
   {
   case ATI_DEVICE_MODE_COMMAND:
      if (strncmp_P(ati_data, modem_at, sizeof(modem_at)-1) != 0)
      {
#ifdef WEB_DEBUG_ATI
         if (web_debug_flag & WEB_DEBUG_ATI_BIT)
            printf_P(PSTR("ATI Only AT-commands allowed in this mode\n"));
#endif
         return ATI_WRITE_ONLY_AT_COMMANDS;
      }
      switch (*(ati_data + sizeof(modem_at)-1))
      {
      case 'A':
#ifdef WEB_DEBUG_ATI
         if (web_debug_flag & WEB_DEBUG_ATI_BIT)
            printf_P(PSTR("ATI Answering incomming call..\n"));
#endif
         ati_device_mode = ATI_DEVICE_MODE_CARRIER;
         ati_device_nextmode = ATI_DEVICE_MODE_ONLINE;
         break;
      case 'D':
#ifdef WEB_DEBUG_ATI
         if (web_debug_flag & WEB_DEBUG_ATI_BIT)
            printf_P(PSTR("ATI Dialing ..\n"));
#endif
         ati_device_mode = ATI_DEVICE_MODE_CARRIER;
         ati_device_nextmode = ATI_DEVICE_MODE_ONLINE;
         break;
      case 'H':
#ifdef WEB_DEBUG_ATI
         if (web_debug_flag & WEB_DEBUG_ATI_BIT)
            printf_P(PSTR("ATI Hanging up\n"));
#endif
         ati_device_mode = ATI_DEVICE_MODE_CARRIER;
         ati_device_nextmode = ATI_DEVICE_MODE_COMMAND;
      default:
         ati_device_mode = ATI_DEVICE_MODE_COMMAND;
         ati_device_nextmode = ATI_DEVICE_MODE_COMMAND;
      }
      break;
   case ATI_DEVICE_MODE_CARRIER:
#ifdef WEB_DEBUG_ATI
      if (web_debug_flag & WEB_DEBUG_ATI_BIT)
         printf_P(PSTR("ATI No command allowed in this mode!\n"));
#endif
      return ATI_WRITE_ACCESS_DENIED;
      break;
   case ATI_DEVICE_MODE_ONLINE:
      if (strncmp_P(ati_data, modem_PPP, sizeof(modem_PPP)-1) == 0)
      {
#ifdef WEB_DEBUG_ATI
         if (web_debug_flag & WEB_DEBUG_ATI_BIT)
            printf_P(PSTR("ATI Entering online command mode 2.5sec wait ...\n"));
#endif
         for(char i=0; i < 100; i++)
           delay_ms(10);
         AT_DEVICE_INTERFACE_SEND_DATA('+');
         AT_DEVICE_INTERFACE_SEND_DATA('+');
         AT_DEVICE_INTERFACE_SEND_DATA('+');
         for(char i=0; i < 150; i++)
            delay_ms(10);
         strcpy_P(ati_data, modem_at);
         ati_device_mode = ATI_DEVICE_MODE_CARRIER;
         ati_device_nextmode = ATI_DEVICE_MODE_COMMAND_ONLINE;
      }
      else
      {
         if ((strncmp_P(ati_data, modem_at, sizeof(modem_at)-1) == 0))
         {
#ifdef WEB_DEBUG_ATI
            if (web_debug_flag & WEB_DEBUG_ATI_BIT)
               printf_P(PSTR("ATI Command entered + Online\n"));
#endif
         }
         while (*ati_data != '\0')
            AT_DEVICE_INTERFACE_SEND_DATA(*ati_data++);
         return ATI_WRITE_DATA_SEND;
      }
      break;
   case ATI_DEVICE_MODE_COMMAND_ONLINE:
      if (strncmp_P(ati_data, modem_at, sizeof(modem_at)-1) != 0)
      {
#ifdef WEB_DEBUG_ATI
         if (web_debug_flag & WEB_DEBUG_ATI_BIT)
            printf_P(PSTR("ATI Only AT-commands allowed in this mode.\n"));
#endif
         return ATI_WRITE_ONLY_AT_COMMANDS;
      }
      switch (*(ati_data + sizeof(modem_at)-1))
      {
      case 'H':
#ifdef WEB_DEBUG_ATI
         if (web_debug_flag & WEB_DEBUG_ATI_BIT)
            printf_P(PSTR("ATI Hanging Up\n"));
#endif
         ati_device_mode = ATI_DEVICE_MODE_CARRIER;
         ati_device_nextmode = ATI_DEVICE_MODE_COMMAND;
         break;
      case 'O':
#ifdef WEB_DEBUG_ATI
         if (web_debug_flag & WEB_DEBUG_ATI_BIT)
            printf_P(PSTR("ATI Returning to online mode\n"));
#endif
         ati_device_mode = ATI_DEVICE_MODE_CARRIER;
         ati_device_nextmode = ATI_DEVICE_MODE_ONLINE;
         break;
      default:
         ati_device_mode = ATI_DEVICE_MODE_COMMAND_ONLINE;
         ati_device_nextmode = ATI_DEVICE_MODE_COMMAND_ONLINE;
      }
      break;
   default:
      break;
   }  // end switch(ati_device_mode)
#ifdef WEB_DEBUG_ATI
   if (web_debug_flag & WEB_DEBUG_ATI_BIT)
      ati_debug_print_mode_change();
#endif
   ati_strlength = (unsigned char) strlen(ati_data);
   offset_a = 0;
   offset_b = 0;
   while (ati_strlength > 0)
   {
      if ((p_ati_tx_buffer_w + offset_a + 1) != p_ati_tx_buffer_s)
      {
         if (first_char)
         {
            *(p_ati_tx_buffer_w + offset_a++) = ati_strlength;
            first_char = 0;
         }
         else
         {
            *(p_ati_tx_buffer_w + offset_a++) = *(ati_data + offset_b++);
            ati_strlength--;
         }
         if ((p_ati_tx_buffer_w + offset_a) ==
             &ati_tx_buffer[ATI_TX_BUFFER_SIZE])
         {
            if ((ati_tx_buffer + ati_strlength) < p_ati_tx_buffer_s)
            {
               p_ati_tx_buffer_w = ati_tx_buffer;
               offset_a = 0;
            }
            else
            {
#ifdef WEB_DEBUG_ATI
               if (web_debug_flag & WEB_DEBUG_ATI_BIT)
                  printf_P(ati_mem_ovl);
#endif
               return ATI_WRITE_MEMORY_OVERFLOW;
            }
         }
      }  // end
      // if
      else
      {
#ifdef WEB_DEBUG_ATI
         if (web_debug_flag & WEB_DEBUG_ATI_BIT)
            printf_P(ati_mem_ovl);
#endif
         return ATI_WRITE_MEMORY_OVERFLOW;
      }                         // end
      // else
   }  // end while(ati_strlength > 0)
   p_ati_tx_buffer_w += offset_a;
   if (ati_state == ATI_STATE_BUFFER_EMPTY)
      ati_state = ATI_STATE_CHECK_BUFFER;
   else if ((ati_state == ATI_STATE_RECEIVE_DATA)
            && (ati_state_old == ATI_STATE_BUFFER_EMPTY))
   {
      ati_state_old = ATI_STATE_CHECK_BUFFER;
   }
   return ATI_WRITE_COMMAND_WROTE;
}  // end unsigned char ati_write_data(unsigned char ati_data)


unsigned char ati_get_device_mode(unsigned char show_answer)
{
#ifdef WEB_DEBUG_ATI
   if ((web_debug_flag & WEB_DEBUG_ATI_BIT) && show_answer)
      printf("ATI ati_device_mode: %p\r\n",
             ati_device_mode_debug[ati_device_mode]);
#else
   show_answer = 0;
#endif
   switch (ati_device_mode)
   {
   case ATI_DEVICE_MODE_COMMAND:
      return ATI_MODE_COMMAND;
   case ATI_DEVICE_MODE_ONLINE:
      return ATI_MODE_ONLINE;
   case ATI_DEVICE_MODE_COMMAND_ONLINE:
      return ATI_MODE_ONLINE_COMMAND;
   case ATI_DEVICE_MODE_CARRIER:
#ifdef WEB_DEBUG_ATI
      if ((web_debug_flag & WEB_DEBUG_ATI_BIT) && show_answer)
         printf("ATI ati_device_nextmode: %p\r\n",
                ati_device_mode_debug[ati_device_nextmode]);
#endif
      switch (ati_device_nextmode)
      {
      case ATI_DEVICE_MODE_COMMAND:
         return ATI_MODE_COMMAND_ENTERING;
      case ATI_DEVICE_MODE_ONLINE:
         return ATI_MODE_ONLINE_ENTERING;
      case ATI_DEVICE_MODE_COMMAND_ONLINE:
         return ATI_MODE_ONLINE_COMMAND_ENTER;
      default:
         break;
      }
      break;
   default:
      break;
   }  // end switch(ati_device_mode)
   return ATI_DEVICE_UNREACHED;
}

unsigned char *ati_get_new_answer(void)
{
   switch (ati_user_info)
   {
   case ATI_USER_INFO_BUFFER_FILLED:
#ifdef WEB_DEBUG_ATI
      if (web_debug_flag & WEB_DEBUG_ATI_BIT)
      {
         printf_P(PSTR("ATI Answer:\n"));
         puts(ati_user_buffer);
         printf_P(PSTR("\n"));
      }
#endif
      return ati_user_buffer;
      break;
   case ATI_USER_INFO_BUFFER_EMPTY:
#ifdef WEB_DEBUG_ATI
      if (web_debug_flag & WEB_DEBUG_ATI_BIT)
         printf_P(PSTR("ATI No new answer available!\n"));
#endif
      break;
   case ATI_USER_INFO_TIMEOUT:
#ifdef WEB_DEBUG_ATI
      if (web_debug_flag & WEB_DEBUG_ATI_BIT)
         printf_P(PSTR("ATI Timeout occured\n"));
#endif
      break;
   }
   return 0x0;
}

unsigned char ati_connect(unsigned char *destination)
{
   unsigned char ati_string[ATI_STRING_LENGTH];

   strcpy_P(ati_string, modem_atd);
   strcat(ati_string, destination);
   if (ati_write_data(ati_string) == ATI_WRITE_COMMAND_WROTE)
      return ATI_CONNECT_DISCONNECT_OK;
   else
      return ATI_CONNECT_DISCONNECT_ERROR;
}


unsigned char ati_disconnect(void)
{
   if (!ati_disconnect_flag)
   {
      switch (ati_get_device_mode(ATI_ANSWER_HIDE))
      {
      case ATI_MODE_ONLINE:
         if (ati_write_data_flash(modem_PPP) == ATI_WRITE_COMMAND_WROTE)
         {
            ati_disconnect_flag = 1;
#ifdef WEB_DEBUG_ATI
            if (web_debug_flag & WEB_DEBUG_ATI_BIT)
               printf_P(PSTR("ATI Disconnecting ...\n"));
#endif
            return ATI_CONNECT_DISCONNECT_OK;
         }
         else
#ifdef WEB_DEBUG_ATI
         if (web_debug_flag & WEB_DEBUG_ATI_BIT)
            printf_P(PSTR("ATI Error\n"));
#endif
         return ATI_CONNECT_DISCONNECT_ERROR;
         break;
      default:
         return ATI_CONNECT_DISCONNECT_ERROR;
      }                         // end
      // switch(ati_get_device_mode(ATI_ANSWER_HIDE))
   }                            // end
   // if(!ati_disconnect_flag)
   else
      return ATI_CONNECT_DISCONNECT_ERROR;
} // unsigned char ati_disconnect(void);

void ati_answer_incomming_call(unsigned char behavior)
{
   switch (behavior)
   {
   case ATI_ANSWER_ENABLED:
      ati_answer_flag = ATI_ANSWER_ENABLED;
#ifdef WEB_DEBUG_ATI
      if (web_debug_flag & WEB_DEBUG_ATI_BIT)
         printf_P(PSTR("ATI Auto answering incomming call ENABLED\n"));
#endif
      break;
   case ATI_ANSWER_DISABLED:
      ati_answer_flag = ATI_ANSWER_DISABLED;
#ifdef WEB_DEBUG_ATI
      if (web_debug_flag & WEB_DEBUG_ATI_BIT)
         printf_P(PSTR("ATI Auto answering incomming call DISABLED\n"));
#endif
      break;
   }
}
