
/*****************************************************************************
 *
 *                              "atinterface_debug.c" 
 *                   -----------------------------
 *                                                                            
 *  Version:    2.03
 *  File:    	...\source\...\atinterface_debug.c    
 *  Created:    16.05.2003
 *  Date:       02.12.2003
 *  Author:     Copyright (C) 2001-2003 
 *              Udo Jakobza - FTZ Leipzig; D-04107 Leipzig; Wchterstr. 13
 *				info@easytoweb.net
 *  Func:	
 *  license:	
 *    This library is free software; you can redistribute it and/or modify it 
 *    under the terms of the GNU Lesser General Public License as published by 
 *    the Free Software Foundation; either version 2.1 of the License, or 
 *    (at your option) any later version. This library is distributed in the hope 
 *    that it will be useful, but WITHOUT ANY WARRANTY; without even the implied 
 *    warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
 *    See the GNU Lesser General Public License for more details.
 *	  see: http://www.gnu.org/copyleft/lesser.html	
 *    You should have received a copy of the GNU Lesser General Public License 
 *    along with this library; if not, write to the Free Software Foundation, 
 *    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *	
 *    Die Bibliothek ist freie Software; Sie drfen sie unter den Bedingungen der 
 *    GNU Lesser General Public License, wie von der Free Software Foundation 
 *    verffentlicht, weiterverteilen und/oder modifizieren; entweder gem 
 *    Version 2.1 der Lizenz oder (nach Ihrer Option) jeder spteren Version. 
 *    Diese Bibliothek wird in der Hoffnung weiterverbreitet, da sie ntzlich 
 *    sein wird, jedoch OHNE IRGENDEINE GARANTIE, auch ohne die implizierte 
 *    Garantie der MARKTREIFE oder der VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK. 
 *    Mehr Details finden Sie in der GNU Lesser General Public License.
 *	  see: http://www.gnu.org/copyleft/lesser.de.html	
 *    Sie sollten eine Kopie der GNU Lesser General Public License zusammen mit 
 *    dieser Bibliothek erhalten haben; falls nicht, schreiben Sie an die FSF,
 *    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 *  history:	
 *		1.) 30.07.2003 Version 2.00a
 *			a.)	- 
 *
 *****************************************************************************/
#include "project.h"

#ifdef WEB_DEBUG_ATI

#include <stdio.h>
#include <string.h>
#ifdef __CODEVISIONAVR__
#include <mega128.h>
#else
#include <avr/io.h>
#endif
#include ATI_H_FILEPATH
#include DEBUG_H_FILEPATH
#include ATI_DEBUG_H_FILEPATH
#include HARDWARE_H_FILEPATH
#include DEVICE_H_FILEPATH


ATI_STATE ati_state_last = ATI_STATE_UNREACHED;
ATI_STATE ati_state_old_last = ATI_STATE_UNREACHED;

ATI_DEVICE_MODE ati_device_mode_last = ATI_DEVICE_UNREACHED;
ATI_DEVICE_MODE ati_device_nextmode_last = ATI_DEVICE_UNREACHED;

static PROGMEM char CbffEmty[]  = "BUFFER_EMPTY";
static PROGMEM char CbffFlld[]  = "BUFFER_FILLED";
static PROGMEM char CchecBff[]  = "CHECK_BUFFER";
static PROGMEM char CrspAwait[] = "RSP_AWAITED";
static PROGMEM char CrxData[]   = "RECEIVE_DATA";
static PROGMEM char Cunreachd[] = "UNREACHED";
PGM_P ati_state_debug[6] PROGMEM = {
   CbffEmty, CbffFlld, CchecBff, CrspAwait,
      CrxData, Cunreachd
};

static PROGMEM char Ccommand[] = "COMMAND";
static PROGMEM char Ccarrier[] = "CARRIER";
static PROGMEM char Conline[]  = "ONLINE";
static PROGMEM char CcmdOnln[] = "COMMAND_ONLINE";
PGM_P ati_device_mode_debug[4] PROGMEM = {
   Ccommand, Ccarrier, Conline, CcmdOnln
};


void ati_debug_print_state_change(void)
{
   if (ati_state != ati_state_last)
   {
      printf_P(PSTR("ATI State: %S\r\n"), pgm_read_word(&ati_state_debug[ati_state]));
      ati_state_last = ati_state;
   }
   if (ati_state_old != ati_state_old_last)
   {
      printf_P(PSTR("ATI State-Old: %S\r\n"), pgm_read_word(&ati_state_debug[ati_state_old]));
      ati_state_old_last = ati_state_old;
   }
}

void ati_debug_print_mode_change(void)
{
   if (ati_device_mode != ati_device_mode_last)
   {
      printf_P(PSTR("ATI Mode: %S\r\n"), pgm_read_word(&ati_device_mode_debug[ati_device_mode]));
      ati_device_mode_last = ati_device_mode;
   }
   if (ati_device_nextmode != ati_device_nextmode_last)
   {
      printf_P(PSTR("ATI Mode-Next: %S\r\n"),
             pgm_read_word(&ati_device_mode_debug[ati_device_nextmode]));
      ati_device_nextmode_last = ati_device_nextmode;
   }
}

void ati_debug_do_cmd(unsigned char *command)
{
   if (strncmp_P(command, PSTR("ati-init"), 9) == 0)
   {
      ati_init();
      return;
   }
   if (strncmp_P(command, PSTR("ati-modus"), 6) == 0)
   {
      ati_get_device_mode(ATI_ANSWER_SHOW);
      return;
   }
   if (strncmp_P(command, PSTR("ati-answer"), 7) == 0)
   {
      ati_get_new_answer();
      return;
   }
   if (strncmp_P(command, PSTR("ati-connect"), 7) == 0)
   {
      command = debug_search_parameter(command);
      if (command != 0)
         ati_connect(command);
      return;
   }
   if (strncmp_P(command, PSTR("ati-disconnect"), 7) == 0)
   {
      ati_disconnect();
      return;
   }
   if (strncmp_P(command, PSTR("ati-on"), 6) == 0)
   {
      ati_answer_incomming_call(ATI_ANSWER_ENABLED);
      return;
   }
   if (strncmp_P(command, PSTR("ati-off"), 7) == 0)
   {
      ati_answer_incomming_call(ATI_ANSWER_DISABLED);
      return;
   }
   if (strncmp_P(command, PSTR("at"), 2) == 0)
   {
      ati_write_data(command);
   }
}

#endif
