
/*****************************************************************************
 *
 *                         "bootp.c"
 *                   -----------------------------
 *
 *  Version:    2.03
 *  File:    	..\source\..\bootp.c
 *  Created:    02.04.2003
 *  Date:       25.02.2004
 *  Author:     Copyright (C) 2001-2004
 *              Udo Jakobza - FTZ Leipzig; D-04107 Leipzig; Wchterstr. 13
 *				info@easytoweb.net
 *  Function:	BOOTP-Protocol functions
 *  license:
 *    This library is free software; you can redistribute it and/or modify it
 *    under the terms of the GNU Lesser General Public License as published by
 *    the Free Software Foundation; either version 2.1 of the License, or
 *    (at your option) any later version. This library is distributed in the hope
 *    that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *    warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *    See the GNU Lesser General Public License for more details.
 *	  see: http://www.gnu.org/copyleft/lesser.html
 *    You should have received a copy of the GNU Lesser General Public License
 *    along with this library; if not, write to the Free Software Foundation,
 *    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *    Die Bibliothek ist freie Software; Sie drfen sie unter den Bedingungen der
 *    GNU Lesser General Public License, wie von der Free Software Foundation
 *    verffentlicht, weiterverteilen und/oder modifizieren; entweder gem
 *    Version 2.1 der Lizenz oder (nach Ihrer Option) jeder spteren Version.
 *    Diese Bibliothek wird in der Hoffnung weiterverbreitet, da sie ntzlich
 *    sein wird, jedoch OHNE IRGENDEINE GARANTIE, auch ohne die implizierte
 *    Garantie der MARKTREIFE oder der VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK.
 *    Mehr Details finden Sie in der GNU Lesser General Public License.
 *	  see: http://www.gnu.org/copyleft/lesser.de.html
 *    Sie sollten eine Kopie der GNU Lesser General Public License zusammen mit
 *    dieser Bibliothek erhalten haben; falls nicht, schreiben Sie an die FSF,
 *    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 *  history:
 *		1.) 08.08.2003 Version 2.00
 *		2.) 14.08.2003 Version 2.01
 *		3.) 12.11.2003 Version 2.02
 *			a.)	- BOOTP has now a own buffer: "bootp_rx_buffer"
 *
 *****************************************************************************/
#include "project.h"

#ifdef BOOTP_ENABLE

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <avr/pgmspace.h>
#include <avr/wdt.h>
#include <avr/sleep.h>

#include ARP_RARP_H_FILEPATH
#include TCP_H_FILEPATH

#include ETHERNET_H_FILEPATH
#include DEVICE_H_FILEPATH
#include BUFFER_H_FILEPATH
#include IP_H_FILEPATH
#include UDP_H_FILEPATH
#include BOOTP_H_FILEPATH
#ifdef WEB_DEBUG
#include WEB_DEBUG_H_FILEPATH
#endif

#include SERVER_H_FILEPATH
#include HARDWARE_H_FILEPATH

#ifdef __CODEVISIONAVR__
#pragma regalloc-
#endif
unsigned long bootp_xid = 0;
unsigned char bootp_ok = 0;
unsigned char bootp_your_ip[IP_ADR_SIZE];
unsigned char bootp_server_ip[IP_ADR_SIZE];
unsigned char bootp_gateway_ip[IP_ADR_SIZE];
unsigned char bootp_subnet_ip[IP_ADR_SIZE];
unsigned char bootp_dns_ip[4] [IP_ADR_SIZE];
unsigned char bootp_rx_buffer[BOOTP_VENDOR_SIZE];
unsigned char udp_connection_bootp = UDP_WRONG_CONNECTIONS;

#ifdef __CODEVISIONAVR__
#pragma regalloc+
#endif

void bootp_init(void)
{
#ifdef WEB_DEBUG
   web_debug_flag |= WEB_DEBUG_BOOTP_BIT;
#endif
   udp_connection_bootp =
      udp_open(UDP_PORT_BOOTP_CLIENT, 0, 0, UDP_PORT_BOOTP_SERVER,
               UDP_FLAG_ACTIVE);
   if (udp_connection_bootp == UDP_WRONG_CONNECTIONS)
   {
#ifdef BOOTP_DEBUG
      if (web_debug_flag & WEB_DEBUG_BOOTP_BIT)
         printf_P(PSTR("BOOTP UDP Active Open Error!!!!\n"));
#endif
      return;
   }
   bootp_request(TIMEOUT_START);
   while (!bootp_ok)
   {
      server_main();
      if (bootp_timeout(TIMEOUT_STOP_CHECK))
         break;
#ifdef __CODEVISIONAVR__
      idle();
#asm("wdr");
#else
      wdt_reset();
      //set_sleep_mode(SLEEP_MODE_IDLE); // done in hardware.c
      sleep_mode();
      wdt_reset();
#endif
#ifdef WEB_DEBUG
      web_debug_command();
#endif
   }
   udp_close(udp_connection_bootp);
#ifdef WEB_DEBUG
   web_debug_flag &= ~WEB_DEBUG_BOOTP_BIT;
#endif
}


void bootp_copy(void)
{
   memcpy(ip_address, bootp_your_ip, sizeof(ip_address));
   memcpy(ip_subnet_mask, bootp_subnet_ip, sizeof(ip_subnet_mask));
   memcpy(ip_gateway, bootp_gateway_ip, sizeof(ip_gateway));
#ifdef WEB_DEBUG_BOOTP
   if (web_debug_flag & WEB_DEBUG_BOOTP_BIT)
      bootp_display();
#endif
   bootp_ok = 1;
}


void bootp_request(BOOTP_TIMEOUT_TYP mode)
{
   UDP_STRUCTURE *p_struct;
   unsigned int timer_value;

   p_struct = udp_get_struct(udp_connection_bootp);
   if (p_struct == 0)
   {
#ifdef WEB_DEBUG_BOOTP
      if (web_debug_flag & WEB_DEBUG_BOOTP_BIT)
         printf_P(PSTR("BOOTP No valid UDP-Connection\n"));
#endif
      return;
   }
   if (udp_tx_buffer_prepare(udp_connection_bootp, 0x0, 0x0) <
       BOOTP_HEADER_SIZE)
   {
#ifdef WEB_DEBUG_BOOTP
      if (web_debug_flag & WEB_DEBUG_BOOTP_BIT)
         printf_P(PSTR("BOOTP too small UDP-buffer\n")));
#endif
      return;
   }
   bootp_ok = 0;
   if (mode == TIMEOUT_START)
   {
      srand(hardware_timer1_counter());
      bootp_xid = rand();
      bootp_xid <<= 16;
      bootp_xid |= hardware_timer1_counter();
      memset(bootp_dns_ip, 0x0, sizeof(bootp_dns_ip));
   }
   memset(&p_struct->udp_tx_frame[UDP_DATA_OFS], 0x0, UDP_TX_DATA_SIZE);
   p_struct->udp_tx_frame[BOOTP_OP_OFS] = BOOTP_FRAME_OP_REQUEST;
   p_struct->udp_tx_frame[BOOTP_HTYPE_OFS] = 1;
   p_struct->udp_tx_frame[BOOTP_HLEN_OFS] = 6;
   HOST_NETWORK_ENDIAN_32BIT(&p_struct->udp_tx_frame[BOOTP_XID_OFS],
                             &bootp_xid);
   timer_value = hardware_timer1_counter() & 0x0003;
   HOST_NETWORK_ENDIAN_16BIT(&p_struct->udp_tx_frame[BOOTP_SECS_OFS],
                             &timer_value);
   memcpy(&p_struct->udp_tx_frame[BOOTP_CHADDR_OFS], &mac_address[0], 6);
   timer_value =
      udp_tx_buffer_prepare(udp_connection_bootp, 0x0, BOOTP_HEADER_SIZE);
#ifdef WEB_DEBUG_BOOTP
   if (web_debug_flag & WEB_DEBUG_BOOTP_BIT)
   {
      printf_P(PSTR("BOOTP Write Request: %ubyte "), timer_value);
      if (timer_value == BOOTP_HEADER_SIZE)
         printf_P(PSTR("OK\n"));
      else
         printf_P(PSTR("Error\n"));
   }
#endif
   bootp_timeout(mode);
}


#ifdef __CODEVISIONAVR__
#pragma regalloc-
#endif
unsigned char bootp_timeout(BOOTP_TIMEOUT_TYP mode)
{
   static unsigned int start_timeout = 0;
   static unsigned int counter_10ms_delay;
   static unsigned char counter_10ms_old;

   if (mode == TIMEOUT_STOP_CHECK)
   {
      if (start_timeout == 0)
         return 1;
      return 0;
   }
   if (mode == TIMEOUT_CHECK)
   {
      if (start_timeout == 0)
         return 0;
      if (counter_10ms_old != (unsigned char) counter_10ms_16bit)
      {
         counter_10ms_old = (unsigned char) counter_10ms_16bit;
         if (counter_10ms_delay > 0)
            counter_10ms_delay--;
         else
         {
#ifdef WEB_DEBUG_BOOTP
            if (web_debug_flag & WEB_DEBUG_BOOTP_BIT)
               printf_P(PSTR("BOOTP Timeout: %ums\r\n"), start_timeout * 10);
#endif
            return 1;
         }
      }
      return 0;
   }
   if (mode == TIMEOUT_START)
   {
      srand(hardware_timer1_counter());
      start_timeout = rand();
      start_timeout &= 0xff;
      if (start_timeout < 100)
         start_timeout += 100;
#ifdef WEB_DEBUG_BOOTP
      if (web_debug_flag & WEB_DEBUG_BOOTP_BIT)
         printf_P(PSTR("BOOTP Search Server\n"));
#endif
   }
   if (mode == TIMEOUT_RESTART)
   {
      start_timeout *= 2;
      if (start_timeout > BOOTP_TIMEOUT)
      {
         bootp_xid = 0;
         start_timeout = 0;
#ifdef WEB_DEBUG_BOOTP
         if (web_debug_flag & WEB_DEBUG_BOOTP_BIT)
            printf_P(PSTR("BOOTP Stop\n"));
#endif
      }
      else
      {
#ifdef WEB_DEBUG_BOOTP
         if (web_debug_flag & WEB_DEBUG_BOOTP_BIT)
            printf_P(PSTR("BOOTP Restart\n"));
#endif
      }
   }
   if (mode == TIMEOUT_CLEAR)
   {
      bootp_xid = 0;
      start_timeout = 0;
   }
   counter_10ms_old = (unsigned char) counter_10ms_16bit;
   counter_10ms_delay = start_timeout;
   return 0;
}

#ifdef __CODEVISIONAVR__
#pragma regalloc+
#endif

void bootp_process(void)
{
   if (bootp_timeout(TIMEOUT_CHECK))
      bootp_request(TIMEOUT_RESTART);
}


void bootp_answer(void)
{
   static const unsigned long bootp_MAGIC_COOKIE = BOOTP_MAGIC_COOKIE;
   unsigned int bootp_len;
   unsigned char length;        // general variable
   unsigned int data;
   unsigned long answer_xid;

   if (bootp_xid == 0)
      return;
   DEVICE_READ_IP_FRAME_16BIT();
   data = DEVICE_READ_IP_FRAME_16BIT();
#ifdef WEB_DEBUG_BOOTP
/*   if (web_debug_flag & WEB_DEBUG_BOOTP_BIT)
   {
      // printf("BOOTP port: %u\r\n", data);
   } */
#endif
   if (data == UDP_PORT_BOOTP_CLIENT)
   {
      bootp_len = DEVICE_READ_IP_FRAME_16BIT();
      bootp_len -= UDP_HEADER_SIZE;
      DEVICE_READ_IP_FRAME_16BIT();
      // BOOTstrap-Protocoll-Data
      data = DEVICE_READ_IP_FRAME_16BIT_LE();
      if ((data & 0xff) == BOOTP_FRAME_OP_ANSWER)
      {
         DEVICE_READ_IP_FRAME_16BIT();
         answer_xid = DEVICE_READ_IP_FRAME_16BIT();
         answer_xid <<= 16;
         answer_xid |= DEVICE_READ_IP_FRAME_16BIT();
#ifdef WEB_DEBUG_BOOTP
         if (web_debug_flag & WEB_DEBUG_BOOTP_BIT)
            printf_P(PSTR("BOOTP answer_xid: 0x%lx\r\n"), answer_xid);
#endif
         if (answer_xid == bootp_xid)
         {
            bootp_timeout(TIMEOUT_CLEAR);
            DEVICE_READ_IP_FRAME_DUMMY(8);
            DEVICE_READ_IP_FRAME_DATA(&bootp_your_ip[0], 4);
            DEVICE_READ_IP_FRAME_DATA(&bootp_server_ip[0], 4);
            DEVICE_READ_IP_FRAME_DATA(&bootp_gateway_ip[0], 4);
            DEVICE_READ_IP_FRAME_DUMMY(16);
            DEVICE_READ_IP_FRAME_DATA(&bootp_rx_buffer[0],
                                      BOOTP_SERVER_NAME_SIZE);
#ifdef WEB_DEBUG_BOOTP
            if (web_debug_flag & WEB_DEBUG_BOOTP_BIT)
            {
               printf_P(PSTR("BOOTP Server    : %s\r\n"), bootp_rx_buffer);
            }
#endif
            DEVICE_READ_IP_FRAME_DUMMY(128);
            bootp_len -=
               (BOOTP_MIN_HEADER_SIZE + BOOTP_SERVER_NAME_SIZE +
                BOOTP_BOOT_FILE_SIZE);
            if (bootp_len > BOOTP_VENDOR_SIZE)
            {
#ifdef WEB_DEBUG_BOOTP
               if (web_debug_flag & WEB_DEBUG_BOOTP_BIT)
                  printf_P(PSTR("BOOTP Vendor to long\n"));
#endif
               bootp_copy();
               return;
            }
            DEVICE_READ_IP_FRAME_DATA(&bootp_rx_buffer[0], BOOTP_VENDOR_SIZE);
#ifdef WEB_DEBUG_BOOTP
            if (web_debug_flag & WEB_DEBUG_BOOTP_BIT)
            {
               printf_P(PSTR("BOOTP Vendor:\n"));
               debug_display_frame(bootp_rx_buffer, BOOTP_VENDOR_SIZE, 0);
            }
#endif
            if (memcmp(&bootp_rx_buffer[0], &bootp_MAGIC_COOKIE, 4))
            {
               data = 4;
               while (data < bootp_len)
               {
                  if (bootp_rx_buffer[data] == BOOTP_VENDOR_SUBNET)
                  {
#ifdef WEB_DEBUG_BOOTP
                     if (web_debug_flag & WEB_DEBUG_BOOTP_BIT)
                     {

                     }
#endif
                     data++;
                     length = bootp_rx_buffer[data++];
                     memcpy(&bootp_subnet_ip[0], &bootp_rx_buffer[data], 4);
                     data += length;
                  }
                  else if (bootp_rx_buffer[data] == BOOTP_VENDOR_GATEWAY)
                  {
#ifdef WEB_DEBUG_BOOTP
/*                     if (web_debug_flag & WEB_DEBUG_BOOTP_BIT)
                     {

                     }*/
#endif
                     data++;
                     length = bootp_rx_buffer[data++];
                     memcpy(&bootp_gateway_ip[0], &bootp_rx_buffer[data], 4);
                     data += length;
                  }
                  else if (bootp_rx_buffer[data] == BOOTP_VENDOR_DNS)
                  {
                     data++;
                     length = bootp_rx_buffer[data++];

                     if (length < (sizeof(bootp_dns_ip)))
                        memcpy(bootp_dns_ip, &bootp_rx_buffer[data], length);
                     else
                        memcpy(bootp_dns_ip, &bootp_rx_buffer[data],
                               sizeof(bootp_dns_ip));
                     data += length;
                  }
                  else if (bootp_rx_buffer[data] == BOOTP_VENDOR_DOMAIN_NAME)
                  {
                     data++;
                     length = bootp_rx_buffer[data++];
#ifdef WEB_DEBUG_BOOTP
                     if (web_debug_flag & WEB_DEBUG_BOOTP_BIT)
                        printf_P(PSTR("BOOTP Domain    : %s\r\n"),
                               &bootp_rx_buffer[data]);
#endif
                     data += length;
                  }
                  else if (bootp_rx_buffer[data] == BOOTP_VENDOR_NETBIOS_NODE)
                  {
#ifdef WEB_DEBUG_BOOTP
                     if (web_debug_flag & WEB_DEBUG_BOOTP_BIT)
                     {
                        printf_P(PSTR("BOOTP NetBIOS over TCP/IP Node: 0x%02x\r\n"),
                               bootp_rx_buffer[data + 2]);
                     }
#endif
                     data += 3;
                  }
                  else if (bootp_rx_buffer[data] == BOOTP_VENDOR_END)
                  {
                     break;
                  }
                  else
                     data++;
               }
            }
            else
            {
#ifdef WEB_DEBUG_BOOTP
               if (web_debug_flag & WEB_DEBUG_BOOTP_BIT)
                  printf_P(PSTR("BOOTP wrong magic cookie: %02x%02x%02x%02x\r\n"),
                         bootp_rx_buffer[0], bootp_rx_buffer[1],
                         bootp_rx_buffer[2], bootp_rx_buffer[3]);
#endif
               return;
            }
            bootp_copy();
         }
      }
   }
}


#ifdef WEB_DEBUG_BOOTP
void bootp_display(void)
{
   unsigned char Lva;

   debug_print_ip(PSTR("BOOTP Your-IP   "), bootp_your_ip);
   debug_print_ip(PSTR("BOOTP Server-IP "), bootp_server_ip);
   debug_print_ip(PSTR("BOOTP Subnet-IP "), bootp_subnet_ip);
   debug_print_ip(PSTR("BOOTP Gateway-IP"), bootp_gateway_ip);
   for (Lva = 0; Lva < 4; Lva++)
      debug_print_ip(PSTR("BOOTP DNS-IP    "), &bootp_dns_ip[Lva] [0]);
}
#endif
#endif // #ifdef BOOTP_ENABLE
