
/*****************************************************************************
 *
 *                          "buffer.c"
 *                   -----------------------------
 *
 *  Version:    2.03
 *  File: 		..\..\buffer.c
 *  Created:    15.04.2003
 *  Date:       15.01.2004
 *  Author:     Copyright (C) 2001-2004
 *              Udo Jakobza - FTZ Leipzig; D-04107 Leipzig; Wchterstr. 13
 *				info@easytoweb.net
 *  Func:		buffer management for easyToWeb-Server
 *  license:
 *    This library is free software; you can redistribute it and/or modify it
 *    under the terms of the GNU Lesser General Public License as published by
 *    the Free Software Foundation; either version 2.1 of the License, or
 *    (at your option) any later version. This library is distributed in the hope
 *    that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *    warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *    See the GNU Lesser General Public License for more details.
 *	  see: http://www.gnu.org/copyleft/lesser.html
 *    You should have received a copy of the GNU Lesser General Public License
 *    along with this library; if not, write to the Free Software Foundation,
 *    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *    Die Bibliothek ist freie Software; Sie drfen sie unter den Bedingungen der
 *    GNU Lesser General Public License, wie von der Free Software Foundation
 *    verffentlicht, weiterverteilen und/oder modifizieren; entweder gem
 *    Version 2.1 der Lizenz oder (nach Ihrer Option) jeder spteren Version.
 *    Diese Bibliothek wird in der Hoffnung weiterverbreitet, da sie ntzlich
 *    sein wird, jedoch OHNE IRGENDEINE GARANTIE, auch ohne die implizierte
 *    Garantie der MARKTREIFE oder der VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK.
 *    Mehr Details finden Sie in der GNU Lesser General Public License.
 *	  see: http://www.gnu.org/copyleft/lesser.de.html
 *    Sie sollten eine Kopie der GNU Lesser General Public License zusammen mit
 *    dieser Bibliothek erhalten haben; falls nicht, schreiben Sie an die FSF,
 *    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 *  history:
 *		1.) 30.07.2003 Version 2.00a
 *			a.)	-
 *
 *****************************************************************************/
#include "project.h"

#include <stdio.h>
#include <string.h>

#ifdef __CODEVISIONAVR__
#include <delay.h>
#else
#include <avr/pgmspace.h>
#include <avr/wdt.h>
#endif
#include HARDWARE_H_FILEPATH
#include DEVICE_H_FILEPATH
#include ETHERNET_H_FILEPATH
#include BUFFER_H_FILEPATH
#ifdef WEB_DEBUG_MEASURE
#include MEASURE_H_FILEPATH
#endif
#ifdef WEB_DEBUG
#include WEB_DEBUG_H_FILEPATH
#endif

#ifdef __CODEVISIONAVR__
#pragma regalloc-
#endif
BUFFER_FRAME buffer_frame;
unsigned char tx_frame2[TX_BUFFER2_SIZE];
unsigned int tx_frame2_size;

#ifdef __CODEVISIONAVR__
#pragma regalloc+
#endif

unsigned char buffer_process(void)
{
   if (buffer_frame.gap < BUFFER_COUNT)
   {
      if (DEVICE_WRITE_READY(buffer_frame.datasize[buffer_frame.rtop]))
      {
#ifdef WEB_DEBUG_MEASURE
         MEASURE_SETTIME(MEA_BUFFER_FRAME2_S)
#endif
         DEVICE_WRITE_FRAME_DATA(buffer_frame.data[buffer_frame.rtop],
                                    buffer_frame.datasize[buffer_frame.rtop]);
#ifdef WEB_DEBUG_MEASURE
         MEASURE_SETTIME(MEA_BUFFER_FRAME2_E)
#endif
#ifdef WEB_DEBUG_BUFFER
         if (web_debug_flag & WEB_DEBUG_BUFFER_BIT)
         {
            printf_P(PSTR("BUFFER write frame (%ubyte)\r\n"),
                   buffer_frame.datasize[buffer_frame.rtop]);
            // debug_display_frame(buffer_frame.data[buffer_frame.rtop],
            // buffer_frame.datasize[buffer_frame.rtop], 0);
         }
#endif
         // --------------------------------------------------------------------------------
         // delete the actual command frame
         // --------------------------------------------------------------------------------
         //
         buffer_frame.rtop++;
         if (buffer_frame.rtop == BUFFER_COUNT)
            buffer_frame.rtop = 0;
         buffer_frame.gap++;
         return 1;
      }
      else
      {
#ifdef WEB_DEBUG_BUFFER
         if (web_debug_flag & WEB_DEBUG_BUFFER_BIT)
            printf_P(PSTR("BUFFER device not ready (%ubyte)\r\n"),
                   buffer_frame.datasize[buffer_frame.rtop]);
#endif
      }
   }
   return 0;
}


void buffer_clear(void)
{
   buffer_frame.gap = BUFFER_COUNT;
}

unsigned char buffer_data_available(void)
{
   return (BUFFER_COUNT - buffer_frame.gap);
}

unsigned char buffer_free(void)
{
   return buffer_frame.gap;
}


unsigned char buffer_write_command(unsigned char *data, unsigned int datasize)
{
   if (buffer_frame.gap > 0)
   {
#ifdef WEB_DEBUG_BUFFER
      if (web_debug_flag & WEB_DEBUG_BUFFER_BIT)
         printf_P(PSTR("BUFFER write command: %u\r\n"), buffer_frame.wtop);
#endif
      buffer_frame.data[buffer_frame.wtop] = data;
      buffer_frame.datasize[buffer_frame.wtop] = datasize;
      buffer_frame.wtop++;
      if (buffer_frame.wtop == BUFFER_COUNT)
         buffer_frame.wtop = 0;
      buffer_frame.gap--;
      return 1;
   }
#ifdef WEB_DEBUG_BUFFER
   if (web_debug_flag & WEB_DEBUG_BUFFER_BIT)
      printf_P(PSTR("BUFFER write command: Error\n"));
#endif
   return 0;
}

unsigned char buffer_process_wait(void)
{
   unsigned char counter_10ms_delay = 10;
   unsigned char counter_10ms_old;
   unsigned int data;

#ifdef WEB_DEBUG_BUFFER
   unsigned char skip_count = 0;
#endif

   if (buffer_data_available())
   {
      // --------------------------------------------------------------------------------
      // delete old receive data
      // --------------------------------------------------------------------------------
      //
      while (DEVICE_READ_READY() & DEVICE_READ_READY_RECEIVE)
      {
#ifdef __CODEVISIONAVR__
#asm("wdr");
#else
         wdt_reset();
#endif
#ifdef WEB_DEBUG_BUFFER
         skip_count++;
#endif
         DEVICE_RECEIVE_SKIP();
      }
      // --------------------------------------------------------------------------------
      // write data
      // --------------------------------------------------------------------------------
      //
      while (buffer_data_available())
      {
#ifdef __CODEVISIONAVR__
#asm("wdr");
#else
        wdt_reset();
#endif
         buffer_process();
#ifdef WEB_DEBUG_BUFFER
         if (web_debug_flag & WEB_DEBUG_BUFFER_BIT)
            printf_P(PSTR("BUFFER process wait, rx-skip %d\r\n"), skip_count);
#endif
      }
      counter_10ms_old = (unsigned char) counter_10ms_16bit;
      // --------------------------------------------------------------------------------
      // wait until data sent
      // --------------------------------------------------------------------------------
      //
      do
      {
#ifdef __CODEVISIONAVR__
#asm("wdr");
#else
         wdt_reset();
#endif
         data = DEVICE_WRITE_COMPLETE();
         if (data & (DEVICE_WRITE_COMPLETE_OK | DEVICE_WRITE_COMPLETE_ERROR))
            break;
         if (counter_10ms_old != (unsigned char) counter_10ms_16bit)
         {
            counter_10ms_old = (unsigned char) counter_10ms_16bit;
            if (counter_10ms_delay > 0)
               counter_10ms_delay--;
            else
               break;
         }
      }
      while (1);
#ifdef WEB_DEBUG_BUFFER
      if (web_debug_flag & WEB_DEBUG_BUFFER_BIT)
         printf_P(PSTR("BUFFER write complete: 0x%x %d0ms\r\n"), data,
                10 - counter_10ms_delay);
#endif
      if (!(data & DEVICE_WRITE_COMPLETE_ERROR))
      {
         return 1;
      }
   }
   return 0;
}


void swap16(void *out_data, void *in_data)
{
#if 1
   *((unsigned char *) out_data + 1) = *((unsigned char *) in_data++);
   *((unsigned char *) out_data) = *(unsigned char *) in_data;
#else
   *((unsigned int *) out_data) = htons(*((unsigned int *) in_data));
#endif   
}


void swap32(void *out_data, void *in_data)
{
#if 1
   *((unsigned char *) out_data + 3) = *((unsigned char *) in_data++);
   *((unsigned char *) out_data + 2) = *((unsigned char *) in_data++);
   *((unsigned char *) out_data + 1) = *((unsigned char *) in_data++);
   *((unsigned char *) out_data) = *(unsigned char *) in_data;
#else
   *((unsigned long *) out_data( = htonl(*((unsigned long *) in_data));
#endif   
}

