
/*****************************************************************************
 *
 *                       "cs8900_debug.c"
 *                   -----------------------------
 *                                                                            
 *  Version:    2.04
 *  File:    	..\..\cs8900_debug.c    
 *  Created:    07.02.2002
 *  Date:       01.06.2004
 *  Author:     Copyright (C) 2001-2004
 *              Udo Jakobza - FTZ Leipzig; D-04107 Leipzig; Wchterstr. 13
 *				info@easytoweb.net
 *  Function:	some ad. function to debug easyToWeb-Server
 *  license:	
 *    This library is free software; you can redistribute it and/or modify it 
 *    under the terms of the GNU Lesser General Public License as published by 
 *    the Free Software Foundation; either version 2.1 of the License, or 
 *    (at your option) any later version. This library is distributed in the hope 
 *    that it will be useful, but WITHOUT ANY WARRANTY; without even the implied 
 *    warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
 *    See the GNU Lesser General Public License for more details.
 *	  see: http://www.gnu.org/copyleft/lesser.html	
 *    You should have received a copy of the GNU Lesser General Public License 
 *    along with this library; if not, write to the Free Software Foundation, 
 *    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *	
 *    Die Bibliothek ist freie Software; Sie drfen sie unter den Bedingungen der 
 *    GNU Lesser General Public License, wie von der Free Software Foundation 
 *    verffentlicht, weiterverteilen und/oder modifizieren; entweder gem 
 *    Version 2.1 der Lizenz oder (nach Ihrer Option) jeder spteren Version. 
 *    Diese Bibliothek wird in der Hoffnung weiterverbreitet, da sie ntzlich 
 *    sein wird, jedoch OHNE IRGENDEINE GARANTIE, auch ohne die implizierte 
 *    Garantie der MARKTREIFE oder der VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK. 
 *    Mehr Details finden Sie in der GNU Lesser General Public License.
 *	  see: http://www.gnu.org/copyleft/lesser.de.html	
 *    Sie sollten eine Kopie der GNU Lesser General Public License zusammen mit 
 *    dieser Bibliothek erhalten haben; falls nicht, schreiben Sie an die FSF,
 *    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 *  history:	
 *		1.) 08.08.2003 Version 2.00
 *		2.) 26.08.2003 Version 2.01
 *			a.)	- new function "cs8900_debug_do_cmd", see also web_debug.c 
 *		3.) 01.06.2004 Version 2.04
 *			a.)	- 2 new debug-commands:  
 *                 "cs8900-reg" - displays all PacketPage-Register
 *                 "cs8900-stat" - displays the Miss- and Collision-Register
 *
 *****************************************************************************/
#include "project.h"

#ifdef WEB_DEBUG_CS8900

#include <stdlib.h>
#include <stdio.h>
#include <avr/pgmspace.h>

#include DEBUG_H_FILEPATH
#include CS8900_H_FILEPATH
#include CS8900_DEBUG_H_FILEPATH

void cs8900_debug_info(void)
{
   unsigned int ident_code_l, ident_code_h;

   ident_code_h = cs8900_read_packetpage16_be(CS8900_PP_CHIP_ID);
   ident_code_l = cs8900_read_packetpage16_be(CS8900_PP_CHIP_ID + 2);
   printf_P(PSTR("CS8900A-Rev "));
   switch (ident_code_l & 0x1f)
   {
   case 0x7:
      printf_P(PSTR("B"));
      break;
   case 0x8:
      printf_P(PSTR("C"));
      break;
   case 0x9:
      printf_P(PSTR("D"));
      break;
   default:
      printf_P(PSTR("unknown"));
   }
   printf_P(PSTR(" (0x%04x%04x); "), ident_code_h, ident_code_l);

   ident_code_l = cs8900_read_packetpage16_le(CS8900_PP_SELF_ST);
   if (ident_code_l & SELF_ST_33V_ACTIVE)
      printf_P(PSTR("3.3Volt\n"));
   else
      printf_P(PSTR("5.0Volt\n"));
}


void cs8900_debug_io_register(void)
{
   unsigned char Lva;
   unsigned int data0, data1;

   printf_P(PSTR("Interface Test (All IO-Register)\n"));
   data0 = 0x01;
   for (Lva = 0; Lva < 16; Lva++)
   {
      cs8900_write_io_reg16(IO_PORT_ADD, data0);
      data1 = cs8900_read_io_reg16_le(IO_PORT_ADD);
      printf_P(PSTR("%d) 0x%04x!=0x%04x\r\n"), Lva, data0, data1);
      data0 <<= 1;
   }
}


unsigned int packetpage_reg[60] PROGMEM = 
{  0x000, 0x002, 0x020, 0x022,
   0x024, 0x026, 0x028, 0x02a,
   0x02c, 0x02e, 0x030, 0x032,
   0x034, 0x036, 0x040, 0x042,
   0x050,
   0x100, 0x102, 0x104, 0x106,
   0x108, 0x10a, 0x10c, 0x10e,
   0x110, 0x112, 0x114, 0x116,
   0x118, 0x11a, 0x11c, 0x11e,
   0x120, 0x122, 0x124, 0x126,
   0x128, 0x12a, 0x12c, 0x12e,
   0x130, 0x132, 0x134, 0x136,
   0x138, 0x13a, 0x13c, 0x13e,
   0x144, 0x146, 0x150, 0x152,
   0x154, 0x156, 0x158, 0x15a,
   0x15c, 0x400, 0x402
};

void cs8900_debug_packetpage_reg(void)
{
   unsigned char Lva;
   unsigned int data;

   printf_P(PSTR("All PacketPage-Register\n"));
   for (Lva = 0; Lva < (sizeof(packetpage_reg) / 2); Lva++)
   {
      data = cs8900_read_packetpage16_le(pgm_read_word(&packetpage_reg[Lva]));
      printf_P(PSTR("0x%03x=0x%04x "), pgm_read_word(&packetpage_reg[Lva]), data);
      if ((Lva > 0) && (((Lva + 1) % 4) == 0))
         printf_P(PSTR("\n"));
   }
}

void cs8900_debug_miss_collision(unsigned char mode)
{
   static unsigned int collision_count = 0;
   static unsigned int miss_count = 0;

   miss_count += cs8900_miss_counter();
   printf_P(PSTR("RX-Miss: %u\r\n"), miss_count);
   collision_count += cs8900_collision_counter();
   printf_P(PSTR("TX-Collision: %u\r\n"), collision_count);
   if (mode == 0)
   {
      miss_count = 0;
      collision_count = 0;
   }
}

void cs8900_debug_do_cmd(unsigned char *command)
{
   unsigned int data;

   if (strncmp_P(command, PSTR("cs8900-info"), 8) == 0)
   {
      cs8900_debug_info();
      data = cs8900_read_packetpage16_le(CS8900_PP_TEST_CTL);
      printf_P(PSTR("TestCTL.DisableLT=="));
      if (data & DISABLE_LT)
         printf_P(PSTR("1\n"));
      else
         printf_P(PSTR("0\n"));
      data = cs8900_read_packetpage16_le(CS8900_PP_LINE_ST);
      printf_P(PSTR("LineST.LinkOK=="));
      if (data & LINK_OK)
         printf_P(PSTR("not failed(1)\n"));
      else
         printf_P(PSTR("has failed(0)\n"));
      printf_P(PSTR("LineST.PolarityOK=="));
      if (data & POLARITY_OK)
         printf_P(PSTR("correct(1)\n"));
      else
         printf_P(PSTR("reversed(0)\n"));
      data = cs8900_read_packetpage16_le(CS8900_PP_LINE_CTL);
      printf_P(PSTR("LineCTL.PolarityDis=="));
      if (data & POLARITY_DIS)
         printf_P(PSTR("not correct(1)\n"));
      else
         printf_P(PSTR("is corrected(0)\n"));
   }
   if (strncmp_P(command, PSTR("cs8900-test"), 8) == 0)
   {
      cs8900_debug_io_register();
   }
   if (strncmp_P(command, PSTR("cs8900-reg"), 8) == 0)
   {
      cs8900_debug_packetpage_reg();
   }
   if (strncmp_P(command, PSTR("cs8900-stat"), 9) == 0)
   {
      data = debug_integer(command);
      cs8900_debug_miss_collision(data);
   }
   if (strncmp_P(command, PSTR("cs8900-prom"), 9) == 0)
   {
      data = cs8900_read_packetpage16_le(CS8900_PP_RX_CTL);
      data ^= RX_PROM_ACCEPT;
      printf_P(PSTR("RxCTL.PromiscuousA=="));
      if (data & RX_PROM_ACCEPT)
         printf_P(PSTR("1\n"));
      else
         printf_P(PSTR("0\n"));
      cs8900_write_packetpage16(CS8900_PP_RX_CTL, data);
   }
   if (strncmp_P(command, PSTR("cs8900-fdx"), 8) == 0)
   {
      data = cs8900_read_packetpage16_le(CS8900_PP_TEST_CTL);
      data ^= FDX_8900;
      printf_P(PSTR("TestCTL.FDX=="));
      if (data & FDX_8900)
         printf_P(PSTR("full duplex\n"));
      else
         printf_P(PSTR("half-duplex\n"));
      cs8900_write_packetpage16(CS8900_PP_TEST_CTL, data);
   }
   if (strncmp_P(command, PSTR("cs8900-link"), 8) == 0)
   {
      data = cs8900_read_packetpage16_le(CS8900_PP_TEST_CTL);
      data ^= DISABLE_LT;
      printf_P(PSTR("TestCTL.DisableLT=="));
      if (data & DISABLE_LT)
         printf_P(PSTR("1\n"));
      else
         printf_P(PSTR("0\n"));
      cs8900_write_packetpage16(CS8900_PP_TEST_CTL, data);
   }
   if (strncmp_P(command, PSTR("cs8900-pol"), 9) == 0)
   {
      data = cs8900_read_packetpage16_le(CS8900_PP_LINE_CTL);
      data ^= POLARITY_DIS;
      printf_P(PSTR("LineCTL.PolarityDis=="));
      if (data & POLARITY_DIS)
         printf_P(PSTR("not correct(1)\n"));
      else
         printf_P(PSTR("is corrected(0)\n"));
      cs8900_write_packetpage16(CS8900_PP_LINE_CTL, data);
   }
   if (strncmp_P(command, PSTR("cs8900-sleep"), 9) == 0)
   {
      cs8900_software_sleep();
   }
   if (strncmp_P(command, PSTR("cs8900-wakeup"), 8) == 0)
   {
      cs8900_software_wakeup();
   }
}

#endif
