
/*****************************************************************************
 *
 *                         "cs8900_sleep.c"
 *                   -----------------------------
 *                                                                            
 *  Version:    2.03
 *  File:     	..\..\cs8900_sleep.c    
 *  Created:    24.06.2003
 *  Date:       11.08.2004
 *  Author:     Copyright (C) 2001-2004
 *              Udo Jakobza - FTZ Leipzig; D-04107 Leipzig; Wchterstr. 13
 *				info@easytoweb.net
 *  Function:	functions to activate the Sleep-modes of CS8900 with Memory-Interface
 *  License:	
 *    This library is free software; you can redistribute it and/or modify it 
 *    under the terms of the GNU Lesser General Public License as published by 
 *    the Free Software Foundation; either version 2.1 of the License, or 
 *    (at your option) any later version. This library is distributed in the hope 
 *    that it will be useful, but WITHOUT ANY WARRANTY; without even the implied 
 *    warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
 *    See the GNU Lesser General Public License for more details.
 *	  see: http://www.gnu.org/copyleft/lesser.html	
 *    You should have received a copy of the GNU Lesser General Public License 
 *    along with this library; if not, write to the Free Software Foundation, 
 *    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *	
 *    Die Bibliothek ist freie Software; Sie drfen sie unter den Bedingungen der 
 *    GNU Lesser General Public License, wie von der Free Software Foundation 
 *    verffentlicht, weiterverteilen und/oder modifizieren; entweder gem 
 *    Version 2.1 der Lizenz oder (nach Ihrer Option) jeder spteren Version. 
 *    Diese Bibliothek wird in der Hoffnung weiterverbreitet, da sie ntzlich 
 *    sein wird, jedoch OHNE IRGENDEINE GARANTIE, auch ohne die implizierte 
 *    Garantie der MARKTREIFE oder der VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK. 
 *    Mehr Details finden Sie in der GNU Lesser General Public License.
 *	  see: http://www.gnu.org/copyleft/lesser.de.html	
 *    Sie sollten eine Kopie der GNU Lesser General Public License zusammen mit 
 *    dieser Bibliothek erhalten haben; falls nicht, schreiben Sie an die FSF,
 *    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 *  history:	
 *		1.) 30.07.2003 Version 2.00a
 *			a.)	- 
 *
 *****************************************************************************/
#include "project.h"


//#include <avr/delay.h>
#include <avr/io.h>

#include CS8900_H_FILEPATH
#include HARDWARE_H_FILEPATH
#include CS8900_SLEEP_H_FILEPATH

#ifdef __CODEVISIONAVR__
#pragma regalloc-
#pragma regalloc+
#endif

#define	IO_ADDRESS	       	0xf000
#define ETHER_IO(address)	*(unsigned char*)(IO_ADDRESS+address)

void __cs8900_write(unsigned char address, unsigned int data)
{
   ETHER_IO(address) = LO(data);
   ETHER_IO(address + 1) = HI(data);
}

void cs8900_sleep_software(void)
{
   __cs8900_write(IO_PORT_ADD, CS8900_PP_SELF_CTL);
   delay_ms(10);
   __cs8900_write(IO_PORT_ADD, CS8900_PP_SELF_CTL);
   __cs8900_write(IO_PORT_DATA, SELF_CTL_SW_SUSPEND);
}


void cs8900_sleep_hardware(void)
{
   CS8900_SLEEP_L;
   CS8900_SLEEP_OUTPUT;
   __cs8900_write(IO_PORT_ADD, CS8900_PP_SELF_CTL);
   __cs8900_write(IO_PORT_DATA, SELF_CTL_HW_SLEEP_E);
}

void cs8900_sleep_activ(void)
{
   if ((MCUCR & 0x80) == 0)
   {
      XMCRA = SRL_7;
      MCUCR |= 0x80;
      cs8900_sleep_software();
      // cs8900_sleep_hardware();
      MCUCR &= ~0x80;
   }
   else
   {
      cs8900_sleep_software();
      // cs8900_sleep_hardware();
   }
}
