
/*****************************************************************************
 *
 *                         "ethernet.c" 
 *                   -----------------------------
 *                                                                            
 *  Version:    2.06
 *  File:     	..\..\ethernet.c    
 *  Created:    15.04.2003
 *  Date:       22.01.2005
 *  Author:     Copyright (C) 2001-2005
 *              Udo Jakobza - FTZ Leipzig; D-04107 Leipzig; Wchterstr. 13
 *				info@easytoweb.net
 *  Func:		implements the ethernet-functions with a simple API to the user
 *  License:	
 *    This library is free software; you can redistribute it and/or modify it 
 *    under the terms of the GNU Lesser General Public License as published by 
 *    the Free Software Foundation; either version 2.1 of the License, or 
 *    (at your option) any later version. This library is distributed in the hope 
 *    that it will be useful, but WITHOUT ANY WARRANTY; without even the implied 
 *    warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
 *    See the GNU Lesser General Public License for more details.
 *	  see: http://www.gnu.org/copyleft/lesser.html	
 *    You should have received a copy of the GNU Lesser General Public License 
 *    along with this library; if not, write to the Free Software Foundation, 
 *    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *	
 *    Die Bibliothek ist freie Software; Sie drfen sie unter den Bedingungen der 
 *    GNU Lesser General Public License, wie von der Free Software Foundation 
 *    verffentlicht, weiterverteilen und/oder modifizieren; entweder gem 
 *    Version 2.1 der Lizenz oder (nach Ihrer Option) jeder spteren Version. 
 *    Diese Bibliothek wird in der Hoffnung weiterverbreitet, da sie ntzlich 
 *    sein wird, jedoch OHNE IRGENDEINE GARANTIE, auch ohne die implizierte 
 *    Garantie der MARKTREIFE oder der VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK. 
 *    Mehr Details finden Sie in der GNU Lesser General Public License.
 *	  see: http://www.gnu.org/copyleft/lesser.de.html	
 *    Sie sollten eine Kopie der GNU Lesser General Public License zusammen mit 
 *    dieser Bibliothek erhalten haben; falls nicht, schreiben Sie an die FSF,
 *    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 *  history:	
 *		1.) 30.07.2003 Version 2.00a
 *			a.)	- 
 *
 *****************************************************************************/
#include "project.h"

#if defined(ETHERNET_ENABLE) && defined(DEVICE_CS8900)

#include <stdio.h>
#include <string.h>
#ifdef __CODEVISIONAVR__
#include <delay.h>
#else
#endif
#include DEVICE_H_FILEPATH
#include ETHERNET_H_FILEPATH
#include BUFFER_H_FILEPATH
#include IP_H_FILEPATH
#if defined(ARP_ENABLE) || defined(RARP_ENABLE)
#include ARP_RARP_H_FILEPATH
#endif
#ifdef WEB_DEBUG_MEASURE
#include MEASURE_H_FILEPATH
#endif
#ifdef WEB_DEBUG
#include DEBUG_H_FILEPATH
#include WEB_DEBUG_H_FILEPATH
#endif


#ifdef __CODEVISIONAVR__
#pragma regalloc-
#endif
unsigned char mac_of_last_frame[6];

#ifdef __CODEVISIONAVR__
#pragma regalloc+
#endif

void ethernet_process(void)
{
   unsigned int rx_event;

#ifdef WEB_DEBUG_MEASURE
   MEASURE_SETTIME(MEA_NET_S)
#endif
   rx_event = DEVICE_READ_READY();

   if (rx_event & DEVICE_READ_READY_RECEIVE)
   {
      if (rx_event & DEVICE_READ_READY_FRAME)
         ethernet_process_frame(0);
      else if (rx_event & DEVICE_READ_READY_BROADCAST)
         ethernet_process_frame(1);
   }
#ifdef ARP_ENABLE
   arp_request_timer(ARP_REQUEST_TIMER_CONTINUE);
#endif
#ifdef WEB_DEBUG_MEASURE
   MEASURE_SETTIME(MEA_NET_E)
#endif
}


void ethernet_process_frame(unsigned char broadcast_flag)
{
   unsigned int ip_frame_type;
   unsigned int frame_length;

#ifdef WEB_DEBUG_ETHERNET
   unsigned char mac_dest[6];
#endif

#ifdef WEB_DEBUG_MEASURE
   MEASURE_SETTIME(MEA_ETHERNET_S)
#endif
   // next two words MUST be read with High-Byte 1st (CS8900 AN181 Page 2)
   DEVICE_READ_FRAME_STATUS();
   frame_length = DEVICE_READ_FRAME_STATUS();

#ifdef WEB_DEBUG_ETHERNET
   DEVICE_READ_FRAME_DATA(mac_dest, 6);
#else
   DEVICE_READ_FRAME_DUMMY(6);
#endif
   DEVICE_READ_FRAME_DATA(mac_of_last_frame, 6);
   ip_frame_type = DEVICE_READ_FRAME_16BIT();
#ifdef WEB_DEBUG_ETHERNET
   if (web_debug_flag & WEB_DEBUG_ETHERNET_BIT)
   {
      printf_P(PSTR("ETHERNET FRAME-Typ: 0x%04x, %uByte"), ip_frame_type,
             frame_length);
      if (broadcast_flag)
         printf_P(PSTR(" Broadcast\rn"));
      else
         printf_P(PSTR("\n"));
      debug_print_mac(PSTR("ETHERNET MAC"), mac_dest);
   }
#endif
   switch (ip_frame_type)
   {
#if defined(ARP_ENABLE) || defined(RARP_ENABLE)
   case ARP_FRAME:
   case RARP_FRAME:
      arp_rarp_process_frame(broadcast_flag);
      break;
#endif
#ifdef IP_ENABLE
   case IP_FRAME:
      ip_process_frame(broadcast_flag);
      break;
#endif
   default:
#ifdef WEB_DEBUG_ETHERNET
      if (web_debug_flag & WEB_DEBUG_ETHERNET_BIT)
         printf_P(PSTR("ETHERNET unsupported FRAME-Typ: 0x%04x\r\n"), ip_frame_type);
#endif
      break;
   }
#ifdef WEB_DEBUG_MEASURE
   MEASURE_SETTIME(MEA_ETHERNET_E);
#endif
}

#endif // #ifdef ETHERNET_ENABLE
