
/*
   Initialisieren des External Memory Interface

   Version 0.02 30.Mai 2005

   Werner Bllmann

   Siehe "Related pages" -> "MEMORY SECTIONS" -> ".initN" in der avr-libc Dokumentation.


    $LastChangedDate: 2005-09-06 14:42:26 +0200 (Tue, 06 Sep 2005) $
    $LastChangedRevision: 97 $
    $LastChangedBy: wb $
    $HeadURL: svn://172.16.50.12/FreeRTOS/trunc/Source/portable/GCC/atmega128/extmem.c $
*/


#include <avr/io.h>


void my_extmem_init( void ) __attribute__ ( ( naked ) )
   __attribute__ ( ( section( ".init1" ) ) );


// Datenblatt ab Seite 24
void my_extmem_init( void )
{
#if 1
   __asm__( "clr r1" );
   // AD - Pull Ups on
   // -- PORTA = 0xff;
   // External Memory Bus-keeper Enable, all address bits
   // -- terminator built in ++ XMCRB = _BV(XMBK);
   // Erst mal ein groes "Upper" segment - mit 2 waitstates
   // --2waits => XMCRA = _BV(SRW01) | _BV(SRW11);
   // 0 waits - ein groes "Upper" segment.
   XMCRA = 0;

   // Enable external memory
   MCUCR |= _BV( SRE );

// Fr "Obere 4kB for ISA-Bus"
#else
   // SRW11+SRW10 - upper sector - SRW01+SRW00 - lower sector
   // Von 0x1100 bis 0x1FFF lower sector
   XMCRA = _BV( SRL0 );

   // lower sector = 2 waitstates + 1 delay
   XMCRA |= ( _BV( SRW00 ) | _BV( SRW01 ) );
   // upper sector = zero waitstates
   // berflssig, bereits 0 // XMCRA &= ~_BV(SRW11);
   MCUCR &= ~_BV( SRW10 );
   // Enable external memory
   MCUCR |= _BV( SRE );

#endif
   *( ( volatile char * ) 0x1101 ) = 0xF0;      // AT-Bus address reset, RD
                                                // passive, WR passive, RESET
                                                // active
   *( ( volatile char * ) 0x1100 ) = 0xAA;      // AT-Bus data dummy
#if defined(__AVR_ATmega32__)||defined(__AVR_ATmega64__)||defined(__AVR_ATmega128__)
   // Zweimal innerhalb von 4 Taktzyklen schreiben
   MCUCSR |= ( 1 << JTD );
   MCUCSR |= ( 1 << JTD );
#endif
}
