
/*****************************************************************************
 *
 *                         "ftp_server.c"
 *                   -----------------------------
 *
 *  Version:    2.04
 *  File:     	..\..\ftp_server.c
 *  Created:    11.08.2003
 *  Date:       10.08.2004
 *  Author:     Copyright (C) 2001-2004
 *              Udo Jakobza - FTZ Leipzig; D-04107 Leipzig; Wchterstr. 13
 *				info@easytoweb.net
 *  Func:		implements a dynamic HTTP-server by using the easyToWeb-API
 *  license:
 *    This library is free software; you can redistribute it and/or modify it
 *    under the terms of the GNU Lesser General Public License as published by
 *    the Free Software Foundation; either version 2.1 of the License, or
 *    (at your option) any later version. This library is distributed in the hope
 *    that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *    warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *    See the GNU Lesser General Public License for more details.
 *	  see: http://www.gnu.org/copyleft/lesser.html
 *    You should have received a copy of the GNU Lesser General Public License
 *    along with this library; if not, write to the Free Software Foundation,
 *    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *    Die Bibliothek ist freie Software; Sie drfen sie unter den Bedingungen der
 *    GNU Lesser General Public License, wie von der Free Software Foundation
 *    verffentlicht, weiterverteilen und/oder modifizieren; entweder gem
 *    Version 2.1 der Lizenz oder (nach Ihrer Option) jeder spteren Version.
 *    Diese Bibliothek wird in der Hoffnung weiterverbreitet, da sie ntzlich
 *    sein wird, jedoch OHNE IRGENDEINE GARANTIE, auch ohne die implizierte
 *    Garantie der MARKTREIFE oder der VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK.
 *    Mehr Details finden Sie in der GNU Lesser General Public License.
 *	  see: http://www.gnu.org/copyleft/lesser.de.html
 *    Sie sollten eine Kopie der GNU Lesser General Public License zusammen mit
 *    dieser Bibliothek erhalten haben; falls nicht, schreiben Sie an die FSF,
 *    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 *  history:
 *		1.) 06.10.2003 Version 2.02
 *			a.)	- FTP RFC-959 Experimental Commands, see function "ftp_server_get_command()"
 *		2.) 13.01.2004 Version 2.03
 *			a.)	- supports now the User-Server Connection if data transfer in progress,
 *                see RFC-959, page 35;
 *			b.)	-
 *
 *****************************************************************************/
#include <avr/pgmspace.h>
#include "project.h"

#ifdef FTP_ENABLE

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include DEVICE_H_FILEPATH
#include BUFFER_H_FILEPATH
#ifdef WEB_DEBUG
#include DEBUG_H_FILEPATH
#include WEB_DEBUG_H_FILEPATH
#endif
#include HARDWARE_H_FILEPATH
#ifdef ETHERNET_ENABLE
#include ETHERNET_H_FILEPATH
#endif
#ifdef TCP_ENABLE
#include TCP_H_FILEPATH
#endif
#ifdef DEVICE_PPP
#include MODEM_H_FILEPATH
#include PPP_H_FILEPATH
#endif
#ifdef WEB_DEBUG_MEASURE
#include MEASURE_H_FILEPATH
#endif
#include FTP_SERVER_H_FILEPATH
#ifdef	DATAFLASH_FILE_ENABLE
#include DATAFLASH_FILE_H_FILEPATH
#include DATAFLASH_FILE_DEBUG_H_FILEPATH
#endif
#include SERVER_H_FILEPATH

static PROGMEM char NewLine[] = "\n";

static PROGMEM char FTP_CRLF[] = "\r\n";

//static PROGMEM char FTP_REPLY_125[] = "125 Data connection already open\r\n";
static PROGMEM char FTP_REPLY_150[] = "150 File status ok\r\n";
static PROGMEM char FTP_REPLY_200[] = "200 Command okay\r\n";
//static PROGMEM char FTP_REPLY_202[] = "202 Command not implemented, superfluous at this site\r\n";
static PROGMEM char FTP_REPLY_214[] = "214 easyToWeb-\"PROJECT_NAME\" \"PROJECT_VERSION\r\n";
static PROGMEM char FTP_REPLY_215[] = "215 easyToWeb-Software FTZ Leipzig\r\n";
static PROGMEM char FTP_REPLY_220[] = "220 Service ready for new user\r\n";
static PROGMEM char FTP_REPLY_221[]	= "221 Service closing control connection\r\n";
static PROGMEM char FTP_REPLY_226[] = "226 Closing data connection\r\n";
//static PROGMEM char FTP_REPLY_227[] = "227 Entering Passiv Mode %u,%u,%u,%u,%u,%u\r\n";
static PROGMEM char FTP_REPLY_230[] = "230 User looged in, proceed\r\n";
static PROGMEM char FTP_REPLY_250[] = "250 Requested file action okay\r\n";
static PROGMEM char FTP_REPLY_257[] = "257 \x22%s\x22 created\r\n";
static PROGMEM char FTP_REPLY_331[] = "331 User name ok, need password\r\n";
static PROGMEM char FTP_REPLY_332[] = "332 Need account for login\r\n";
//static PROGMEM char FTP_REPLY_421[] = "421 Service not available, closing control connections\r\n";
static PROGMEM char FTP_REPLY_425[] = "425 Can not open data connection\r\n";
//static PROGMEM char FTP_REPLY_426[] = "426 Connection closed, transfer aborted\r\n";
//static PROGMEM char FTP_REPLY_450[] = "450 Requested file action not taken\r\n";
//static PROGMEM char FTP_REPLY_451[] = "451 Requested action aborted\r\n";
//static PROGMEM char FTP_REPLY_500[] = "500 Syntax error, command unrecognized\r\n";
static PROGMEM char FTP_REPLY_501[] = "501 Syntax error in parameters or argumants\r\n";
static PROGMEM char FTP_REPLY_502[] = "502 Command not implemented\r\n";
//static PROGMEM char FTP_REPLY_503[] = "503 Bad sequence of commands\r\n";
static PROGMEM char FTP_REPLY_504[] = "504 Command not implemented for that parameter\r\n";
//static PROGMEM char FTP_REPLY_530[] = "530 Not logged in\r\n";
//static PROGMEM char FTP_REPLY_532[] = "532 Need account for storing files\r\n";
static PROGMEM char FTP_REPLY_550[] = "550 Requested action not taken, File unavailable\r\n";
static PROGMEM char FTP_REPLY_552[] = "552 Requested file action aborted, Exceeded storage allocation\r\n";

static PROGMEM char FTP_COMMAND_XMKD[] = "XMKD";
static PROGMEM char FTP_COMMAND_XRMD[] = "XRMD";
static PROGMEM char FTP_COMMAND_XPWD[] = "XPWD";
static PROGMEM char FTP_COMMAND_XCUP[] = "XCUP";
static PROGMEM char FTP_COMMAND_XCWD[] = "XCWD";

static PROGMEM char FTP_COMMAND_USER[] = "USER";
static PROGMEM char FTP_COMMAND_PASS[] = "PASS";
static PROGMEM char FTP_COMMAND_ACCT[] = "ACCT";
static PROGMEM char FTP_COMMAND_CWD	[] = "CWD";
static PROGMEM char FTP_COMMAND_CDUP[] = "CDUP";
static PROGMEM char FTP_COMMAND_SMNT[] = "SMNT";
static PROGMEM char FTP_COMMAND_QUIT[] = "QUIT";
static PROGMEM char FTP_COMMAND_REIN[] = "REIN";
static PROGMEM char FTP_COMMAND_PORT[] = "PORT";
static PROGMEM char FTP_COMMAND_PASV[] = "PASV";
static PROGMEM char FTP_COMMAND_TYPE[] = "TYPE";
static PROGMEM char FTP_COMMAND_STRU[] = "STRU";
static PROGMEM char FTP_COMMAND_MODE[] = "MODE";
static PROGMEM char FTP_COMMAND_RETR[] = "RETR";
static PROGMEM char FTP_COMMAND_STOR[] = "STOR";
static PROGMEM char FTP_COMMAND_STOU[] = "STOU";
static PROGMEM char FTP_COMMAND_APPE[] = "APPE";
static PROGMEM char FTP_COMMAND_ALLO[] = "ALLO";
static PROGMEM char FTP_COMMAND_REST[] = "REST";
static PROGMEM char FTP_COMMAND_RNFR[] = "RNFR";
static PROGMEM char FTP_COMMAND_RNTO[] = "RNTO";
static PROGMEM char FTP_COMMAND_ABOR[] = "ABOR";
static PROGMEM char FTP_COMMAND_DELE[] = "DELE";
static PROGMEM char FTP_COMMAND_RMD	[] = "RMD";
static PROGMEM char FTP_COMMAND_MKD	[] = "MKD";
static PROGMEM char FTP_COMMAND_PWD	[] = "PWD";
static PROGMEM char FTP_COMMAND_LIST[] = "LIST";
static PROGMEM char FTP_COMMAND_NLST[] = "NLST";
static PROGMEM char FTP_COMMAND_SITE[] = "SITE";
static PROGMEM char FTP_COMMAND_SYST[] = "SYST";
static PROGMEM char FTP_COMMAND_STAT[] = "STAT";
static PROGMEM char FTP_COMMAND_HELP[] = "HELP";
static PROGMEM char FTP_COMMAND_NOOP[] = "NOOP";



#ifdef __CODEVISIONAVR__
#pragma regalloc-
#endif
unsigned char ftp_server_tcp_command = TCP_WRONG_CONNECTIONS;
unsigned char ftp_server_tcp_data = TCP_WRONG_CONNECTIONS;
unsigned char ftp_server_command[FTP_MAX_COMMAND_SIZE + 1];
unsigned char ftp_server_parameter[FTP_MAX_PARAMETER_SIZE + 1];
unsigned char ftp_server_data_ip[IP_ADR_SIZE];
unsigned int ftp_server_data_port;
unsigned int ftp_server_flag =
   FTP_FLAG_TYPE_A | FTP_FLAG_TYPE_N | FTP_FLAG_MODE_S | FTP_FLAG_STRU_F;
FTP_STATE_MACHINE ftp_state_machine = FTP_STATE_CLOSED;
unsigned char ftp_file_handle = FILE_HANDLE_DISABLE;
unsigned char ftp_temp_buffer[TCP_TX_SEGMENT_SIZE];

#ifdef __CODEVISIONAVR__
#pragma regalloc+
#endif
unsigned char ftp_server_reply(PGM_P data)
{
#ifdef WEB_DEBUG_FTP
   static unsigned char repeat_count;
#endif

   if (tcp_tx_buffer_write_f
       (ftp_server_tcp_command, data, strlen_P(data),
        TCP_TX_BUFFER_WRITE_FLASH_DATA))
   {
#ifdef WEB_DEBUG_FTP
      if (web_debug_flag & WEB_DEBUG_FTP_BIT)
         printf_P(PSTR("FTP Reply: %S"), data);
      repeat_count = 0;
#endif
      return 1;
   }
#ifdef WEB_DEBUG_FTP
   if (web_debug_flag & WEB_DEBUG_FTP_BIT)
   {
      if (repeat_count == 0)
         printf_P(PSTR("FTP Reply-Error: %S"), data);
      repeat_count = 1;
   }
#endif
   return 0;
}


FTP_SERVER_GET_MODE ftp_server_get_command(TCP_STRUCTURE * p_struct)
{
   unsigned char command_len = 0, parameter_len = 0;
   unsigned char *data, telnet_command = 0;
   unsigned int tcp_data_len;

#ifdef WEB_DEBUG_FTP
   unsigned char *temp_data;
#endif

   if (p_struct->tcp_socket_status & SOCK_DATA_AVAILABLE)
   {
      data =
         tcp_rx_buffer_read(ftp_server_tcp_command, 0x0, &tcp_data_len,
                            TCP_RX_BUFFER_GET_SIZE);
#ifdef WEB_DEBUG_FTP
      temp_data = data;
#endif
      if (tcp_data_len > 4)
      {
         while ((*data != ' ') && (*data != '\r')
                && (command_len < FTP_MAX_COMMAND_SIZE))
         {
            ftp_server_command[command_len] = *data;
            data++;
            command_len++;
         }
         ftp_server_command[command_len] = 0x0;
         if ((command_len > 0) && (command_len <= FTP_MAX_COMMAND_SIZE))
         {
            // ----------------------------------------------
            // ftp parameter
            if (*data == ' ')
               data++;
            while ((*data != '\r')
                   && (parameter_len < FTP_MAX_PARAMETER_SIZE))
            {
               ftp_server_parameter[parameter_len] = *data;
               data++;
               parameter_len++;
            }
            ftp_server_parameter[parameter_len] = 0x0;
            // ----------------------------------------------
            // ftp command
            if (ftp_server_command[0] == 'X')
               strcpy(ftp_server_command, &ftp_server_command[1]);
            if (ftp_server_command[0] == 0xF2)
            {
               telnet_command = ftp_server_command[0];
               strcpy(ftp_server_command, &ftp_server_command[1]);
            }
            // ----------------------------------------------
#ifdef WEB_DEBUG_FTP
            if (web_debug_flag & WEB_DEBUG_FTP_BIT)
            {
               printf_P(PSTR("FTP Command: %s %s"), ftp_server_command,
                      ftp_server_parameter);
               if (telnet_command)
               {
                  switch (telnet_command)
                  {
                  case 0xF2:
                     printf_P(PSTR(" + Telnet-Synch"));
                     break;

                  }
               }
               printf_P(NewLine);
            }
#endif
            if (telnet_command)
               return FTP_SERVER_GET_BREAK;
            return FTP_SERVER_GET_NORMAL;
         }
         else
         {
#ifdef WEB_DEBUG_FTP
            if (web_debug_flag & WEB_DEBUG_FTP_BIT)
            {
               printf_P(PSTR("FTP wrong Command: %u Byte\n"), tcp_data_len);
               debug_display_frame(temp_data, tcp_data_len, 0);
            }
#endif
         }
      }
   }  // if(p_struct->tcp_socket_status & SOCK_DATA_AVAILABLE)
   return FTP_SERVER_GET_NOTHING;
}


unsigned char ftp_server_user(void)
{
   if (strcmp_P(ftp_server_parameter, FTP_USER_ID) != 0)
      return 0;
   if (ftp_server_reply(FTP_REPLY_331))
      return 1;
   return 0;
}


unsigned char ftp_server_password(void)
{
   if (strcmp_P(ftp_server_parameter, FTP_PASSWORD) != 0)
      return 0;
#ifdef FTP_ACCOUNT_ENABLE
   if (ftp_server_reply(FTP_REPLY_332))
      return 1;
#else
   if (ftp_server_reply(FTP_REPLY_230))
      return 1;
#endif
   return 0;
}


#ifdef FTP_ACCOUNT_ENABLE
unsigned char ftp_server_account(void)
{
   if (strcmp_P(ftp_server_parameter, FTP_ACCOUNT) != 0)
      return 0;
   if (ftp_server_reply(FTP_REPLY_230))
      return 1;
   return 0;
}
#endif


unsigned char ftp_server_port(void)
{
   unsigned char *parameter;

   if (ftp_server_parameter == 0x0)
      return 0;
   parameter = ftp_server_parameter;

   ftp_server_data_ip[0] = atoi(parameter);
   while ((*parameter != ',') && (*parameter != 0x0))
      parameter++;
   parameter++;
   ftp_server_data_ip[1] = atoi(parameter);
   while ((*parameter != ',') && (*parameter != 0x0))
      parameter++;
   parameter++;
   ftp_server_data_ip[2] = atoi(parameter);
   while ((*parameter != ',') && (*parameter != 0x0))
      parameter++;
   parameter++;
   ftp_server_data_ip[3] = atoi(parameter);
   while ((*parameter != ',') && (*parameter != 0x0))
      parameter++;
   parameter++;
   ftp_server_data_port = atoi(parameter);
   ftp_server_data_port <<= 8;
   while ((*parameter != ',') && (*parameter != 0x0))
      parameter++;
   parameter++;
   ftp_server_data_port |= atoi(parameter);
#ifdef WEB_DEBUG_FTP
   if (web_debug_flag & WEB_DEBUG_FTP_BIT)
   {
      printf_P(PSTR("FTP PORT-IP: %u.%u.%u.%u Port: %u\n"), ftp_server_data_ip[0],
             ftp_server_data_ip[1], ftp_server_data_ip[2],
             ftp_server_data_ip[3], ftp_server_data_port);
   }
#endif
   return 1;
}



unsigned char ftp_server_data_start(void)
{
   if (ftp_server_flag & FTP_FLAG_PASSIV)
   {

   }
   else
   {
      if (ftp_server_tcp_data == TCP_WRONG_CONNECTIONS)
         ftp_server_tcp_data =
            tcp_active_open(ftp_server_data_ip, ftp_server_data_port,
                            TCP_PORT_FTP_DATA);
      else
         return 0;
      if (ftp_server_tcp_data == TCP_WRONG_CONNECTIONS)
         return 0;
#ifdef WEB_DEBUG_FTP
      if (web_debug_flag & WEB_DEBUG_FTP_BIT)
         printf_P(PSTR("FTP Data Active Open (TCP: %u)\n"), ftp_server_tcp_data);
#endif
      ftp_server_reply(FTP_REPLY_150);
   }
   return 1;
}

static PROGMEM char Cnix[] = "";
static PROGMEM char Cjan[] = "Jan";
static PROGMEM char Cfeb[] = "Feb";
static PROGMEM char Cmar[] = "Mar";
static PROGMEM char Capr[] = "Apr";
static PROGMEM char Cmay[] = "May";
static PROGMEM char Cjun[] = "Jun";
static PROGMEM char Cjul[] = "Jul";
static PROGMEM char Caug[] = "Aug";
static PROGMEM char Csep[] = "Sep";
static PROGMEM char Coct[] = "Oct";
static PROGMEM char Cnov[] = "Nov";
static PROGMEM char Cdec[] = "Dec";
PGM_P date_month[16] PROGMEM = {
   Cnix, Cjan, Cfeb, Cmar,
   Capr, Cmay, Cjun, Cjul,
   Caug, Csep, Coct, Cnov,
   Cdec, Cnix, Cnix, Cjan
};

void ftp_server_list_dir_file(unsigned int *count, unsigned char start)
{
   static unsigned char dir_count;
   static unsigned char dir_file_state;
   unsigned char file_find;
   unsigned int Lva;
   unsigned char data[22];
   DIR_NAME_STRUCT dir_struct;
   FILE_NAME_STRUCT file_struct;

   if (start)
   {
      dir_count = 0;
      dir_file_state = 0;
   }
   ftp_temp_buffer[0] = 0;
   if (dir_file_state == 0)
   {
      dir_file_state = 1;
   }
   if (dir_file_state == 1)
   {
      for (Lva = dir_count; Lva < FILE_DIR_COUNT; Lva++)
      {
         if (dataflash_dir_search(0x0, &dir_count, &dir_struct))
         {
            strcat_P(ftp_temp_buffer, PSTR("d--------- 1 ftp ftp      0 "));
            if (dir_struct.date.year == 3)
            {
               sprintf_P(data, PSTR("%S %02u %02u:%02u "),
                       pgm_read_word(&date_month[dir_struct.date.month]), dir_struct.date.day,
                       dir_struct.date.hour, dir_struct.date.minute);
               (*count) += 13;
            }
            else
            {
               sprintf_P(data, PSTR("%S %02u %04u "),
                       pgm_read_word(&date_month[dir_struct.date.month]), dir_struct.date.day,
                       (unsigned int) dir_struct.date.year + 2000);
               (*count) += 12;
            }
            strcat(ftp_temp_buffer, data);
            strcat(ftp_temp_buffer, dir_struct.name);
            strcat_P(ftp_temp_buffer, FTP_CRLF);
            (*count) += 28 + strlen(dir_struct.name) + sizeof(FTP_CRLF);
         }
         dir_count++;
         if (dir_count >= FILE_DIR_COUNT)
            dir_file_state = 2;
         if ((*count) >
             (sizeof(ftp_temp_buffer) -
              (28 + 13 + DIR_NAME_SIZE + sizeof(FTP_CRLF))))
            return;
      }
   }
   if ((dir_file_state == 2) || (dir_file_state == 3))
   {
      while (1)
      {
         if (dir_file_state == 2)
         {
            file_find =
               dataflash_file_search(0x0, &file_struct, 0x0, SEARCH_FIRST);
            dir_file_state = 3;
         }
         else
            file_find =
               dataflash_file_search(0x0, &file_struct, 0x0, SEARCH_NEXT);
         if (file_find == 0)
         {
            dir_file_state = 4;
            return;
         }
         else
         {
            strcat_P(ftp_temp_buffer, PSTR("---------- 1 ftp ftp "));
            sprintf_P(data, PSTR("%6lu "),
                    (unsigned long) (file_struct.countpage -
                                     1) * FILE_DATA_PAGE_SIZE +
                    file_struct.lastpage_byte);
            strcat(ftp_temp_buffer, data);
            sprintf_P(data, PSTR("%S %02u %02u:%02u "),
                    pgm_read_word(&date_month[file_struct.date.month]), file_struct.date.day,
                    file_struct.date.hour, file_struct.date.minute);
            (*count) += 13;
            strcat(ftp_temp_buffer, data);
            strcat(ftp_temp_buffer, file_struct.name);
            strcat_P(ftp_temp_buffer, FTP_CRLF);
            (*count) += 21 + 7 + strlen(file_struct.name) + sizeof(FTP_CRLF);
            if ((*count) >
                (sizeof(ftp_temp_buffer) -
                 (21 + 7 + 13 + FILE_NAME_SIZE + sizeof(FTP_CRLF))))
               return;
         }
      }
   }
   if (dir_file_state == 4)
      return;
}


unsigned char ftp_server_list(unsigned char start)
{
   static unsigned int count;
   static unsigned char state;
   TCP_STRUCTURE *p_struct;

   if (ftp_server_tcp_data == TCP_WRONG_CONNECTIONS)
      return 0;
   if (start)
   {
      state = 0;
      count = 0;
      ftp_server_list_dir_file(&count, 1);
   }
   if (state == 1)
   {
      if (count == 0)
      {
         ftp_server_list_dir_file(&count, 0);
         if (count == 0)
            return 0;
      }
   }
   p_struct = tcp_get_struct(ftp_server_tcp_data);
   if ((p_struct != 0) && (p_struct->tcp_socket_status & SOCK_CONNECTED))
   {
      state = 1;
      if (tcp_tx_buffer_write
          (ftp_server_tcp_data, ftp_temp_buffer, count,
           TCP_TX_BUFFER_WRITE_RAM_DATA))
      {
#ifdef WEB_DEBUG_FTP
         if (web_debug_flag & WEB_DEBUG_FTP_BIT)
            printf_P(PSTR("FTP DATA: %u Byte\n"), count);
#endif
         count = 0;
      }
   }
   return 1;
}


unsigned char ftp_server_type(void)
{
   unsigned char type;

   if (ftp_server_parameter)
   {
      ftp_server_flag &= ~FTP_FLAG_TYPE_MASK;
      ftp_server_flag |= FTP_FLAG_TYPE_N;
      type = ftp_server_parameter[0];
      switch (type)
      {
      case 'A':
         ftp_server_flag |= FTP_FLAG_TYPE_A;
         break;
      case 'I':
         ftp_server_flag |= FTP_FLAG_TYPE_I;
         break;
      case 'E':
      case 'L':
         ftp_server_reply(FTP_REPLY_504);
         return 0;
      default:
         ftp_server_flag |= (FTP_FLAG_TYPE_A | FTP_FLAG_TYPE_N);
      }
      ftp_server_reply(FTP_REPLY_200);
      return 1;
   }
   ftp_server_reply(FTP_REPLY_501);
   return 0;
}


unsigned char ftp_server_pwd(void)
{
   unsigned char data_buffer[60];
   unsigned char info_buffer[30];

#ifdef	DATAFLASH_FILE_ENABLE
   DIR_NAME_STRUCT dir_struct;
#endif

   sprintf_P(info_buffer, PSTR("eTW_%u_%u_%u_%u:\\\\"), ip_address[0], ip_address[1],
           ip_address[2], ip_address[3]);
#ifdef	DATAFLASH_FILE_ENABLE
   if (dataflash_dir_search(0x0, &directory_actual, &dir_struct))
   {
      sprintf_P(data_buffer, PSTR("%s\\\\"), dir_struct.name);
      strncat(info_buffer, data_buffer,
              sizeof(info_buffer) - strlen(info_buffer));
   }
#endif
   sprintf_P(data_buffer, FTP_REPLY_257, info_buffer);
   if (tcp_tx_buffer_write
       (ftp_server_tcp_command, data_buffer, strlen(data_buffer),
        TCP_TX_BUFFER_WRITE_RAM_DATA))
   {
#ifdef WEB_DEBUG_FTP
      if (web_debug_flag & WEB_DEBUG_FTP_BIT)
         printf_P(PSTR("FTP PWD: %s\n"), info_buffer);
#endif
      return 1;
   }
   ftp_server_reply(FTP_REPLY_550);
   return 0;
}


unsigned char ftp_server_retr_data(unsigned char start)
{
   static unsigned int count;
   TCP_STRUCTURE *p_struct;

   if (ftp_server_tcp_data == TCP_WRONG_CONNECTIONS)
      return 0;
   if (start)
   {
      count = 0;
      if (dataflash_file_open(ftp_server_parameter, &ftp_file_handle))
      {
         count =
            dataflash_file_read(ftp_file_handle, ftp_temp_buffer,
                                sizeof(ftp_temp_buffer));
      }
   }
   if (count == 0)
   {
      if (ftp_file_handle != FILE_HANDLE_DISABLE)
      {
         count =
            dataflash_file_read(ftp_file_handle, ftp_temp_buffer,
                                sizeof(ftp_temp_buffer));
      }
      if (count == 0)
      {
         if (ftp_file_handle != FILE_HANDLE_DISABLE)
            dataflash_file_close(&ftp_file_handle);
         return 0;
      }
   }
   p_struct = tcp_get_struct(ftp_server_tcp_data);
   if ((p_struct != 0) && (p_struct->tcp_socket_status & SOCK_CONNECTED))
   {
      if (tcp_tx_buffer_write
          (ftp_server_tcp_data, ftp_temp_buffer, count,
           TCP_TX_BUFFER_WRITE_RAM_DATA))
      {
#ifdef WEB_DEBUG_FTP
         if (web_debug_flag & WEB_DEBUG_FTP_BIT)
            printf_P(PSTR("FTP DATA: %u Byte\n"), count);
#endif
         count = 0;
      }
   }
   return 1;
}

unsigned char ftp_server_stor_data(unsigned char start)
{
   static unsigned char state;
   unsigned int tcp_data_count;
   TCP_STRUCTURE *p_struct;

   p_struct = tcp_get_struct(ftp_server_tcp_data);
   if (p_struct == 0)
      return 0;
   if (start)
   {
      state = 0;
      if (dataflash_file_new(ftp_server_parameter))
         dataflash_file_open(ftp_server_parameter, &ftp_file_handle);
      else
      {
         if (dataflash_file_open(ftp_server_parameter, &ftp_file_handle))
         {
            dataflash_file_delete(ftp_file_handle);
            if (dataflash_file_new(ftp_server_parameter))
               dataflash_file_open(ftp_server_parameter, &ftp_file_handle);
         }
      }
   }
   if (p_struct->tcp_socket_status & SOCK_CONNECTED)
   {
      state = 1;
      if (p_struct->tcp_socket_status & SOCK_DATA_AVAILABLE)
      {
         tcp_data_count = sizeof(ftp_temp_buffer);
         tcp_rx_buffer_read(ftp_server_tcp_data, ftp_temp_buffer,
                            &tcp_data_count, TCP_RX_BUFFER_READ_DATA);
         if (ftp_file_handle != FILE_HANDLE_DISABLE)
         {
            if (!dataflash_file_write
                (ftp_file_handle, ftp_temp_buffer, tcp_data_count))
            {
               ftp_server_reply(FTP_REPLY_552);
               dataflash_file_close(&ftp_file_handle);
            }
         }
         else
            ftp_server_reply(FTP_REPLY_550);
      }
   }
   else
   {
      if (state == 1)
      {
         if (ftp_file_handle != FILE_HANDLE_DISABLE)
            dataflash_file_close(&ftp_file_handle);
         return 0;
      }
   }
   return 1;
}


void ftp_server_dele(void)
{
   if (ftp_file_handle == FILE_HANDLE_DISABLE)
   {
      if (dataflash_file_open(ftp_server_parameter, &ftp_file_handle))
      {
         dataflash_file_delete(ftp_file_handle);
         ftp_file_handle = FILE_HANDLE_DISABLE;
         ftp_server_reply(FTP_REPLY_250);
         return;
      }
   }
   ftp_server_reply(FTP_REPLY_550);
}


#ifdef WEB_DEBUG_FTP
static PROGMEM char CstClosed[] = "FTP_STATE_CLOSED";
static PROGMEM char CstUid[]    = "FTP_STATE_USER_ID";
static PROGMEM char CstPwd[]    = "FTP_STATE_PASSWORD";
static PROGMEM char CstCmd[]    = "FTP_STATE_COMMAND";
static PROGMEM char CstAcct[]   = "FTP_STATE_ACCOUNT";
static PROGMEM char CstList[]   = "FTP_STATE_LIST";
static PROGMEM char CstRetr[]   = "FTP_STATE_RETR";
static PROGMEM char CstStore[]  = "FTP_STATE_STOR";
PGM_P ftp_state_name[8] PROGMEM = {
   CstClosed, CstUid, CstPwd, CstCmd,
   CstAcct, CstList, CstRetr, CstStore
};
#endif

void ftp_server(void)
{
#ifdef WEB_DEBUG_FTP
   static FTP_STATE_MACHINE temp_ftp_state_machine = FTP_STATE_CLOSED;
#endif
   FTP_SERVER_GET_MODE new_ftp_command;
   TCP_STRUCTURE *p_struct;

#ifdef WEB_DEBUG_FTP
   if (web_debug_flag & WEB_DEBUG_FTP_BIT)
   {
      if (temp_ftp_state_machine != ftp_state_machine)
      {
         printf_P(PSTR("FTP State: %S\n"), pgm_read_word(&ftp_state_name[ftp_state_machine]));
         temp_ftp_state_machine = ftp_state_machine;
      }
   }
#endif
   p_struct = tcp_get_struct(ftp_server_tcp_command);
   if ((p_struct != 0) && (p_struct->tcp_socket_status & SOCK_CONNECTED))
   {
      new_ftp_command = ftp_server_get_command(p_struct);
      if (new_ftp_command == FTP_SERVER_GET_BREAK)
         ftp_state_machine = FTP_STATE_COMMAND;
      switch (ftp_state_machine)
      {
      case FTP_STATE_CLOSED:
         if (ftp_server_reply(FTP_REPLY_220))
         {
            memcpy(ftp_server_data_ip, p_struct->tcp_ip_remote, IP_ADR_SIZE);
            ftp_server_data_port = TCP_PORT_FTP_DATA;
            ftp_state_machine = FTP_STATE_USER_ID;
#ifdef ICMP_ENABLE
            icmp_prepare_timestamp_request(p_struct->tcp_ip_remote,
                                           p_struct->tcp_mac_remote, 0);
#endif
         }
         break;
      case FTP_STATE_USER_ID:
         if (!(new_ftp_command))
            break;
         if (strcmp_P(ftp_server_command, FTP_COMMAND_USER) == 0)
         {
            if (ftp_server_user())
               ftp_state_machine = FTP_STATE_PASSWORD;
            else
            {
               ftp_server_reply(FTP_REPLY_501);
               tcp_close(ftp_server_tcp_command);
            }
         }
         break;
      case FTP_STATE_PASSWORD:
         if (!(new_ftp_command))
            break;
         if (strcmp_P(ftp_server_command, FTP_COMMAND_PASS) == 0)
         {
            if (ftp_server_password())
            {
#ifdef FTP_ACCOUNT_ENABLE
               ftp_state_machine = FTP_STATE_ACCOUNT;
#else
               ftp_state_machine = FTP_STATE_COMMAND;
#endif
            }
            else
            {
               ftp_server_reply(FTP_REPLY_501);
               tcp_close(ftp_server_tcp_command);
            }
         }
         break;
#ifdef FTP_ACCOUNT_ENABLE
      case FTP_STATE_ACCOUNT:
         if (!(new_ftp_command))
            break;
         if (strcmp_P(ftp_server_command, FTP_COMMAND_ACCT) == 0)
         {
            if (ftp_server_account())
               ftp_state_machine = FTP_STATE_COMMAND;
            else
            {
               ftp_server_reply(FTP_REPLY_501);
               tcp_close(ftp_server_tcp_command);
            }
         }
         break;
#endif
      case FTP_STATE_LIST:
         if (!(ftp_server_list(0)))
         {
            if (ftp_server_reply(FTP_REPLY_226))
            {

               tcp_close(ftp_server_tcp_data);
               ftp_server_tcp_data = TCP_WRONG_CONNECTIONS;
               ftp_state_machine = FTP_STATE_COMMAND;
            }
         }
         break;
      case FTP_STATE_RETR:
         if (!(ftp_server_retr_data(0)))
         {
            if (ftp_server_reply(FTP_REPLY_226))
            {

               tcp_close(ftp_server_tcp_data);
               ftp_server_tcp_data = TCP_WRONG_CONNECTIONS;
               ftp_state_machine = FTP_STATE_COMMAND;
            }
         }
         break;
      case FTP_STATE_STOR:
         if (!(ftp_server_stor_data(0)))
         {
            if (ftp_server_reply(FTP_REPLY_226))
            {

               tcp_close(ftp_server_tcp_data);
               ftp_server_tcp_data = TCP_WRONG_CONNECTIONS;
               ftp_state_machine = FTP_STATE_COMMAND;
            }
         }
         break;
      case FTP_STATE_COMMAND:
         if (ftp_file_handle != FILE_HANDLE_DISABLE)
         {
#ifdef WEB_DEBUG_FTP
            if (web_debug_flag & WEB_DEBUG_FTP_BIT)
               printf_P(PSTR("FTP ERROR Close File: %u\n"), ftp_file_handle);
#endif
            if (!dataflash_file_close(&ftp_file_handle))
            {
               dataflash_file_close_all();
               ftp_file_handle = FILE_HANDLE_DISABLE;
            }
         }
         if (!(new_ftp_command))
            break;
         if (strcmp_P(ftp_server_command, FTP_COMMAND_QUIT) == 0)
         {
            ftp_server_reply(FTP_REPLY_221);

            tcp_close(ftp_server_tcp_data);
            ftp_server_tcp_data = TCP_WRONG_CONNECTIONS;
            tcp_close(ftp_server_tcp_command);
            break;
         }
         if (strcmp_P(ftp_server_command, FTP_COMMAND_ABOR) == 0)
         {
            if (ftp_server_tcp_data != TCP_WRONG_CONNECTIONS)
            {

               tcp_close(ftp_server_tcp_data);
               ftp_server_tcp_data = TCP_WRONG_CONNECTIONS;
               ftp_server_reply(FTP_REPLY_226);
            }
            break;
         }
         if (strcmp_P(ftp_server_command, FTP_COMMAND_PORT) == 0)
         {
            if (ftp_server_port())
               ftp_server_reply(FTP_REPLY_200);
            break;
         }
         if (strcmp_P(ftp_server_command, FTP_COMMAND_TYPE) == 0)
         {
            ftp_server_type();
            break;
         }
         if (strcmp_P(ftp_server_command, FTP_COMMAND_RETR) == 0)
         {
            if (ftp_server_data_start())
            {
               if (ftp_server_retr_data(1))
                  ftp_state_machine = FTP_STATE_RETR;
               else
               {
                  if (ftp_server_reply(FTP_REPLY_226))
                  {

                     tcp_close(ftp_server_tcp_data);
                     ftp_server_tcp_data = TCP_WRONG_CONNECTIONS;
                  }
               }
            }
            else
               ftp_server_reply(FTP_REPLY_425);
            break;
         }
         if (strcmp_P(ftp_server_command, FTP_COMMAND_STOR) == 0)
         {
            if (ftp_server_data_start())
            {
               ftp_server_stor_data(1);
               ftp_state_machine = FTP_STATE_STOR;
            }
            else
               ftp_server_reply(FTP_REPLY_425);
            break;
         }
         if (strcmp_P(ftp_server_command, FTP_COMMAND_NOOP) == 0)
         {
            ftp_server_reply(FTP_REPLY_200);
            break;
         }
         if (strcmp_P(ftp_server_command, FTP_COMMAND_PWD) == 0)
         {
            ftp_server_pwd();
            break;
         }
         if (strcmp_P(ftp_server_command, FTP_COMMAND_SYST) == 0)
         {
            ftp_server_reply(FTP_REPLY_215);
            break;
         }
         if (strcmp_P(ftp_server_command, FTP_COMMAND_HELP) == 0)
         {
            ftp_server_reply(FTP_REPLY_214);
            break;
         }

         if (strcmp_P(ftp_server_command, FTP_COMMAND_LIST) == 0)
         {
            if (ftp_server_data_start())
            {
               ftp_state_machine = FTP_STATE_LIST;
               ftp_server_list(1);
            }
            else
               ftp_server_reply(FTP_REPLY_425);
            break;
         }
         if (strcmp_P(ftp_server_command, FTP_COMMAND_NLST) == 0)
         {
            if (ftp_server_data_start())
            {
               ftp_state_machine = FTP_STATE_LIST;
               ftp_server_list(1);
            }
            else
               ftp_server_reply(FTP_REPLY_425);
            break;
         }
         if (strcmp_P(ftp_server_command, FTP_COMMAND_DELE) == 0)
         {
            ftp_server_dele();
            break;
         }

         ftp_server_reply(FTP_REPLY_502);
#ifdef WEB_DEBUG_FTP
         if (web_debug_flag & WEB_DEBUG_FTP_BIT)
            printf_P(PSTR("FTP Unsupported Command: %s\n"), ftp_server_command);
#endif
         break;
      default:
         break;
      }                         // switch(ftp_state_machine)
      if (p_struct->tcp_socket_status & SOCK_DATA_AVAILABLE)
         tcp_rx_buffer_clear(ftp_server_tcp_command);
   }                            // if(p_struct->tcp_socket_status &
                                // SOCK_CONNECTED)
   else
   {
      if (ftp_state_machine != FTP_STATE_CLOSED)
      {
         // tcp_abort(ftp_server_tcp_data);
         tcp_close(ftp_server_tcp_data);
         ftp_server_tcp_data = TCP_WRONG_CONNECTIONS;
         tcp_close(ftp_server_tcp_command);
      }
      ftp_state_machine = FTP_STATE_CLOSED;
   }
}


#ifdef WEB_DEBUG_FTP
void ftp_debug_do_cmd(unsigned char *command)
{
   if (strncmp_P(command, PSTR("ftp-info"), 5) == 0)
   {
      printf_P(PSTR("tcp_command: %u\n"), ftp_server_tcp_command);
      printf_P(PSTR("tcp_data   : %u\n"), ftp_server_tcp_data);
      printf_P(PSTR("command    : %s\n"), ftp_server_command);
      printf_P(PSTR("parameter  : %s\n"), ftp_server_parameter);
      debug_print_ip(PSTR("ip         "), ftp_server_data_ip);
      printf_P(PSTR("port       : %u\n"), ftp_server_data_port);
      printf_P(PSTR("flag       : 0x%04x\n"), ftp_server_flag);
      printf_P(PSTR("state      : %S\n"), pgm_read_word(&ftp_state_name[ftp_state_machine]));
      printf_P(PSTR("handle     : %u\n"), ftp_file_handle);
   }
   if (strncmp_P(command, PSTR("ftp-pass"), 5) == 0)
   {
   }
   if (strncmp_P(command, PSTR("ftp-user"), 5) == 0)
   {
   }
}
#endif
#endif // #ifdef FTP_ENABLE
