
/*****************************************************************************
 *
 *                              "hardware.c"
 *                   -----------------------------
 *
 *  Version:    2.04
 *  File:    	..\source\hardware.c
 *  Created:    09.06.2005
 *  Date:       09.06.2005
 *  Author:     Copyright (C) 2001-2005
 *              Udo Jakobza - FTZ Leipzig; D-04107 Leipzig; Wchterstr. 13
 *				info@easytoweb.net
 *  Func:	Microcontroller functions for easyToWeb-AVR board
 *  License:
 *    This library is free software; you can redistribute it and/or modify it
 *    under the terms of the GNU Lesser General Public License as published by
 *    the Free Software Foundation; either version 2.1 of the License, or
 *    (at your option) any later version. This library is distributed in the hope
 *    that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *    warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *    See the GNU Lesser General Public License for more details.
 *	  see: http://www.gnu.org/copyleft/lesser.html
 *    You should have received a copy of the GNU Lesser General Public License
 *    along with this library; if not, write to the Free Software Foundation,
 *    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *    Die Bibliothek ist freie Software; Sie drfen sie unter den Bedingungen der
 *    GNU Lesser General Public License, wie von der Free Software Foundation
 *    verffentlicht, weiterverteilen und/oder modifizieren; entweder gem
 *    Version 2.1 der Lizenz oder (nach Ihrer Option) jeder spteren Version.
 *    Diese Bibliothek wird in der Hoffnung weiterverbreitet, da sie ntzlich
 *    sein wird, jedoch OHNE IRGENDEINE GARANTIE, auch ohne die implizierte
 *    Garantie der MARKTREIFE oder der VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK.
 *    Mehr Details finden Sie in der GNU Lesser General Public License.
 *	  see: http://www.gnu.org/copyleft/lesser.de.html
 *    Sie sollten eine Kopie der GNU Lesser General Public License zusammen mit
 *    dieser Bibliothek erhalten haben; falls nicht, schreiben Sie an die FSF,
 *    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 *  history:
 *		1.) 30.07.2003 Version 2.00a
 *		2.) 11.11.2003 Version 2.02
 *			a.)	- add variable "second_counter"(32bit) and
 *                "day_counter"(16bit)
 *		3.) 30.01.2004 Version 2.03
 *			a.)	- functions memcpye() and memcpy2e() now with 16bit count
 *		4.) 31.01.2004 Version 2.03
 *			a.)	- new function memsete(), see memset
 *		5.) 25.02.2004 Version 2.03
 *			a.)	- new file structure, see also so util.c
 *		6.) 31.05.2005 Version 2.0x
 *			a.)	- etw_mc_spi_init renamed to hardware_spi_init()
 *		7.) 09.06.2005 Version 2.0x
 *			a.)	- rename the file etw_mc.c to hardware.c
 *
 *****************************************************************************/
#include "project.h"

#include <stdio.h>
#include <string.h>


#ifdef __CODEVISIONAVR__
#ifdef BOARD_ETW_AVR
#asm
    .equ __w1_port = 0x12.equ __w1_bit = 7
#endasm
#endif
#ifdef BOARD_ETW_ATMEGA32
#asm
   .equ __w1_port = 0x12.equ __w1_bit = 2
#endasm
#endif

#ifdef DEVICE_CS8900
#include <1wire.h>
#include <ds2430.h>
#endif
#endif

#ifdef DEVICE_CS8900
#include CS8900_H_FILEPATH
#endif

#ifndef __CODEVISIONAVR__
#include <avr/interrupt.h>
#include <avr/io.h>
#include <avr/signal.h>
#include <avr/sleep.h>
#include <avr/wdt.h>
//#include <avr/delay.h>
#endif

#include UTIL_H_FILEPATH
#include HARDWARE_H_FILEPATH
#ifdef WEB_DEBUG
#include WEB_DEBUG_H_FILEPATH
#endif
#ifdef WEB_DEBUG_MEASURE
#include MEASURE_H_FILEPATH
#endif
#ifdef TCP_ENABLE
#include TCP_H_FILEPATH
#endif
#ifdef DEVICE_PPP
#include PPP_H_FILEPATH
#include ATI_H_FILEPATH
#endif
#ifdef DEBUG_DATAFLASH
#include DATAFLASH_DEBUG_H_FILEPATH
#endif
#ifdef	DATAFLASH_ENABLE
#include DATAFLASH_H_FILEPATH
#endif
#ifdef	DATAFLASH_FILE_ENABLE
#include DATAFLASH_FILE_H_FILEPATH
#include DATAFLASH_FILE_DEBUG_H_FILEPATH
#endif
#ifdef AT_DEVICE_BLUETOOTH
#include BLUETOOTH_H_FILEPATH
#endif
#ifdef ENABLE_EEPROM_ADDRESS
#include <avr/eeprom.h>
unsigned char eeprom_ip[IP_ADR_SIZE] EEMEM = IP_DEFAULT;
unsigned char eeprom_submask[IP_ADR_SIZE] EEMEM = IP_SUBMASK_DEFAULT;
unsigned char eeprom_gateway[IP_ADR_SIZE] EEMEM = IP_GATEWAY_DEFAULT;
#endif

#include DEVICE_H_FILEPATH

#ifdef __CODEVISIONAVR__
#pragma regalloc-
#endif
volatile unsigned int counter_10ms_16bit;
volatile unsigned long second_counter = 0;
volatile unsigned int day_counter = 378;
unsigned char hardware_reset_status = 0;

#ifdef __CODEVISIONAVR__
#pragma regalloc+
#endif

#ifndef DS2430_PROM_SIZE
#define DS2430_PROM_SIZE	8
#endif

#ifdef DEVICE_CS8900
unsigned char hardware_read_CS8900_mac(unsigned char *romcode_buffer,
                                unsigned char *data_buffer,
                                unsigned char device)
{
   unsigned char devices_1wire = 0;
#if 0
   unsigned char romcodes_1wire[MAX_1WIRE_DEVICES, 9];
   unsigned char new_data_buffer[DS2430_PROM_SIZE];
   unsigned char sreg;

   sreg = SREG;
   cli();
   devices_1wire = w1_search(0xf0, romcodes_1wire);
   if ((device >= devices_1wire) && (device >= MAX_1WIRE_DEVICES))
      devices_1wire = 0;
   if (devices_1wire)
   {
      if (romcode_buffer)
         memcpy(romcode_buffer, romcodes_1wire, sizeof(romcodes_1wire));
      if (romcodes_1wire[device, 0] == DS2430_FAMILY_CODE)
      {
         if (!ds2430_read_appreg_block
             (&romcodes_1wire[device, 0], new_data_buffer, 0,
              DS2430_PROM_SIZE))
         {
            devices_1wire = 0;
         }
         else
         {
            if (data_buffer)
               memcpy(data_buffer, new_data_buffer, DS2430_PROM_SIZE);
            if (((new_data_buffer[0] != 0x10) || (new_data_buffer[1] != 0x00)
                 || (new_data_buffer[2] != 0xaa))
                && ((new_data_buffer[0] != 0x00)
                    || (new_data_buffer[1] != 0x50)
                    || (new_data_buffer[2] != 0xc2)))
            {
               devices_1wire = 0;
            }
         }
      }
   }
   SREG = sreg;
#endif
   return devices_1wire;
}
#endif

void hardware_timer1_init(void)
{
   TCCR1B = 0;      // stop counter
   TCNT1  = 0;
   OCR1A  = TIMER1_ACOMP; // (F_CPU / 800) 16000000 / 8 / 800 = 2500 Hz -> 2.5ms
   // OCIE2 TOIE2 TICIE1 OCIE1A OCIE1B TOIE1 OCIE0 TOIE0 = TIMSK
   TIMSK  |= (1<<OCIE1A); //0x10;
   TIFR   |= 0x10;
   // ICNC1 ICES1  WGM13 WGM12 CS12 CS11 CS10 = TCCR1B
   // CSn2 CSn1 CSn0 Description
   //   0     0    0 No clock source. (Timer/Counter stopped)
   //   0     0    1 clkI/O/1 (No prescaling
   //   0     1    0 clkI/O/8 (From prescaler)
   //   0     1    1 clkI/O/64 (From prescaler)
   //   1     0    0 clkI/O/256 (From prescaler)
   //   1     0    1 clkI/O/1024 (From prescaler)
   //   1     1    0 External clock source on Tn pin. Clock on falling edge
   //   1     1    1 External clock source on Tn pin. Clock on rising edge
   TCCR1B = (0<<CS12)|(1<<CS11)|(0<<CS10); // /8 = TIMER1_PRE => 2MHzcounter freq; => 2.5
   TCCR1A = 0;          // WGM1 = 0 = Normal Mode
#ifdef WEB_DEBUG_MEASURE
   measure_init();
   TIFR   |= 0x04;
#endif
}

unsigned int hardware_timer1_counter(void)
{
   return TCNT1;
}

#ifndef __CODEVISIONAVR__

static volatile unsigned int ms_delay = 0;

void delay_ms(unsigned int ms)
{
    ms += 3;
    ms_delay = (ms * 4)/10;
    while(ms_delay != 0)
        ;
}
#endif
#ifdef __CODEVISIONAVR__
interrupt[TIM1_COMPA]
     void hardware_timer1_compa(void)
#else
SIGNAL(SIG_OUTPUT_COMPARE1A)
#endif
{
   static unsigned char count_100 = 0;

#ifdef TCP_ENABLE
   static unsigned char count_5 = 0;
#endif

   counter_10ms_16bit++;
#ifdef TCP_ENABLE
   count_5++;
   if (count_5 == 5)
   {
      count_5 = 0;
//counter_10ms_16bit++;
//#ifdef TCP_ENABLE
      tcp_clock_handler(); // jede ?ms
//#endif
   }
#endif
   count_100++;
   if (count_100 == /*401*/100)
   {
      count_100 = 0;
      second_counter++;
      if (second_counter >= 86400)
      {
         second_counter = 0;
         day_counter++;
      }
   }
   OCR1A += TIMER1_ACOMP;

#ifndef __CODEVISIONAVR__
   if(ms_delay)
    ms_delay--;
#endif
}


void hardware_set_second_counter(unsigned long new_value)
{
   unsigned char sreg = SREG;
   cli();
   second_counter = new_value;
   SREG = sreg;
}

#ifndef _MCU_CLOCK_FREQUENCY_
 #define _MCU_CLOCK_FREQUENCY_ F_CPU
#endif

void hardware_init(void)
{
   hardware_reset_status = (MCUCSR & 0x1f);
   MCUCSR &= ~0x1f;
   ADCSRA = 0x80;
/*
   LED1_ON;
   LED2_ON;
   LED3_ON;
   LED4_ON;
   LED1_ACTIV;
   LED2_ACTIV;
   LED3_ACTIV;
   LED4_ACTIV;
*/
#ifdef BOARD_ETW_AVR
   XMCRA = SRL_6;
   MCUCR = 0x80;
#if(_MCU_CLOCK_FREQUENCY_==16000000)
   XMCRA |= SRW11_XMCRA;
#endif
#if(_MCU_CLOCK_FREQUENCY_==7372800)
   MCUCR |= SRW10_MCUCR;
#endif
#if defined(AT_DEVICE_MODEM) || defined(AT_DEVICE_BLUETOOTH)
   // init UART1
   UCSR1A = 0x0;
   UCSR1B = 0x0;
   UCSR1A |= (1<<U2X1); //0x02;
   UBRR1 = ( _MCU_CLOCK_FREQUENCY_ / ( 8 * 115200UL )) - 1;
   // UBRR1L=_MCU_CLOCK_FREQUENCY_/(8*57600)-1; // ==34 bei 57600Baud und
   // 16.0000Mhz (-0.8% Fehler)
   // UBRR1L=_MCU_CLOCK_FREQUENCY_/(8*19200)-1; // ==103 bei 19200Baud und
   // 16.0000Mhz (0.2% Fehler)
   // UBRR1L=_MCU_CLOCK_FREQUENCY_/(8*9600)-1; // ==207 bei 9600kBaud und
   // 16.0000Mhz (0.2% Fehler)
//   UBRR1H = 0x00;
   //UCSR1B = 0x98;  // 1001 1000
   UCSR1B = (1<<RXCIE1) | (1<<RXEN1) | (1<<RXEN1);
#endif
#endif

#ifdef WEB_DEBUG
   web_debug_init();
#endif
   hardware_timer1_init();
#ifdef __CODEVISIONAVR__
#asm("wdr");
#else
   wdt_reset();
#endif
#ifdef WATCHDOG_ENABLE
#ifdef __CODEVISIONAVR__
   WDTCR = 0x18;
#ifdef WATCHDOG_16MS
   WDTCR = (0x08 | 0x00);
#endif
#ifdef WATCHDOG_32MS
   WDTCR = (0x08 | 0x01);
#endif
#ifdef WATCHDOG_65MS
   WDTCR = (0x08 | 0x02);
#endif
#ifdef WATCHDOG_130MS
   WDTCR = (0x08 | 0x03);
#endif
#ifdef WATCHDOG_260MS
   WDTCR = (0x08 | 0x04);
#endif
#ifdef WATCHDOG_520MS
   WDTCR = (0x08 | 0x05);
#endif
#ifdef WATCHDOG_1000MS
   WDTCR = (0x08 | 0x06);
#endif
#ifdef WATCHDOG_2100MS
   WDTCR = (0x08 | 0x07);
#endif
#else
#ifdef WATCHDOG_16MS
   wdt_enable(WDTO_15MS);
#endif
#ifdef WATCHDOG_32MS
   wdt_enable(WDTO_30MS);
#endif
#ifdef WATCHDOG_65MS
   wdt_enable(WDTO_60MS);
#endif
#ifdef WATCHDOG_130MS
   wdt_enable(WDTO_120MS);
#endif
#ifdef WATCHDOG_260MS
   wdt_enable(WDTO_250MS);
#endif
#ifdef WATCHDOG_520MS
   wdt_enable(WDTO_500MS);
#endif
#ifdef WATCHDOG_1000MS
   wdt_enable(WDTO_1S);
#endif
#ifdef WATCHDOG_2100MS
   wdt_enable(WDTO_2S);
#endif
#endif
#endif
   sei();
#ifdef __CODEVISIONAVR__
   sleep_enable();
#else
   set_sleep_mode(SLEEP_MODE_IDLE);
#endif
#ifdef DATAFLASH_ENABLE
   dataflash_init(SPI_MODE);
#endif
}

void hardware_ad_init(unsigned char init_value)
{
//   ADMUX = AD_REF_256 | AD_CHANNEL_0;
   ADMUX   = (1<<REFS1) | (1<<REFS0) | MUX0;
   ADCSRA  = init_value;
   ADCSRA |= (1<<4);
}


unsigned int hardware_ad_read(unsigned char channel)
{
   while (ADCSRA & (1<<ADSC))
      ;
//   ADMUX = AD_REF_256 | channel;
   ADMUX =  (1<<REFS1) | (1<<REFS0) | channel;
   ADCSRA |= (1<<ADSC);
   while (ADCSRA & (1<<ADSC))
       ;
   return ADCW;
}


#ifdef DEVICE_CS8900
void hardware_init_mac_address(void)
{
   unsigned char ds2430_buffer[DS2430_PROM_SIZE];

   if (hardware_read_CS8900_mac(0x0, ds2430_buffer, 0))
   {
      memcpy(mac_address, &ds2430_buffer[0], sizeof(mac_address));
      cs8900_set_mac(mac_address);
   }
}
#endif

#ifdef DEVICE_3c509b
extern void nic_init( uint8_t *addr );

// ToDo ...
void hardware_init_mac_address(void)
{
   unsigned char mac_buffer[sizeof(mac_address)];
   nic_init(mac_buffer);
      memcpy(mac_address, &mac_buffer[0], sizeof(mac_address));

}
#endif


#ifdef IP_ENABLE
void hardware_init_ip_addresses(void)
{
#ifdef ENABLE_EEPROM_ADDRESS
   memcpye(ip_address, eeprom_ip, sizeof(ip_address));
   memcpye(ip_subnet_mask, eeprom_submask, sizeof(ip_subnet_mask));
   memcpye(ip_gateway, eeprom_gateway, sizeof(ip_gateway));
#endif
}
#endif


#ifdef BOARD_ETW_AVR
#ifdef	DATAFLASH_ENABLE
void hardware_spi_init(unsigned int mode)
{
   if (mode & SPCR_MSTR)
   {                            // *** MASTER-MODE ***
      // MISO input
      // MOSI output
      // SCK output
      // /SS unused
      SPI_MISO_HIGH;
      SPI_MOSI_HIGH;
      SPI_SCK_HIGH;

      SPI_MISO_INPUT;
      SPI_MOSI_OUTPUT;
      SPI_SCK_OUTPUT;
   }
   else
   {                            // *** SLAVE-MODE ***
#ifdef WEB_DEBUG
      putsf("SPI supports only Master-Mode\r");
#endif
   }
#if defined(_CHIP_ATMEGA128_)||defined(_CHIP_ATMEGA128L_)||defined(_CHIP_ATMEGA32_)||defined(_CHIP_ATMEGA32L_)
   if (mode & 0x0100)
      SPSR .0 = 1;
   else
      SPSR .0 = 0;
#endif
   SPCR = mode;
#asm
   in r30, spsr;
   read the status - register in r30, spdr;
   read the data - register
#endasm
}
#endif
#endif


/* USART1 Status Register A - UCSR1A
#define    RXC1         7
#define    TXC1         6
#define    UDRE1        5
#define    FE1          4
#define    DOR1         3
#define    UPE1         2
#define    U2X1         1
#define    MPCM1        0
*/
#if defined(AT_DEVICE_MODEM) || defined(AT_DEVICE_BLUETOOTH)
void uart1_putchar(unsigned char c)
{
   while ((UCSR1A & (1<<UDRE1)) == 0)
       ;
   UDR1 = c;
}

/* USART1 Control Register B - UCSR1B
#define    RXCIE1       7
#define    TXCIE1       6
#define    UDRIE1       5
#define    RXEN1        4
#define    TXEN1        3
#define    UCSZ12       2
#define    RXB81        1
#define    TXB81        0
*/
void uart1_irq_receive_enable(void)
{
   UCSR1B |= (1<<RXCIE1);
}

void uart1_irq_receive_disable(void)
{
   UCSR1B &= ~(1<<RXCIE1);
}

#ifdef __CODEVISIONAVR__
interrupt[USART1_RXC]
     void uart1_irq_receive(void)
#else
SIGNAL(SIG_USART1_RECV)
#endif
{
   ati_receive_data(UDR1);
}

#endif
