
/*****************************************************************************
 *
 *                         "http_server.c"
 *                   -----------------------------
 *
 *  Version:    2.06
 *  File:     	..\..\..\http_server.c
 *  Created:    04.11.2003
 *  Date:       14.01.2005
 *  Author:     Copyright (C) 2001-2005
 *              Udo Jakobza - FTZ Leipzig; D-04107 Leipzig; Wchterstr. 13
 *				info@easytoweb.net
 *  Func:		implements a HTTP-server by using the easyToWeb-API
 *  License:
 *    This library is free software; you can redistribute it and/or modify it
 *    under the terms of the GNU Lesser General Public License as published by
 *    the Free Software Foundation; either version 2.1 of the License, or
 *    (at your option) any later version. This library is distributed in the hope
 *    that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *    warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *    See the GNU Lesser General Public License for more details.
 *	  see: http://www.gnu.org/copyleft/lesser.html
 *    You should have received a copy of the GNU Lesser General Public License
 *    along with this library; if not, write to the Free Software Foundation,
 *    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *    Die Bibliothek ist freie Software; Sie drfen sie unter den Bedingungen der
 *    GNU Lesser General Public License, wie von der Free Software Foundation
 *    verffentlicht, weiterverteilen und/oder modifizieren; entweder gem
 *    Version 2.1 der Lizenz oder (nach Ihrer Option) jeder spteren Version.
 *    Diese Bibliothek wird in der Hoffnung weiterverbreitet, da sie ntzlich
 *    sein wird, jedoch OHNE IRGENDEINE GARANTIE, auch ohne die implizierte
 *    Garantie der MARKTREIFE oder der VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK.
 *    Mehr Details finden Sie in der GNU Lesser General Public License.
 *	  see: http://www.gnu.org/copyleft/lesser.de.html
 *    Sie sollten eine Kopie der GNU Lesser General Public License zusammen mit
 *    dieser Bibliothek erhalten haben; falls nicht, schreiben Sie an die FSF,
 *    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 *  history:
 *		1.) 04.11.2003 Version 2.02
 *		2.) 02.12.2003 Version 2.03
 *			a.)	- HTTP-Server supports now a default start file, see "HTTP_DEFAULT_FILE"
 *
 *****************************************************************************/
#include "project.h"

#ifdef HTTP_ENABLE

#include <stdio.h>
#include <string.h>
#ifdef __CODEVISIONAVR__
#include <delay.h>
#else
#include <avr/pgmspace.h>
#endif
#include DEVICE_H_FILEPATH
#include BUFFER_H_FILEPATH
#ifdef WEB_DEBUG
#include WEB_DEBUG_H_FILEPATH
#endif
#include HARDWARE_H_FILEPATH
#ifdef ETHERNET_ENABLE
#include ETHERNET_H_FILEPATH
#endif
#ifdef TCP_ENABLE
#include TCP_H_FILEPATH
#endif
#ifdef DEVICE_PPP
#endif
#ifdef HTTP_ENABLE
#include HTTP_SERVER_H_FILEPATH
#include WEBSIDE_H_FILEPATH
#endif
#ifdef WEB_DEBUG_MEASURE
#include MEASURE_H_FILEPATH
#endif
#ifdef	DATAFLASH_FILE_ENABLE
#include DATAFLASH_FILE_H_FILEPATH
#include DATAFLASH_FILE_DEBUG_H_FILEPATH
#endif
#ifdef FTP_ENABLE
#include FTP_SERVER_H_FILEPATH
#endif
#include UTIL_H_FILEPATH

#define HTTP_COMMAND_SIZE		20
#define HTTP_PARAMETER_SIZE		40

#ifdef __CODEVISIONAVR__
#pragma regalloc-
#endif
unsigned char http_server_tcp = TCP_WRONG_CONNECTIONS;
unsigned char http_command[HTTP_COMMAND_SIZE + 1];
unsigned char http_parameter[HTTP_PARAMETER_SIZE + 1];

#ifdef DATAFLASH_FILE_ENABLE
unsigned char http_file_handle = FILE_HANDLE_DISABLE;
#endif
#ifdef __CODEVISIONAVR__
#pragma regalloc+
#endif

#ifdef WEB_DEBUG_HTTP
static PROGMEM char NewLine[] = "\n";
#endif
static PROGMEM char http1_1[]  = "HTTP/1.1 ";
static PROGMEM char httVers[]  = "\r\nServer: " PROJECT_NAME " " PROJECT_VERSION "\r\n";
static PROGMEM char txt_html[] = "Content-Type: text/html\r\n";
//#ifdef DATAFLASH_FILE_ENABLE
static PROGMEM char img_Jpeg[] = "Content-Type: image/jpeg\r\n";
static PROGMEM char img_ico[]  = "Content-Type: image/x-icon\r\n";
static PROGMEM char app_bin[]  = "Content-Type: application/octet-stream\r\n";
//#endif

#ifndef DATAFLASH_FILE_ENABLE
   unsigned char file_type;
   #define FILE_TYPE_HTML  1
   #define FILE_TYPE_JPEG  2
   #define FILE_TYPE_ICO   3
   #define FILE_TYPE_CLASS 0
#endif


unsigned char http_response(PGM_P response_code,
                            unsigned long data_size,
                            PGM_P message)
{
   unsigned char http_buffer[50];

#ifdef DATAFLASH_FILE_ENABLE
   FILE_TYP file_type;
   DATE_STRUCT file_time;
#endif

   if (tcp_tx_buffer_write(http_server_tcp, 0x0, 0, TCP_TX_BUFFER_GET_SIZE) == 0)
      return 0;
   tcp_tx_buffer_write_f(http_server_tcp, http1_1,
                         sizeof(http1_1)-1,
                         TCP_TX_BUFFER_WRITE_FLASH_DATA);
   tcp_tx_buffer_write_f(http_server_tcp, response_code,
                         strlen_P(response_code),
                         TCP_TX_BUFFER_WRITE_FLASH_DATA);
   tcp_tx_buffer_write_f(http_server_tcp, httVers,
                         sizeof(httVers)-1,
                         TCP_TX_BUFFER_WRITE_FLASH_DATA);
#ifdef DATAFLASH_FILE_ENABLE
   if (http_file_handle != FILE_HANDLE_DISABLE)
   {
      dataflash_file_size(http_file_handle, &data_size);
      dataflash_file_gettype(http_file_handle, &file_type);
      dataflash_file_gettime(http_file_handle, &file_time);
      sprintf_P(http_buffer,
              PSTR("Last-Modified: Thu, 15 Mar 2004 %02u:%02u:%02u GMT\r\n"),
              file_time.hour, file_time.minute, file_time.second);
      tcp_tx_buffer_write(http_server_tcp, http_buffer, strlen(http_buffer),
                          TCP_TX_BUFFER_WRITE_RAM_DATA);
      switch (file_type)
      {
      case FILE_TYPE_HTML:
         tcp_tx_buffer_write_f(http_server_tcp, txt_html, sizeof(txt_html)-1,
                               TCP_TX_BUFFER_WRITE_FLASH_DATA);
         break;
      case FILE_TYPE_JPEG:
         tcp_tx_buffer_write_f(http_server_tcp, img_Jpeg, sizeof(img_Jpeg)-1,
                               TCP_TX_BUFFER_WRITE_FLASH_DATA);
         break;
      case FILE_TYPE_ICO:
         tcp_tx_buffer_write_f(http_server_tcp, img_ico, sizeof(img_ico)-1,
                               TCP_TX_BUFFER_WRITE_FLASH_DATA);
         break;
      case FILE_TYPE_CLASS:
  default:
         tcp_tx_buffer_write_f(http_server_tcp, app_bin, sizeof(app_bin)-1,
                               TCP_TX_BUFFER_WRITE_FLASH_DATA);
         break;
/*
      default:
         tcp_tx_buffer_write_f(http_server_tcp, "Content-Type: text/html\r\n",
                               strlenf("Content-Type: text/html\r\n"),
                               TCP_TX_BUFFER_WRITE_FLASH_DATA);
*/
      }
   }
#else
    if(file_type == FILE_TYPE_ICO)
    {
        tcp_tx_buffer_write_f(http_server_tcp, img_ico,
                               sizeof(img_ico)-1,
                               TCP_TX_BUFFER_WRITE_FLASH_DATA);
    }
    else
        tcp_tx_buffer_write_f(http_server_tcp, txt_html,
                               sizeof(txt_html)-1,
                               TCP_TX_BUFFER_WRITE_FLASH_DATA);
#endif
   unsigned int mlen = 0;
   if (message != NULL)
      mlen = strlen_P(message);
   data_size += mlen;
   sprintf_P(http_buffer, PSTR("Content-Length: %lu\r\n\r\n"), data_size);
   tcp_tx_buffer_write(http_server_tcp, http_buffer, strlen(http_buffer),
                       TCP_TX_BUFFER_WRITE_RAM_DATA);
#ifdef WEB_DEBUG_HTTP
   if (web_debug_flag & WEB_DEBUG_HTTP_BIT)
      printf_P(PSTR("HTTP Response: \"%p\" %u Byte\n"), response_code, data_size);
#endif
   if ((message != NULL) && (mlen != 0))
      tcp_tx_buffer_write_f(http_server_tcp, message, mlen,
                            TCP_TX_BUFFER_WRITE_FLASH_DATA);
   return 1;
}

#ifdef DATAFLASH_FILE_ENABLE
unsigned char http_server_file_data_buffer[TCP_TX_SEGMENT_SIZE];
#endif
unsigned char http_server_file(HTTP_SERVER_FILE_STATUS status)
{
#ifdef DATAFLASH_FILE_ENABLE
   unsigned int count;
   TCP_STRUCTURE *p_struct;
#endif

#ifdef DATAFLASH_FILE_ENABLE
   if (status == HTTP_SERVER_FILE_START)
   {
      if (http_file_handle != FILE_HANDLE_DISABLE)
      {
         dataflash_file_close(&http_file_handle);
#ifdef WEB_DEBUG_HTTP
         if (web_debug_flag & WEB_DEBUG_HTTP_BIT)
            printf_P(PSTR("HTTP Close File\n"));
#endif
      }
      if (!dataflash_file_open(http_parameter, &http_file_handle))
         return 0;
      http_response(HTTP_STATUS_200, 0, 0x0);
   }
   if (status == HTTP_SERVER_FILE_CLOSE)
   {
      if (http_file_handle != FILE_HANDLE_DISABLE)
         dataflash_file_close(&http_file_handle);
      return 1;
   }
   p_struct = tcp_get_struct(http_server_tcp);
   if ((p_struct != 0) && (p_struct->tcp_socket_status & SOCK_CONNECTED))
   {
      count =
         tcp_tx_buffer_write(http_server_tcp, 0x0, 0, TCP_TX_BUFFER_GET_SIZE);
      if (count < sizeof(http_server_file_data_buffer))
         return 1;
      if (http_file_handle != FILE_HANDLE_DISABLE)
      {
         if (count > sizeof(http_server_file_data_buffer))
            count = sizeof(http_server_file_data_buffer);
         count = dataflash_file_read(http_file_handle, http_server_file_data_buffer, count);    // read
                                                                                                // data
         tcp_tx_buffer_write(http_server_tcp, http_server_file_data_buffer,
                             count, TCP_TX_BUFFER_WRITE_RAM_DATA);
         if (count != 0)
         {
#ifdef WEB_DEBUG_HTTP
            if (web_debug_flag & WEB_DEBUG_HTTP_BIT)
               printf_P(PSTR("HTTP DATA: %u Byte\n"), count);
#endif
         }
         else
         {
            if (http_file_handle != FILE_HANDLE_DISABLE)
               dataflash_file_close(&http_file_handle);
            return 0;
         }
      }
      else
      {
         http_response(HTTP_STATUS_404, 0, PSTR("File Not Found\n"));
         return 0;
      }
   }
   return 1;
#else
   status = 0;
   return 0;
#endif
}


#ifdef WEBSIDE_DEFAULT_ENABLE
unsigned char http_server_default(HTTP_SERVER_DEFAULT_STATUS status)
{
   static PGM_P p_webside;
   static unsigned int http_bytes2send;
   unsigned int http_data_len;
   TCP_STRUCTURE *p_struct;

   file_type = FILE_TYPE_HTML;
   p_struct = tcp_get_struct(http_server_tcp);
   if (status == HTTP_SERVER_DEFAULT_START)
   {
//printf_P(PSTR("http_parameter: '%s' %d\n"),http_parameter, strlen(http_parameter));

    if(strcmp_P(http_parameter, PSTR("favicon.ico")) == 0)
    {
//printf_P(PSTR("isIcon\n"));
      file_type = FILE_TYPE_ICO;
      http_bytes2send = getsize_favicon();
      p_webside = &data_favicon_ico[0];
    }
    else
    {
//printf_P(PSTR("isNotIcon\n"));
      http_bytes2send = strlen_P(webside_default);
      p_webside = &webside_default[0];
    }
#ifdef WEB_DEBUG_HTTP
      if (web_debug_flag & WEB_DEBUG_HTTP_BIT)
         printf_P(PSTR("HTTP open default webside: %u Byte\n"), http_bytes2send);
#endif
      // icmp_prepare_timestamp_request(p_struct->tcp_ip_remote,
      // p_struct->tcp_mac_remote, 0);
      if (http_bytes2send == 0)
      {
#ifdef WEB_DEBUG_HTTP
         if (web_debug_flag & WEB_DEBUG_HTTP_BIT)
            printf_P(PSTR("HTTP wrong size\n"));
#endif
         return 0;
      }
      http_response(HTTP_STATUS_200, http_bytes2send, 0x0);
   }
   if ((p_struct != 0) && (p_struct->tcp_socket_status & SOCK_CONNECTED))
   {
      http_data_len =
         tcp_tx_buffer_write(http_server_tcp, 0x0, 0, TCP_TX_BUFFER_GET_SIZE);
      if (http_data_len == 0)
         return 1;
      if (http_bytes2send < http_data_len)
         http_data_len = http_bytes2send;
      tcp_tx_buffer_write_f(http_server_tcp, p_webside, http_data_len,
                            TCP_TX_BUFFER_WRITE_FLASH_DATA);
      http_bytes2send -= http_data_len;
      p_webside += http_data_len;
#ifdef WEB_DEBUG_HTTP
      if (web_debug_flag & WEB_DEBUG_HTTP_BIT)
         printf_P(PSTR("HTTP data: %u Byte (rest:%u)\n"), http_data_len,
                http_bytes2send);
#endif
      if (http_bytes2send == 0)
         return 0;
   }
   return 1;
}
#endif


void http_server(void)
{
   static HTTP_SERVER_STATUS http_status = HTTP_SERVER_START;
   unsigned char *p_data, Lva;
   unsigned int tcp_data_size;
   unsigned int Lvb;
   TCP_STRUCTURE *p_struct;

   p_struct = tcp_get_struct(http_server_tcp);
   if ((p_struct != 0) && (p_struct->tcp_socket_status & SOCK_CONNECTED))
   {
      if (http_status == HTTP_SERVER_START)
      {
         if (p_struct->tcp_socket_status & SOCK_DATA_AVAILABLE)
         {
            http_command[0] = 0;
            http_parameter[0] = 0;
            p_data =
               tcp_rx_buffer_read(http_server_tcp, 0x0,
                                  &tcp_data_size,
                                  TCP_RX_BUFFER_GET_SIZE);
            if (p_data && (tcp_data_size > (HTTP_COMMAND_SIZE + HTTP_PARAMETER_SIZE)))
            {
               Lva = 0;
               while ((*p_data != ' ') && (Lva < HTTP_COMMAND_SIZE))
               {
                  http_command[Lva] = *p_data++;
                  Lva++;
               }
               http_command[Lva] = 0;
               if (*p_data == ' ')
                  p_data++;
               if (*p_data == '/')
                  p_data++;
               Lva = 0;
               while ((*p_data != ' ') && (Lva < HTTP_PARAMETER_SIZE))
               {
                  http_parameter[Lva] = *p_data++;
                  Lva++;
               }
               http_parameter[Lva] = 0;
               if (Lva == 0)
                  strncpy_P(http_parameter, HTTP_DEFAULT_FILE,
                           HTTP_PARAMETER_SIZE);
            }
#ifdef WEB_DEBUG_HTTP
            if (web_debug_flag & WEB_DEBUG_HTTP_BIT)
            {
               printf_P(PSTR("HTTP request: \"%s\" - \"%s\" %u Byte\n"),
                      http_command, http_parameter, tcp_data_size);
               // for(Lvb=0;Lvb<tcp_data_size;Lvb++)
               // printf("%c", p_struct->tcp_rx.data_frame[Lvb]);
            }
#endif
            if (strcmp_P(http_command, PSTR("GET")) == 0)
            {
               tcp_rx_buffer_clear(http_server_tcp);
               http_status = HTTP_SERVER_HTTP_GET;
            }
            else if (strcmp_P(http_command, PSTR("POST")) == 0)
               http_status = HTTP_SERVER_HTTP_PUT;
            else
            {
               tcp_rx_buffer_clear(http_server_tcp);
            }
         }
      }                         // if(http_status==HTTP_SERVER_START)
      else if (http_status == HTTP_SERVER_FILE_DATA)
      {
         if (!http_server_file(HTTP_SERVER_FILE_DATA))
            http_status = HTTP_SERVER_FILE_CLOSE;
      }
      else if (http_status == HTTP_SERVER_FILE_CLOSE)
      {
         http_server_file(HTTP_SERVER_FILE_CLOSE);
         http_status = HTTP_SERVER_CLOSE_CONNECTION;
      }
#ifdef WEBSIDE_DEFAULT_ENABLE
      else if (http_status == HTTP_SERVER_DATA)
      {
         if (!http_server_default(HTTP_SERVER_DEFAULT_DATA))
            http_status = HTTP_SERVER_CLOSE_CONNECTION;
      }
#endif
      else if (http_status == HTTP_SERVER_CLOSE_CONNECTION)
      {
         tcp_close(http_server_tcp);
         http_status = HTTP_SERVER_CLOSE;
      }
      else if (http_status == HTTP_SERVER_CLOSE)
      {
         tcp_rx_buffer_clear(http_server_tcp);
         http_status = HTTP_SERVER_START;
#ifdef WEB_DEBUG_HTTP
         if (web_debug_flag & WEB_DEBUG_HTTP_BIT)
            printf_P(PSTR("HTTP close\""));
#endif
      }
      else if (http_status == HTTP_SERVER_HTTP_PUT)
      {
         p_data =
            tcp_rx_buffer_read(http_server_tcp, 0x0, &tcp_data_size,
                               TCP_RX_BUFFER_GET_SIZE);
         if (p_data
             && (tcp_data_size > (HTTP_COMMAND_SIZE + HTTP_PARAMETER_SIZE)))
         {
//???            p_data = strstrf(p_data, "\r\n\r\n");
            p_data = strstr(p_data, "\r\n\r\n");
            if (p_data != 0x0)
            {
               p_data += 4;
               Lvb = strstrfn(p_struct->tcp_rx.data_frame, PSTR("\r\n\r\n"));
               Lvb += 4;
#ifdef WEB_DEBUG_HTTP
               if (web_debug_flag & WEB_DEBUG_HTTP_BIT)
               {
                  printf_P(PSTR("HTTP POST: %u Byte\n"), tcp_data_size);
                  while (Lvb < tcp_data_size)
                  {
                     printf_P(PSTR("%c"), *p_data);
                     p_data++;
                     Lvb++;
                  }
                  printf_P(NewLine);
               }
#endif
            }
            tcp_rx_buffer_clear(http_server_tcp);
            http_status = HTTP_SERVER_CLOSE_CONNECTION;
         }
      }
      else if (http_status == HTTP_SERVER_HTTP_GET)
      {
         if (http_server_file(HTTP_SERVER_FILE_START))
            http_status = HTTP_SERVER_FILE_DATA;
         else
         {
#ifdef WEB_DEBUG_HTTP
            if (web_debug_flag & WEB_DEBUG_HTTP_BIT)
               printf_P(PSTR("HTTP open File: \"%s\" Error!!\n"), http_parameter);
#endif
#ifdef WEBSIDE_DEFAULT_ENABLE
            if (http_server_default(HTTP_SERVER_DEFAULT_START))
               http_status = HTTP_SERVER_DATA;
            else
               http_status = HTTP_SERVER_CLOSE_CONNECTION;
#else
            http_response(HTTP_STATUS_404, 0, PSTR("File Not Found\r\n"));
            http_status = HTTP_SERVER_FILE_CLOSE;
#endif
         }
      }
   }  // if(p_struct->tcp_socket_status & SOCK_CONNECTED) // check if somebody has
                                                          // connected to our TCP
   else
      http_status = HTTP_SERVER_START;
}



#endif // #ifdef HTTP_ENABLE
