
/*****************************************************************************
 *
 *                            "icmp.c"
 *                    -----------------------------
 *
 *  Version:    2.03
 *  File:     	..\..\icmp.c
 *  Created:    15.04.2003
 *  Date:       11.02.2004
 *  Author:     Copyright (C) 2001-2004
 *              Udo Jakobza - FTZ Leipzig; D-04107 Leipzig; Wchterstr. 13
 *              info@easytoweb.net
 *  Func:		implements the ICMP-functions and provides a simple API to the user
 *  License:
 *    This library is free software; you can redistribute it and/or modify it
 *    under the terms of the GNU Lesser General Public License as published by
 *    the Free Software Foundation; either version 2.1 of the License, or
 *    (at your option) any later version. This library is distributed in the hope
 *    that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *    warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *    See the GNU Lesser General Public License for more details.
 *	  see: http://www.gnu.org/copyleft/lesser.html
 *    You should have received a copy of the GNU Lesser General Public License
 *    along with this library; if not, write to the Free Software Foundation,
 *    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *    Die Bibliothek ist freie Software; Sie drfen sie unter den Bedingungen der
 *    GNU Lesser General Public License, wie von der Free Software Foundation
 *    verffentlicht, weiterverteilen und/oder modifizieren; entweder gem
 *    Version 2.1 der Lizenz oder (nach Ihrer Option) jeder spteren Version.
 *    Diese Bibliothek wird in der Hoffnung weiterverbreitet, da sie ntzlich
 *    sein wird, jedoch OHNE IRGENDEINE GARANTIE, auch ohne die implizierte
 *    Garantie der MARKTREIFE oder der VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK.
 *    Mehr Details finden Sie in der GNU Lesser General Public License.
 *	  see: http://www.gnu.org/copyleft/lesser.de.html
 *    Sie sollten eine Kopie der GNU Lesser General Public License zusammen mit
 *    dieser Bibliothek erhalten haben; falls nicht, schreiben Sie an die FSF,
 *    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 *  history:
 *		1.) 08.08.2003 Version 2.00
 *		2.) 13.08.2003 Version 2.01
 *			a.)	- new macro "ICMP_ENABLE", see project.h inside of project-path
 *		3.) 11.02.2004 Version 2.03
 *			a.)	- supports now Type: "ICMP_DEST_UNREACHABLE"
 *
 *****************************************************************************/
#include "project.h"

#ifdef ICMP_ENABLE
#ifdef IP_ENABLE

#include <stdio.h>
#include <string.h>
#include <avr/pgmspace.h>
#include DEVICE_H_FILEPATH
#include HARDWARE_H_FILEPATH
#include ETHERNET_H_FILEPATH
#include BUFFER_H_FILEPATH
#include ICMP_H_FILEPATH
#ifdef WEB_DEBUG_MEASURE
#include MEASURE_H_FILEPATH
#endif
#ifdef WEB_DEBUG
#include WEB_DEBUG_H_FILEPATH
#endif

#ifdef __CODEVISIONAVR__
#pragma regalloc-
#endif
#ifdef WEB_DEBUG_ICMP
unsigned int icmp_count = 0;
#endif
#ifdef __CODEVISIONAVR__
#pragma regalloc+
#endif

void icmp_prepare_echo_reply(unsigned char *ip_remote,
                             unsigned char *mac_remote,
                             unsigned int icmp_ident, unsigned int icmp_seq)
{
   unsigned int icmp_data_count;
   unsigned char ip_offset;

   icmp_data_count = ip_header.length - IP_HEADER_SIZE - ICMP_HEADER_SIZE;
   if (icmp_data_count > ICMP_DATA_SIZE)
      icmp_data_count = ICMP_DATA_SIZE;
   *(unsigned int *) &tx_frame2[ICMP_TYPE_CODE_OFS] = SWAPB(ICMP_ECHO_REPLY << 8);
   *(unsigned int *) &tx_frame2[ICMP_CHKSUM_OFS] = 0;
   HOST_NETWORK_ENDIAN_16BIT(&tx_frame2[ICMP_IDENT_OFS], &icmp_ident);
   HOST_NETWORK_ENDIAN_16BIT(&tx_frame2[ICMP_SEQ_OFS], &icmp_seq);
   DEVICE_READ_IP_FRAME_DATA(&tx_frame2[ICMP_ECHO_DATA_OFS], icmp_data_count);
   // read data from DEVICE and write data to buffer
   *(unsigned int *) &tx_frame2[ICMP_CHKSUM_OFS] =
      ip_checksum(&tx_frame2[IP_DATA_OFS], icmp_data_count+ICMP_HEADER_SIZE, 0);
   tx_frame2_size = IP_HEADER_SIZE + ICMP_HEADER_SIZE + icmp_data_count;
   if (ip_header_write(tx_frame2, &tx_frame2_size,
                       &ip_offset, IP_ICMP_PROT,
                       ip_address, ip_remote) == 0)
   {
#if defined(WEB_DEBUG_ICMP)&&defined(IPSEC_ENABLE)
      if (web_debug_flag & WEB_DEBUG_ICMP_BIT)
      {
         printf_P(PSTR("IMCP(%u) Echo-Reply: IP-Error\n"), icmp_count);
         debug_display_frame(tx_frame2,
                             tx_frame2_size+IPSEC_OFFSET+ETH_HEADER_SIZE, 0);
      }
#endif
      return;
   }
#ifdef ETHERNET_ENABLE
   memcpy(&tx_frame2[(unsigned char) (ETH_DA_OFS + ip_offset)], mac_remote, MAC_ADR_SIZE);
   memcpy(&tx_frame2[(unsigned char) (ETH_SA_OFS + ip_offset)], mac_address, MAC_ADR_SIZE);
   *(unsigned int *)&tx_frame2[(unsigned char)(ETH_TYPE_OFS+ip_offset)] = SWAPB(IP_FRAME);
#else
   mac_remote = ip_remote;
   memset(&tx_frame2[(unsigned char) (ETH_DA_OFS + ip_offset)], 0x0, ETH_HEADER_SIZE);
#endif
   tx_frame2_size += ETH_HEADER_SIZE;
   buffer_write_command(tx_frame2 + ip_offset, tx_frame2_size);
#ifdef WEB_DEBUG_ICMP
   if (web_debug_flag & WEB_DEBUG_ICMP_BIT)
      printf_P(PSTR("IMCP(%u) Echo-Reply: %ubyte (data %ubyte)\n"), icmp_count,
             tx_frame2_size, icmp_data_count);
#endif
}


void icmp_prepare_echo_request(unsigned char *ip_remote,
                               unsigned char *mac_remote,
                               unsigned char pattern)
{
   static unsigned int icmp_ident;
   static unsigned int icmp_seq;
   unsigned char ip_offset;

   memset(tx_frame2, pattern, sizeof(tx_frame2));
   *(unsigned int *) &tx_frame2[ICMP_TYPE_CODE_OFS] = SWAPB(ICMP_ECHO_REQUEST << 8);
   *(unsigned int *) &tx_frame2[ICMP_CHKSUM_OFS]    = 0;
   HOST_NETWORK_ENDIAN_16BIT(&tx_frame2[ICMP_IDENT_OFS], &icmp_ident);
   icmp_ident++;
   HOST_NETWORK_ENDIAN_16BIT(&tx_frame2[ICMP_SEQ_OFS], &icmp_seq);
   icmp_seq++;
   *(unsigned int *) &tx_frame2[ICMP_CHKSUM_OFS] =
      ip_checksum(&tx_frame2[IP_DATA_OFS], ICMP_DATA_SIZE + ICMP_HEADER_SIZE, 0);
   tx_frame2_size = IP_HEADER_SIZE + ICMP_HEADER_SIZE + ICMP_DATA_SIZE;
   if (ip_header_write
       (tx_frame2, &tx_frame2_size, &ip_offset, IP_ICMP_PROT, ip_address, ip_remote) == 0)
   {
#if defined(WEB_DEBUG_ICMP)&&defined(IPSEC_ENABLE)
      if (web_debug_flag & WEB_DEBUG_ICMP_BIT)
      {
         printf_P(PSTR("IMCP(%u) Echo-Request: IP-Error\n"), icmp_count);
         debug_display_frame(tx_frame2,
                             tx_frame2_size + IPSEC_OFFSET + ETH_HEADER_SIZE,
                             0);
      }
#endif
      return;
   }
#ifdef ETHERNET_ENABLE
   memcpy(&tx_frame2[(unsigned char) (ETH_DA_OFS + ip_offset)], mac_remote, MAC_ADR_SIZE);
   memcpy(&tx_frame2[(unsigned char) (ETH_SA_OFS + ip_offset)], mac_address, MAC_ADR_SIZE);
   *(unsigned int *) &tx_frame2[(unsigned char) (ETH_TYPE_OFS + ip_offset)] = SWAPB(IP_FRAME);
#else
   mac_remote = ip_remote;
   memset(&tx_frame2[(unsigned char) (ETH_DA_OFS + ip_offset)], 0x0, ETH_HEADER_SIZE);
#endif
   tx_frame2_size += ETH_HEADER_SIZE;
   buffer_write_command(tx_frame2 + ip_offset, tx_frame2_size);
#ifdef WEB_DEBUG_ICMP
   if (web_debug_flag & WEB_DEBUG_ICMP_BIT)
      printf_P(PSTR("IMCP(%u) Echo-Request: %ubyte (data %ubyte)\n"), icmp_count,
             tx_frame2_size, ICMP_DATA_SIZE);
#endif
}


void icmp_prepare_timestamp_request(unsigned char *ip_remote,
                                    unsigned char *mac_remote,
                                    unsigned long time)
{
   static unsigned int icmp_identifikator = 0;
   static unsigned int icmp_sequenz = 0xaa11;
   unsigned char ip_offset;

#ifdef WEB_DEBUG_MEASURE
   MEASURE_SETTIME(MEA_ICMP_ECHO_S)
#endif
   *(unsigned int *) &tx_frame2[ICMP_TYPE_CODE_OFS] = SWAPB(ICMP_TIMESTAMP_REQUEST << 8);
   *(unsigned int *) &tx_frame2[ICMP_CHKSUM_OFS] = 0;
   HOST_NETWORK_ENDIAN_16BIT(&tx_frame2[ICMP_IDENT_OFS], &icmp_identifikator);
   HOST_NETWORK_ENDIAN_16BIT(&tx_frame2[ICMP_SEQ_OFS], &icmp_sequenz);
   HOST_NETWORK_ENDIAN_32BIT(&tx_frame2[ICMP_TIMESTAMP_ORIGINATE_OFS], &time);
   memset(&tx_frame2[ICMP_TIMESTAMP_RECEIVE_OFS], 0x0, 8);
   *(unsigned int *) &tx_frame2[ICMP_CHKSUM_OFS] =
      ip_checksum(&tx_frame2[IP_DATA_OFS], ICMP_TIMESTAMP_SIZE, 0);
   tx_frame2_size = IP_HEADER_SIZE + ICMP_TIMESTAMP_SIZE;
   if (ip_header_write
       (tx_frame2, &tx_frame2_size, &ip_offset, IP_ICMP_PROT, ip_address, ip_remote) == 0)
   {
#if defined(WEB_DEBUG_ICMP)&&defined(IPSEC_ENABLE)
      if (web_debug_flag & WEB_DEBUG_ICMP_BIT)
      {
         printf_P(PSTR("IMCP(%u) timestamp-Request: IP-Error\n"), icmp_count);
         debug_display_frame(tx_frame2,
                             tx_frame2_size + IPSEC_OFFSET + ETH_HEADER_SIZE, 0);
      }
#endif
      return;
   }
#ifdef ETHERNET_ENABLE
   memcpy(&tx_frame2[(unsigned char) (ETH_DA_OFS + ip_offset)], mac_remote, MAC_ADR_SIZE);
   memcpy(&tx_frame2[(unsigned char) (ETH_SA_OFS + ip_offset)], mac_address, MAC_ADR_SIZE);
   *(unsigned int *) &tx_frame2[(unsigned char) (ETH_TYPE_OFS + ip_offset)] = SWAPB(IP_FRAME);
#else
   mac_remote = ip_remote;
   memset(&tx_frame2[(unsigned char) (ETH_DA_OFS + ip_offset)], 0x0, ETH_HEADER_SIZE);
#endif
   tx_frame2_size += ETH_HEADER_SIZE;
   buffer_write_command(tx_frame2 + ip_offset, tx_frame2_size);
#ifdef WEB_DEBUG_ICMP
   if (web_debug_flag & WEB_DEBUG_ICMP_BIT)
      printf_P(PSTR("IMCP(%u) Timestamp-Request: %ubyte\n"), icmp_count,
             tx_frame2_size);
#endif
   icmp_identifikator++;
}


void icmp_process_frame(void)
{
   ICMP_HEADER_STRUCTURE icmp_header;
   unsigned long timestamp;

   icmp_header.type = DEVICE_READ_IP_FRAME_16BIT_LE();
   icmp_header.checksum = DEVICE_READ_IP_FRAME_16BIT();
   icmp_header.ident = DEVICE_READ_IP_FRAME_16BIT();
   icmp_header.seq = DEVICE_READ_IP_FRAME_16BIT();
#ifdef WEB_DEBUG_ICMP
   icmp_count++;
#endif
   switch (icmp_header.type)
   {
   case ICMP_ECHO_REQUEST:
#ifdef WEB_DEBUG_ICMP
      if (web_debug_flag & WEB_DEBUG_ICMP_BIT)
         printf_P(PSTR("IMCP(%u) Echo-Request ident: 0x%x; seq: 0x%x\n"),
                icmp_count, icmp_header.ident, icmp_header.seq);
#endif
#ifdef ETHERNET_ENABLE
      icmp_prepare_echo_reply(ip_of_last_frame, mac_of_last_frame,
                              icmp_header.ident, icmp_header.seq);
#else
      icmp_prepare_echo_reply(ip_of_last_frame, 0, icmp_header.ident,
                              icmp_header.seq);
#endif
      break;
   case ICMP_DEST_UNREACHABLE:
#ifdef WEB_DEBUG_ICMP
      if (web_debug_flag & WEB_DEBUG_ICMP_BIT)
         printf_P(PSTR("IMCP(%u) Destination Unreachable: %u\n"), icmp_count,
                icmp_header.code);
#endif
      break;
   case ICMP_ECHO_REPLY:
#ifdef WEB_DEBUG_ICMP
      if (web_debug_flag & WEB_DEBUG_ICMP_BIT)
         printf_P(PSTR("IMCP(%u) Echo-Reply ident: 0x%x; seq: 0x%x\n"), icmp_count,
                icmp_header.ident, icmp_header.seq);
#endif
      break;
   case ICMP_TIMESTAMP_REQUEST:
#ifdef WEB_DEBUG_ICMP
      if (web_debug_flag & WEB_DEBUG_ICMP_BIT)
         printf_P(PSTR("IMCP(%u) Timestamp-Request ident: 0x%x; seq: 0x%x\n"),
                icmp_count, icmp_header.ident, icmp_header.seq);
#endif
      break;
   case ICMP_TIMESTAMP_REPLY:
#ifdef WEB_DEBUG_ICMP
      if (web_debug_flag & WEB_DEBUG_ICMP_BIT)
      {
         printf_P(PSTR("IMCP(%u) Timestamp-Reply ident: %x; seq: %x\n"), icmp_count,
                icmp_header.ident, icmp_header.seq);
         timestamp = DEVICE_READ_IP_FRAME_16BIT_LE();
         timestamp |= (unsigned long) DEVICE_READ_IP_FRAME_16BIT_LE() << 16;
         printf_P(PSTR("IMCP(%u) Originate: %lu,%u\n"), icmp_count,
                timestamp / 1000, timestamp % 1000);
         timestamp = DEVICE_READ_IP_FRAME_16BIT_LE();
         timestamp |= (unsigned long) DEVICE_READ_IP_FRAME_16BIT_LE() << 16;
         printf_P(PSTR("IMCP(%u) Receive  : %lu,%u\n"), icmp_count,
                timestamp / 1000, timestamp % 1000);
         timestamp = DEVICE_READ_IP_FRAME_16BIT_LE();
         timestamp |= (unsigned long) DEVICE_READ_IP_FRAME_16BIT_LE() << 16;
         printf_P(PSTR("IMCP(%u) Transmit : %lu,%u\n"), icmp_count,
                timestamp / 1000, timestamp % 1000);
      }
      else
      {
         DEVICE_READ_IP_FRAME_DUMMY(8);
         timestamp = DEVICE_READ_IP_FRAME_16BIT_LE();
         timestamp |= (unsigned long) DEVICE_READ_IP_FRAME_16BIT_LE() << 16;
      }
#else
      DEVICE_READ_IP_FRAME_DUMMY(8);
      timestamp = DEVICE_READ_IP_FRAME_16BIT_LE();
      timestamp |= (unsigned long) DEVICE_READ_IP_FRAME_16BIT_LE() << 16;
#endif
      timestamp /= CLOCKS_PER_SEC;
      hardware_set_second_counter(timestamp);
      break;
   default:
#ifdef WEB_DEBUG_ICMP
      if (web_debug_flag & WEB_DEBUG_ICMP_BIT)
         printf_P(PSTR("IMCP(%u) type: %u\n"), icmp_count, icmp_header.type);
#endif
      break;
   }
}
#endif
#endif // #ifdef ICMP_ENABLE
