
/*****************************************************************************
 *
 *                            "ip.c"
 *                   -----------------------------
 *
 *  Version:    2.06
 *  File:     	..\..\ip.c
 *  Created:    08.04.2003
 *  Date:       05.10.2004
 *  Author:     Copyright (C) 2001-2004
 *              Udo Jakobza - FTZ Leipzig; D-04107 Leipzig; Wchterstr. 13
 *				info@easytoweb.net
 *  Func:		implements the IP-functions and provides a simple API to the user
 *  license:
 *    This library is free software; you can redistribute it and/or modify it
 *    under the terms of the GNU Lesser General Public License as published by
 *    the Free Software Foundation; either version 2.1 of the License, or
 *    (at your option) any later version. This library is distributed in the hope
 *    that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *    warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *    See the GNU Lesser General Public License for more details.
 *	  see: http://www.gnu.org/copyleft/lesser.html
 *    You should have received a copy of the GNU Lesser General Public License
 *    along with this library; if not, write to the Free Software Foundation,
 *    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *    Die Bibliothek ist freie Software; Sie drfen sie unter den Bedingungen der
 *    GNU Lesser General Public License, wie von der Free Software Foundation
 *    verffentlicht, weiterverteilen und/oder modifizieren; entweder gem
 *    Version 2.1 der Lizenz oder (nach Ihrer Option) jeder spteren Version.
 *    Diese Bibliothek wird in der Hoffnung weiterverbreitet, da sie ntzlich
 *    sein wird, jedoch OHNE IRGENDEINE GARANTIE, auch ohne die implizierte
 *    Garantie der MARKTREIFE oder der VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK.
 *    Mehr Details finden Sie in der GNU Lesser General Public License.
 *	  see: http://www.gnu.org/copyleft/lesser.de.html
 *    Sie sollten eine Kopie der GNU Lesser General Public License zusammen mit
 *    dieser Bibliothek erhalten haben; falls nicht, schreiben Sie an die FSF,
 *    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 *  history:
 *		1.) 30.07.2003 Version 2.00a
 *			a.)	-
 *		2.) 20.08.2004 Version 2.04
 *			a.)	- function "ip_checksum()" calculate the correct checksum with
 *                odd Bytes
 *		3.) 05.10.2004 Version 2.06
 *			a.)	- function "ip_header_write()" writes the IP_VER_IHL_TOS_OFS with IP_TOS_MIN_DELAY
 *
 *****************************************************************************/
#include "project.h"

#ifdef IP_ENABLE

#include <stdio.h>
#include <string.h>
#include <avr/pgmspace.h>

#include DEVICE_H_FILEPATH
#include BUFFER_H_FILEPATH
#include ETHERNET_H_FILEPATH
#include IP_H_FILEPATH
#include ICMP_H_FILEPATH
#ifdef TCP_ENABLE
#include TCP_H_FILEPATH
#endif
#ifdef UDP_ENABLE
#include UDP_H_FILEPATH
#endif
#ifdef BOOTP_ENABLE
#include BOOTP_H_FILEPATH
#endif
#ifdef IPSEC_ENABLE
#include IPSEC_H_FILEPATH
#endif
#ifdef WEB_DEBUG_MEASURE
#include MEASURE_H_FILEPATH
#endif
#ifdef WEB_DEBUG
#include DEBUG_H_FILEPATH
#include WEB_DEBUG_H_FILEPATH
#endif

#ifdef __CODEVISIONAVR__
#pragma regalloc-
#endif
IP_HEADER_STRUCTURE ip_header;
unsigned char ip_of_last_frame[IP_ADR_SIZE];
unsigned char ip_address[IP_ADR_SIZE] = IP_DEFAULT;
unsigned char ip_subnet_mask[IP_ADR_SIZE] = IP_SUBMASK_DEFAULT;
unsigned char ip_gateway[IP_ADR_SIZE] = IP_GATEWAY_DEFAULT;

#ifdef WEB_DEBUG_IP
static PROGMEM char NewLine[] = "\n";
#endif

#ifdef __CODEVISIONAVR__
#pragma regalloc+
#pragma regalloc-
#endif
void ip_process_frame(unsigned char broadcast_flag)
{
#ifdef WEB_DEBUG_IP
   static unsigned int ip_count = 0;
#endif
   IP_HEADER_STRUCTURE *p_ip_header;

#ifdef WEB_DEBUG_MEASURE
   measure_flag = 1;
#endif
#ifdef WEB_DEBUG_IP
   ip_count++;
#endif
#ifdef IPSEC_ENABLE
   if (!ipsec_input_frame())
      return;
#endif
   p_ip_header = &ip_header;
   *(unsigned int *)&(p_ip_header->ver_ihl) = DEVICE_READ_IP_FRAME_16BIT_LE();
   if ((p_ip_header->ver_ihl & 0xFF) == SWAPB(IP_VER_IHL))
   {
      p_ip_header->length = DEVICE_READ_IP_FRAME_16BIT();
#ifdef WEB_DEBUG_IP
      if (web_debug_flag & WEB_DEBUG_IP_BIT)
      {
         printf_P(PSTR("IP(%u) Read-FRAME: %ubyte"), ip_count, p_ip_header->length);
         if (broadcast_flag)
            printf_P(PSTR(" Broadcast"));
         printf(NewLine);
      }
#endif
      p_ip_header->ident = DEVICE_READ_IP_FRAME_16BIT();
      p_ip_header->flags_frag_offset = DEVICE_READ_IP_FRAME_16BIT();
      if (!(p_ip_header->
           flags_frag_offset & (IP_FLAG_MOREFRAG | IP_FRAGOFS_MASK)))
      {
         p_ip_header->protocol = (unsigned char) DEVICE_READ_IP_FRAME_16BIT();
         DEVICE_READ_IP_FRAME_16BIT();
         DEVICE_READ_IP_FRAME_DATA(ip_of_last_frame, IP_ADR_SIZE);
         memcpy(p_ip_header->source, ip_of_last_frame, IP_ADR_SIZE);
         DEVICE_READ_IP_FRAME_DATA(p_ip_header->destination, IP_ADR_SIZE);
         if (broadcast_flag)
         {
#ifdef BOOTP_ENABLE
            if (p_ip_header->protocol == IP_UDP_PROT)
               bootp_answer();
#ifdef WEB_DEBUG_IP
            if (web_debug_flag & WEB_DEBUG_IP_BIT)
            {
               printf_P(PSTR("IP(%u) "), ip_count);
               debug_print_ip(PSTR("Address"), p_ip_header->destination);
            }
#endif
#endif
         }
         else
            if (!memcmp
                (p_ip_header->destination, &ip_address[0],
                 sizeof(ip_address)))
         {
            switch (p_ip_header->protocol)
            {
#ifdef ICMP_ENABLE
            case IP_ICMP_PROT:
               icmp_process_frame();
               break;
#endif
#ifdef TCP_ENABLE
            case IP_TCP_PROT:
#ifdef WEB_DEBUG_MEASURE
               measure_flag = 1;
#endif
               tcp_process_frame();
               break;
#endif
#ifdef UDP_ENABLE
            case IP_UDP_PROT:
               udp_process_frame();
               break;
#endif
            default:
#ifdef WEB_DEBUG_IP
               if (web_debug_flag & WEB_DEBUG_IP_BIT)
                  printf_P(PSTR("IP(%u) Protocol unsupported: 0x%04x\n"), ip_count,
                         p_ip_header->protocol);
#endif
               break;
            }
         }
         else
         {
#ifdef WEB_DEBUG_IP
            if (web_debug_flag & WEB_DEBUG_IP_BIT)
            {
               printf_P(PSTR("IP(%u) "), ip_count);
               debug_print_ip(PSTR("Address wrong"), p_ip_header->destination);
            }
#endif
#ifdef BOOTP_ENABLE
            if (p_ip_header->protocol == IP_UDP_PROT)
               bootp_answer();
#endif
         }
      }
      else
      {
#ifdef WEB_DEBUG_IP
         if (web_debug_flag & WEB_DEBUG_IP_BIT)
            printf_P(PSTR("IP(%u) Frame fragment: %u\n"), ip_count,
                   (p_ip_header->flags_frag_offset & IP_FRAGOFS_MASK) * 8);
#endif
      }
   }
   else
   {
#ifdef WEB_DEBUG_IP
      p_ip_header->length = DEVICE_READ_IP_FRAME_16BIT();
      if (web_debug_flag & WEB_DEBUG_IP_BIT)
         printf_P(PSTR("IP(%u) Typ wrong: 0x%02x (%ubyte)\n"), ip_count,
                p_ip_header->ver_ihl, p_ip_header->length);
#endif
   }
}


unsigned char ip_header_write(unsigned char *eth_data,
                              unsigned int *ip_length,
                              unsigned char *ip_offset,
                              unsigned char ip_protocol,
                              unsigned char *ip_source,
                              unsigned char *ip_destination)
{
   static unsigned int ip_write_frame_counter = 0;

   *ip_offset = IPSEC_OFFSET;
   *(unsigned int *) (eth_data + IP_VER_IHL_TOS_OFS) = SWAPB(IP_VER_IHL);
   HOST_NETWORK_ENDIAN_16BIT(eth_data + IP_TOTAL_LENGTH_OFS, ip_length);
   HOST_NETWORK_ENDIAN_16BIT(eth_data + IP_IDENT_OFS,
                             &ip_write_frame_counter);
   *(unsigned int *) (eth_data + IP_FLAGS_FRAG_OFS) = SWAPB(IP_FLAG_DONTFRAG);
   *(eth_data + IP_TTL_OFS) = IP_DEFAULT_TTL;
   *(eth_data + IP_PROTOCOL_OFS) = ip_protocol;
   *(unsigned int *) (eth_data + IP_HEAD_CHKSUM_OFS) = 0;
   memcpy(eth_data + IP_SOURCE_OFS, ip_source, IP_ADR_SIZE);
   memcpy(eth_data + IP_DESTINATION_OFS, ip_destination, IP_ADR_SIZE);
   *(unsigned int *) (eth_data + IP_HEAD_CHKSUM_OFS) =
      ip_checksum(eth_data + IP_HEADER_START_OFS, IP_HEADER_SIZE, 0);
   ip_write_frame_counter++;
#ifdef IPSEC_ENABLE
   return ipsec_output_frame(eth_data + ETH_HEADER_SIZE, ip_length,
                             ip_offset);
#else
   return 1;
#endif
}
#endif


unsigned int ip_checksum(void *data, unsigned int count,
                         unsigned char *tcp_ip_remote)
{
   unsigned long sum = 0;
   unsigned int *p_data;

   p_data = data;
   if (tcp_ip_remote)
   {
#ifdef IP_ENABLE
      sum += ((unsigned int) ip_address[1] << 8) | ip_address[0];
      sum += ((unsigned int) ip_address[3] << 8) | ip_address[2];
      sum += ((unsigned int) tcp_ip_remote[1] << 8) | tcp_ip_remote[0];
      sum += ((unsigned int) tcp_ip_remote[3] << 8) | tcp_ip_remote[2];
      sum += SWAPB(IP_TCP_PROT);
      sum += (count >> 8) | (count << 8);
#endif
   }
   while (count > 1)
   {
      sum += *p_data;
      p_data++;
      count -= 2;
   }
   if (count)
      sum += (*p_data) & 0x00FF;
   while (sum >> 16)
      sum = (sum & 0xFFFF) + (sum >> 16);
   return (unsigned int) ~sum;
}
