
/*****************************************************************************
 *
 *                        "measure.c"
 *                   -----------------------------
 *
 *  Version:    2.00a
 *  File:    	...\projects\...\measure.c
 *  Created:    10.02.2003
 *  Date:       28.07.2003
 *  Author:     Copyright (C) 2001-2003
 *              Udo Jakobza - FTZ Leipzig; D-04107 Leipzig; Wchterstr. 13
 *				info@easytoweb.net
 *  Function:	time measure fuctions and variables
 *  license:
 *    This library is free software; you can redistribute it and/or modify it
 *    under the terms of the GNU Lesser General Public License as published by
 *    the Free Software Foundation; either version 2.1 of the License, or
 *    (at your option) any later version. This library is distributed in the hope
 *    that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *    warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *    See the GNU Lesser General Public License for more details.
 *	  see: http://www.gnu.org/copyleft/lesser.html
 *    You should have received a copy of the GNU Lesser General Public License
 *    along with this library; if not, write to the Free Software Foundation,
 *    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *    Bibliothek ist freie Software; Sie drfen sie unter den Bedingungen der
 *    GNU Lesser General Public License, wie von der Free Software Foundation
 *    verffentlicht, weiterverteilen und/oder modifizieren; entweder gem
 *    Version 2.1 der Lizenz oder (nach Ihrer Option) jeder spteren Version.
 *    Diese Bibliothek wird in der Hoffnung weiterverbreitet, da sie ntzlich
 *    sein wird, jedoch OHNE IRGENDEINE GARANTIE, auch ohne die implizierte
 *    Garantie der MARKTREIFE oder der VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK.
 *    Mehr Details finden Sie in der GNU Lesser General Public License.
 *	  see: http://www.gnu.org/copyleft/lesser.de.html
 *    Sie sollten eine Kopie der GNU Lesser General Public License zusammen mit
 *    dieser Bibliothek erhalten haben; falls nicht, schreiben Sie an die FSF,
 *    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 *  history:
 *		1.) 30.07.2003 Version 2.00a
 *			a.)	-
 *
 *****************************************************************************/
#include "project.h"
#include <avr/wdt.h>
#include <avr/pgmspace.h>

#ifdef WEB_DEBUG_MEASURE

#include <stdio.h>
#include <math.h>
#include MEASURE_H_FILEPATH

#ifdef __CODEVISIONAVR__
#pragma regalloc-
#endif
unsigned char measure_timer1 = 0;
unsigned char measure_flag = 0;
unsigned char measure_frame = 0;
MEASURE_FRAME measure_buffer[MEA_MAX_TIME_FRAMES];
p_MEASURE_FRAME measure_pointer = &measure_buffer[0];

#ifdef __CODEVISIONAVR__
#pragma regalloc+
#endif


void measure_init(void)
{
   measure_flag = 0;
   measure_frame = 0;
   measure_pointer = &measure_buffer[0];
   memset(measure_buffer, 0x0, sizeof(measure_buffer));
}


void measure_time(void)
{
   if (TIFR & 0x04)
   {
      measure_timer1++;
      TIFR |= 0x04;
   }
}

void measure_switch_time_frame(void)
{
   if (measure_flag)
   {
      measure_flag = 0;
      measure_frame++;
      if (measure_frame >= MEA_MAX_TIME_FRAMES)
         measure_frame = 0;
      measure_pointer = &measure_buffer[measure_frame];
   }
}



unsigned long measure_calc_time(unsigned int time, unsigned char over)
{
   unsigned long time1;

   time1 = over;
   time1 *= (0xffff * MEASURE_TIME);
   time1 += (unsigned long) time *MEASURE_TIME;

   return time1;
}

static PROGMEM char Cbf1s[] = "BUFFER_FRAME1_S ";
static PROGMEM char Cbf1e[] = "BUFFER_FRAME1_E ";
static PROGMEM char Cbf2s[] = "BUFFER_FRAME2_S ";
static PROGMEM char Cbf2e[] = "BUFFER_FRAME2_E ";
static PROGMEM char Cucss[] = "UDP_CHECKSUM_S  ";
static PROGMEM char Cucse[] = "UDP_CHECKSUM_E  ";
static PROGMEM char Cics1[] = "ICMP_CHECKSUM_S1";
static PROGMEM char Cice1[] = "ICMP_CHECKSUM_E1";
static PROGMEM char Cics2[] = "ICMP_CHECKSUM_S2";
static PROGMEM char Cice2[] = "ICMP_CHECKSUM_E2";
static PROGMEM char Ctcs1[] = "TCP_CHECKSUM_S1 ";
static PROGMEM char Ctce1[] = "TCP_CHECKSUM_E1 ";
static PROGMEM char Ctcs2[] = "TCP_CHECKSUM_S2 ";
static PROGMEM char Ctce2[] = "TCP_CHECKSUM_E2 ";
static PROGMEM char Ctds[]  = "TCP_DATA_S      ";
static PROGMEM char Ctde[]  = "TCP_DATA_E      ";
static PROGMEM char Ctfs[]  = "TCP_FRAME_S     ";
static PROGMEM char Ctfe[]  = "TCP_FRAME_E     ";
static PROGMEM char Cies[]  = "ICMP_ECHO_S     ";
static PROGMEM char Ciee[]  = "ICMP_ECHO_E     ";
static PROGMEM char Caas[]  = "ARP_ANSWER_S    ";
static PROGMEM char Caae[]  = "ARP_ANSWER_E    ";
static PROGMEM char Cars[]  = "ARP_REQUEST_S   ";
static PROGMEM char Care[]  = "ARP_REQUEST_E   ";
static PROGMEM char Cts[]   = "TCP_S           ";
static PROGMEM char Cte1[]  = "TCP_E1          ";
static PROGMEM char Cte2[]  = "TCP_E2          ";
static PROGMEM char Cte3[]  = "TCP_E3          ";
static PROGMEM char Cens[]  = "ETHERNET_S      ";
static PROGMEM char Cene[]  = "ETHERNET_E      ";
static PROGMEM char Cnes[]  = "NET_S           ";
static PROGMEM char Cnee[]  = "NET_E           ";
static PROGMEM char Cmns[]  = "MAIN_S          ";
static PROGMEM char Cmne[]  = "MAIN_E          ";

PGM_P measure_name[MEA_MAX_TIMES] PROGMEM = {
   Cbf1s, Cbf1e, Cbf2s, Cbf2e, Cucss, Cucse,
   Cics1, Cice1, Cics2, Cice2, Ctcs1, Ctce1,
   Ctcs2, Ctxe2, Ctds,  Ctde,  Ctfs,  Ctfe,
   Cies,  Ciee,  Caas,  Caae,  Cars,  Care,
   Cts,   Cte1,  Cte2,  Cte3,  Cens,  Cene,
   Cnes,  Cnee,  Cmns,  Cmne
};

static unsigned char measure_diff[MEA_MAX_TIMES] PROGMEM = {
   255, 0, 255, 2,
   255, 4, 255, 6,
   255, 8, 255, 10,
   255, 12, 255, 14,
   255, 16, 255, 18,
   255, 20, 255, 22,
   255, 24, 24, 24,
   255, 28, 255, 30,
   255, 32
};


unsigned long time[MEA_MAX_TIMES];
void measure_diplay(void)
{
   unsigned char Lva, Lvb, Lvc, min_Lva;
   unsigned long time1;
   unsigned char act_frame;

   time1 = measure_calc_time(TCNT1, measure_timer1);
   printf_P(PSTR("Measure time:%lu,%03ums\n"), time1 / 1000, time1 % 1000);
   act_frame = measure_frame;
   for (Lvb = 0; Lvb < MEA_MAX_TIME_FRAMES; Lvb++)
   {
#ifdef __CODEVISIONAVR__
#asm("wdr");
#else
      wdt_reset();
#endif
      act_frame++;
      if (act_frame >= MEA_MAX_TIME_FRAMES)
         act_frame = 0;
      for (Lva = 0; Lva < MEA_MAX_TIMES; Lva++)
      {
         time[Lva] =
            measure_calc_time(measure_buffer[act_frame].time[Lva],
                              measure_buffer[act_frame].over[Lva]);
      }
      for (Lva = 0; Lva < MEA_MAX_TIMES; Lva++)
      {
         min_Lva = 0xff;
         // search the smallest value
         for (Lvc = 0; Lvc < MEA_MAX_TIMES; Lvc++)
         {
            if (time[Lvc] != 0)
            {
               if (min_Lva == 0xff)
                  min_Lva = Lvc;
               else if (time[Lvc] < time[min_Lva])
                  min_Lva = Lvc;
            }
         }
         if (min_Lva == 0xff)
            break;
         printf_P(PSTR("%2u-%S: %lu.%03ums"), Lvb, pgm_read_word(&measure_name[min_Lva]),
                time[min_Lva] / 1000, time[min_Lva] % 1000);
         if (pgm_read_byte(&measure_diff[min_Lva]) != 255)
         {
            time1 =
               measure_calc_time(measure_buffer[act_frame].
                                 time[pgm_read_byte(&measure_diff[min_Lva])],
                                 measure_buffer[act_frame].
                                 over[pgm_read_byte(&measure_diff[min_Lva])]);
            time1 = labs(time1 - time[min_Lva]);
            printf_P(PSTR(" (%lu.%03ums)\n"), time1 / 1000, time1 % 1000);
         }
         else
            printf_P(PSTR("\n"));
         time[min_Lva] = 0;
      }
   }
   measure_init();
}

#endif
