
/*****************************************************************************
 *
 *                              "ppp_debug.c"
 *                   -----------------------------
 *
 *  Version:    2.03
 *  File:    	...\source\...\ppp_debug.c
 *  Created:    16.05.2003
 *  Date:       02.12.2003
 *  Author:     Copyright (C) 2001-2003
 *              Udo Jakobza - FTZ Leipzig; D-04107 Leipzig; Wchterstr. 13
 *				info@easytoweb.net
 *  Func:
 *  license:
 *    This library is free software; you can redistribute it and/or modify it
 *    under the terms of the GNU Lesser General Public License as published by
 *    the Free Software Foundation; either version 2.1 of the License, or
 *    (at your option) any later version. This library is distributed in the hope
 *    that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *    warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *    See the GNU Lesser General Public License for more details.
 *	  see: http://www.gnu.org/copyleft/lesser.html
 *    You should have received a copy of the GNU Lesser General Public License
 *    along with this library; if not, write to the Free Software Foundation,
 *    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *    Die Bibliothek ist freie Software; Sie drfen sie unter den Bedingungen der
 *    GNU Lesser General Public License, wie von der Free Software Foundation
 *    verffentlicht, weiterverteilen und/oder modifizieren; entweder gem
 *    Version 2.1 der Lizenz oder (nach Ihrer Option) jeder spteren Version.
 *    Diese Bibliothek wird in der Hoffnung weiterverbreitet, da sie ntzlich
 *    sein wird, jedoch OHNE IRGENDEINE GARANTIE, auch ohne die implizierte
 *    Garantie der MARKTREIFE oder der VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK.
 *    Mehr Details finden Sie in der GNU Lesser General Public License.
 *	  see: http://www.gnu.org/copyleft/lesser.de.html
 *    Sie sollten eine Kopie der GNU Lesser General Public License zusammen mit
 *    dieser Bibliothek erhalten haben; falls nicht, schreiben Sie an die FSF,
 *    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 *  history:
 *		1.) 30.07.2003 Version 2.00a
 *			a.)	-
 *
 *****************************************************************************/
#include "project.h"

#ifdef WEB_DEBUG_PPP

#include <stdio.h>
#include <string.h>
#ifdef __CODEVISIONAVR__
#include <mega128.h>
#else
#include <avr/io.h>
#include <avr/pgmspace.h>
#endif

#include HARDWARE_H_FILEPATH
#include PPP_DEBUG_H_FILEPATH
#include PPP_H_FILEPATH
#include DEVICE_H_FILEPATH


#ifdef __CODEVISIONAVR__
#pragma regalloc-
#endif

PPP_EVENT_TYPE last_ppp_event;
unsigned int ppp_frame_count = 0;

#ifdef __CODEVISIONAVR__
#pragma regalloc+
#endif

void ppp_debug_print_event_change(void)
{
   if (last_ppp_event != ppp_event)
   {
      printf_P(PSTR("PPP(%u) Event: %S\n"), ppp_frame_count,
             pgm_read_word(&ppp_event_name[ppp_event]));
      last_ppp_event = ppp_event;
   }
}

void ppp_debug_do_cmd(unsigned char *command)
{
   if (strncmp_P(command, PSTR("ppp-close"), 5) == 0)
   {
      ppp_event = PPP_EVENT_CLOSE;
      return;
   }
   if (strncmp_P(command, PSTR("ppp-open"), 5) == 0)
   {
      ppp_event = PPP_EVENT_OPEN;
      return;
   }
   if (strncmp_P(command, PSTR("ppp-server"), 5) == 0)
   {
      ppp_behaviour = PPP_SERVER;
      ppp_init();
      return;
   }
   if (strncmp_P(command, PSTR("ppp-client"), 5) == 0)
   {
      ppp_behaviour = PPP_CLIENT;
      ppp_init();
   }
}

#endif
