
/*****************************************************************************
 *
 *                         "server.c" 
 *                   -----------------------------
 *                                                                            
 *  Version:    2.09
 *  File:     	..\..\server.c    
 *  Created:    10.08.2004
 *  Date:       27.04.2005
 *  Author:     Copyright (C) 2001-2005
 *              Udo Jakobza - FTZ Leipzig; D-04107 Leipzig; Wchterstr. 13
 *				info@easytoweb.net
 *  Func:		implements a generell server functions by using the easyToWeb-API
 *  License:	
 *    This library is free software; you can redistribute it and/or modify it 
 *    under the terms of the GNU Lesser General Public License as published by 
 *    the Free Software Foundation; either version 2.1 of the License, or 
 *    (at your option) any later version. This library is distributed in the hope 
 *    that it will be useful, but WITHOUT ANY WARRANTY; without even the implied 
 *    warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
 *    See the GNU Lesser General Public License for more details.
 *	  see: http://www.gnu.org/copyleft/lesser.html	
 *    You should have received a copy of the GNU Lesser General Public License 
 *    along with this library; if not, write to the Free Software Foundation, 
 *    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *	
 *    Die Bibliothek ist freie Software; Sie drfen sie unter den Bedingungen der 
 *    GNU Lesser General Public License, wie von der Free Software Foundation 
 *    verffentlicht, weiterverteilen und/oder modifizieren; entweder gem 
 *    Version 2.1 der Lizenz oder (nach Ihrer Option) jeder spteren Version. 
 *    Diese Bibliothek wird in der Hoffnung weiterverbreitet, da sie ntzlich 
 *    sein wird, jedoch OHNE IRGENDEINE GARANTIE, auch ohne die implizierte 
 *    Garantie der MARKTREIFE oder der VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK. 
 *    Mehr Details finden Sie in der GNU Lesser General Public License.
 *	  see: http://www.gnu.org/copyleft/lesser.de.html	
 *    Sie sollten eine Kopie der GNU Lesser General Public License zusammen mit 
 *    dieser Bibliothek erhalten haben; falls nicht, schreiben Sie an die FSF,
 *    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 *  history:	
 *		1.) 10.08.2004 Version 2.04
 *			a.)	- 
 *
 *****************************************************************************/
#include "project.h"

#include <stdio.h>
#include <string.h>
#include <avr/pgmspace.h>
#include DEVICE_H_FILEPATH
#include BUFFER_H_FILEPATH
#include HARDWARE_H_FILEPATH
#ifdef ETHERNET_ENABLE
#include ETHERNET_H_FILEPATH
#endif
#ifdef DEVICE_PPP
#include PPP_H_FILEPATH
#endif
#ifdef TCP_ENABLE
#include TCP_H_FILEPATH
#endif
#ifdef DATAFLASH_FILE_ENABLE
#include DATAFLASH_FILE_H_FILEPATH
#include DATAFLASH_FILE_DEBUG_H_FILEPATH
#endif
#ifdef HTTP_ENABLE
#include HTTP_SERVER_H_FILEPATH
#endif
#ifdef FTP_ENABLE
#include FTP_SERVER_H_FILEPATH
#endif

//#include SERVER_H_FILEPATH

#ifdef BOOTP_ENABLE
#include BOOTP_H_FILEPATH
#endif

#ifdef UDP_ENABLE
#include UDP_H_FILEPATH
#endif

#ifdef __CODEVISIONAVR__
#pragma regalloc-
#endif
unsigned char server_ok = 0;

#ifdef __CODEVISIONAVR__
#pragma regalloc+
#endif

void server_init(void)
{
   server_ok = 0;
#if defined (DEVICE_CS8900) || defined (DEVICE_3c509b)
   hardware_init_mac_address();
#endif
   hardware_init_ip_addresses();
   buffer_clear();
   if (DEVICE_INIT() == 0)
      return;
#ifdef UDP_ENABLE
   udp_init();
#ifdef BOOTP_ENABLE
   server_ok = 1;
   bootp_init();
   server_ok = 0;
#endif
#endif
#ifdef TCP_ENABLE
   tcp_init();
#endif
#ifdef HTTP_ENABLE
   http_server_tcp = tcp_passive_open(TCP_PORT_HTTP);
   if (http_server_tcp == TCP_WRONG_CONNECTIONS)
      return;
#endif
#ifdef FTP_ENABLE
   ftp_server_tcp_command = tcp_passive_open(TCP_PORT_FTP_COMMAND);
   if (ftp_server_tcp_command == TCP_WRONG_CONNECTIONS)
      return;
#endif
#ifdef ARP_ENABLE
   arp_request_timer(ARP_REQUEST_TIMER_START);
#endif
#ifdef DATAFLASH_FILE_ENABLE
   dataflash_file_init(SPI_MODE);
#endif
   server_ok = 1;
}

void server_main(void)
{
   if (server_ok)
   {
#ifdef DEVICE_PPP
      ppp_main();
      if (DEVICE_READ_READY())
      {
#ifdef IP_ENABLE
         ip_process_frame(0);
#endif
         ppp_data_clear();
      }
#else
      ethernet_process();
#endif
      buffer_process();
#ifdef UDP_ENABLE
      udp_main();
#ifdef BOOTP_ENABLE
      bootp_process();
#endif
#endif
#ifdef TCP_ENABLE
      tcp_main();
      buffer_process();
#ifdef HTTP_ENABLE
      http_server();
#endif
#ifdef FTP_ENABLE
      ftp_server();
#endif
#endif
      buffer_process();
   }
}
